/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.account;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.account.BuiltinActivationModel;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.util.Debug;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class RoleActivationModel
extends BuiltinActivationModel {
    public boolean afterSave(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) throws LDAPException {
        if (this._modified) {
            LDAPConnection lDAPConnection = resourceEditor.getConsoleInfo().getLDAPConnection();
            try {
                if (!this._activator.isLockingInfrastructureCreated(lDAPConnection)) {
                    Debug.println((int)0, (String)"RoleActivationModel.afterSave: creating the locking infrastructure");
                    this._activator.createLockingInfrastructure(lDAPConnection);
                }
                if (this._activated) {
                    this._activator.modifyRolesToActivateRole(lDAPConnection);
                } else {
                    this._activator.modifyRolesToInactivateRole(lDAPConnection);
                }
                Debug.println((String)("RoleActivationModel.afterSave: committed activation = " + this._activated));
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)0, (String)("RoleActivationModel.afterSave: " + (Object)((Object)lDAPException)));
                if (Debug.getTrace()) {
                    lDAPException.printStackTrace();
                }
                DSUtil.showLDAPErrorDialog(resourceEditor.getFrame(), lDAPException, "updating-directory-title");
            }
            this._modified = false;
        } else {
            Debug.println((String)"RoleActivationModel.afterSave: no change, nothing to do");
        }
        return true;
    }
}

