/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSEntryObject;
import com.netscape.admin.dirserv.IDSEntryObject;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.task.CreateVLVIndex;
import com.netscape.management.client.util.Debug;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.AbstractListModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;

class VListEntryModel
extends AbstractListModel {
    Vector _entries = new Vector();
    private String _selectedPartitionView = "Show All Partitions";
    protected boolean _initialized = false;
    private int _top = 0;
    protected int _beforeCount;
    protected int _afterCount;
    private int _pageSize = 50;
    private int _selectedIndex = 0;
    protected LDAPControl[] _pageControls = null;
    protected LDAPVirtualListControl _vlc = null;
    private static LDAPControl _manageDSAITControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
    private boolean _followReferrals = true;
    private boolean _mismatch = false;
    protected int _size = -1;
    private String _base;
    private int _scope;
    private String _filter;
    private String _host;
    private int _port;
    private String _authDN;
    private String _authPassword;
    protected boolean _debug = false;
    private LDAPConnection _ldc;
    private IDSModel _model = null;
    private static final boolean _verbose = System.getProperty("verbose") != null;

    VListEntryModel(LDAPConnection lDAPConnection, String string, int n, String string2, IDSModel iDSModel, String string3) {
        this._ldc = (LDAPConnection)lDAPConnection.clone();
        this._base = string;
        this._scope = n;
        this._filter = string2;
        this._model = iDSModel;
        this._host = lDAPConnection.getHost();
        this._port = lDAPConnection.getPort();
        this._authDN = lDAPConnection.getAuthenticationDN();
        this._authPassword = lDAPConnection.getAuthenticationPassword();
        this._selectedPartitionView = string3;
    }

    VListEntryModel(LDAPConnection lDAPConnection, String string, int n, String string2, IDSModel iDSModel) {
        this(lDAPConnection, string, n, string2, iDSModel, "Show All Partitions");
    }

    public int getSize() {
        Debug.println((int)9, (String)"VListEntryModel.getSize()");
        if (!this._initialized) {
            this._initialized = true;
            this._pageControls = new LDAPControl[2];
            LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[CreateVLVIndex.DEFAULT_ATTRIBUTES.length];
            int n = 0;
            while (n < lDAPSortKeyArray.length) {
                lDAPSortKeyArray[n] = new LDAPSortKey(CreateVLVIndex.DEFAULT_ATTRIBUTES[n]);
                ++n;
            }
            this._pageControls[0] = new LDAPSortControl(lDAPSortKeyArray, true);
            this._beforeCount = this._pageSize;
            this._afterCount = this._pageSize;
            LDAPVirtualListControl lDAPVirtualListControl = new LDAPVirtualListControl("A", this._beforeCount, this._afterCount);
            this._pageControls[1] = lDAPVirtualListControl;
            this._vlc = (LDAPVirtualListControl)this._pageControls[1];
            this.getPage(0);
        }
        Debug.println((int)9, (String)("VListEntryModel.getSize()=" + this._size));
        return this._size;
    }

    public Object getElementAt(int n) {
        int n2;
        Debug.println((int)9, (String)("VListEntryModel.getElementAt: need entry " + n));
        if (this._mismatch) {
            Debug.println((int)9, (String)"VListEntryModel.getElementAt: mismatch");
            DSEntryObject dSEntryObject = DSEntryObject.getBogusEntryObject();
            this._entries.addElement(dSEntryObject);
            return dSEntryObject;
        }
        Debug.println((int)9, (String)("VListEntryModel.getElementAt: _top=" + this._top + " _entries.size()=" + this._entries.size()));
        if (n < this._top || n >= this._top + this._entries.size()) {
            Debug.println((int)9, (String)("VListEntryModel.getElementAt: fetching a page starting at " + n));
            if (!this.getPage(n)) {
                Debug.println((int)9, (String)("VListEntryModel.getElementAt: first getPage(" + n + ") is null"));
                return DSEntryObject.getBogusEntryObject();
            }
            n2 = n - this._top;
            if (n2 >= this._entries.size()) {
                this._beforeCount = this._entries.size() / 3;
                this._afterCount = this._pageSize * 2 - this._beforeCount;
                if (!this.getPage(n)) {
                    Debug.println((int)9, (String)("VListEntryModel.getElementAt: second getPage(" + n + ") is null"));
                    return DSEntryObject.getBogusEntryObject();
                }
            }
        }
        if ((n2 = n - this._top) < 0 || n2 >= this._entries.size()) {
            Debug.println((int)9, (String)("VListEntryModel.getElementAt: bogus offset=" + n2));
            DSEntryObject dSEntryObject = DSEntryObject.getBogusEntryObject();
            this._entries.addElement(dSEntryObject);
            return dSEntryObject;
        }
        Debug.println((int)9, (String)("VListEntryModel.getElementAt: success for element=" + n2));
        IDSEntryObject iDSEntryObject = (IDSEntryObject)this._entries.elementAt(n2);
        Debug.println((int)9, (String)("VListEntryModel.getElementAt: object=" + iDSEntryObject));
        return iDSEntryObject;
    }

    public void recalculate() {
        Debug.println((int)9, (String)"VListEntryModel.recalculate: BEGIN");
        this._initialized = false;
        this.getSize();
    }

    private IDSEntryObject getEntryObject(LDAPEntry lDAPEntry) {
        Debug.println((int)8, (String)("VListEntryModel.getEntryObject: entry=" + lDAPEntry));
        DSEntryObject dSEntryObject = new DSEntryObject(this._model, lDAPEntry, this.getReferralsEnabled());
        return dSEntryObject;
    }

    private String getNameForEntry(LDAPEntry lDAPEntry) {
        String[] stringArray;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cn");
        if (lDAPAttribute != null && (stringArray = lDAPAttribute.getStringValues()).hasMoreElements()) {
            return (String)stringArray.nextElement();
        }
        stringArray = LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true);
        return stringArray[0];
    }

    /*
     * Unable to fully structure code
     */
    private LDAPVirtualListResponse getEntries() {
        block28: {
            block27: {
                Debug.println((int)9, (String)"VListEntryModel.getEntries: begin");
                var1_1 = null;
                if (this._ldc == null) {
                    return var1_1;
                }
                var2_2 = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
                var2_2.setMaxResults(0);
                var3_3 = this._pageControls;
                if (this._selectedPartitionView.equals("Show All Partitions")) {
                    if (!this.getReferralsEnabled()) {
                        var3_3 = new LDAPControl[this._pageControls.length + 1];
                        var4_4 = 0;
                        while (var4_4 < this._pageControls.length) {
                            var3_3[var4_4] = this._pageControls[var4_4];
                            ++var4_4;
                        }
                        var3_3[this._pageControls.length] = VListEntryModel._manageDSAITControl;
                    } else {
                        Debug.println((int)9, (String)"VListEntryModel.getEntries: referrals are enabled");
                    }
                } else if (!this.getReferralsEnabled()) {
                    try {
                        var4_5 = this._selectedPartitionView.getBytes("UTF8");
                        var5_11 = new LDAPControl("2.16.840.1.113730.3.4.14", true, var4_5);
                        var3_3 = new LDAPControl[this._pageControls.length + 2];
                        var6_15 = 0;
                        while (var6_15 < this._pageControls.length) {
                            var3_3[var6_15] = this._pageControls[var6_15];
                            ++var6_15;
                        }
                        var3_3[this._pageControls.length - 1] = VListEntryModel._manageDSAITControl;
                        var3_3[this._pageControls.length] = var5_11;
                        break block27;
                    }
                    catch (UnsupportedEncodingException var4_6) {
                        Debug.println((String)"VListEntryModel.getEntries(): Error: UTF8 not supported");
                        var3_3 = new LDAPControl[this._pageControls.length + 1];
                        var5_12 = 0;
                        ** while (var5_12 < this._pageControls.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var3_3[var5_12] = this._pageControls[var5_12];
                        ++var5_12;
                        continue;
                    }
lbl41:
                    // 1 sources

                    var3_3[this._pageControls.length] = VListEntryModel._manageDSAITControl;
                } else {
                    try {
                        var4_7 = this._selectedPartitionView.getBytes("UTF8");
                        var5_13 = new LDAPControl("2.16.840.1.113730.3.4.14", true, var4_7);
                        var3_3 = new LDAPControl[this._pageControls.length + 1];
                        var6_15 = 0;
                        while (var6_15 < this._pageControls.length) {
                            var3_3[var6_15] = this._pageControls[var6_15];
                            ++var6_15;
                        }
                        var3_3[this._pageControls.length] = var5_13;
                    }
                    catch (UnsupportedEncodingException var4_8) {
                        Debug.println((String)"VListEntryModel.getEntries(): Error: UTF8 not supported");
                    }
                }
            }
            var2_2.setServerControls(var3_3);
            this._entries.removeAllElements();
            try {
                Debug.println((int)8, (String)("VListEntryModel.getEntries: searching <" + this._base + ">, " + this._filter));
                var4_9 = this._ldc.search(this._base, this._scope, this._filter, DSEntryObject.MINIMAL_ATTRS, false, var2_2);
                var5_14 = 0;
                block12: while (var4_9.hasMoreElements()) {
                    try {
                        Debug.println((int)8, (String)"VListEntryModel.getEntries: getting next entry from result");
                        var6_16 = var4_9.next();
                        Debug.println((int)8, (String)("VListEntryModel.getEntries: adding <" + var6_16.getDN() + ">"));
                        this._entries.addElement(this.getEntryObject(var6_16));
                        ++var5_14;
                        continue;
                    }
                    catch (LDAPReferralException var6_17) {
                        var7_19 = var6_17.getURLs();
                        var8_20 = 0;
                        ** while (var8_20 < var7_19.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        Debug.println((String)("VListEntryModel.getEntries: referral " + var7_19[var8_20].getUrl()));
                        ++var8_20;
                        continue;
lbl78:
                        // 1 sources

                    }
                }
                var6_18 = this._afterCount + this._beforeCount;
                var7_19 = this._ldc.getResponseControls();
                if (var7_19 != null) {
                    var1_1 = LDAPVirtualListResponse.parseResponse((LDAPControl[])var7_19);
                    if (var1_1 != null) {
                        Debug.println((int)8, (String)("VListEntryModel.getEntries: result <" + var4_9.hasMoreElements() + "> total content count=" + var1_1.getContentCount()));
                        if (var1_1.getContentCount() < var6_18) {
                            var6_18 = var1_1.getContentCount();
                        }
                    } else {
                        Debug.println((int)8, (String)"VListEntryModel.getEntries: VLVResponse is null");
                    }
                } else {
                    Debug.println((int)8, (String)"VListEntryModel.getEntries: null response controls");
                    var6_18 = var5_14;
                }
                Debug.println((int)9, (String)("VListEntryModel.getEntries: requested " + var6_18 + " entries, read " + var5_14));
                var8_20 = var5_14;
                while (var8_20 < var6_18) {
                    this._entries.addElement(DSEntryObject.getBogusEntryObject());
                    ++var8_20;
                }
            }
            catch (LDAPException var4_10) {
                Debug.println((String)("VListEntryModel.getEntries: " + (Object)var4_10 + ", searching"));
                if (this._pageControls != null) break block28;
                return null;
            }
        }
        Debug.println((int)8, (String)("VListEntryModel.getEntries: Returning " + this._entries.size() + " entries for " + this._base));
        return var1_1;
    }

    boolean getPage(int n) {
        int n2 = n - this._beforeCount;
        if (n2 < 0) {
            n -= n2;
        }
        this._vlc.setRange(n, this._beforeCount, this._afterCount);
        Debug.println((int)9, (String)("VListEntryModel.getPage: Setting requested range to " + n + ", -" + this._beforeCount + ", +" + this._afterCount));
        return this.getPage();
    }

    boolean getPage() {
        LDAPVirtualListResponse lDAPVirtualListResponse = this.getEntries();
        if (lDAPVirtualListResponse == null) {
            this._size = this._entries.size();
            this._vlc.setListSize(this._size);
            this._selectedIndex = 0;
        } else {
            this._selectedIndex = lDAPVirtualListResponse.getFirstPosition() - 1;
            this._top = Math.max(0, this._selectedIndex - this._beforeCount);
            Debug.println((int)9, (String)("VListEntryModel.getPage: _selectedIndex=" + this._selectedIndex + " _beforeCount=" + this._beforeCount + " _entries.size()=" + this._entries.size()));
            this._size = lDAPVirtualListResponse.getContentCount();
            if (this._size < this._entries.size()) {
                Debug.println((String)("VListEntryModel.getPage: Reported list size = " + this._size));
                this._size = this._entries.size();
            } else if (this._size > this._entries.size()) {
                Debug.println((String)("VListEntryModel.getPage: mismatch " + (this._size - this._entries.size()) + " entries"));
            }
            this._vlc.setListSize(this._size);
            Debug.println((int)8, (String)("VListEntryModel.getPage: Virtual window: " + this._top + ".." + (this._top + this._entries.size() - 1) + " of " + this._size));
            this._mismatch = this._size > 0 && this._entries.size() == 0;
        }
        return true;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getFirstIndex() {
        return this._top;
    }

    public Vector getStoredEntries() {
        return this._entries;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public void setPageSize(int n) {
        this._pageSize = n;
    }

    public void reset() {
        Debug.println((int)9, (String)"VListEntryModel.reset: BEGIN");
        if (this._entries != null && this._entries.size() > 0) {
            Debug.println((int)9, (String)("VListEntryModel.reset: old first entry=" + this._entries.elementAt(0)));
        }
        this._entries.removeAllElements();
        this._initialized = false;
    }

    public void setReferralsEnabled(boolean bl) {
        Debug.println((int)8, (String)("VListEntryModel.setReferralsEnabled: " + bl));
        this._followReferrals = bl;
    }

    public boolean getReferralsEnabled() {
        return this._followReferrals;
    }
}

