/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSContentModel;
import com.netscape.admin.dirserv.DSEntryObject;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.ISubtreeSelectionDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IResourceModel;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceCellRenderer;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SubtreeSelectionDialog
extends AbstractDialog
implements ISubtreeSelectionDialog,
ActionListener,
TreeSelectionListener,
MouseListener {
    private JTree _tree = null;
    private DSContentModel _resourceModel;
    private ResourceCellRenderer _treeRenderer;
    private IResourceObject[] _previousSelection = null;
    private JButton _bOK;
    private JButton _bCancel;
    private JButton _bHelp;
    private boolean _isOk = false;
    private String _dnString;
    private boolean _rootOK;
    private boolean _multipleOK;
    private static final String _helpToken = "subtree-selection-dbox-help";
    private static final String _section = "general";
    private static ResourceSet _resource = DSUtil._resource;

    public SubtreeSelectionDialog(JFrame jFrame, ConsoleInfo consoleInfo, boolean bl, boolean bl2) {
        super((Frame)jFrame, true);
        this._rootOK = bl;
        this._multipleOK = bl2;
        String string = consoleInfo.getHost() + ":" + consoleInfo.getPort();
        ((Dialog)((Object)this)).setTitle(_resource.getString("browser", "title") + " [" + string + "]");
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(_resource.getString("browser", "description"));
        ((Component)((Object)this)).setSize(350, 300);
        ((Window)((Object)this)).setLocationRelativeTo(jFrame);
        this.getContentPane().setLayout(new BorderLayout());
        this._treeRenderer = new ResourceCellRenderer();
        DSEntryObject dSEntryObject = new DSEntryObject(null, "", string, false);
        this._resourceModel = new DSContentModel(null, consoleInfo, dSEntryObject);
        dSEntryObject.setModel(this._resourceModel);
        this.getContentPane().add("Center", this.createTreePanel(this._resourceModel));
        this._bOK = UIFactory.makeJButton((Object)this, _section, "OK");
        if (!this._rootOK) {
            this._bOK.setEnabled(false);
        }
        this._bCancel = UIFactory.makeJButton((Object)this, _section, "Cancel");
        this._bHelp = UIFactory.makeJButton((Object)this, _section, "Help");
        JButton[] jButtonArray = new JButton[]{this._bOK, this._bCancel, this._bHelp};
        JPanel jPanel = UIFactory.makeJButtonPanel(jButtonArray, true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("Center", jPanel);
        jPanel2.add("North", Box.createVerticalStrut(UIFactory.getDifferentSpace()));
        this.getContentPane().add("South", jPanel2);
    }

    public IResourceObject[] getSelection() {
        IResourceObject[] iResourceObjectArray = null;
        TreePath[] treePathArray = this._tree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            iResourceObjectArray = new IResourceObject[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                iResourceObjectArray[n] = (IResourceObject)treePathArray[n].getLastPathComponent();
                ++n;
            }
        }
        return iResourceObjectArray;
    }

    public IResourceObject[] getPreviousSelection() {
        return this._previousSelection;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        IResourceObject[] iResourceObjectArray = this.getSelection();
        this._resourceModel.actionObjectSelected(this._resourceModel.getSelectedPage(), iResourceObjectArray, this.getPreviousSelection());
        this._previousSelection = iResourceObjectArray;
        this.checkSelection();
    }

    private void checkSelection() {
        if (this._bOK != null) {
            boolean bl;
            int n = this._tree.getSelectionCount();
            boolean bl2 = bl = n > 0;
            if (!this._rootOK) {
                bl &= this._tree.getMinSelectionRow() > 0;
            }
            if (!this._multipleOK) {
                bl &= n < 2;
            }
            this._bOK.setEnabled(bl);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        IResourceObject[] iResourceObjectArray = this.getSelection();
        if (iResourceObjectArray != null && mouseEvent.getClickCount() == 2) {
            if (iResourceObjectArray.length == 1 && !this._resourceModel.isLeaf(iResourceObjectArray[0])) {
                return;
            }
            this._resourceModel.actionObjectRun(this._resourceModel.getSelectedPage(), iResourceObjectArray);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void runComplete(IResourceObject iResourceObject) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource().equals(this._bCancel) || actionEvent.getActionCommand().equals("close")) {
                this._isOk = false;
                ((Component)((Object)this)).setVisible(false);
                this.dispose();
                DSUtil.dialogCleanup();
            }
            if (actionEvent.getSource().equals(this._bHelp)) {
                DSUtil.help(_helpToken);
            }
            if (actionEvent.getSource().equals(this._bOK)) {
                this._dnString = ((DSEntryObject)this._tree.getLastSelectedPathComponent()).getDN();
                this._isOk = true;
                ((Component)((Object)this)).setVisible(false);
                this.dispose();
                DSUtil.dialogCleanup();
            }
        }
        catch (NullPointerException nullPointerException) {
            Debug.println((String)("SubtreeSelectionDialog: Caught: " + nullPointerException.toString()));
        }
    }

    public boolean isOk() {
        return this._isOk;
    }

    public String getDN() {
        return this._dnString;
    }

    private JComponent createTreePanel(IResourceModel iResourceModel) {
        this._tree = new JTree((TreeModel)iResourceModel);
        this._tree.setCellRenderer((TreeCellRenderer)this._treeRenderer);
        this._tree.addTreeSelectionListener(this);
        this._tree.addMouseListener(this);
        int n = UIFactory.getBorderInsets().left;
        this._tree.setBorder(new EmptyBorder(n, n, n, n));
        this._tree.setSelectionRow(0);
        JScrollPane jScrollPane = new JScrollPane(20, 30);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        jScrollPane.getViewport().add(this._tree);
        return jScrollPane;
    }

    public void packAndShow() {
        this.pack();
        super.show();
    }
}

