/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSBaseModel;
import com.netscape.admin.dirserv.DefaultResourceModel;
import com.netscape.admin.dirserv.IChangeClient;
import com.netscape.admin.dirserv.IDSContentListener;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.IDSResourceSelectionListener;
import com.netscape.admin.dirserv.SubtreeSelectionDialog;
import com.netscape.admin.dirserv.node.RootResourceObject;
import com.netscape.admin.dirserv.panel.ConfirmationPreferencesPanel;
import com.netscape.admin.dirserv.panel.DatabaseExportPanel;
import com.netscape.admin.dirserv.panel.DatabaseImportPanel;
import com.netscape.admin.dirserv.panel.LDAPAddPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class DSResourceModel
extends DSBaseModel
implements IDSContentListener {
    private String[] _categoryID = null;
    private IMenuItem[] _menuFile = null;
    private IMenuItem[] _menuContext = null;
    private IMenuItem[] _menuView = null;
    private IMenuItem[] _menuEdit = null;
    private Vector _contentListeners = new Vector();
    private Hashtable _disabledPanels = new Hashtable();
    private Hashtable _disabledAttributes = new Hashtable();
    static final String USE_LDIF_FILE = "useldiffile";
    static final String IMPORT = "import";
    static final String EXPORT = "export";
    public static final String REFRESH = "refresh";
    public static final String REFRESH_ALL = "refresh-all";
    static final String CONFIRMATION = "confirmation";

    public DSResourceModel(ConsoleInfo consoleInfo, ConsoleInfo consoleInfo2) {
        super(consoleInfo, consoleInfo2);
        this.initialize();
        RootResourceObject rootResourceObject = new RootResourceObject(this);
        this.setRoot(rootResourceObject);
        this.setSelectedNode((IResourceObject)rootResourceObject);
    }

    private void initialize() {
        this.getServerInfo().put("dsresmodel", this);
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                String string = "cn=options,cn=features,cn=config";
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "(objectclass=directoryServerFeature)", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    Object var4_5 = null;
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cn");
                    String string2 = (String)lDAPAttribute.getStringValues().nextElement();
                    if (string2.equalsIgnoreCase("modules")) {
                        this.initializeDisabledModules(lDAPEntry);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("attributes")) {
                        this.initializeDisabledAttributes(lDAPEntry);
                        continue;
                    }
                    Debug.println((String)("DSResourceModel.initialize: unexpected cn - " + string2));
                }
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    private void initializeDisabledModules(LDAPEntry lDAPEntry) {
        String[] stringArray = new String[]{"cn", "objectclass"};
        Enumeration enumeration = lDAPEntry.getAttributeSet().getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String string = lDAPAttribute.getName();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    string = null;
                    break;
                }
                ++n;
            }
            if (string == null) continue;
            this._disabledPanels.put(string, "true");
            Debug.println((String)("DSResourceModel.initializeDisabledPanels: added " + string));
        }
    }

    private void initializeDisabledAttributes(LDAPEntry lDAPEntry) {
        String[] stringArray = new String[]{"cn", "objectclass"};
        Enumeration enumeration = lDAPEntry.getAttributeSet().getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String string = lDAPAttribute.getName();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    string = null;
                    break;
                }
                ++n;
            }
            if (string == null) continue;
            string = string.replace('|', ':');
            this._disabledAttributes.put(string, "true");
            Debug.println((String)("DSResourceModel.initializeDisabledAttributes: added " + string));
        }
    }

    public boolean isModuleDisabled(String string) {
        return this._disabledPanels.containsKey(string.toLowerCase());
    }

    public boolean isAttributeDisabled(String string) {
        return this._disabledAttributes.containsKey(string.toLowerCase());
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"FILE", "EDIT", "VIEW"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("FILE")) {
            if (this._menuFile == null) {
                this._menuFile = new IMenuItem[]{new MenuItemText("authenticate", DSBaseModel._resource.getString("menu", "authenticate"), DSBaseModel._resource.getString("menu", "authenticate-description")), new MenuItemSeparator(), new MenuItemText(USE_LDIF_FILE, DSBaseModel._resource.getString("menu", USE_LDIF_FILE), DSBaseModel._resource.getString("menu", "useldiffile-description")), new MenuItemText(IMPORT, DSBaseModel._resource.getString("menu", IMPORT), DSBaseModel._resource.getString("menu", "import-description")), new MenuItemText(EXPORT, DSBaseModel._resource.getString("menu", EXPORT), DSBaseModel._resource.getString("menu", "export-description")), new MenuItemSeparator()};
            }
            return this._menuFile;
        }
        if (string.equals("CONTEXT")) {
            if (this._menuContext == null) {
                this._menuContext = new IMenuItem[]{new MenuItemText("acl", DSBaseModel._resource.getString("menu", "editacls"), DSBaseModel._resource.getString("menu", "editacls-description"))};
            }
            return this._menuContext;
        }
        if (string.equals("EDIT")) {
            if (this._menuEdit == null) {
                this._menuEdit = new IMenuItem[]{new MenuItemText(CONFIRMATION, DSBaseModel._resource.getString("menu", CONFIRMATION), DSBaseModel._resource.getString("menu", "confirmation-description"))};
            }
            return this._menuEdit;
        }
        if (string.equals("VIEW")) {
            if (this._menuView == null) {
                this._menuView = new IMenuItem[]{new MenuItemSeparator(), new MenuItemText(REFRESH_ALL, DSBaseModel._resource.getString("menu", REFRESH_ALL), DSBaseModel._resource.getString("menu", "refresh-all-description"))};
            }
            return this._menuView;
        }
        return null;
    }

    public void refreshView() {
        this.refreshObject();
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        super.actionMenuSelected(iPage, iMenuItem);
        this.setWaitCursor(true);
        if (iMenuItem.getID().equals("open")) {
            this.actionObjectRun(iPage, this._selection);
        } else if (iMenuItem.getID().equals("authenticate")) {
            boolean bl = this.getNewAuthentication();
        } else if (!iMenuItem.getID().equals("acl")) {
            if (iMenuItem.getID().equals(USE_LDIF_FILE)) {
                this.useLDIFFile();
            } else if (iMenuItem.getID().equals(IMPORT)) {
                this.databaseImport();
            } else if (iMenuItem.getID().equals(EXPORT)) {
                this.databaseExport();
            } else if (iMenuItem.getID().equals(REFRESH)) {
                this.refreshObject();
            } else if (iMenuItem.getID().equals(REFRESH_ALL)) {
                this.setSelectedNode((IResourceObject)this.getRoot());
                this.refreshObject();
            } else if (iMenuItem.getID().equals(CONFIRMATION)) {
                this.confirmationPreferences();
            }
        }
        this.setWaitCursor(false);
    }

    public void actionObjectSelected(IPage iPage, IResourceObject[] iResourceObjectArray, IResourceObject[] iResourceObjectArray2) {
        IDSResourceSelectionListener iDSResourceSelectionListener;
        Component component;
        Component component2;
        super.actionObjectSelected(iPage, iResourceObjectArray, iResourceObjectArray2);
        this._selection = iResourceObjectArray;
        if (this._selection == null) {
            this._selection = new IResourceObject[0];
        }
        Vector<Component> vector = new Vector<Component>();
        Vector<IResourceObject> vector2 = new Vector<IResourceObject>();
        int n = 0;
        while (n < this._selection.length) {
            IResourceObject iResourceObject = this._selection[n];
            component2 = iResourceObject.getCustomPanel();
            if (component2 != null && this._selectionListeners.contains(component2)) {
                vector2.addElement(iResourceObject);
            }
            vector.addElement(component2);
            ++n;
        }
        if (iResourceObjectArray2 != null) {
            int n2 = 0;
            while (n2 < iResourceObjectArray2.length) {
                component2 = iResourceObjectArray2[n2];
                component = component2.getCustomPanel();
                if (component != null && this._selectionListeners.contains(component) && !vector.contains(component)) {
                    try {
                        iDSResourceSelectionListener = (IDSResourceSelectionListener)((Object)component);
                        iDSResourceSelectionListener.unselect((IResourceObject)component2, iPage);
                    }
                    catch (Exception exception) {
                        Debug.println((String)("DSResourceModel.actionObjectSelected: c = " + component + ", " + exception.toString()));
                    }
                }
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < vector2.size()) {
            component2 = (IResourceObject)vector2.elementAt(n3);
            component = component2.getCustomPanel();
            iDSResourceSelectionListener = (IDSResourceSelectionListener)((Object)component);
            iDSResourceSelectionListener.select((IResourceObject)component2, iPage);
            ++n3;
        }
    }

    public void actionViewClosing(IPage iPage) throws CloseVetoException {
        Enumeration enumeration = this._changeClients.elements();
        while (enumeration.hasMoreElements()) {
            if (!((IChangeClient)enumeration.nextElement()).isDirty()) continue;
            throw new CloseVetoException();
        }
    }

    private void useLDIFFile() {
        LDAPAddPanel lDAPAddPanel = new LDAPAddPanel(this);
        SimpleDialog simpleDialog = new SimpleDialog(this.getFrame(), lDAPAddPanel.getTitle(), 11, lDAPAddPanel);
        simpleDialog.setComponent(lDAPAddPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        simpleDialog.packAndShow();
    }

    private void databaseImport() {
        DatabaseImportPanel databaseImportPanel = new DatabaseImportPanel(this);
        SimpleDialog simpleDialog = new SimpleDialog(this.getFrame(), databaseImportPanel.getTitle(), 11, databaseImportPanel);
        simpleDialog.setComponent(databaseImportPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        simpleDialog.packAndShow();
    }

    private void databaseExport() {
        SubtreeSelectionDialog subtreeSelectionDialog = new SubtreeSelectionDialog(this.getFrame(), this.getServerInfo(), true, false);
        DatabaseExportPanel databaseExportPanel = new DatabaseExportPanel((IDSModel)this, subtreeSelectionDialog, true);
        SimpleDialog simpleDialog = new SimpleDialog(this.getFrame(), databaseExportPanel.getTitle(), 11, databaseExportPanel);
        simpleDialog.setComponent(databaseExportPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        simpleDialog.packAndShow();
    }

    private void confirmationPreferences() {
        ConfirmationPreferencesPanel confirmationPreferencesPanel = new ConfirmationPreferencesPanel(new DefaultResourceModel());
        SimpleDialog simpleDialog = new SimpleDialog(this.getFrame(), confirmationPreferencesPanel.getTitle(), 11, confirmationPreferencesPanel);
        simpleDialog.setComponent(confirmationPreferencesPanel);
        simpleDialog.setDefaultButton(1);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSBaseModel._resource.getString(CONFIRMATION, "description"));
        simpleDialog.packAndShow();
    }

    private void refreshObject() {
        if (this._selection != null && this._selection.length > 0) {
            IResourceObject iResourceObject = this._selection[0];
            if (iResourceObject.equals(this.getRoot())) {
                this.setSchema(null);
            }
            Component component = iResourceObject.getCustomPanel();
            if (iResourceObject instanceof ActionListener) {
                ((ActionListener)iResourceObject).actionPerformed(new ActionEvent(this, 1001, REFRESH));
            }
            if (component != null && component instanceof ActionListener) {
                ((ActionListener)((Object)component)).actionPerformed(new ActionEvent(this, 1001, REFRESH));
            }
        }
    }

    public void contentChanged() {
        Enumeration enumeration = this._contentListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((IDSContentListener)enumeration.nextElement()).contentChanged();
        }
    }

    public void addContentListener(IDSContentListener iDSContentListener) {
        if (!this._contentListeners.contains(iDSContentListener)) {
            this._contentListeners.addElement(iDSContentListener);
        }
    }

    public void removeContentListener(IDSContentListener iDSContentListener) {
        this._contentListeners.removeElement(iDSContentListener);
    }
}

