/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.AttributeAlias;
import com.netscape.admin.dirserv.DSBaseModel;
import com.netscape.admin.dirserv.DSContentModel;
import com.netscape.admin.dirserv.DSEntryDialog;
import com.netscape.admin.dirserv.DSEntryList;
import com.netscape.admin.dirserv.DSResourceEditor;
import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSEntryObject;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.VListEntryModel;
import com.netscape.admin.dirserv.account.AccountInactivation;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.propedit.ChooseObjectClassDialog;
import com.netscape.admin.dirserv.propedit.DSEntryPanel;
import com.netscape.admin.dirserv.propedit.DSPropertyModel;
import com.netscape.admin.dirserv.propedit.EntryPageDescription;
import com.netscape.admin.dirserv.task.CreateVLVIndex;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.IResEditorAdvancedOpt;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class DSEntryObject
extends ResourceObject
implements IDSEntryObject {
    static ResourceSet _resource = DSUtil._resource;
    private IDSEntryObject _parent = null;
    private String _selectedPartitionView = "Show All Partitions";
    private String[] _suffixes;
    private static String _defaultImageName = DSEntryObject.initDefaultIconName();
    private static String _defaultFolderImageName = DSEntryObject.initDefaultFolderIconName();
    private String _dn;
    private String _sDisplayName;
    private boolean _fLoaded = false;
    private int _iChildren = -1;
    private boolean _fHasChildren = false;
    private boolean _fHasCheckedForChildren = false;
    private boolean _fHasGrandChildren = false;
    private boolean _fHasCheckedForGrandChildren = false;
    private boolean _fContainer = false;
    private DSEntryList _customizePanel = null;
    private long _objectCode = 0L;
    private static final boolean _verbose = System.getProperty("verbose") != null;
    private static Hashtable _cContainers = null;
    private static Hashtable _icons = new Hashtable();
    private Hashtable _objectClasses = null;
    private IDSModel _model = null;
    private LDAPEntry _entry = null;
    private VListEntryModel _dataModel = null;
    private static String _childFilter;
    private boolean _isPrivateSuffix = false;
    private boolean _isBogus = false;
    private static boolean _showAliases;
    private static final boolean releaseOnUnselect = true;
    private boolean _followReferrals = true;
    private static LDAPControl _manageDSAITControl;
    private boolean _showPrivateSuffixes = true;
    private static final String SUBORDINATE_ATTR = "numsubordinates";
    private static final String NSROLEDN_ATTR = "nsroledn";
    private static final String NSROLE_ATTR = "nsrole";
    private static final String NSLOOKTROUGHLIMIT_ATTR = "nslookthroughlimit";
    private static final String NSSIZELIMIT_ATTR = "nssizelimit";
    private static final String NSTIMELIMIT_ATTR = "nstimelimit";
    private static final String NSIDLETIMEOUT_ATTR = "nsidletimeout";
    private static final String NSACCOUNTLOCK_ATTR = "nsaccountlock";
    private static final String ACI_ATTR = "aci";
    private static final String USERPASSWORD_ATTR = "userpassword";
    private static final String OBJECTCLASS_ATTR = "objectclass";
    private static final String NSROLEDEFINITION_ATTR = "nsroledefinition";
    private static final String INACTIVATED = "true";
    public static final String[] MINIMAL_ATTRS;
    private static final int MAX_UNINDEXED_COUNT = 1000;
    private static final String _section = "EntryObject";
    private static final String _serverIconName = "directory.gif";
    private static String[] PREFIXES;
    private static final String DEFAULT_NEW;
    private static final String BOGUS_ICON_NAME;
    private static final RemoteImage BOGUS_ICON;
    private static final String BOGUS_LABEL;
    public static final String SEARCH_OID = "2.16.840.1.113730.3.4.14";

    protected DSEntryObject(boolean bl) {
        this._isBogus = bl;
    }

    public DSEntryObject(IDSModel iDSModel, String string, String string2, boolean bl) {
        this._showPrivateSuffixes = bl;
        Debug.println((int)9, (String)("DSEntryObject.DSEntryObject(4): dn=" + string));
        this.initialize(iDSModel, string, string2);
    }

    public DSEntryObject(IDSModel iDSModel, String string, String string2) {
        this(iDSModel, string, string2, true);
        Debug.println((int)9, (String)("DSEntryObject.DSEntryObject(3): dn=" + string));
    }

    public DSEntryObject(IDSModel iDSModel, String string) {
        String string2 = this.getDisplayNameFromDN(iDSModel, string);
        this.initialize(iDSModel, string, string2);
    }

    public DSEntryObject(String string) {
        this(null, string);
        Debug.println((int)9, (String)("DSEntryObject.DSEntryObject(1): dn=" + string));
    }

    public DSEntryObject(IDSModel iDSModel, LDAPEntry lDAPEntry, boolean bl) {
        this(iDSModel, lDAPEntry.getDN());
        Debug.println((int)9, (String)("DSEntryObject.DSEntryObject(2a): dn=" + lDAPEntry.getDN()));
        this._entry = lDAPEntry;
        this.setReferralsEnabled(bl);
        this.initializeFromEntry(this._entry);
    }

    protected void initialize(IDSModel iDSModel, String string, String string2) {
        RemoteImage remoteImage;
        this._dn = string;
        this._model = iDSModel;
        ((DefaultMutableTreeNode)((Object)this)).setAllowsChildren(true);
        this._sDisplayName = string2;
        if (this.isRootDSE()) {
            this._isPrivateSuffix = true;
            remoteImage = DSUtil.getPackageImage(_serverIconName);
        } else {
            remoteImage = DSUtil.getPackageImage(_defaultImageName);
        }
        this.setName(this._sDisplayName);
        this.setIcon((Icon)remoteImage);
        if (_cContainers == null) {
            _cContainers = DSEntryObject.initContainerNames();
        }
        if (iDSModel instanceof DSContentModel) {
            this._selectedPartitionView = ((DSContentModel)iDSModel).getSelectedPartitionView();
        }
        this._suffixes = null;
    }

    public void setModel(IDSModel iDSModel) {
        this._model = iDSModel;
    }

    public LDAPEntry getEntry() {
        Debug.println((int)9, (String)("DSEntryObject.getEntry: " + this.getDN()));
        if (this._entry == null) {
            try {
                String[] stringArray = DSSchemaHelper.getOperationalAttributes(this._model.getSchema());
                String[] stringArray2 = null;
                if (stringArray == null) {
                    stringArray2 = new String[]{"*"};
                } else {
                    stringArray2 = new String[stringArray.length + 1];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray2[n] = stringArray[n];
                        ++n;
                    }
                    stringArray2[stringArray.length] = "*";
                }
                this._entry = this.readEntry(this.getDN(), stringArray2);
                this.initializeFromEntry(this._entry);
            }
            catch (Exception exception) {
                Debug.println((String)("DSEntryObject.getEntry <" + this.getDN() + "> " + exception));
            }
        }
        return this._entry;
    }

    public void setEntry(LDAPEntry lDAPEntry) {
        this._entry = lDAPEntry;
    }

    public void reset() {
        this._entry = null;
    }

    public String getHost() {
        return this.getLDAPConnection().getHost();
    }

    public int getPort() {
        return this.getLDAPConnection().getPort();
    }

    private static Hashtable initContainerNames() {
        StringTokenizer stringTokenizer;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = _resource.getString(_section, "containers");
        if (_verbose) {
            Debug.println((String)"DSEntryObject.initContainerNames");
        }
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, " ");
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().toLowerCase();
                if (_verbose) {
                    Debug.println((String)("  added container type " + string2));
                }
                hashtable.put(string2, string2);
            }
        }
        _childFilter = "(|(&(numsubordinates=*)(numsubordinates>=1))";
        stringTokenizer = hashtable.keys();
        while (stringTokenizer.hasMoreElements()) {
            _childFilter = _childFilter + "(objectclass=" + (String)stringTokenizer.nextElement() + ")";
        }
        _childFilter = _childFilter + ")";
        if (_verbose) {
            Debug.println((String)("DSEntryObject.initContainerNames: VList filter for tree = " + _childFilter));
        }
        return hashtable;
    }

    private static String initDefaultIconName() {
        String string = _resource.getString(_section, "default-icon");
        if (string == null) {
            string = "genobject.gif";
        }
        return string;
    }

    private static String initDefaultFolderIconName() {
        String string = _resource.getString(_section, "default-folder-icon");
        if (string == null) {
            string = "folder.gif";
        }
        return string;
    }

    public static void addContainerName(String string) {
        String string2 = string.toLowerCase();
        _cContainers.put(string2, string2);
    }

    public String getDN() {
        return this._dn;
    }

    public void setDN(String string) {
        this._dn = string;
    }

    public LDAPConnection getLDAPConnection() {
        return this._model.getServerInfo().getLDAPConnection();
    }

    public void load() {
        String string = this.getDN();
        Debug.println((int)9, (String)("DSEntryObject.load <" + string + ">"));
        if (this.isRootDSE()) {
            this.expandRoot();
        } else {
            this.removeAllChildren();
            String[] stringArray = MINIMAL_ATTRS;
            LDAPConnection lDAPConnection = this.getLDAPConnection();
            if (lDAPConnection == null) {
                Debug.println((String)"DSEntryObject.load: no LDAP connection");
                return;
            }
            LDAPEntry lDAPEntry = this.readEntry(string, stringArray);
            if (lDAPEntry != null) {
                this.initializeFromEntry(lDAPEntry);
            }
            this._fLoaded = true;
            this._iChildren = -1;
            Debug.println((int)9, (String)"DSEntryObject.load: calling getChildCount()");
            int n = this.getChildCount();
        }
        if (this._customizePanel != null) {
            this._customizePanel.recalculate();
        }
    }

    DSEntryObject nodeFromEntry(LDAPEntry lDAPEntry) {
        Debug.println((int)9, (String)("DSEntryObject.nodeFromEntry: " + lDAPEntry.getDN()));
        DSEntryObject dSEntryObject = new DSEntryObject(this._model, lDAPEntry, this.getReferralsEnabled());
        dSEntryObject.setParentNode(this);
        return dSEntryObject;
    }

    DSEntryObject addOneChild(LDAPEntry lDAPEntry, boolean bl) {
        if (lDAPEntry == null) {
            return null;
        }
        DSEntryObject dSEntryObject = this.nodeFromEntry(lDAPEntry);
        if (!bl || !dSEntryObject.isLeafType()) {
            Debug.println((int)9, (String)("DSEntryObject.addOneChild: Adding " + dSEntryObject.getDN() + " to " + this.getDN()));
            ((DefaultMutableTreeNode)((Object)this)).add(dSEntryObject);
            return dSEntryObject;
        }
        Debug.println((int)9, (String)("DSEntryObject.addOneChild: Rejected " + dSEntryObject.getDN() + " as child of " + this.getDN()));
        return null;
    }

    private LDAPEntry readEntry(String string, String[] stringArray) {
        return this.readEntry(string, stringArray, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private LDAPEntry readEntry(String var1_1, String[] var2_2, boolean var3_3) {
        block16: {
            Debug.println((int)9, (String)("DSEntryObject.readEntry: " + var1_1));
            try {
                var4_4 = this.getLDAPConnection();
                if (var4_4 == null) {
                    Debug.println((String)"DSEntryObject.readEntry: no LDAP connection");
                    return null;
                }
                var5_6 = (LDAPSearchConstraints)var4_4.getSearchConstraints().clone();
                if (!this.getReferralsEnabled()) {
                    Debug.println((int)9, (String)"DSEntryObject.readEntry: no referrals");
                    if (var3_3 && !this._selectedPartitionView.equals("Show All Partitions")) {
                        try {
                            var6_9 /* !! */  = (LDAPEntry)this._selectedPartitionView.getBytes("UTF8");
                            var7_13 = new LDAPControl("2.16.840.1.113730.3.4.14", true, (byte[])var6_9 /* !! */ );
                            var8_15 = new LDAPControl[]{DSEntryObject._manageDSAITControl, var7_13};
                            var5_6.setServerControls(var8_15);
                        }
                        catch (UnsupportedEncodingException var6_10) {
                            Debug.println((String)"DSEntryObject.readEntry: Error: UTF8 not supported");
                            var5_6.setServerControls(DSEntryObject._manageDSAITControl);
                        }
                    } else {
                        var5_6.setServerControls(DSEntryObject._manageDSAITControl);
                    }
                } else {
                    if (var3_3 && !this._selectedPartitionView.equals("Show All Partitions")) {
                        try {
                            var6_9 /* !! */  = (LDAPEntry)this._selectedPartitionView.getBytes("UTF8");
                            var7_14 = new LDAPControl("2.16.840.1.113730.3.4.14", true, (byte[])var6_9 /* !! */ );
                            var5_6.setServerControls(var7_14);
                        }
                        catch (UnsupportedEncodingException var6_11) {
                            Debug.println((String)"DSEntryObject.readEntry: Error: UTF8 not supported");
                        }
                    }
                    Debug.println((int)9, (String)"DSEntryObject.readEntry: referrals on");
                }
                var6_9 /* !! */  = DSUtil.readEntry(var4_4, var1_1, var2_2, var5_6);
                if (var6_9 /* !! */  == null) {
                    Debug.println((String)("DSEntryObject.readEntry: unable to read <" + var1_1 + ">"));
                } else {
                    Debug.println((int)9, (String)("DSEntryObject.readEntry of " + var1_1 + " returned " + var6_9 /* !! */ ));
                }
                return var6_9 /* !! */ ;
            }
            catch (LDAPReferralException var4_5) {
                Debug.println((String)("DSEntryObject.readEntry referral problem " + var1_1 + ": " + (Object)var4_5));
                var5_7 = var4_5.getURLs();
                var6_12 = 0;
                ** while (var6_12 < var5_7.length)
            }
lbl-1000:
            // 1 sources

            {
                Debug.println((String)("DSEntryObject.readEntry: url=" + var5_7[var6_12]));
                ++var6_12;
                continue;
lbl46:
                // 1 sources

                break block16;
            }
            catch (LDAPException var5_8) {
                Debug.println((String)("DSEntryObject.readEntry of " + var1_1 + ": " + (Object)var5_8));
            }
        }
        return null;
    }

    private DSEntryObject expandRootNode(String string) {
        if (_verbose) {
            Debug.println((String)("DSEntryObject.expandRootNode: <" + string + ">"));
        }
        DSEntryObject dSEntryObject = null;
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println((String)("DSEntryObject.expandRootNode: <" + string + ">, no LDAP connection"));
            return null;
        }
        String[] stringArray = MINIMAL_ATTRS;
        if (DSEntryObject.isRootDSE(string)) {
            return null;
        }
        Debug.println((String)("  NamingContext: " + string));
        LDAPEntry lDAPEntry = this._selectedPartitionView.equals("Show All Partitions") ? this.readEntry(string, stringArray) : this.readEntry(string, stringArray, true);
        if (_verbose) {
            Debug.println((String)("DSEntryObject.expandRootNode: Read of <" + string + "> returned " + lDAPEntry));
        }
        if (lDAPEntry != null) {
            dSEntryObject = this.addOneChild(lDAPEntry, false);
        }
        return dSEntryObject;
    }

    private void expandRootNode(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Debug.println((String)("DSEntryObject.expandRootNode: " + string));
            DSEntryObject dSEntryObject = this.expandRootNode(string);
        }
    }

    private void expandRoot() {
        Debug.println((String)"DSEntryObject.expandRoot");
        this.removeAllChildren();
        String string = "";
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println((String)"DSEntryObject.expandRoot: no LDAP connection");
            return;
        }
        if (this._selectedPartitionView.equals("Show All Partitions")) {
            Enumeration enumeration;
            String[] stringArray = new String[]{"namingcontexts"};
            LDAPEntry lDAPEntry = this.readEntry("", stringArray);
            if (lDAPEntry == null) {
                Debug.println((String)"DSEntryObject.expandRoot: readRoot returned null");
                return;
            }
            this.checkObjectClasses(lDAPEntry);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
            if (lDAPAttribute != null) {
                enumeration = lDAPAttribute.getStringValues();
                this.expandRootNode(enumeration);
            }
            if (this._showPrivateSuffixes) {
                stringArray[0] = "nsslapd-privatenamespaces";
                lDAPEntry = this.readEntry("cn=config", stringArray);
                if (lDAPEntry == null) {
                    Debug.println((String)"DSEntryObject.expandRoot: cn=config returned null");
                } else {
                    lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
                    if (lDAPAttribute != null) {
                        enumeration = lDAPAttribute.getStringValues();
                        this.expandRootNode(enumeration);
                    }
                }
            }
        } else {
            String string2 = MappingUtils.getSuffixForBackend(lDAPConnection, this._selectedPartitionView);
            if (string2 != null) {
                this.expandRootNode(string2);
            }
        }
        this._fLoaded = true;
        this._fContainer = true;
        this._iChildren = super.getChildCount();
        Debug.println((String)("DSEntryObject.expandRoot found " + this._iChildren + " searchable suffixes"));
    }

    public boolean isContainer() {
        return this._fContainer;
    }

    private void initDataModel() {
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println((String)"DSEntryObject.initDataModel: no LDAP connection");
            return;
        }
        if (this._dataModel == null) {
            this._dataModel = new VListEntryModel(lDAPConnection, this.getDN(), 1, _childFilter, this._model);
            this._dataModel.setReferralsEnabled(this.getReferralsEnabled());
            this._dataModel.setDebug(true);
        }
    }

    public void reload() {
        String string = this.getDN();
        if (_verbose) {
            Debug.println((String)("DSEntryObject.reload for <" + string + ">"));
        }
        if (this.isRootDSE()) {
            this.expandRoot();
            return;
        }
        this.getChildList(true, false);
    }

    private boolean getChildList(boolean bl, boolean bl2) {
        DN dN;
        String string = this.getDN();
        Debug.println((int)9, (String)("DSEntryObject.getChildList for <" + string + "> check = " + bl2));
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        try {
            DN dN2;
            DN dN3;
            DN dN4;
            LDAPConnection lDAPConnection = this.getLDAPConnection();
            if (this._suffixes == null) {
                this._suffixes = DSContentModel.getSuffixes();
            }
            Vector<DN> vector2 = new Vector<DN>();
            if (this._suffixes != null) {
                dN = new DN(string);
                int n = 0;
                while (n < this._suffixes.length) {
                    dN4 = new DN(this._suffixes[n]);
                    if (dN4.getParent().getParent().equals(dN) && vector2.indexOf(dN4) < 0) {
                        boolean bl3 = false;
                        int n2 = 0;
                        while (n2 < vector2.size()) {
                            dN3 = (DN)vector2.elementAt(n2);
                            if (dN3.equals(dN4)) {
                                bl3 = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!bl3) {
                            vector2.addElement(dN4);
                        }
                    }
                    ++n;
                }
            }
            dN = MINIMAL_ATTRS;
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
            lDAPSearchConstraints.setMaxResults(0);
            if (this._selectedPartitionView.equals("Show All Partitions")) {
                if (!this.getReferralsEnabled()) {
                    lDAPSearchConstraints.setServerControls(_manageDSAITControl);
                }
                dN4 = lDAPConnection.search(string, 1, _childFilter, (String[])dN, false, lDAPSearchConstraints);
            } else {
                byte[] byArray;
                if (!this.getReferralsEnabled()) {
                    try {
                        byArray = this._selectedPartitionView.getBytes("UTF8");
                        LDAPControl lDAPControl = new LDAPControl(SEARCH_OID, true, byArray);
                        dN3 = new DN[]{_manageDSAITControl, lDAPControl};
                        lDAPSearchConstraints.setServerControls((LDAPControl[])dN3);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Debug.println((String)"DSEntryObject.getChildList: Error: UTF8 not supported");
                        lDAPSearchConstraints.setServerControls(_manageDSAITControl);
                    }
                } else {
                    try {
                        byArray = this._selectedPartitionView.getBytes("UTF8");
                        LDAPControl lDAPControl = new LDAPControl(SEARCH_OID, true, byArray);
                        lDAPSearchConstraints.setServerControls(lDAPControl);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Debug.println((String)"DSEntryObject.getChildList: Error: UTF8 not supported");
                    }
                }
                dN4 = lDAPConnection.search(string, 1, _childFilter, (String[])dN, false, lDAPSearchConstraints);
            }
            Debug.println((int)9, (String)("DSEntryObject.getChildList search for <" + string + "> =" + dN4.hasMoreElements() + " cons.getHopLimit()=" + lDAPSearchConstraints.getHopLimit()));
            while (dN4.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)dN4.nextElement();
                Debug.println((int)9, (String)("DSEntryObject.getChildList adding <" + lDAPEntry.getDN() + "> check = " + bl2));
                DN dN5 = new DN(lDAPEntry.getDN());
                int n = vector2.size() - 1;
                while (n >= 0) {
                    dN2 = (DN)vector2.elementAt(n);
                    if (dN2.isDescendantOf(dN5)) {
                        vector2.removeElementAt(n);
                    }
                    --n;
                }
                if (bl2) {
                    if (this.getCountFromEntry(lDAPEntry) <= 0) continue;
                    Debug.println((int)9, (String)"DSEntryObject.getChildList: has children");
                    lDAPConnection.abandon((LDAPSearchResults)dN4);
                    return true;
                }
                vector.addElement(lDAPEntry);
            }
            lDAPConnection.abandon((LDAPSearchResults)dN4);
            Vector<DN> vector3 = new Vector<DN>();
            int n = 0;
            while (n < vector2.size()) {
                DN dN6 = (DN)vector2.elementAt(n);
                dN2 = dN6.getParent();
                boolean bl4 = false;
                int n3 = 0;
                while (n3 < vector3.size() && !bl4) {
                    if (dN2.equals((DN)vector3.elementAt(n3))) {
                        bl4 = true;
                    }
                    ++n3;
                }
                if (!bl4) {
                    String string2 = dN2.toRFCString();
                    LDAPEntry lDAPEntry = this.readEntry(dN6.toRFCString(), (String[])dN, true);
                    LDAPEntry lDAPEntry2 = this.readEntry(string2, (String[])dN, true);
                    if (lDAPEntry != null && lDAPEntry2 != null) {
                        if (bl2) {
                            return true;
                        }
                        vector.addElement(lDAPEntry2);
                        vector3.addElement(dN2);
                    }
                }
                ++n;
            }
            if (bl2) {
                return false;
            }
            this._iChildren = vector.size();
            this._fHasChildren = this._iChildren > 0;
            this._fHasCheckedForChildren = true;
            Debug.println((int)9, (String)("DSEntryObject.getChildList dn <" + string + "> nchildren=" + this._iChildren));
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSEntryObject.getChildList cannot get entry <" + string + ">"));
            return false;
        }
        if (bl) {
            this.removeAllChildren();
            int n = vector.size();
            int n4 = 0;
            while (n4 < n) {
                dN = (LDAPEntry)vector.elementAt(n4);
                this.addOneChild((LDAPEntry)dN, true);
                ++n4;
            }
        }
        return vector == null;
    }

    public boolean isLoaded() {
        return this._fLoaded;
    }

    private DSEntryList createChildPanel() {
        if (!this._isPrivateSuffix) {
            return new DSEntryList(this.getLDAPConnection(), this.getDN(), 1, "|(objectclass=*)(objectclass=ldapsubentry)", (DSBaseModel)this._model, this);
        }
        Vector<DSEntryObject> vector = new Vector<DSEntryObject>();
        Debug.println((String)"DSEntryObject.createChildPanel: root children =");
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)((Object)this)).children();
        while (enumeration.hasMoreElements()) {
            DSEntryObject dSEntryObject = (DSEntryObject)enumeration.nextElement();
            Debug.println((String)("  " + dSEntryObject.getDN()));
            vector.addElement(dSEntryObject);
        }
        return new DSEntryList(vector, (DSBaseModel)this._model, this);
    }

    private int getCountFromEntry(LDAPEntry lDAPEntry) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(SUBORDINATE_ATTR);
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            String string = (String)enumeration.nextElement();
            int n = Integer.parseInt(string);
            if (_verbose) {
                Debug.println((String)("DSEntryObject.getCountFromEntry: " + lDAPEntry.getDN() + " = " + n));
            }
            return n;
        }
        return -1;
    }

    public Component getCustomPanel() {
        if (this._isBogus) {
            return null;
        }
        if (this._customizePanel == null) {
            LDAPConnection lDAPConnection;
            String string = this.getDN();
            if (_verbose) {
                Debug.println((String)("DSEntryObject.getCustomPanel for <" + string + ">"));
            }
            if ((lDAPConnection = this.getLDAPConnection()) == null) {
                Debug.println((String)"DSEntryObject.getCustomPanel: no LDAP connection");
                return null;
            }
            LDAPEntry lDAPEntry = this.readEntry(string, MINIMAL_ATTRS);
            if (lDAPEntry == null) {
                return null;
            }
            int n = this.getCountFromEntry(lDAPEntry);
            Debug.println((String)("DSEntryObject.getCustomPanel: numsubordinates = " + n));
            this.initializeFromEntry(lDAPEntry);
            if (n > 1000 && !this.nodeHasIndex(string)) {
                return new NoListPanel();
            }
            if (_verbose) {
                Debug.println((String)"DSEntryObject.getCustomPanel: calling getChildCount()");
            }
            int n2 = this.getChildCount();
            if (_verbose) {
                Debug.println((String)("  Creating DSEntryList for <" + string + ">"));
            }
            this._model.setWaitCursor(true);
            this._customizePanel = this.createChildPanel();
            this._model.setWaitCursor(false);
        }
        if (this._model instanceof DSContentModel) {
            ((DSContentModel)this._model).setDSEntryList(this._customizePanel);
        }
        return this._customizePanel;
    }

    private boolean nodeHasIndex(String string) {
        return CreateVLVIndex.hasIndex(string, this._model.getServerInfo());
    }

    public void initializeFromEntry(LDAPEntry lDAPEntry) {
        String string = lDAPEntry.getDN();
        if (_verbose) {
            Debug.println((String)("DSEntryObject.initializeFromEntry: " + string));
        }
        this.checkObjectClasses(lDAPEntry);
        this.checkForChildren(lDAPEntry);
        if (_verbose) {
            Debug.println((String)("DSEntryObject.initializeFromEntry: " + string));
        }
        this.checkIfContainer();
        if (!this.isRootDSE()) {
            this.setIcon((Icon)this.checkIcon(this._objectClasses, this.isLeafType()));
        }
        String string2 = this.getDisplayNameFromDN(this._model, lDAPEntry.getDN());
        this.setDisplayName(string2);
        if (_verbose) {
            Debug.println((String)("DSEntryObject.initializeFromEntry: end dn=" + string));
        }
        this._suffixes = null;
    }

    private boolean checkForChildren(LDAPEntry lDAPEntry) {
        int n;
        if (this._fHasCheckedForChildren) {
            if (_verbose) {
                Debug.println((String)("DSEntryObject.checkForChildren: already checked - " + this._fHasChildren));
            }
            return this._fHasChildren;
        }
        if (_verbose) {
            Debug.println((String)("DSEntryObject.checkForChildren: Checking if <" + lDAPEntry.getDN() + "> has children"));
        }
        if ((n = super.getChildCount()) > 0) {
            this._iChildren = n;
            this.setHasChildren(true);
            if (_verbose) {
                Debug.println((String)("... " + n + " children"));
            }
            return true;
        }
        int n2 = this.getCountFromEntry(lDAPEntry);
        if (n2 > 0) {
            this.setHasChildren(true);
            return true;
        }
        if (this._suffixes == null) {
            this._suffixes = DSContentModel.getSuffixes();
        }
        if (this._suffixes != null) {
            DN dN = new DN(lDAPEntry.getDN());
            int n3 = 0;
            while (n3 < this._suffixes.length) {
                DN dN2 = new DN(this._suffixes[n3]);
                if (dN2.getParent().equals(dN) && this.readEntry(dN2.toRFCString(), null, true) != null) {
                    this.setHasChildren(true);
                    return true;
                }
                ++n3;
            }
        }
        if (_verbose) {
            Debug.println((String)("... numsubordinates = " + n2));
        }
        this.setHasChildren(false);
        this._iChildren = 0;
        return false;
    }

    private void checkObjectClasses(String[] stringArray) {
        if (_verbose) {
            Debug.println((String)("DSEntryObject.checkObjectClasses: " + this.getDN()));
        }
        if (this._objectClasses != null) {
            return;
        }
        this._objectClasses = new Hashtable();
        int n = 0;
        n = 0;
        while (n < stringArray.length) {
            this._objectClasses.put(stringArray[n].toLowerCase(), stringArray[n]);
            ++n;
        }
        if (n > 0) {
            DSUtil.trimAndBubbleSort(stringArray, true);
            String string = stringArray[0];
            n = 1;
            while (n < stringArray.length) {
                string = string + stringArray[n];
                ++n;
            }
            this._objectCode = DSUtil.getCRC32(string);
        }
    }

    private void checkObjectClasses(LDAPEntry lDAPEntry) {
        if (this._objectClasses != null) {
            return;
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(OBJECTCLASS_ATTR);
        String[] stringArray = new String[]{"top"};
        if (lDAPAttribute != null) {
            stringArray = new String[lDAPAttribute.size()];
            Enumeration enumeration = lDAPAttribute.getStringValues();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
        }
        this.checkObjectClasses(stringArray);
    }

    public long getObjectClassCode() {
        return this._objectCode;
    }

    private void checkIfContainer() {
        if (_verbose) {
            Debug.println((String)("DSEntryObject.checkIfContainer: <" + this.getDN() + ">"));
        }
        if (this._fHasChildren) {
            if (_verbose) {
                Debug.println((String)"  It has children, so yes");
            }
            this._fContainer = true;
            return;
        }
        Enumeration enumeration = this._objectClasses.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (_verbose) {
                Debug.println((String)("  Looking up object class " + string));
            }
            if (_cContainers.get(string.toLowerCase()) == null) continue;
            if (_verbose) {
                Debug.println((String)("  It is an " + string + ", so yes"));
            }
            this._fContainer = true;
            return;
        }
        if (_verbose) {
            Debug.println((String)"  ...no");
        }
    }

    RemoteImage checkIcon(Hashtable hashtable, boolean bl) {
        if (_verbose) {
            Debug.println((String)("DSEntryObject.checkIcon: isLeaf = " + bl));
        }
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = ((String)enumeration.nextElement()).toLowerCase();
            string = (String)_icons.get(string2);
            if (string == null) {
                string = _resource.getString(_section, string2 + "-icon");
                if (string == null) {
                    string = "";
                }
                _icons.put(string2, string);
            }
            if (!string.equals("")) break;
        }
        if (string.equals("")) {
            string = bl ? _defaultImageName : _defaultFolderImageName;
        }
        if (!this.isActivated()) {
            if (this.isRole()) {
                return DSUtil.getInactivatedRolePackageImage(string);
            }
            return DSUtil.getInactivatedPackageImage(string);
        }
        return DSUtil.getPackageImage(string);
    }

    private static String getFirstValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    protected String getDisplayNameFromDN(IDSModel iDSModel, String string) {
        String string2 = "";
        if (!DSEntryObject.isRootDSE(string)) {
            String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
            if (stringArray != null && stringArray[0] != null) {
                string2 = stringArray[0];
            } else {
                string2 = string;
                Debug.println((String)("DSEntryObject.checkDisplayName: cannot explode " + string));
            }
        } else if (iDSModel != null) {
            ConsoleInfo consoleInfo = iDSModel.getServerInfo();
            LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
            string2 = lDAPConnection != null ? lDAPConnection.getHost() + ":" + lDAPConnection.getPort() : consoleInfo.getHost() + ":" + consoleInfo.getPort();
        }
        return string2;
    }

    void setHasChildren(boolean bl) {
        if (_verbose) {
            Debug.println((String)("DSEntryObject.setHasChildren: <" + this.getDN() + "> - " + bl));
        }
        this._fHasChildren = bl;
        this._fHasCheckedForChildren = true;
    }

    void setHasGrandChildren(boolean bl) {
        if (_verbose) {
            Debug.println((String)("DSEntryObject.setHasGrandChildren: <" + this.getDN() + "> - " + bl));
        }
        this._fHasGrandChildren = bl;
        this._fHasCheckedForGrandChildren = true;
    }

    public TreeNode getChildAt(int n) {
        TreeNode treeNode = null;
        if (_verbose) {
            Debug.println((String)("DSEntryObject.getChildAt: <" + this.getDN() + "> index " + n));
        }
        if (this._iChildren < 0) {
            this.reload();
        }
        try {
            treeNode = super.getChildAt(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (treeNode != null) {
            ((DSEntryObject)treeNode).setParentNode(this);
        }
        return treeNode;
    }

    public int getChildCount() {
        if (_verbose) {
            Debug.println((String)("DSEntryObject.getChildCount for <" + this.getDN() + ">"));
            Thread.dumpStack();
        }
        if (this._iChildren < 0) {
            this._model.setWaitCursor(true);
            this.reload();
            this._model.setWaitCursor(false);
        }
        int n = super.getChildCount();
        if (_verbose) {
            Debug.println((String)("DSEntryObject.getChildCount: <" + this.getDN() + "> - " + n));
        }
        return n;
    }

    public void removeAllChildren() {
        this._iChildren = 0;
        super.removeAllChildren();
    }

    public boolean isLeaf() {
        if (!this._fHasCheckedForChildren && !this.isLoaded()) {
            if (_verbose) {
                Debug.println((String)("DSEntryObject.isLeaf: <" + this.getDN() + "> before load()"));
            }
            this.load();
            if (_verbose) {
                Debug.println((String)("DSEntryObject.isLeaf: <" + this.getDN() + "> after load()"));
            }
        }
        if (_verbose) {
            Debug.println((String)("DSEntryObject.isLeaf: <" + this.getDN() + ">  - " + !this._fContainer));
        }
        if (!this._fHasCheckedForGrandChildren) {
            this._fHasGrandChildren = this.hasGrandchildren();
            this._fHasCheckedForGrandChildren = true;
        }
        return !this._fHasGrandChildren && this.getChildCount() <= 0;
    }

    private boolean hasGrandchildren() {
        if (super.getChildCount() > 0) {
            return true;
        }
        if (this._fHasCheckedForChildren && !this._fHasChildren) {
            return false;
        }
        return this.getChildList(false, true);
    }

    private boolean isLeafType() {
        this.isLeaf();
        return !this._fContainer;
    }

    public String getDisplayName() {
        if (this._sDisplayName == null) {
            Debug.println((int)9, (String)"DSEntryObject.getDisplayName is null");
        }
        return this._sDisplayName;
    }

    public void setDisplayName(String string) {
        this._sDisplayName = string;
    }

    public void setShowAliases(boolean bl) {
        _showAliases = bl;
    }

    private DSEntryDialog doGenericDialog(boolean bl) {
        return this.doGenericDialog(bl, 0);
    }

    private DSEntryDialog doGenericDialog(boolean bl, int n) {
        LDAPAttribute lDAPAttribute;
        this._model.setWaitCursor(true);
        LDAPAttributeSet lDAPAttributeSet = this._entry.getAttributeSet();
        int n2 = 0;
        LDAPSchema lDAPSchema = this._model.getSchema();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            vector.addElement(lDAPAttribute.getName().toLowerCase());
        }
        lDAPAttribute = new String[vector.size()];
        String[] stringArray = new String[vector.size()];
        n2 = 0;
        while (n2 < ((LDAPAttribute)lDAPAttribute).length) {
            lDAPAttribute[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        if (_showAliases) {
            AttributeAlias.getAliases((String[])lDAPAttribute, stringArray);
        } else {
            DSUtil.trimAndBubbleSort((String[])lDAPAttribute, true);
            n2 = 0;
            while (n2 < ((LDAPAttribute)lDAPAttribute).length) {
                stringArray[n2] = lDAPAttribute[n2];
                ++n2;
            }
        }
        EntryPageDescription entryPageDescription = new EntryPageDescription((String[])lDAPAttribute, stringArray);
        DSPropertyModel dSPropertyModel = new DSPropertyModel(this._model.getSchema(), this._entry, entryPageDescription);
        DSEntryPanel dSEntryPanel = new DSEntryPanel(dSPropertyModel, n, this._model.getServerInfo().getLDAPConnection());
        DSEntryDialog dSEntryDialog = new DSEntryDialog(this._model.getFrame(), dSEntryPanel);
        ((Dialog)((Object)dSEntryDialog)).setTitle(_resource.getString(_section, "property-dialog-title", this.getDisplayName()));
        ((Window)((Object)dSEntryDialog)).setLocationRelativeTo(this._model.getFrame());
        this._model.setWaitCursor(false);
        if (Debug.getTrace() && Debug.getTraceLevel() > 7) {
            System.out.println("DSEntryObject.doGenericDialog: stack trace:");
            Thread.dumpStack();
        }
        dSEntryDialog.packAndShow();
        DSUtil.dialogCleanup();
        if (!dSEntryDialog.isCancel()) {
            return dSEntryDialog;
        }
        return null;
    }

    DSEntryDialog editGenericDialog(boolean bl) {
        return this.doGenericDialog(bl);
    }

    DSEntryDialog editGenericDialog(boolean bl, int n) {
        return this.doGenericDialog(bl, n);
    }

    DSEntryDialog addGenericDialog(boolean bl) {
        return this.doGenericDialog(bl);
    }

    DSEntryDialog addGenericDialog(boolean bl, int n) {
        return this.doGenericDialog(bl, n);
    }

    public DSEntryDialog editGeneric(boolean bl, boolean bl2) {
        if (this._isBogus) {
            return null;
        }
        DSEntryDialog dSEntryDialog = this.editGenericDialog(bl);
        if (!bl2) {
            return dSEntryDialog;
        }
        if (dSEntryDialog == null) {
            return null;
        }
        LDAPModificationSet lDAPModificationSet = dSEntryDialog.getChanges();
        if (lDAPModificationSet != null) {
            DN dN = new DN(this.getDN());
            DN dN2 = new DN(dSEntryDialog.getDN());
            String string = this.getDN();
            boolean bl3 = false;
            if (!dN.equals(dN2)) {
                this.setDN(dSEntryDialog.getDN());
                bl3 = true;
            }
            if (bl3) {
                DSEntryObject dSEntryObject;
                block13: {
                    String[] stringArray = LDAPDN.explodeDN((String)this.getDN(), (boolean)false);
                    String string2 = stringArray[0];
                    String string3 = this.getDN();
                    try {
                        this.getLDAPConnection().rename(string, string2, true);
                    }
                    catch (LDAPException lDAPException) {
                        this.setDN(string);
                        if (lDAPException.getLDAPResultCode() != 32) {
                            Debug.println((String)("DSEntryObject.editGeneric: renaming <" + string + "> to <" + this.getDN() + ">, " + (Object)((Object)lDAPException)));
                            DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "111-title");
                            return null;
                        }
                        if (lDAPException.getLDAPResultCode() == 34) break block13;
                        if (dSEntryDialog.isValidDN()) {
                            DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "111-title");
                        }
                        return null;
                    }
                }
                if (!this.saveChanges(lDAPModificationSet, dSEntryDialog.getAttributes())) {
                    dSEntryDialog = null;
                }
                if ((dSEntryObject = (DSEntryObject)this.getParentNode()) != null) {
                    dSEntryObject.redisplay();
                } else {
                    this.redisplay();
                }
                return dSEntryDialog;
            }
            return this.saveChanges(lDAPModificationSet, dSEntryDialog.getAttributes()) ? dSEntryDialog : null;
        }
        return null;
    }

    public boolean addGeneric(boolean bl) {
        LDAPAttributeSet lDAPAttributeSet = null;
        DSEntryDialog dSEntryDialog = this.addGenericDialog(bl, 1);
        if (dSEntryDialog != null) {
            lDAPAttributeSet = dSEntryDialog.getAttributes();
        }
        if (lDAPAttributeSet == null) {
            return false;
        }
        this.setDN(dSEntryDialog.getDN());
        return this.addEntry(lDAPAttributeSet, dSEntryDialog);
    }

    public boolean addGenericNoNaming(boolean bl) {
        LDAPAttributeSet lDAPAttributeSet = null;
        DSEntryDialog dSEntryDialog = this.addGenericDialog(bl, 0);
        if (dSEntryDialog != null) {
            lDAPAttributeSet = dSEntryDialog.getAttributes();
        }
        if (lDAPAttributeSet == null) {
            return false;
        }
        this.setDN(dSEntryDialog.getDN());
        return this.addEntry(lDAPAttributeSet, dSEntryDialog);
    }

    public DSEntryDialog editGeneric(IResourceObject[] iResourceObjectArray, boolean bl) {
        LDAPModificationSet lDAPModificationSet;
        DSEntryDialog dSEntryDialog = this.editGenericDialog(bl, 2);
        if (dSEntryDialog != null && (lDAPModificationSet = dSEntryDialog.getChanges()) != null) {
            int n = 0;
            while (n < iResourceObjectArray.length) {
                if (!((DSEntryObject)iResourceObjectArray[n]).saveChanges(lDAPModificationSet, dSEntryDialog.getAttributes())) {
                    return null;
                }
                ++n;
            }
            return dSEntryDialog;
        }
        return null;
    }

    boolean saveChanges(LDAPModificationSet lDAPModificationSet, LDAPAttributeSet lDAPAttributeSet) {
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println((String)"DSEntryObject.saveChanges: no LDAP connection");
            return false;
        }
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        if (!this.getReferralsEnabled()) {
            lDAPSearchConstraints.setServerControls(_manageDSAITControl);
        }
        try {
            while (lDAPModificationSet != null) {
                try {
                    lDAPConnection.modify(this.getDN(), lDAPModificationSet, lDAPSearchConstraints);
                    this._entry = null;
                    this.getEntry();
                    boolean bl = true;
                    Object var8_7 = null;
                    this._model.notifyAuthChangeListeners();
                    return bl;
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("Modifying " + this.getDN() + ", " + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)this._model.getFrame(), lDAPConnection);
                        if (this._model.getNewAuthentication(false)) continue;
                        boolean bl = false;
                        Object var8_8 = null;
                        this._model.notifyAuthChangeListeners();
                        return bl;
                    }
                    if (lDAPException.getLDAPResultCode() == 32) {
                        boolean bl = this.addEntry(lDAPAttributeSet);
                        Object var8_9 = null;
                        this._model.notifyAuthChangeListeners();
                        return bl;
                    }
                    DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "111-title");
                    boolean bl = false;
                    Object var8_10 = null;
                    this._model.notifyAuthChangeListeners();
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this._model.notifyAuthChangeListeners();
            throw throwable;
        }
        Object var8_11 = null;
        this._model.notifyAuthChangeListeners();
        return false;
    }

    boolean addEntry(LDAPAttributeSet lDAPAttributeSet) {
        return this.addEntry(lDAPAttributeSet, null);
    }

    boolean addEntry(LDAPAttributeSet lDAPAttributeSet, DSEntryDialog dSEntryDialog) {
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println((String)"DSEntryObject.addEntry: no LDAP connection");
            return false;
        }
        LDAPEntry lDAPEntry = new LDAPEntry(this.getDN(), lDAPAttributeSet);
        try {
            while (true) {
                try {
                    Object object;
                    Vector vector;
                    lDAPConnection.add(lDAPEntry);
                    this._entry = null;
                    this.getEntry();
                    if (this._model instanceof DSContentModel) {
                        vector = ((DSContentModel)this._model).getSuffixWithNoEntryList();
                        object = new DN(this.getDN());
                        int n = 0;
                        while (n < vector.size()) {
                            DN dN = new DN((String)vector.elementAt(n));
                            if (object.equals(dN)) {
                                ((DSContentModel)this._model).updateNewRootEntryMenu(true);
                            }
                            ++n;
                        }
                    }
                    if (!this._selectedPartitionView.equals("Show All Partitions")) {
                        vector = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                        object = null;
                        try {
                            object = this._selectedPartitionView.getBytes("UTF8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Debug.println((String)("DSEntryObject.addEntry() " + unsupportedEncodingException));
                            boolean bl = true;
                            Object var10_19 = null;
                            this._model.notifyAuthChangeListeners();
                            return bl;
                        }
                        LDAPControl lDAPControl = new LDAPControl(SEARCH_OID, true, (byte[])object);
                        vector.setServerControls(lDAPControl);
                        vector.setMaxResults(0);
                        try {
                            lDAPEntry = DSUtil.readEntry(lDAPConnection, this.getDN(), null, (LDAPSearchConstraints)vector);
                            if (lDAPEntry == null) {
                                DSUtil.showInformationDialog((Component)this._model.getFrame(), "add-entry-to-different-partition", (String)null);
                            }
                        }
                        catch (LDAPException lDAPException) {
                            if (lDAPException.getLDAPResultCode() == 32) {
                                DSUtil.showInformationDialog((Component)this._model.getFrame(), "add-entry-to-different-partition", (String)null);
                            }
                            Debug.println((String)("DSEntryObject.addEntry() " + (Object)((Object)lDAPException)));
                        }
                    }
                    boolean bl = true;
                    Object var10_20 = null;
                    this._model.notifyAuthChangeListeners();
                    return bl;
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("Adding " + this.getDN() + ", " + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)this._model.getFrame(), lDAPConnection);
                        if (this._model.getNewAuthentication(false)) continue;
                        boolean bl = false;
                        Object var10_21 = null;
                        this._model.notifyAuthChangeListeners();
                        return bl;
                    }
                    if (lDAPException.getLDAPResultCode() == 32) {
                        DSUtil.showErrorDialog((Component)this._model.getFrame(), "noParentForAdd", "", _section);
                        boolean bl = false;
                        Object var10_22 = null;
                        this._model.notifyAuthChangeListeners();
                        return bl;
                    }
                    if (lDAPException.getLDAPResultCode() == 34) {
                        if (dSEntryDialog != null && dSEntryDialog.isValidDN()) {
                            DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "111-title");
                        }
                        boolean bl = false;
                        Object var10_23 = null;
                        this._model.notifyAuthChangeListeners();
                        return bl;
                    }
                    DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "111-title");
                    boolean bl = false;
                    Object var10_24 = null;
                    this._model.notifyAuthChangeListeners();
                    return bl;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var10_25 = null;
            this._model.notifyAuthChangeListeners();
            throw throwable;
        }
    }

    void newPredefinedObject(Vector vector) {
        this._model.setWaitCursor(true);
        ConsoleInfo consoleInfo = (ConsoleInfo)this._model.getConsoleInfo().clone();
        ConsoleInfo consoleInfo2 = this._model.getServerInfo();
        consoleInfo.setLDAPConnection(consoleInfo2.getLDAPConnection());
        consoleInfo.setAuthenticationDN(consoleInfo2.getAuthenticationDN());
        consoleInfo.setAuthenticationPassword(consoleInfo2.getAuthenticationPassword());
        consoleInfo.setUserLDAPConnection(consoleInfo2.getLDAPConnection());
        consoleInfo.setUserHost(consoleInfo2.getLDAPConnection().getHost());
        consoleInfo.setUserPort(consoleInfo2.getLDAPConnection().getPort());
        String string = MappingUtils.getTopSuffixForEntry(this.getDN(), DSContentModel.getSuffixes());
        if (string != null) {
            consoleInfo.setUserBaseDN(string);
        }
        consoleInfo.put("NewUserBaseDN", this.getDN());
        DSResourceEditor dSResourceEditor = null;
        try {
            dSResourceEditor = new DSResourceEditor(this._model.getFrame(), consoleInfo, vector, this.getDN());
            this._model.setWaitCursor(false);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.println((String)("DSEntryObject.newPredefinedObject: got" + arrayIndexOutOfBoundsException + " while instantiating a resource editor"));
            this._model.setWaitCursor(false);
            JOptionPane.showMessageDialog(null, _resource.getString(_section, "role-extension-error"), _resource.getString(_section, "role-extension-title"), 0);
            ModalDialogUtil.sleep();
        }
        if (dSResourceEditor != null) {
            String string2 = _resource.getString("UserGroup", "Advanced-label");
            dSResourceEditor.registerAdvancedOption(new UserGroupAdapter(string2));
            dSResourceEditor.showModal();
            boolean bl = dSResourceEditor.getSaveStatus();
            ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSResourceEditor), (Frame)this._model.getFrame());
            if (bl) {
                DN dN;
                Object object;
                Vector vector2;
                LDAPConnection lDAPConnection = this.getLDAPConnection();
                String string3 = dSResourceEditor.getLDAPEntry().getDN();
                if (this._model instanceof DSContentModel) {
                    vector2 = ((DSContentModel)this._model).getSuffixWithNoEntryList();
                    object = new DN(string3);
                    int n = 0;
                    while (n < vector2.size()) {
                        dN = new DN((String)vector2.elementAt(n));
                        if (object.equals(dN)) {
                            ((DSContentModel)this._model).updateNewRootEntryMenu(true);
                        }
                        ++n;
                    }
                }
                if (!this._selectedPartitionView.equals("Show All Partitions")) {
                    vector2 = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
                    object = null;
                    try {
                        object = this._selectedPartitionView.getBytes("UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Debug.println((String)("DSEntryObject.addEntry() " + unsupportedEncodingException));
                        this.updateInTree();
                        return;
                    }
                    LDAPControl lDAPControl = new LDAPControl(SEARCH_OID, true, (byte[])object);
                    vector2.setServerControls(lDAPControl);
                    vector2.setMaxResults(0);
                    try {
                        dN = DSUtil.readEntry(lDAPConnection, string3, null, (LDAPSearchConstraints)vector2);
                        if (dN == null) {
                            DSUtil.showInformationDialog((Component)this._model.getFrame(), "add-entry-to-different-partition", (String)null);
                        }
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getLDAPResultCode() == 32) {
                            DSUtil.showInformationDialog((Component)this._model.getFrame(), "add-entry-to-different-partition", (String)null);
                        }
                        Debug.println((String)("DSEntryObject.addEntry() " + (Object)((Object)lDAPException)));
                    }
                }
                this.reload();
                this.updateInTree();
            }
        }
    }

    private void updateInTree() {
        DSEntryObject dSEntryObject;
        if (((DefaultMutableTreeNode)((Object)this)).getParent() == null && !(dSEntryObject = (DSEntryObject)this.getParentNode()).childExists(this)) {
            ((DefaultMutableTreeNode)((Object)dSEntryObject)).add(this);
        }
        this.setHasChildren(true);
        if (this.getParentNode() != null) {
            ((DSEntryObject)this.getParentNode()).setHasGrandChildren(true);
        }
        this.checkIfContainer();
        this.redisplay();
    }

    private void redisplay() {
        this._model.fireTreeStructureChanged(this);
        this._model.setSelectedNode(this);
        if (this._customizePanel != null) {
            this._customizePanel.recalculate();
        }
    }

    public void newUser() {
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newUserObjectClasses");
        this.newPredefinedObject(vector);
    }

    public void newGroup() {
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newGroupObjectClasses");
        this.newPredefinedObject(vector);
    }

    public void newOrganizationalUnit() {
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newOUObjectClasses");
        this.newPredefinedObject(vector);
    }

    public void newRole() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("ldapsubentry");
        vector.addElement(NSROLEDEFINITION_ATTR);
        this.newPredefinedObject(vector);
    }

    public void newCos() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("ldapsubentry");
        vector.addElement("cossuperdefinition");
        this.newPredefinedObject(vector);
    }

    private String findPrefix(String string, String[] stringArray, boolean bl) {
        String string2 = null;
        if (string != null) {
            Enumeration enumeration;
            Object object;
            LDAPObjectClassSchema lDAPObjectClassSchema = this._model.getSchema().getObjectClass(string);
            if (lDAPObjectClassSchema == null) {
                string = null;
                return null;
            }
            if (bl) {
                object = new Hashtable();
                DSSchemaHelper.allRequiredAttributes(string, this._model.getSchema(), object);
                enumeration = ((Hashtable)object).elements();
            } else {
                object = new Hashtable();
                DSSchemaHelper.allOptionalAttributes(string, this._model.getSchema(), object);
                enumeration = ((Hashtable)object).elements();
            }
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                int n = 0;
                while (n < stringArray.length) {
                    if (((String)object).equalsIgnoreCase(stringArray[n])) {
                        string2 = stringArray[n];
                        break;
                    }
                    ++n;
                }
                if (string2 != null) break;
            }
        }
        return string2;
    }

    private String findRequiredPrefix(String string) {
        return this.findPrefix(string, PREFIXES, true);
    }

    private String findOptionalPrefix(String string) {
        return this.findPrefix(string, PREFIXES, false);
    }

    public void newObject() {
        LDAPSchema lDAPSchema = this._model.getSchema();
        JFrame jFrame = this._model.getFrame();
        ChooseObjectClassDialog chooseObjectClassDialog = new ChooseObjectClassDialog(jFrame, lDAPSchema);
        chooseObjectClassDialog.show();
        ((Window)((Object)chooseObjectClassDialog)).dispose();
        if (!chooseObjectClassDialog.isCancel()) {
            LDAPEntry lDAPEntry;
            Object object;
            Object object2;
            String string;
            String string2 = chooseObjectClassDialog.getSelectedValue();
            Vector vector = this.getObjectClassVector(string2, lDAPSchema);
            if (DSEntryObject.isStandardObjectClass(vector.elements(), this._model.getConsoleInfo())) {
                this.newPredefinedObject(vector);
                return;
            }
            Hashtable hashtable = new Hashtable();
            DSSchemaHelper.allRequiredAttributes(string2, lDAPSchema, hashtable);
            Enumeration enumeration = hashtable.elements();
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String string3 = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object2 = new LDAPAttribute(string);
                if (string.equalsIgnoreCase(OBJECTCLASS_ATTR)) {
                    vector = this.getObjectClassVector(string2, lDAPSchema);
                    int n = vector.size() - 1;
                    while (n >= 0) {
                        object2.addValue((String)vector.elementAt(n));
                        --n;
                    }
                } else {
                    object2.addValue("");
                    if (string3 == null && !string.equalsIgnoreCase(ACI_ATTR)) {
                        string3 = string;
                    }
                }
                lDAPAttributeSet.add((LDAPAttribute)object2);
            }
            string = this.findRequiredPrefix(string2);
            if (string == null) {
                string = this.findOptionalPrefix(string2);
            }
            if (string == null) {
                int n = 0;
                while (n < PREFIXES.length) {
                    if (lDAPAttributeSet.getAttribute(PREFIXES[n]) != null) {
                        string = PREFIXES[n];
                        break;
                    }
                    ++n;
                }
            }
            if (string == null) {
                string = string3;
            }
            if (string == null) {
                hashtable = new Hashtable();
                DSSchemaHelper.allOptionalAttributes(string2, lDAPSchema, hashtable);
                enumeration = hashtable.elements();
                if (enumeration.hasMoreElements() && (string = (String)enumeration.nextElement()).equalsIgnoreCase(ACI_ATTR)) {
                    string = enumeration.hasMoreElements() ? (String)enumeration.nextElement() : null;
                }
            }
            if (string == null) {
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "noRDN", string2, _section);
                return;
            }
            object2 = DEFAULT_NEW;
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute(string);
            if (lDAPAttribute != null) {
                Debug.println((String)("DSEntryObject.newObject: prefix attribute = " + lDAPAttribute));
                object = lDAPAttribute.getStringValues();
                if (object != null && object.hasMoreElements()) {
                    object2 = (String)object.nextElement();
                    if (((String)object2).length() < 1) {
                        object2 = DEFAULT_NEW;
                        lDAPAttributeSet.remove(string);
                        lDAPAttributeSet.add(new LDAPAttribute(string, (String)object2));
                    }
                } else {
                    lDAPAttribute.addValue((String)object2);
                }
            } else {
                lDAPAttribute = new LDAPAttribute(string, (String)object2);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            object = string + "=" + (String)object2;
            String string4 = this.getDN();
            if (string4 != null && string4.length() > 0) {
                lDAPEntry = new DN(string4);
                lDAPEntry.addRDN(new RDN((String)object));
                object = lDAPEntry.toRFCString();
            }
            lDAPEntry = new LDAPEntry((String)object, lDAPAttributeSet);
            DSEntryObject dSEntryObject = this.nodeFromEntry(lDAPEntry);
            Debug.println((String)("DSEntryObject.newObject: editing entry: " + lDAPEntry));
            if (dSEntryObject.addGeneric(true)) {
                this.reload();
                this.updateInTree();
            }
        }
    }

    protected void getObjectClassVector(String string, LDAPSchema lDAPSchema, Vector vector) {
        DSSchemaHelper.getObjectClassVector(string, lDAPSchema, vector);
    }

    protected Vector getObjectClassVector(String string, LDAPSchema lDAPSchema) {
        return DSSchemaHelper.getObjectClassVector(string, lDAPSchema);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isStandardObjectClass(Enumeration var0, ConsoleInfo var1_1) {
        var2_2 = ResourceEditor.getResourceEditorExtension();
        if (var2_2 != null) ** GOTO lbl8
        Debug.println((String)"DSEntryObject.isStandardObjectClass: No resourceEditorExtension in ConsoleInfo");
        return false;
lbl-1000:
        // 1 sources

        {
            var3_3 = ((String)var0.nextElement()).toLowerCase();
            if (var2_2.get(var3_3) == null) continue;
            return true;
lbl8:
            // 2 sources

            ** while (var0.hasMoreElements())
        }
lbl9:
        // 1 sources

        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void editProperties() {
        block11: {
            block10: {
                if (this._isBogus) {
                    return;
                }
                this._model.setWaitCursor(true);
                try {
                    try {
                        IDSEntryObject iDSEntryObject = this.getParentNode();
                        Debug.println((String)("DSEntryObject.editProperties: model = " + this._model + ", panel = " + this._customizePanel + ", parent node = " + iDSEntryObject));
                        String string = this.getDisplayName();
                        this._entry = null;
                        this.getEntry();
                        if (this._entry == null) {
                            DSUtil.showErrorDialog((Component)this._model.getFrame(), "entryNotFound", string);
                            this._model.removeElement(this);
                            Object var9_4 = null;
                            this._model.setWaitCursor(false);
                            return;
                        }
                        ConsoleInfo consoleInfo = (ConsoleInfo)this._model.getServerInfo().clone();
                        consoleInfo.setUserLDAPConnection(consoleInfo.getLDAPConnection());
                        consoleInfo.setUserHost(consoleInfo.getLDAPConnection().getHost());
                        consoleInfo.setUserPort(consoleInfo.getLDAPConnection().getPort());
                        String string2 = MappingUtils.getTopSuffixForEntry(this.getDN(), DSContentModel.getSuffixes());
                        if (string2 != null) {
                            consoleInfo.setUserBaseDN(string2);
                        }
                        if (DSEntryObject.isStandardObjectClass(this._objectClasses.elements(), consoleInfo)) {
                            DSResourceEditor dSResourceEditor = new DSResourceEditor(this._model.getFrame(), consoleInfo, this._entry);
                            String string3 = _resource.getString("UserGroup", "Advanced-label");
                            dSResourceEditor.registerAdvancedOption(new UserGroupAdapter(string3));
                            this._model.setWaitCursor(false);
                            dSResourceEditor.showModal();
                            ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSResourceEditor), (Frame)this._model.getFrame());
                            this.setDN(dSResourceEditor.getLDAPEntry().getDN());
                            String string4 = this.getDisplayNameFromDN(this._model, this.getDN());
                            this.setDisplayName(string4);
                            this.setName(string4);
                            this._entry = null;
                            this.getEntry();
                            break block10;
                        }
                        this._model.setWaitCursor(false);
                        this.editGeneric(true, true);
                        this._entry = null;
                        this.getEntry();
                        if (!this.isRootDSE()) {
                            this.setIcon((Icon)this.checkIcon(this._objectClasses, this.isLeafType()));
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        Debug.println((String)("DSEntryObject.editProperties <" + this.getDN() + "> " + exception));
                        exception.printStackTrace();
                        Object var9_7 = null;
                        this._model.setWaitCursor(false);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    this._model.setWaitCursor(false);
                    throw throwable;
                }
            }
            Object var9_5 = null;
            this._model.setWaitCursor(false);
            return;
        }
        Object var9_6 = null;
        this._model.setWaitCursor(false);
    }

    public void performAction(String string) {
        Debug.println((String)("DSEntryObject.performAction " + string));
    }

    public boolean run(IPage iPage) {
        this.editProperties();
        return false;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        this.editProperties();
        return false;
    }

    public void unselect(IPage iPage) {
        if (this._dataModel != null) {
            this._dataModel.reset();
            this._dataModel = null;
        }
        if (this._customizePanel != null) {
            this._customizePanel.removeAllElements();
            this._customizePanel = null;
        }
    }

    public void select(IPage iPage) {
    }

    public IDSEntryObject getParentNode() {
        return this._parent;
    }

    public void setParentNode(IDSEntryObject iDSEntryObject) {
        this._parent = iDSEntryObject;
    }

    public void setReferralsEnabled(boolean bl) {
        if (this._dataModel != null) {
            Debug.println((int)9, (String)("DSEntryObject.setReferralsEnabled: setting referrals on=" + bl + " for " + "model=" + this._dataModel));
            this._dataModel.setReferralsEnabled(bl);
        } else {
            Debug.println((int)9, (String)("DSEntryObject.setReferralsEnabled: _dataModel is null this=" + this + " on=" + bl));
        }
        this._followReferrals = bl;
    }

    public boolean getReferralsEnabled() {
        Debug.println((int)9, (String)("DSEntryObject.getReferralsEnabled: this=" + this + " referrals=" + this._followReferrals));
        return this._followReferrals;
    }

    public void propagateReferralsEnabled(boolean bl) {
        Debug.println((int)9, (String)("DSEntryObject.propagateReferralsEnabled: referrals on=" + bl));
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)((Object)this)).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DSEntryObject dSEntryObject = (DSEntryObject)enumeration.nextElement();
            Debug.println((int)9, (String)("DSEntryObject.propagateReferralsEnabled: setting referrals to " + bl + " for " + dSEntryObject));
            dSEntryObject.setReferralsEnabled(bl);
        }
    }

    public String toString() {
        return "DSEntryObject for " + this.getDN();
    }

    private LDAPEntry sortByAttribute(LDAPEntry lDAPEntry) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        int n = lDAPAttributeSet.size();
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[n];
        int n2 = 0;
        while (n2 < n) {
            lDAPAttributeArray[n2] = lDAPAttributeSet.elementAt(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = n3 + 1;
            while (n4 < n) {
                if (lDAPAttributeArray[n3].getName().compareTo(lDAPAttributeArray[n4].getName()) > 0) {
                    LDAPAttribute lDAPAttribute = lDAPAttributeArray[n3];
                    lDAPAttributeArray[n3] = lDAPAttributeArray[n4];
                    lDAPAttributeArray[n4] = lDAPAttribute;
                }
                ++n4;
            }
            ++n3;
        }
        LDAPAttributeSet lDAPAttributeSet2 = new LDAPAttributeSet();
        int n5 = 0;
        while (n5 < n) {
            lDAPAttributeSet2.add(lDAPAttributeArray[n5]);
            ++n5;
        }
        return new LDAPEntry(lDAPEntry.getDN(), lDAPAttributeSet2);
    }

    private void sortEntryVector(Vector vector) {
        int n = vector.size();
        if (n > 1) {
            Hashtable<String, DSEntryObject> hashtable = new Hashtable<String, DSEntryObject>();
            String[] stringArray = new String[n];
            Enumeration enumeration = vector.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                String string;
                DSEntryObject dSEntryObject = (DSEntryObject)enumeration.nextElement();
                stringArray[n2] = string = dSEntryObject.getDisplayName().toLowerCase();
                ++n2;
                hashtable.put(string, dSEntryObject);
            }
            DSUtil.trimAndBubbleSort(stringArray, false);
            vector.removeAllElements();
            n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(hashtable.get(stringArray[n2]));
                ++n2;
            }
        }
    }

    public boolean childExists(IDSEntryObject iDSEntryObject) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)((Object)this)).children();
        while (enumeration.hasMoreElements()) {
            DSEntryObject dSEntryObject = (DSEntryObject)enumeration.nextElement();
            if (!dSEntryObject.getDN().equals(iDSEntryObject.getDN())) continue;
            return true;
        }
        return false;
    }

    public static DSEntryObject getBogusEntryObject() {
        DSEntryObject dSEntryObject = new DSEntryObject(true);
        dSEntryObject.setDN(BOGUS_LABEL);
        dSEntryObject.setDisplayName(BOGUS_LABEL);
        dSEntryObject.setIcon((Icon)BOGUS_ICON);
        return dSEntryObject;
    }

    private static boolean isRootDSE(String string) {
        return string == null || string.equals("");
    }

    private boolean isRootDSE() {
        return DSEntryObject.isRootDSE(this.getDN());
    }

    public void setSelectedPartitionView(String string) {
        this._selectedPartitionView = string;
    }

    public String getSelectedPartitionView() {
        return this._selectedPartitionView;
    }

    private boolean isActivated() {
        if (this._model instanceof DSContentModel && !((DSContentModel)this._model).isViewAccountInactivationSelected()) {
            return true;
        }
        LDAPEntry lDAPEntry = this.getEntry();
        if (lDAPEntry == null) {
            return true;
        }
        AccountInactivation accountInactivation = new AccountInactivation(lDAPEntry);
        boolean bl = true;
        try {
            bl = !accountInactivation.isLocked(this.getLDAPConnection());
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSEntryObject.isActivated(): " + (Object)((Object)lDAPException)));
        }
        return bl;
    }

    private boolean isRole() {
        LDAPEntry lDAPEntry = this.getEntry();
        if (lDAPEntry == null) {
            return false;
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(OBJECTCLASS_ATTR);
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            boolean bl = false;
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                if (string.equalsIgnoreCase(NSROLEDEFINITION_ATTR)) {
                    bl = true;
                } else if (string.equalsIgnoreCase("ldapsubentry")) {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                return true;
            }
        }
        return false;
    }

    static {
        _showAliases = true;
        _manageDSAITControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
        MINIMAL_ATTRS = new String[]{OBJECTCLASS_ATTR, SUBORDINATE_ATTR, NSACCOUNTLOCK_ATTR};
        PREFIXES = new String[]{"cn", "uid", "ou", "dc", "o"};
        DEFAULT_NEW = _resource.getString(_section, "defaultnew");
        BOGUS_ICON_NAME = _resource.getString(_section, "bogus-icon");
        BOGUS_ICON = DSUtil.getPackageImage(BOGUS_ICON_NAME);
        BOGUS_LABEL = _resource.getString(_section, "bogus-label");
    }

    class UserGroupAdapter
    implements IResEditorAdvancedOpt {
        private String _buttonText = null;

        UserGroupAdapter(String string) {
            this._buttonText = string;
        }

        public String getButtonText() {
            return this._buttonText;
        }

        public boolean run(ConsoleInfo consoleInfo, ResourcePageObservable resourcePageObservable) {
            DSEntryDialog dSEntryDialog;
            String string;
            if (resourcePageObservable.isNewUser()) {
                Object object;
                Object[] objectArray;
                Vector vector;
                String string2;
                string = resourcePageObservable.getDN();
                Debug.println((String)("DSEntryObject.UserGroupAdapter.run: DN = " + string));
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                Enumeration enumeration = resourcePageObservable.getAttributesList();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        vector = resourcePageObservable.get(string2);
                        objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        lDAPAttributeSet.add(new LDAPAttribute(string2, (String[])objectArray));
                        vector.removeAllElements();
                    }
                }
                string2 = "cn";
                vector = resourcePageObservable.get(DSEntryObject.OBJECTCLASS_ATTR);
                objectArray = DSEntryObject.this._model.getSchema();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    Enumeration enumeration2 = DSSchemaHelper.allRequiredAttributes((String)object, (LDAPSchema)objectArray);
                    while (enumeration2.hasMoreElements()) {
                        String string3 = (String)enumeration2.nextElement();
                        if (lDAPAttributeSet.getAttribute(string3) != null) continue;
                        lDAPAttributeSet.add(new LDAPAttribute(string3, ""));
                    }
                    if (((String)object).equalsIgnoreCase("person")) {
                        string2 = "uid";
                        continue;
                    }
                    if (!((String)object).equalsIgnoreCase("organizationalunit")) continue;
                    string2 = "ou";
                }
                Debug.println((String)("DSEntryObject.UserGroupAdapter.run: key = " + string2));
                if (string == null) {
                    object = this.getFirstStringValue(lDAPAttributeSet, string2);
                    if (object == null || ((String)object).length() < 1) {
                        object = DEFAULT_NEW;
                        Debug.println((String)("DSEntryObject.UserGroupAdapter.run: Adding " + string2 + "=" + (String)object));
                    }
                    string = string2 + "=" + (String)object + ", " + DSEntryObject.this.getDN();
                    Debug.println((String)("DSEntryObject.UserGroupAdapter.run: Setting dn = " + string));
                }
                LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                object = DSEntryObject.this.nodeFromEntry(lDAPEntry);
                dSEntryDialog = ((DSEntryObject)object).editGeneric(true, false);
                lDAPEntry = ((DSEntryObject)object).getEntry();
            } else {
                dSEntryDialog = DSEntryObject.this.editGeneric(true, false);
                LDAPEntry lDAPEntry = DSEntryObject.this.getEntry();
            }
            if (dSEntryDialog != null && (string = dSEntryDialog.getChanges()) != null) {
                Debug.println((int)9, (String)("DSEntryObject.UserGroupAdapter.run: dialog mod set=" + string.elementAt(0)));
                this.updateObservable(resourcePageObservable, (LDAPModificationSet)string);
            }
            return dSEntryDialog != null;
        }

        private String getFirstStringValue(LDAPAttributeSet lDAPAttributeSet, String string) {
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute(string);
            if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
                return ((String)enumeration.nextElement()).trim();
            }
            return null;
        }

        private void updateObservable(ResourcePageObservable resourcePageObservable, LDAPModificationSet lDAPModificationSet) {
            Vector vector = new Vector();
            int n = 0;
            while (n < lDAPModificationSet.size()) {
                LDAPModification lDAPModification = lDAPModificationSet.elementAt(n);
                LDAPAttribute lDAPAttribute = lDAPModification.getAttribute();
                Enumeration enumeration = lDAPAttribute.getByteValues();
                if (enumeration == null) {
                    enumeration = lDAPAttribute.getStringValues();
                }
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                switch (lDAPModification.getOp()) {
                    case 0: {
                        resourcePageObservable.add(lDAPAttribute.getName(), vector);
                        break;
                    }
                    case 2: {
                        resourcePageObservable.replace(lDAPAttribute.getName(), vector);
                        break;
                    }
                    case 1: {
                        Enumeration enumeration2 = lDAPAttribute.getStringValues();
                        if (enumeration2 != null) {
                            if (enumeration2.hasMoreElements()) {
                                resourcePageObservable.delete(lDAPAttribute.getName(), (String)enumeration2.nextElement());
                            } else {
                                resourcePageObservable.delete(lDAPAttribute.getName());
                            }
                            while (enumeration2.hasMoreElements()) {
                                resourcePageObservable.delete(lDAPAttribute.getName(), (String)enumeration2.nextElement());
                            }
                            break;
                        }
                        resourcePageObservable.delete(lDAPAttribute.getName());
                    }
                }
                vector.removeAllElements();
                ++n;
            }
        }
    }

    class NoListPanel
    extends JPanel {
        NoListPanel() {
            String string = _resource.getString(DSEntryObject._section, "too-many-children-label");
            JLabel jLabel = new JLabel(string);
            this.add(jLabel);
        }
    }
}

