/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSBaseModel;
import com.netscape.admin.dirserv.DSContentModel;
import com.netscape.admin.dirserv.DSMenu;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSEntryObject;
import com.netscape.admin.dirserv.IDSResourceSelectionListener;
import com.netscape.admin.dirserv.IDSResourceSelectionModel;
import com.netscape.admin.dirserv.SuiScrollPane;
import com.netscape.admin.dirserv.VListEntryModel;
import com.netscape.admin.dirserv.account.AccountInactivation;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import com.netscape.management.nmclf.SuiListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class DSEntryList
extends JPanel
implements IDSResourceSelectionModel,
IDSResourceSelectionListener,
ListSelectionListener,
ListDataListener,
ActionListener,
FocusListener,
MouseListener,
MouseMotionListener {
    private String _host;
    private int _port;
    private String _authDN;
    private String _authPassword;
    private JList _entryList;
    private Vector _entries = null;
    private VListEntryModel _dataModel = null;
    private DSBaseModel _model = null;
    private JPopupMenu _contextMenu;
    private JMenuItem _pasteMenuItem;
    private JMenuItem _activateMenuItem;
    private JMenuItem _inactivateMenuItem;
    private Vector _selectionListeners = new Vector();
    private IDSEntryObject _parent = null;
    private boolean _hasVlist = true;
    private IResourceObject[] _previousSelection = new IResourceObject[0];
    private SuiScrollPane _scrollPane = null;
    static ResourceSet _resource = DSUtil._resource;
    static final String _section = "entryList";
    private static Color backgroundColor = UIManager.getColor("List.background");
    private static final int ROW_HEIGHT = 10;

    public DSEntryList(LDAPConnection lDAPConnection, String string, int n, String string2, DSBaseModel dSBaseModel, IDSEntryObject iDSEntryObject) {
        this._model = dSBaseModel;
        this._parent = iDSEntryObject;
        this._host = lDAPConnection.getHost();
        this._port = lDAPConnection.getPort();
        this._authDN = lDAPConnection.getAuthenticationDN();
        this._authPassword = lDAPConnection.getAuthenticationPassword();
        this._hasVlist = true;
        this._dataModel = new VListEntryModel(lDAPConnection, string, n, string2, dSBaseModel, iDSEntryObject.getSelectedPartitionView());
        this._dataModel.setDebug(Debug.getTrace());
        if (iDSEntryObject != null) {
            Debug.println((int)9, (String)("DSEntryList.DSEntryList: referrals=" + iDSEntryObject.getReferralsEnabled()));
            this._dataModel.setReferralsEnabled(iDSEntryObject.getReferralsEnabled());
        }
        this._entryList = new JList(this._dataModel);
        this.init();
    }

    public DSEntryList(Vector vector, DSBaseModel dSBaseModel, IDSEntryObject iDSEntryObject) {
        this._entries = vector;
        this._model = dSBaseModel;
        this._parent = iDSEntryObject;
        this._hasVlist = false;
        this._entryList = new JList(vector);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBackground(backgroundColor);
        this.setBorder(UITools.createLoweredBorder());
        IconLabelCellRenderer iconLabelCellRenderer = new IconLabelCellRenderer();
        this._entryList.setCellRenderer(iconLabelCellRenderer);
        this._entryList.setPrototypeCellValue("1234567890 1234567890");
        this._entryList.setValueIsAdjusting(false);
        ListKeyListener listKeyListener = new ListKeyListener();
        this._entryList.addKeyListener(listKeyListener);
        this.addKeyListener(listKeyListener);
        this._entryList.addMouseListener(this);
        this._entryList.addMouseMotionListener(this);
        this._entryList.registerKeyboardAction(new ListActionListener(this, "open"), KeyStroke.getKeyStroke(10, 0), 0);
        this._entryList.registerKeyboardAction(new ListActionListener(this, "acl"), KeyStroke.getKeyStroke(65, 0), 0);
        this._entryList.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DSEntryList.this._entryList.getToolTipText();
                if (string != null) {
                    StringSelection stringSelection = new StringSelection(string);
                    DSEntryList.this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                }
            }
        }, KeyStroke.getKeyStroke(67, 3), 0);
        this._entryList.addListSelectionListener(this);
        this._entryList.getSelectionModel().setSelectionMode(2);
        this._scrollPane = new SuiScrollPane(this._entryList);
        ((JComponent)((Object)this._scrollPane)).setBorder(new EmptyBorder(0, 0, 0, 0));
        ((Component)((Object)this._scrollPane)).addKeyListener(listKeyListener);
        ((JScrollPane)((Object)this._scrollPane)).getVerticalScrollBar().addKeyListener(listKeyListener);
        int n = 10;
        if (this._entryList.getCellBounds(0, 0) != null) {
            n = this._entryList.getCellBounds((int)0, (int)0).height;
        }
        ((JScrollPane)((Object)this._scrollPane)).getVerticalScrollBar().setUnitIncrement(n);
        this.add((Component)((Object)this._scrollPane), "Center");
        this._contextMenu = new JPopupMenu();
        this._entryList.add(this._contextMenu);
        DSMenu.addMenuItem(_section, "Edit", this._contextMenu, this, _resource, false);
        Component[] componentArray = this._contextMenu.getComponents();
        if (componentArray != null) {
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof JMenuItem) {
                    String string = ((JMenuItem)componentArray[n2]).getActionCommand();
                    if (string.equals("paste")) {
                        this._pasteMenuItem = (JMenuItem)componentArray[n2];
                    } else if (string.equals("activate")) {
                        this._activateMenuItem = (JMenuItem)componentArray[n2];
                    } else if (string.equals("inactivate")) {
                        this._inactivateMenuItem = (JMenuItem)componentArray[n2];
                    }
                }
                ++n2;
            }
        }
        this._entryList.addFocusListener(this);
        this.repaint();
        this.validate();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    private IDSEntryObject getEntryObject(int n) {
        IDSEntryObject iDSEntryObject = this._hasVlist ? (IDSEntryObject)this._entryList.getModel().getElementAt(n) : (IDSEntryObject)this._entries.elementAt(n);
        if (iDSEntryObject != null) {
            iDSEntryObject.setParentNode(this._parent);
        }
        return iDSEntryObject;
    }

    public IDSEntryObject getEntryObject(String string) {
        block6: {
            Vector vector;
            DN dN;
            block5: {
                dN = new DN(string);
                if (this._hasVlist) break block5;
                if (this._entries == null) break block6;
                int n = this._entries.size();
                int n2 = 0;
                while (n2 < n) {
                    DN dN2;
                    Object e = this._entries.elementAt(n2);
                    if (e instanceof IDSEntryObject && (dN2 = new DN(((IDSEntryObject)e).getDN())).equals(dN)) {
                        return (IDSEntryObject)e;
                    }
                    ++n2;
                }
                break block6;
            }
            if (this._dataModel != null && (vector = this._dataModel.getStoredEntries()) != null) {
                int n = vector.size();
                int n3 = 0;
                while (n3 < n) {
                    DN dN3;
                    Object e = vector.elementAt(n3);
                    if (e instanceof IDSEntryObject && (dN3 = new DN(((IDSEntryObject)e).getDN())).equals(dN)) {
                        return (IDSEntryObject)e;
                    }
                    ++n3;
                }
            }
        }
        return null;
    }

    public DN getParentDN() {
        block6: {
            Vector vector;
            block5: {
                if (this._hasVlist) break block5;
                if (this._entries == null) break block6;
                int n = 0;
                while (n < this._entries.size()) {
                    DN dN;
                    Object e = this._entries.elementAt(n);
                    if (e != null && e instanceof IDSEntryObject && (dN = new DN(((IDSEntryObject)e).getDN())) != null) {
                        return dN.getParent();
                    }
                    ++n;
                }
                break block6;
            }
            if (this._dataModel != null && (vector = this._dataModel.getStoredEntries()) != null) {
                int n = 0;
                while (n < vector.size()) {
                    DN dN;
                    Object e = vector.elementAt(n);
                    if (e != null && e instanceof IDSEntryObject && (dN = new DN(((IDSEntryObject)e).getDN())) != null) {
                        return dN.getParent();
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    void recalculate() {
        if (this._hasVlist) {
            Debug.println((int)9, (String)"DSEntryList.recalculate");
            this._dataModel.recalculate();
        } else {
            Debug.println((int)9, (String)("DSEntryList.recalculate: _entries=" + this._entries.size()));
            this._entryList.setListData(this._entries);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Debug.println((String)("DSEntryList.actionPerformed <" + actionEvent + "> <" + actionEvent.getSource() + ">" + " _model=" + this._model));
        IResourceObject[] iResourceObjectArray = this.getCurrentSelection();
        if (iResourceObjectArray.length > 0) {
            this._model.actionSelected(actionEvent.getActionCommand(), iResourceObjectArray, this._model.getSelectedPage());
        }
    }

    private IResourceObject[] getCurrentSelection() {
        int[] nArray = this._entryList.getSelectedIndices();
        if (nArray.length > 0) {
            IResourceObject[] iResourceObjectArray = new IResourceObject[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                iResourceObjectArray[n] = this.getEntryObject(nArray[n]);
                ++n;
            }
            return iResourceObjectArray;
        }
        return new IResourceObject[0];
    }

    void singleClicked(MouseEvent mouseEvent) {
        int n;
        Debug.println((String)("DSEntryList.singleClicked " + mouseEvent));
        int n2 = this._entryList.locationToIndex(mouseEvent.getPoint());
        if (n2 >= 0 && ((n = mouseEvent.getModifiers()) & 4) != 0) {
            this.popup(mouseEvent);
        }
    }

    void doubleClicked(MouseEvent mouseEvent) {
        IDSEntryObject iDSEntryObject;
        int n = this._entryList.locationToIndex(mouseEvent.getPoint());
        if (n >= 0 && (iDSEntryObject = this.getEntryObject(n)) != null) {
            iDSEntryObject.editProperties();
        }
    }

    private void popup(MouseEvent mouseEvent) {
        Debug.println((String)("DSEntryList.popup " + mouseEvent));
        if (this._contextMenu != null) {
            int[] nArray;
            if (this._model instanceof DSContentModel && this._pasteMenuItem != null) {
                if (((DSContentModel)this._model).isClipboardEmpty()) {
                    this._pasteMenuItem.setEnabled(false);
                } else {
                    this._pasteMenuItem.setEnabled(true);
                }
            }
            if ((nArray = this._entryList.getSelectedIndices()).length > 0) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n = 0;
                while (n < nArray.length) {
                    LDAPEntry lDAPEntry;
                    IDSEntryObject iDSEntryObject;
                    int n2 = nArray[n];
                    if (n2 >= 0 && (iDSEntryObject = this.getEntryObject(n2)) != null && (lDAPEntry = iDSEntryObject.getEntry()) != null) {
                        AccountInactivation accountInactivation = new AccountInactivation(lDAPEntry);
                        try {
                            bl3 = accountInactivation.isLocked(this._model.getServerInfo().getLDAPConnection());
                            bl = bl || bl3;
                            bl2 = bl2 || !bl3;
                        }
                        catch (LDAPException lDAPException) {
                            Debug.println((String)("DSEntryList.popup() " + (Object)((Object)lDAPException)));
                        }
                    }
                    ++n;
                }
                if (bl) {
                    if (this._activateMenuItem != null) {
                        this._activateMenuItem.setEnabled(true);
                    }
                } else if (this._activateMenuItem != null) {
                    this._activateMenuItem.setEnabled(false);
                }
                if (bl2) {
                    if (this._inactivateMenuItem != null) {
                        this._inactivateMenuItem.setEnabled(true);
                    }
                } else if (this._inactivateMenuItem != null) {
                    this._inactivateMenuItem.setEnabled(false);
                }
            }
            this._contextMenu.show(this._entryList, mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    void keyEvent(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        Debug.println((String)("DSEntryList keyEvent " + n));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2 && (n & 4) == 0) {
            this.doubleClicked(mouseEvent);
        } else {
            this.singleClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        IDSEntryObject iDSEntryObject;
        Point point = mouseEvent.getPoint();
        int n = this._entryList.locationToIndex(point);
        String string = null;
        if (n >= 0 && (iDSEntryObject = this.getEntryObject(n)) != null) {
            string = iDSEntryObject.getDN();
        }
        this._entryList.setToolTipText(string);
    }

    void setData(Vector vector) {
        this._entries = vector;
        this.recalculate();
    }

    void addElement(Object object) {
        if (this._entries != null) {
            this._entries.addElement(object);
        }
        this.recalculate();
    }

    public void removeElement(Object object) {
        if (this._entries != null) {
            this._entries.removeElement(object);
        }
        this.recalculate();
    }

    void removeAllElements() {
        if (this._entries != null) {
            this._entries.removeAllElements();
        }
        if (this._dataModel != null) {
            this._dataModel.reset();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        IResourceObject[] iResourceObjectArray = this._previousSelection;
        IResourceObject[] iResourceObjectArray2 = this.getCurrentSelection();
        this._previousSelection = iResourceObjectArray2;
        this._model.setSelected(this._model.getSelectedPage(), iResourceObjectArray2, iResourceObjectArray);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        Debug.println((String)("DSEntryList.intervalChanged " + listDataEvent));
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        Debug.println((String)("DSEntryList.intervalRemoved " + listDataEvent));
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        Debug.println((String)("DSEntryList.contentsChanged " + listDataEvent));
    }

    public void addIDSResourceSelectionListener(IDSResourceSelectionListener iDSResourceSelectionListener) {
        this._selectionListeners.addElement(iDSResourceSelectionListener);
    }

    public void removeIDSResourceSelectionListener(IDSResourceSelectionListener iDSResourceSelectionListener) {
        this._selectionListeners.removeElement(iDSResourceSelectionListener);
    }

    public Enumeration getSelectionListeners() {
        return this._selectionListeners.elements();
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        Debug.println((String)"DSEntryList.select() called.");
    }

    public void unselect(IResourceObject iResourceObject, IPage iPage) {
        Debug.println((String)"DSEntryList.unselect() called.");
    }

    class IconLabelCellRenderer
    extends SuiListCellRenderer {
        IconLabelCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object == null) {
                string = "null";
            } else if (object instanceof IDSEntryObject) {
                IDSEntryObject iDSEntryObject = (IDSEntryObject)object;
                string = iDSEntryObject.getDisplayName();
                ((JLabel)((Object)this)).setIcon(iDSEntryObject.getIcon());
            } else {
                string = object.toString();
            }
            return super.getListCellRendererComponent(jList, (Object)string, n, bl, bl2);
        }
    }

    class ListActionListener
    implements ActionListener {
        private String _cmd;
        private ActionListener _parent;

        ListActionListener(ActionListener actionListener, String string) {
            this._parent = actionListener;
            this._cmd = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Debug.println((String)("DSEntryListActionListener.actionPerformed <" + actionEvent + "> <" + actionEvent.getSource() + "> <" + actionEvent.getActionCommand() + ">"));
            this._parent.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this._cmd, actionEvent.getModifiers()));
        }
    }

    class ListKeyListener
    implements KeyListener {
        private final int _key = 16;
        private boolean _pressed = false;

        ListKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!this._pressed & keyEvent.getKeyCode() == 16) {
                Debug.println((String)"Key pressed");
                this._pressed = true;
                DSEntryList.this._scrollPane.setUpdateWhileAdjusting(this._pressed);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 16) {
                Debug.println((String)"Key released");
                this._pressed = false;
                DSEntryList.this._scrollPane.setUpdateWhileAdjusting(this._pressed);
            }
        }
    }
}

