/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.Activator;
import com.netscape.admin.dirserv.AttributeController;
import com.netscape.admin.dirserv.Clipboard;
import com.netscape.admin.dirserv.ContentMenuController;
import com.netscape.admin.dirserv.Copier;
import com.netscape.admin.dirserv.CutDeleter;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSSearchPanel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DatabaseConfig;
import com.netscape.admin.dirserv.DisplayedChildrenLimitExceededDialog;
import com.netscape.admin.dirserv.EntryEditor;
import com.netscape.admin.dirserv.Helper;
import com.netscape.admin.dirserv.IAuthenticationChangeListener;
import com.netscape.admin.dirserv.IContentPageInfo;
import com.netscape.admin.dirserv.Inactivator;
import com.netscape.admin.dirserv.Paster;
import com.netscape.admin.dirserv.RemoteNodeInformationDialog;
import com.netscape.admin.dirserv.SearchUG;
import com.netscape.admin.dirserv.SimpleReferral;
import com.netscape.admin.dirserv.SortedChildrenLimitExceededDialog;
import com.netscape.admin.dirserv.SwingWorker;
import com.netscape.admin.dirserv.account.AccountInactivation;
import com.netscape.admin.dirserv.browser.BrowserController;
import com.netscape.admin.dirserv.browser.BrowserEvent;
import com.netscape.admin.dirserv.browser.BrowserEventListener;
import com.netscape.admin.dirserv.browser.ChildrenController;
import com.netscape.admin.dirserv.browser.IBrowserNodeInfo;
import com.netscape.admin.dirserv.browser.IconPool;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.panel.NonResolvedReferralDialog;
import com.netscape.admin.dirserv.panel.ReferralEditor;
import com.netscape.admin.dirserv.roledit.RoleEditorDialog;
import com.netscape.admin.dirserv.task.CreateVLVIndex;
import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.ace.ACIManager;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.ug.IRPCallBack;
import com.netscape.management.client.ug.IResourcePickerPlugin;
import com.netscape.management.client.ug.ResourcePickerDlg;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;

public class DSContentPage
extends JPanel
implements IPage,
SuiConstants,
IAuthenticationChangeListener,
BrowserEventListener,
TreeSelectionListener,
TreeWillExpandListener,
ListSelectionListener,
ActionListener,
MouseListener,
IContentPageInfo {
    DSFramework _framework;
    DatabaseConfig _databaseConfig;
    EntryEditor _entryEditor;
    LDAPConnectionPool _connectionPool;
    IconPool _iconPool;
    BrowserController _controller;
    ContentMenuController _menuController;
    protected JTree _tree;
    protected JScrollPane _treePanel;
    protected JList _list;
    protected JScrollPane _childrenPanel;
    protected Component _lastSelectedComponent;
    Color _listDefaultColor;
    Color _listDisabledColor;
    ChildrenController _childrenController;
    JPanel _attributePanel;
    AttributeController _attributeController;
    protected JPopupMenu _contextMenu;
    JLabel _selectedDnLabel;
    JLabel _statusLabel;
    JSplitPane _splitPanel;
    JPanel _displayedPanel;
    boolean _showRemoteInformationDialog;
    boolean _showDisplayedChildrenLimitExceededDialog;
    boolean _showSortedChildrenLimitExceededDialog;
    private String _selectedPartitionView = "ALL_PARTITIONS";
    static ResourceSet _resource = DSUtil._resource;
    static final String NO_SELECTED_DN = "  ";
    static final String[] CONTAINER_OBJECTCLASSES = new String[]{"organization", "organizationalUnit", "netscapeServer", "netscapeResource", "domain"};
    static final String DEFAULT_NEW = _resource.getString("EntryObject", "defaultnew");
    static final String SEARCH_OID = "2.16.840.1.113730.3.4.14";
    static final String SHOW_REMOTE_INFORMATION_DIALOG = "SHOW_REMOTE_INFORMATION_DIALOG";
    static final String SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED = "SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED";
    static final String SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED = "SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED";
    static final String SORT_PREFERENCES = "SORT_PREFERENCES";
    static final String FOLLOW_REFERRALS_PREFERENCES = "FOLLOW_REFERRALS_PREFERENCES";
    static final String DISPLAY_PREFERENCES = "DISPLAY_PREFERENCES";
    static final String LAYOUT_PREFERENCES = "LAYOUT_PREFERENCES";
    static final int NO_VLV_SORTED_LIMIT = 300;
    static final int DISPLAYED_CHILDREN_LIMIT = 5000;
    Preferences _preferences = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0").getPreferences("DS_MISCELLANEOUS");
    public static LDAPControl _manageDSAITControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
    private Hashtable _vlvCache = new Hashtable();
    private Hashtable _activationCache = new Hashtable();
    private String _layout = "NODE_LEAF_LAYOUT";
    private int _display;
    private boolean _isInitialized = false;
    private boolean _isPageSelected = false;
    private boolean _refreshUponSelect = false;
    private Clipboard _clipboard = new Clipboard();
    private Vector _authListeners = new Vector();
    private String[] _allAttrs = null;

    public void actionViewClosing(IFramework iFramework) throws CloseVetoException {
        Debug.println((String)"DSContentPage.actionViewClosing");
        if (this._controller != null) {
            this._controller.shutDown();
        }
        if (this._attributeController != null) {
            this._attributeController.shutDown();
        }
        if (this._childrenController != null) {
            this._childrenController.shutDown();
        }
    }

    public Object clone() {
        throw new IllegalStateException("DSContentPage.clone() should not be called");
    }

    public IFramework getFramework() {
        return this._framework;
    }

    public String getPageTitle() {
        return DSUtil._resource.getString("browser", "tab-title");
    }

    public void initialize(IFramework iFramework) {
        Debug.println((String)"DSContentPage.initialize");
        this._framework = (DSFramework)iFramework;
        this._showRemoteInformationDialog = this._preferences.getBoolean(SHOW_REMOTE_INFORMATION_DIALOG, true);
        this._showDisplayedChildrenLimitExceededDialog = this._preferences.getBoolean(SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED, true);
        this._showSortedChildrenLimitExceededDialog = this._preferences.getBoolean(SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED, true);
        final boolean bl = this._preferences.getBoolean(SORT_PREFERENCES, false);
        final boolean bl2 = this._preferences.getBoolean(FOLLOW_REFERRALS_PREFERENCES, true);
        this._display = this._preferences.getInt(DISPLAY_PREFERENCES, 1);
        this._layout = this._preferences.getString(LAYOUT_PREFERENCES, "NODE_LEAF_LAYOUT");
        this._tree = new JTree();
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.addTreeSelectionListener(this);
        this._tree.addTreeWillExpandListener(this);
        this._tree.addMouseListener(this);
        this._list = new JList(new DefaultListModel());
        this._list.setSelectionMode(0);
        this._list.addListSelectionListener(this);
        this._list.addMouseListener(this);
        this._listDefaultColor = this._list.getBackground();
        this._listDisabledColor = ((Component)((Object)this._framework)).getBackground();
        this._selectedDnLabel = new JLabel(NO_SELECTED_DN);
        this._selectedDnLabel.setLabelFor(this._tree);
        this._statusLabel = new JLabel("");
        this._statusLabel.setLabelFor(this._tree);
        ConsoleInfo consoleInfo = this._framework.getServerObject().getServerInfo();
        final LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        this._connectionPool = new LDAPConnectionPool();
        this._iconPool = new IconPool();
        this.layoutComponents();
        this._controller = new BrowserController(this._tree, this._connectionPool, this._iconPool);
        this._controller.addBrowserEventListener(this);
        this._controller.setLDAPConnection(lDAPConnection);
        this._controller.setShowContainerOnly(false);
        this._controller.setContainerClasses(CONTAINER_OBJECTCLASSES);
        this._controller.setMaxChildren(5000);
        this._childrenController = new ChildrenController(this._list, this._connectionPool, this._iconPool);
        this._childrenController.setLDAPConnection(lDAPConnection);
        this._childrenController.addBrowserEventListener(this);
        this._childrenController.setContainerClasses(CONTAINER_OBJECTCLASSES);
        this._childrenController.setMaxChildren(5000);
        this._attributeController = new AttributeController(this._connectionPool, this._attributePanel);
        this._databaseConfig = new DatabaseConfig();
        this._controller.setNumSubordinateHacker(this._databaseConfig.getNumSubordinateHacker());
        this._contextMenu = new JPopupMenu();
        this._menuController = new ContentMenuController(this, this._contextMenu, (IFramework)this._framework, this._databaseConfig, this);
        this._menuController.addShortCutRegisterer(this._tree);
        this._menuController.addShortCutRegisterer(this._list);
        SwingWorker swingWorker = new SwingWorker(){
            LDAPConnection _ldc;
            String[] _suffixes;
            {
                this._ldc = lDAPConnection;
            }

            public Object construct() {
                try {
                    DSContentPage.this._databaseConfig.reload(lDAPConnection);
                }
                catch (LDAPException lDAPException) {
                    LDAPException lDAPException2 = lDAPException;
                    SwingUtilities.invokeLater(new Runnable(this, lDAPException2){
                        private final /* synthetic */ LDAPException val$e;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$e = lDAPException;
                        }

                        public void run() {
                            String[] stringArray = new String[]{Helper.getLDAPErrorMessage(this.val$e)};
                            DSUtil.showErrorDialog((Component)((Object)1.access$000(this.this$1)._framework), "reading-databaseconfig-error-title", "reading-databaseconfig-error-msg", stringArray, "browser");
                        }
                    });
                }
                DSContentPage.this._entryEditor = new EntryEditor(DSContentPage.this.getSchema(), (JFrame)((Object)DSContentPage.this._framework), DSContentPage.this._databaseConfig);
                Vector vector = DSContentPage.this._databaseConfig.getRootSuffixesWithEntry();
                if (vector.size() > 0) {
                    this._suffixes = new String[vector.size()];
                    vector.copyInto(this._suffixes);
                }
                return null;
            }

            public void finished() {
                if (this._suffixes != null) {
                    int n = 0;
                    while (n < this._suffixes.length) {
                        DSContentPage.this._controller.addSuffix(this._suffixes[n], null);
                        ++n;
                    }
                    DSContentPage.this._controller.addSuffix("cn=schema", null);
                    DSContentPage.this._controller.addSuffix("cn=monitor", null);
                    DSContentPage.this._controller.addSuffix("cn=config", null);
                } else {
                    Debug.println((int)0, (String)"DSContentPage.initialize: no suffix found");
                }
                DSContentPage.this._childrenController.setSorted(bl);
                DSContentPage.this._controller.setShowContainerOnly(DSContentPage.this._layout.equals("NODE_LEAF_LAYOUT"));
                DSContentPage.this._controller.setSorted(bl);
                DSContentPage.this._controller.setFollowReferrals(bl2);
                DSContentPage.this._childrenController.setFollowReferrals(bl2);
                DSContentPage.this._controller.setDisplayFlags(DSContentPage.this._display);
                DSContentPage.this._childrenController.setDisplayFlags(DSContentPage.this._display);
                if (DSContentPage.this._isPageSelected) {
                    DSContentPage.this._menuController.populateMenuItems();
                }
                DSContentPage.this._tree.clearSelection();
                DSContentPage.this._menuController.disableMenus();
                DSContentPage.this._isInitialized = true;
            }

            static /* synthetic */ DSContentPage access$000(1 var0) {
                return var0.DSContentPage.this;
            }
        };
        swingWorker.start();
    }

    void layoutComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._treePanel = new JScrollPane(this._tree);
        this._treePanel.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        this._treePanel.setPreferredSize(new Dimension(200, 200));
        this._treePanel.setMinimumSize(new Dimension(1, 1));
        this._childrenPanel = new JScrollPane(this._list);
        this._childrenPanel.setBorder(new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow")));
        this._childrenPanel.setPreferredSize(new Dimension(200, 200));
        this._childrenPanel.setMinimumSize(new Dimension(1, 1));
        this._attributePanel = new JPanel(new GridBagLayout());
        this._splitPanel = new JSplitPane(1);
        this._splitPanel.setLeftComponent(this._treePanel);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._splitPanel.setRightComponent(this._childrenPanel);
        } else if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
            this._splitPanel.setRightComponent(this._attributePanel);
        }
        this._splitPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._displayedPanel = new JPanel(new BorderLayout());
        this.add((Component)this._displayedPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this._selectedDnLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this._statusLabel, gridBagConstraints);
        if (this._layout.equals("ONLY_TREE_LAYOUT")) {
            this._displayedPanel.add(this._treePanel);
        } else {
            this._displayedPanel.add(this._splitPanel);
        }
    }

    public void pageSelected(IFramework iFramework) {
        Debug.println((String)"DSContentPage.pageSelected ");
        this._isPageSelected = true;
        if (this._isInitialized) {
            try {
                this.RefreshDatabaseConfigAndSuffixes();
                this._menuController.populateMenuItems();
                this._menuController.recreateDynamicMenus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._refreshUponSelect) {
            this.actionRefreshTree();
            this._refreshUponSelect = false;
        }
    }

    public void pageUnselected(IFramework iFramework) {
        Debug.println((String)"DSContentPage.pageUnselected");
        this._isPageSelected = false;
        this._menuController.unpopulateMenuItems();
        this._controller.stopRefresh();
    }

    public boolean isRootSelected() {
        boolean bl = false;
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            bl = iBrowserNodeInfo.isRootNode();
        }
        return bl;
    }

    public boolean isSelectedNodeRemote() {
        boolean bl = false;
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            bl = iBrowserNodeInfo.isRemote();
        }
        return bl;
    }

    public boolean isClipboardEmpty() {
        return this._clipboard.isEmpty();
    }

    public Integer getSelectionVlvState() {
        String string;
        Integer n = new Integer(CreateVLVIndex.CAN_NOT_HAVE_INDEX);
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && (string = Helper.getNodeInfoDN(iBrowserNodeInfo)) != null && (n = (Integer)this._vlvCache.get(string)) == null) {
            try {
                n = new Integer(CreateVLVIndex.CAN_NOT_HAVE_INDEX);
                n = new Integer(CreateVLVIndex.indexStatus(string, this._framework.getServerObject().getServerInfo()));
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            this._vlvCache.put(string, n);
        }
        return n;
    }

    public Integer getSelectionActivationState() {
        String string;
        Integer n = new Integer(10);
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && (string = Helper.getNodeInfoDN(iBrowserNodeInfo)) != null && (n = (Integer)this._activationCache.get(string)) == null) {
            try {
                n = new Integer(10);
                String[] stringArray = new String[]{"nsrole", "nsroledn", "objectclass", "nsAccountLock"};
                LDAPConnection lDAPConnection = this.setReferralControl(this._framework.getServerObject().getServerInfo().getLDAPConnection());
                LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
                if (lDAPEntry != null) {
                    AccountInactivation accountInactivation = new AccountInactivation(lDAPEntry);
                    n = new Integer(accountInactivation.operationAllowed(lDAPConnection));
                }
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            this._activationCache.put(string, n);
        }
        return n;
    }

    public String getPanelLayout() {
        return this._layout;
    }

    public int getDisplay() {
        return this._display;
    }

    public boolean isSorted() {
        return this._controller.isSorted();
    }

    public boolean getFollowReferrals() {
        return this._controller.getFollowReferrals();
    }

    public String getSelectedPartitionView() {
        return this._selectedPartitionView;
    }

    public void authenticationChanged(String string, String string2, String string3, String string4) {
        Debug.println((String)("DSContentPage.authenticationChanged(): new bind DN = " + string2 + " old bind DN = " + string));
        if (this._framework != null) {
            LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
            if (this._controller != null) {
                this._controller.setLDAPConnection(lDAPConnection);
            }
            if (this._childrenController != null) {
                this._childrenController.setLDAPConnection(lDAPConnection);
            }
        }
        if (this._isPageSelected) {
            this.actionRefreshTree();
        } else if (this._isInitialized) {
            this._refreshUponSelect = true;
        }
    }

    public boolean getNewAuthentication() {
        boolean bl = false;
        DSUtil.DeferAuthListeners deferAuthListeners = null;
        String string = (String)this._framework.getServerObject().getServerInfo().get("rootdn");
        deferAuthListeners = DSUtil.reauthenticateDefer(this._framework.getServerObject().getServerInfo().getLDAPConnection(), (JFrame)((Object)this._framework), this._authListeners, string, null);
        boolean bl2 = bl = deferAuthListeners != null;
        if (bl) {
            deferAuthListeners.notifyListeners();
        }
        return bl;
    }

    public void setAuthenticationChangeListener(Vector vector) {
        this._authListeners = vector;
    }

    public void processBrowserEvent(BrowserEvent browserEvent) {
        switch (browserEvent.getID()) {
            case 1: {
                this._statusLabel.setText("Updating...");
                break;
            }
            case 2: {
                this._statusLabel.setText("");
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this._isInitialized) {
            this._lastSelectedComponent = this._tree;
            IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
            if (iBrowserNodeInfo == null) {
                this._menuController.disableMenus();
                this._selectedDnLabel.setText(NO_SELECTED_DN);
                if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                    this._childrenController.setBaseNodeInfo(null);
                    this._list.setBackground(this._listDefaultColor);
                } else if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
                    this._attributeController.clearAttributePanel();
                }
            } else {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                if (string == null || string.equals("")) {
                    this._selectedDnLabel.setText(NO_SELECTED_DN);
                } else {
                    this._selectedDnLabel.setText(this.findDisplayNameFromNode(iBrowserNodeInfo));
                }
                this._menuController.updateMenuState();
                if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                    boolean bl = this.checkChildrenForNode(iBrowserNodeInfo);
                    if (bl) {
                        this._childrenController.setBaseNodeInfo(iBrowserNodeInfo);
                        this._list.setBackground(this._listDefaultColor);
                    } else {
                        this._childrenController.setBaseNodeInfo(null);
                        this._list.setBackground(this._listDisabledColor);
                    }
                } else if (this._layout.equals("ATTRIBUTE_LAYOUT")) {
                    this._attributeController.updateAttributePanel(iBrowserNodeInfo);
                }
            }
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        boolean bl;
        IBrowserNodeInfo iBrowserNodeInfo;
        TreePath treePath;
        if (this._isInitialized && (treePath = treeExpansionEvent.getPath()) != null && (iBrowserNodeInfo = this._controller.getNodeInfoFromPath(treePath)) != null && !(bl = this.checkChildrenForNode(iBrowserNodeInfo))) {
            throw new ExpandVetoException(treeExpansionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._isInitialized) {
            this._lastSelectedComponent = this._list;
            IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
            if (iBrowserNodeInfo == null) {
                this._menuController.disableMenus();
                this._selectedDnLabel.setText(NO_SELECTED_DN);
            } else {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                if (string == null || string.equals("")) {
                    this._selectedDnLabel.setText(NO_SELECTED_DN);
                } else {
                    this._selectedDnLabel.setText(this.findDisplayNameFromNode(iBrowserNodeInfo));
                }
                this._menuController.updateMenuState();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setBusyCursor(true);
        String string = actionEvent.getActionCommand();
        Debug.println((String)("DSContentPage.actionPerformed(): " + string));
        if (string.equals("open")) {
            this.actionEdit();
        } else if (string.equals("advanced open")) {
            this.actionAdvancedEdit();
        } else if (string.equals("authenticate")) {
            this.actionAuthenticate();
        } else if (string.equals("copy")) {
            this.actionCopy();
        } else if (string.equals("paste")) {
            this.actionPaste();
        } else if (string.equals("cut")) {
            this.actionCut();
        } else if (string.equals("delete")) {
            this.actionDelete();
        } else if (string.equals("copydn")) {
            this.actionCopyDN();
        } else if (string.equals("copyldapurl")) {
            this.actionCopyLDAPURL();
        } else if (string.equals("newuser")) {
            this.actionNewUser();
        } else if (string.equals("newgroup")) {
            this.actionNewGroup();
        } else if (string.equals("newou")) {
            this.actionNewOrganizationalUnit();
        } else if (string.equals("newrole")) {
            this.actionNewRole();
        } else if (string.equals("newcos")) {
            this.actionNewCos();
        } else if (string.equals("newobject")) {
            this.actionNewObject();
        } else if (string.equals("acl")) {
            this.actionACL();
        } else if (string.equals("roles")) {
            this.actionRoles();
        } else if (string.equals("referral")) {
            this.actionSetReferral();
        } else if (string.equals("search")) {
            this.actionSearchUG();
        } else if (string.equals("createVLVIndex")) {
            this.actionCreateVLVIndex();
        } else if (string.equals("deleteVLVIndex")) {
            this.actionDeleteVLVIndex();
        } else if (string.equals("FOLLOW_REFERRALS")) {
            this.actionFollowReferrals();
        } else if (string.equals("REFRESHTREE")) {
            this.actionRefreshTree();
        } else if (string.equals("activate")) {
            this.actionActivate();
        } else if (string.equals("inactivate")) {
            this.actionInactivate();
        } else if (string.equals("ALL_PARTITIONS")) {
            this.actionSelectPartitionView("ALL_PARTITIONS");
        } else if (string.equals("DISPLAY_ACCOUNT_INACTIVATION")) {
            this.actionDisplayAccountInactivation();
        } else if (string.equals("DISPLAY_ACI_COUNT")) {
            this.actionDisplayACICount();
        } else if (string.equals("DISPLAY_ROLE_COUNT")) {
            this.actionDisplayRoleCount();
        } else if (string.equals("NODE_LEAF_LAYOUT")) {
            this.actionNodeLeafLayout();
        } else if (string.equals("ONLY_TREE_LAYOUT")) {
            this.actionOnlyTreeLayout();
        } else if (string.equals("ATTRIBUTE_LAYOUT")) {
            this.actionAttributeLayout();
        } else if (string.equals("SORT")) {
            this.actionSetSorted();
        } else {
            Vector vector = this._databaseConfig.getSuffixesWithoutEntryList();
            if (vector != null) {
                if (vector.indexOf(string) >= 0) {
                    this.actionCreateRootEntry(string);
                } else {
                    Vector vector2 = this._databaseConfig.getDatabaseList(0);
                    if (vector2.indexOf(string) >= 0) {
                        this.actionSelectPartitionView(string);
                    }
                }
            }
        }
        this.setBusyCursor(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._isInitialized && mouseEvent.getClickCount() == 2) {
            int n;
            int n2;
            if (this._lastSelectedComponent == this._tree) {
                TreePath treePath;
                TreePath treePath2 = this.getLastSelectedPath();
                if (treePath2 != null && (treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.equals(treePath2)) {
                    this.setBusyCursor(true);
                    this.actionEdit();
                    this.setBusyCursor(false);
                }
            } else if (this._lastSelectedComponent == this._list && (n2 = this.getLastSelectedIndex()) >= 0 && (n = this._list.locationToIndex(mouseEvent.getPoint())) == n2) {
                this.setBusyCursor(true);
                this.actionEdit();
                this.setBusyCursor(false);
            }
        }
    }

    private void popupContextMenu(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this._tree) {
            TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                if (!this._tree.isPathSelected(treePath)) {
                    this._tree.setSelectionPath(treePath);
                }
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Point point = this._tree.getLocationOnScreen();
                int n = (int)dimension.getWidth();
                int n2 = this._contextMenu.getWidth();
                int n3 = mouseEvent.getX();
                int n4 = (int)point.getX();
                int n5 = (int)dimension.getHeight();
                int n6 = this._contextMenu.getHeight();
                int n7 = mouseEvent.getY();
                int n8 = (int)point.getY();
                if (n4 + n3 + n2 > n) {
                    n3 -= n2;
                }
                if (n8 + n7 + n6 > n5) {
                    n7 -= n6;
                }
                this._contextMenu.show(component, n3, n7);
            }
        } else if (mouseEvent.getComponent() == this._list) {
            boolean bl;
            int n = this._list.locationToIndex(mouseEvent.getPoint());
            boolean bl2 = bl = n != -1;
            if (bl) {
                if (!this._list.isSelectedIndex(n)) {
                    this._list.setSelectedIndex(n);
                }
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Point point = this._list.getLocationOnScreen();
                int n9 = (int)dimension.getWidth();
                int n10 = this._contextMenu.getWidth();
                int n11 = mouseEvent.getX();
                int n12 = (int)point.getX();
                int n13 = (int)dimension.getHeight();
                int n14 = this._contextMenu.getHeight();
                int n15 = mouseEvent.getY();
                int n16 = (int)point.getY();
                if (n12 + n11 + n10 > n9) {
                    n11 -= n10;
                }
                if (n16 + n15 + n14 > n13) {
                    n15 -= n14;
                }
                this._contextMenu.show(component, n11, n15);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._contextMenu != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._contextMenu != null && !this._contextMenu.isVisible() && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.popupContextMenu(mouseEvent);
        }
    }

    private void RefreshDatabaseConfigAndSuffixes() {
        ConsoleInfo consoleInfo = this._framework.getServerObject().getServerInfo();
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        try {
            int n;
            Vector vector = this._databaseConfig.getRootSuffixesWithEntry();
            this._databaseConfig.reload(lDAPConnection);
            Vector vector2 = this._databaseConfig.getRootSuffixesWithEntry();
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            int n2 = 0;
            while (n2 < vector.size()) {
                DN dN = new DN((String)vector.elementAt(n2));
                boolean bl = true;
                n = 0;
                while (n < vector2.size() && bl) {
                    DN dN2 = new DN((String)vector2.elementAt(n));
                    if (dN2.equals(dN)) {
                        bl = false;
                    }
                    ++n;
                }
                if (bl) {
                    vector4.add(vector.elementAt(n2));
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector2.size()) {
                DN dN = new DN((String)vector2.elementAt(n3));
                n = 1;
                int n4 = 0;
                while (n4 < vector.size() && n != 0) {
                    DN dN3 = new DN((String)vector.elementAt(n4));
                    if (dN.equals(dN3)) {
                        n = 0;
                    }
                    ++n4;
                }
                if (n != 0) {
                    vector3.add(vector2.elementAt(n3));
                }
                ++n3;
            }
            int n5 = 0;
            while (n5 < vector4.size()) {
                this._controller.removeSuffix((String)vector4.elementAt(n5));
                ++n5;
            }
            n = 0;
            while (n < vector3.size()) {
                this._controller.addSuffix((String)vector3.elementAt(n), null);
                ++n;
            }
        }
        catch (LDAPException lDAPException) {
            String[] stringArray = new String[]{Helper.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)((Object)this._framework), "reading-databaseconfig-error-title", "reading-databaseconfig-error-msg", stringArray, "browser");
        }
    }

    private boolean checkChildrenForNode(IBrowserNodeInfo iBrowserNodeInfo) {
        boolean bl = true;
        int n = iBrowserNodeInfo.getNumSubOrdinates();
        if (this._controller.isSorted() && this._showSortedChildrenLimitExceededDialog && n > 300) {
            Object object;
            boolean bl2 = true;
            String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
            if (string != null && (object = (Integer)this._vlvCache.get(string)) != null && ((Integer)object == CreateVLVIndex.HAS_INDEX || (Integer)object == CreateVLVIndex.CAN_NOT_HAVE_INDEX)) {
                bl2 = false;
            }
            if (bl2) {
                object = new SortedChildrenLimitExceededDialog((JFrame)((Object)this._framework), iBrowserNodeInfo);
                ((SortedChildrenLimitExceededDialog)((Object)object)).packAndShow();
                this._showSortedChildrenLimitExceededDialog = ((SortedChildrenLimitExceededDialog)((Object)object)).continueShowingDialog();
                if (!this._showSortedChildrenLimitExceededDialog) {
                    this._preferences.set(SHOW_SORTED_CHILDREN_LIMIT_EXCEEDED, this._showSortedChildrenLimitExceededDialog);
                }
            }
        }
        if (this._showDisplayedChildrenLimitExceededDialog && bl && n > 5000) {
            DisplayedChildrenLimitExceededDialog displayedChildrenLimitExceededDialog = new DisplayedChildrenLimitExceededDialog((JFrame)((Object)this._framework), iBrowserNodeInfo);
            displayedChildrenLimitExceededDialog.packAndShow();
            this._showDisplayedChildrenLimitExceededDialog = displayedChildrenLimitExceededDialog.continueShowingDialog();
            if (!this._showDisplayedChildrenLimitExceededDialog) {
                this._preferences.set(SHOW_DISPLAYED_CHILDREN_LIMIT_EXCEEDED, this._showDisplayedChildrenLimitExceededDialog);
            }
        }
        return bl;
    }

    private String findDisplayNameFromNode(IBrowserNodeInfo iBrowserNodeInfo) {
        String string = null;
        LDAPUrl lDAPUrl = iBrowserNodeInfo.getURL();
        string = iBrowserNodeInfo.isRemote() ? lDAPUrl.getDN() + "   ( " + lDAPUrl.getHost() + ":" + lDAPUrl.getPort() + " )" : lDAPUrl.getDN();
        return string;
    }

    private boolean continueOperation(IBrowserNodeInfo iBrowserNodeInfo) {
        Object object;
        boolean bl = true;
        int n = iBrowserNodeInfo.getErrorType();
        if (n == 0 && iBrowserNodeInfo.isRemote() && this._showRemoteInformationDialog) {
            object = new RemoteNodeInformationDialog((JFrame)((Object)this._framework), iBrowserNodeInfo);
            ((RemoteNodeInformationDialog)((Object)object)).packAndShow();
            this._showRemoteInformationDialog = ((RemoteNodeInformationDialog)((Object)object)).continueShowingDialog();
            if (!this._showRemoteInformationDialog) {
                this._preferences.set(SHOW_REMOTE_INFORMATION_DIALOG, this._showRemoteInformationDialog);
            }
            boolean bl2 = bl = !((RemoteNodeInformationDialog)((Object)object)).isCancelled();
        }
        if (n == 2) {
            object = (String)iBrowserNodeInfo.getErrorArg();
            Exception exception = iBrowserNodeInfo.getErrorException();
            NonResolvedReferralDialog nonResolvedReferralDialog = new NonResolvedReferralDialog((JFrame)((Object)this._framework), iBrowserNodeInfo.getURL(), (String)object, exception);
            nonResolvedReferralDialog.packAndShow();
            bl = !nonResolvedReferralDialog.isCancel();
        }
        return bl;
    }

    private void actionFollowReferrals() {
        this._controller.setFollowReferrals(!this._controller.getFollowReferrals());
        this._childrenController.setFollowReferrals(this._controller.getFollowReferrals());
        this._tree.clearSelection();
        this._attributeController.reset();
        this._vlvCache.clear();
        this._activationCache.clear();
        this._preferences.set(FOLLOW_REFERRALS_PREFERENCES, this._controller.getFollowReferrals());
    }

    private void actionRefreshTree() {
        this.RefreshDatabaseConfigAndSuffixes();
        this.setSchema(null);
        this._allAttrs = null;
        this._attributeController.reset();
        this._vlvCache.clear();
        this._activationCache.clear();
        this._entryEditor.setSchema(this.getSchema());
        this._menuController.recreateDynamicMenus();
        this._controller.startRefresh();
        this._tree.clearSelection();
    }

    private void actionSearchUG() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                ConsoleInfo consoleInfo = (ConsoleInfo)this._framework.getServerObject().getServerInfo().clone();
                consoleInfo.setUserBaseDN(Helper.getNodeInfoDN(iBrowserNodeInfo));
                consoleInfo.setUserLDAPConnection(lDAPConnection2);
                consoleInfo.setLDAPConnection(lDAPConnection2);
                consoleInfo.setUserHost(lDAPConnection2.getHost());
                consoleInfo.setUserPort(lDAPConnection2.getPort());
                ResourcePickerDlg resourcePickerDlg = new ResourcePickerDlg(consoleInfo, (IRPCallBack)new SearchUG((JFrame)((Object)this._framework), this._iconPool, lDAPConnection2, this._entryEditor), (JFrame)((Object)this._framework));
                resourcePickerDlg.appendSearchInterface((IResourcePickerPlugin)new DSSearchPanel());
                resourcePickerDlg.show();
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionSelectPartitionView(String string) {
        this._selectedPartitionView = string;
        if (!this._selectedPartitionView.equals("ALL_PARTITIONS")) {
            LDAPConnection lDAPConnection = this._controller.getLDAPConnection();
            LDAPControl[] lDAPControlArray = lDAPConnection.getSearchConstraints().getServerControls();
            byte[] byArray = null;
            try {
                byArray = this._selectedPartitionView.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.println((String)("DSContentPage.actionSelectPartitionView() " + unsupportedEncodingException));
            }
            LDAPControl lDAPControl = new LDAPControl(SEARCH_OID, true, byArray);
            if (lDAPControlArray != null) {
                boolean bl = false;
                int n = 0;
                while (n < lDAPControlArray.length && !bl) {
                    if (lDAPControlArray[n].getID().equals(SEARCH_OID)) {
                        bl = true;
                        lDAPControlArray[n] = lDAPControl;
                    }
                    ++n;
                }
                if (!bl) {
                    LDAPControl[] lDAPControlArray2 = new LDAPControl[lDAPControlArray.length + 1];
                    int n2 = 0;
                    while (n2 < lDAPControlArray.length) {
                        lDAPControlArray2[n2] = lDAPControlArray[n2];
                        ++n2;
                    }
                    lDAPControlArray2[lDAPControlArray2.length - 1] = lDAPControl;
                }
            } else {
                LDAPControl[] lDAPControlArray3 = new LDAPControl[]{lDAPControl};
                lDAPConnection.getSearchConstraints().setServerControls(lDAPControlArray3);
            }
            String string2 = this._databaseConfig.getSuffixForDatabase(string);
            this._controller.removeAllSuffixes();
            this._controller.addSuffix(string2, null);
        } else {
            int n;
            Vector vector;
            LDAPConnection lDAPConnection = this._controller.getLDAPConnection();
            LDAPControl[] lDAPControlArray = lDAPConnection.getSearchConstraints().getServerControls();
            if (lDAPControlArray != null) {
                vector = new Vector();
                n = 0;
                while (n < lDAPControlArray.length) {
                    if (!lDAPControlArray[n].getID().equals(SEARCH_OID)) {
                        vector.addElement(lDAPControlArray[n]);
                    }
                    ++n;
                }
                Object[] objectArray = new LDAPControl[vector.size()];
                vector.copyInto(objectArray);
                lDAPConnection.getSearchConstraints().setServerControls((LDAPControl[])objectArray);
            }
            this._controller.removeAllSuffixes();
            vector = this._databaseConfig.getRootSuffixesWithEntry();
            n = 0;
            while (n < vector.size()) {
                this._controller.addSuffix((String)vector.elementAt(n), null);
                ++n;
            }
            this._controller.addSuffix("cn=schema", null);
            this._controller.addSuffix("cn=monitor", null);
            this._controller.addSuffix("cn=config", null);
        }
        this._menuController.updateMenuState();
        if (!this.getSelectedPartitionView().equals("ALL_PARTITIONS") && this.getFollowReferrals()) {
            this.actionFollowReferrals();
        } else {
            this._tree.clearSelection();
        }
    }

    private void actionDisplayACICount() {
        this._display = (this._display & 1) == 0 ? (this._display |= 1) : (this._display &= 0xFFFFFFFE);
        this._controller.setDisplayFlags(this._display);
        this._childrenController.setDisplayFlags(this._display);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._childrenController.startRefresh();
        }
        this._preferences.set(DISPLAY_PREFERENCES, this._display);
    }

    private void actionDisplayRoleCount() {
        this._display = (this._display & 2) == 0 ? (this._display |= 2) : (this._display &= 0xFFFFFFFD);
        this._controller.setDisplayFlags(this._display);
        this._childrenController.setDisplayFlags(this._display);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._childrenController.startRefresh();
        }
        this._preferences.set(DISPLAY_PREFERENCES, this._display);
    }

    private void actionDisplayAccountInactivation() {
        this._display = (this._display & 4) == 0 ? (this._display |= 4) : (this._display &= 0xFFFFFFFB);
        this._controller.setDisplayFlags(this._display);
        this._childrenController.setDisplayFlags(this._display);
        if (this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._childrenController.startRefresh();
        }
        this._preferences.set(DISPLAY_PREFERENCES, this._display);
    }

    private void actionOnlyTreeLayout() {
        if (!this._layout.equals("ONLY_TREE_LAYOUT")) {
            this._displayedPanel.remove(this._splitPanel);
            this._displayedPanel.add(this._treePanel);
            this._layout = "ONLY_TREE_LAYOUT";
            if (this._controller.isShowContainerOnly()) {
                this._controller.setShowContainerOnly(false);
            }
            this._tree.clearSelection();
            this.validate();
            this.repaint();
            this._preferences.set(LAYOUT_PREFERENCES, this._layout);
        }
    }

    private void actionNodeLeafLayout() {
        if (!this._layout.equals("NODE_LEAF_LAYOUT")) {
            this._splitPanel.setRightComponent(this._childrenPanel);
            if (this._layout.equals("ONLY_TREE_LAYOUT")) {
                this._displayedPanel.remove(this._treePanel);
                this._splitPanel.setLeftComponent(this._treePanel);
                this._displayedPanel.add(this._splitPanel);
            }
            this._layout = "NODE_LEAF_LAYOUT";
            if (!this._controller.isShowContainerOnly()) {
                this._controller.setShowContainerOnly(true);
            }
            this._tree.clearSelection();
            IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
            this._childrenController.setBaseNodeInfo(iBrowserNodeInfo);
            this._list.setBackground(this._listDefaultColor);
            this.validate();
            this.repaint();
            this._preferences.set(LAYOUT_PREFERENCES, this._layout);
        }
    }

    private void actionAttributeLayout() {
        if (!this._layout.equals("ATTRIBUTE_LAYOUT")) {
            this._splitPanel.setRightComponent(this._attributePanel);
            if (this._layout.equals("ONLY_TREE_LAYOUT")) {
                this._displayedPanel.remove(this._treePanel);
                this._splitPanel.setLeftComponent(this._treePanel);
                this._displayedPanel.add(this._splitPanel);
            }
            this._layout = "ATTRIBUTE_LAYOUT";
            if (this._controller.isShowContainerOnly()) {
                this._controller.setShowContainerOnly(false);
            }
            this._tree.clearSelection();
            IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
            if (iBrowserNodeInfo == null) {
                this._attributeController.clearAttributePanel();
            } else {
                this._attributeController.updateAttributePanel(iBrowserNodeInfo);
            }
            this.validate();
            this.repaint();
            this._preferences.set(LAYOUT_PREFERENCES, this._layout);
        }
    }

    private void actionSetSorted() {
        this._controller.setSorted(!this._controller.isSorted());
        this._childrenController.setSorted(this._controller.isSorted());
        this._preferences.set(SORT_PREFERENCES, this._controller.isSorted());
        this._tree.clearSelection();
    }

    private void actionCopy() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                Copier copier = new Copier(lDAPConnection2, string, (JFrame)((Object)this._framework), this._clipboard);
                copier.execute();
                this._connectionPool.releaseConnection(lDAPConnection);
                this._menuController.updateMenuState();
            }
        }
    }

    private void actionCopyDN() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    private void actionCopyLDAPURL() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            StringSelection stringSelection = new StringSelection(iBrowserNodeInfo.getURL().toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    private void actionPaste() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                Paster paster = new Paster(lDAPConnection, string, (JFrame)((Object)this._framework), this._clipboard);
                paster.execute();
                Vector vector = paster.getPastedRootEntries();
                if (vector != null) {
                    if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            this._controller.notifyEntryAdded(iBrowserNodeInfo, string2);
                            if (!this._layout.equals("NODE_LEAF_LAYOUT")) continue;
                            this._childrenController.notifyEntryAdded(string2);
                        }
                    } else if (this._list == this._lastSelectedComponent) {
                        IBrowserNodeInfo iBrowserNodeInfo2;
                        this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                        TreePath treePath = this.getLastSelectedPath();
                        if (treePath != null && (iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                            this._controller.notifyChildEntryChanged(iBrowserNodeInfo2, string);
                        }
                    }
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionCut() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                TreePath treePath;
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                CutDeleter cutDeleter = new CutDeleter(lDAPConnection2, string, (JFrame)((Object)this._framework), this._clipboard, true);
                cutDeleter.execute();
                this._menuController.updateMenuState();
                if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                    treePath = this.getLastSelectedPath().getParentPath();
                    this._tree.setSelectionPath(treePath);
                }
                if (cutDeleter.isWholeTreeDeleted()) {
                    if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                        this._controller.notifyEntryDeleted(iBrowserNodeInfo);
                    } else if (this._list == this._lastSelectedComponent) {
                        IBrowserNodeInfo iBrowserNodeInfo2;
                        this._childrenController.notifyEntryDeleted(iBrowserNodeInfo);
                        treePath = this.getLastSelectedPath();
                        if (treePath != null && (iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                            this._controller.notifyChildEntryDeleted(iBrowserNodeInfo2, string);
                        }
                    }
                    this.checkObjectDeleted(string, lDAPConnection2);
                } else if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                    this._controller.startRefresh(iBrowserNodeInfo);
                } else if (this._list == this._lastSelectedComponent) {
                    IBrowserNodeInfo iBrowserNodeInfo3;
                    this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                    treePath = this.getLastSelectedPath();
                    if (treePath != null && (iBrowserNodeInfo3 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                        this._controller.notifyChildEntryChanged(iBrowserNodeInfo3, string);
                    }
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionDelete() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                TreePath treePath;
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                CutDeleter cutDeleter = new CutDeleter(lDAPConnection2, string, (JFrame)((Object)this._framework), this._clipboard, false);
                cutDeleter.execute();
                if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                    treePath = this.getLastSelectedPath().getParentPath();
                    this._tree.setSelectionPath(treePath);
                }
                if (cutDeleter.isWholeTreeDeleted()) {
                    if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                        this._controller.notifyEntryDeleted(iBrowserNodeInfo);
                    } else if (this._list == this._lastSelectedComponent) {
                        IBrowserNodeInfo iBrowserNodeInfo2;
                        this._childrenController.notifyEntryDeleted(iBrowserNodeInfo);
                        treePath = this.getLastSelectedPath();
                        if (treePath != null && (iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                            this._controller.notifyChildEntryDeleted(iBrowserNodeInfo2, string);
                        }
                    }
                    this.checkObjectDeleted(string, lDAPConnection2);
                } else if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                    this._controller.startRefresh(iBrowserNodeInfo);
                } else if (this._list == this._lastSelectedComponent) {
                    IBrowserNodeInfo iBrowserNodeInfo3;
                    this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                    treePath = this.getLastSelectedPath();
                    if (treePath != null && (iBrowserNodeInfo3 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                        this._controller.notifyChildEntryChanged(iBrowserNodeInfo3, string);
                    }
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private boolean checkObjectDeleted(String string, LDAPConnection lDAPConnection) {
        boolean bl = false;
        DN dN = new DN(string);
        Vector vector = this._databaseConfig.getRootSuffixesWithEntry();
        int n = 0;
        while (n < vector.size() && !bl) {
            String string2 = (String)vector.elementAt(n);
            DN dN2 = new DN(string2);
            if (dN.equals(dN2)) {
                this._databaseConfig.setHasRootEntry(string2, false);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this._menuController.recreateNewRootEntryMenus();
        }
        return bl;
    }

    private void actionACL() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                String string2;
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                LDAPConnection lDAPConnection3 = Console.getConsoleInfo().getUserLDAPConnection();
                if (lDAPConnection3.getHost().equals(lDAPConnection2.getHost()) && lDAPConnection3.getPort() == lDAPConnection2.getPort()) {
                    Debug.println((String)"ContentModel.actionACL: ACI and users are on the same directory");
                    string2 = Console.getConsoleInfo().getUserBaseDN();
                } else {
                    Debug.println((String)"ContentModel.actionACL: ACI and users are on different directories");
                    string2 = this._databaseConfig.getRootSuffixForEntry(string);
                }
                Debug.println((String)("ContentModel.actionACL: users will be search from " + string2));
                ACIManager aCIManager = new ACIManager((JFrame)((Object)this._framework), string, lDAPConnection2, string, lDAPConnection2, string2);
                aCIManager.show();
                this._connectionPool.releaseConnection(lDAPConnection);
                if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                    this._controller.notifyEntryChanged(iBrowserNodeInfo);
                } else if (this._list == this._lastSelectedComponent) {
                    IBrowserNodeInfo iBrowserNodeInfo2;
                    this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                    TreePath treePath = this.getLastSelectedPath();
                    if (treePath != null && (iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                        this._controller.notifyChildEntryChanged(iBrowserNodeInfo2, string);
                    }
                }
                this._attributeController.reset();
            }
        }
    }

    private void actionRoles() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            if (!iBrowserNodeInfo.isRemote()) {
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                LDAPConnection lDAPConnection = this.setReferralControl(this._framework.getServerObject().getServerInfo().getLDAPConnection());
                ConsoleInfo consoleInfo = new ConsoleInfo(lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword(), string);
                consoleInfo.setCurrentDN(string);
                consoleInfo.setUserGroupDN(string);
                consoleInfo.setLDAPConnection(lDAPConnection);
                RoleEditorDialog roleEditorDialog = new RoleEditorDialog((JFrame)((Object)this._framework), consoleInfo);
                roleEditorDialog.show();
                if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                    this._controller.notifyEntryChanged(iBrowserNodeInfo);
                } else if (this._list == this._lastSelectedComponent) {
                    IBrowserNodeInfo iBrowserNodeInfo2;
                    this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                    TreePath treePath = this.getLastSelectedPath();
                    if (treePath != null && (iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                        this._controller.notifyChildEntryChanged(iBrowserNodeInfo2, string);
                    }
                }
                this._attributeController.reset();
            } else {
                DSUtil.showErrorDialog((Component)((Object)this._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
            }
        }
    }

    private void actionSetReferral() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                ReferralEditor referralEditor = new ReferralEditor((JFrame)((Object)this._framework), lDAPConnection, string, this._connectionPool);
                referralEditor.packAndShow();
                this._connectionPool.releaseConnection(lDAPConnection);
                if (referralEditor.isObjectModified()) {
                    if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                        this._controller.notifyEntryChanged(iBrowserNodeInfo);
                    } else if (this._list == this._lastSelectedComponent) {
                        IBrowserNodeInfo iBrowserNodeInfo2;
                        this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                        TreePath treePath = this.getLastSelectedPath();
                        if (treePath != null && (iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                            this._controller.notifyChildEntryChanged(iBrowserNodeInfo2, Helper.getNodeInfoDN(iBrowserNodeInfo));
                        }
                    }
                }
                if (referralEditor.isAuthModified()) {
                    this._controller.notifyAuthDataChanged(null);
                }
                this._attributeController.reset();
            }
        }
    }

    private void actionCreateVLVIndex() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                IBrowserNodeInfo iBrowserNodeInfo = DSContentPage.this.getSelectedNodeInfo();
                if (iBrowserNodeInfo != null) {
                    if (!iBrowserNodeInfo.isRemote()) {
                        CreateVLVIndex createVLVIndex = new CreateVLVIndex(DSContentPage.this._framework.getServerObject().getServerInfo());
                        createVLVIndex.execute(Helper.getNodeInfoDN(iBrowserNodeInfo));
                        DSContentPage.this._vlvCache.remove(Helper.getNodeInfoDN(iBrowserNodeInfo));
                        DSContentPage.this._menuController.updateMenuState();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                DSUtil.showErrorDialog((Component)((Object)3.access$600(this.this$1)._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
                            }
                        });
                    }
                }
            }

            static /* synthetic */ DSContentPage access$600(3 var0) {
                return var0.DSContentPage.this;
            }
        });
        thread.start();
    }

    private void actionDeleteVLVIndex() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                IBrowserNodeInfo iBrowserNodeInfo = DSContentPage.this.getSelectedNodeInfo();
                if (iBrowserNodeInfo != null) {
                    CreateVLVIndex.deleteIndex(Helper.getNodeInfoDN(iBrowserNodeInfo), DSContentPage.this._framework.getServerObject().getServerInfo());
                    DSContentPage.this._vlvCache.remove(Helper.getNodeInfoDN(iBrowserNodeInfo));
                    DSContentPage.this._menuController.updateMenuState();
                }
            }
        });
        thread.start();
    }

    private void actionInactivate() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                IBrowserNodeInfo iBrowserNodeInfo = DSContentPage.this.getSelectedNodeInfo();
                if (iBrowserNodeInfo != null) {
                    if (!iBrowserNodeInfo.isRemote()) {
                        String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                        LDAPConnection lDAPConnection = DSContentPage.this.setReferralControl(DSContentPage.this._framework.getServerObject().getServerInfo().getLDAPConnection());
                        Inactivator inactivator = new Inactivator((JFrame)((Object)DSContentPage.this._framework), string, lDAPConnection);
                        inactivator.execute();
                        SwingUtilities.invokeLater(new Runnable(this, iBrowserNodeInfo, inactivator){
                            private final /* synthetic */ IBrowserNodeInfo val$node;
                            private final /* synthetic */ Inactivator val$task;
                            private final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$node = iBrowserNodeInfo;
                                this.val$task = inactivator;
                            }

                            public void run() {
                                6.access$700(this.this$1, this.val$node, this.val$task.getLockingInfrastructureDNs());
                            }
                        });
                        DSContentPage.this._attributeController.reset();
                        DSContentPage.this._activationCache.remove(Helper.getNodeInfoDN(iBrowserNodeInfo));
                        DSContentPage.this._menuController.updateMenuState();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                DSUtil.showErrorDialog((Component)((Object)6.access$900(this.this$1)._framework), "unsupported-remote-error-title", "unsupported-remote-error-msg", (String[])null, "browser");
                            }
                        });
                    }
                }
            }

            private void updateViewAfterInactivation(IBrowserNodeInfo iBrowserNodeInfo, Vector vector) {
                IBrowserNodeInfo iBrowserNodeInfo2;
                TreePath treePath;
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                if (vector != null && vector.size() > 0) {
                    String string2;
                    TreePath treePath2;
                    treePath = DSContentPage.this.getLastSelectedPath();
                    while (treePath.getPathCount() > 2) {
                        treePath = treePath.getParentPath();
                    }
                    iBrowserNodeInfo2 = DSContentPage.this._controller.getNodeInfoFromPath(treePath);
                    boolean bl = false;
                    if (DSContentPage.this._layout.equals("NODE_LEAF_LAYOUT") && (treePath2 = DSContentPage.this.getLastSelectedPath()).getPathCount() == 2) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n = 0;
                    while (n < vector.size()) {
                        String string3 = (String)vector.elementAt(n);
                        if (DSContentPage.this._controller.isShowContainerOnly()) {
                            if (string3.indexOf("cn=nsAccountInactivationTmp") == 0) {
                                DSContentPage.this._controller.notifyEntryAdded(iBrowserNodeInfo2, string3);
                                bl2 = true;
                            } else if (string3.indexOf("cn=\"cn=nsDisabledRole") == 0) {
                                bl3 = true;
                            }
                            if (bl && string3.indexOf("cn=\"cn=nsDisabledRole") < 0) {
                                DSContentPage.this._childrenController.notifyEntryAdded(string3);
                            }
                        } else if (string3.indexOf("cn=\"cn=nsDisabledRole") < 0) {
                            DSContentPage.this._controller.notifyEntryAdded(iBrowserNodeInfo2, string3);
                        }
                        ++n;
                    }
                    if (DSContentPage.this._controller.isShowContainerOnly() && bl3 && !bl2 && (string2 = Helper.getNodeInfoDN(iBrowserNodeInfo2)) != null) {
                        DSContentPage.this._controller.notifyEntryAdded(iBrowserNodeInfo2, "cn=nsAccountInactivationTmp, " + string2);
                    }
                }
                if (!DSContentPage.this._layout.equals("NODE_LEAF_LAYOUT") || DSContentPage.this._tree == DSContentPage.this._lastSelectedComponent) {
                    DSContentPage.this._controller.notifyEntryChanged(iBrowserNodeInfo);
                } else if (DSContentPage.this._list == DSContentPage.this._lastSelectedComponent) {
                    DSContentPage.this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                    treePath = DSContentPage.this.getLastSelectedPath();
                    if (treePath != null && (iBrowserNodeInfo2 = DSContentPage.this._controller.getNodeInfoFromPath(treePath)) != null) {
                        DSContentPage.this._controller.notifyChildEntryChanged(iBrowserNodeInfo2, string);
                    }
                }
            }

            static /* synthetic */ void access$700(6 var0, IBrowserNodeInfo iBrowserNodeInfo, Vector vector) {
                var0.updateViewAfterInactivation(iBrowserNodeInfo, vector);
            }

            static /* synthetic */ DSContentPage access$900(6 var0) {
                return var0.DSContentPage.this;
            }
        });
        thread.start();
    }

    private void actionActivate() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                IBrowserNodeInfo iBrowserNodeInfo = DSContentPage.this.getSelectedNodeInfo();
                if (iBrowserNodeInfo != null) {
                    LDAPConnection lDAPConnection = DSContentPage.this.setReferralControl(DSContentPage.this._framework.getServerObject().getServerInfo().getLDAPConnection());
                    String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                    Activator activator = new Activator((JFrame)((Object)DSContentPage.this._framework), string, lDAPConnection);
                    activator.execute();
                    if (!DSContentPage.this._layout.equals("NODE_LEAF_LAYOUT") || DSContentPage.this._tree == DSContentPage.this._lastSelectedComponent) {
                        DSContentPage.this._controller.notifyEntryChanged(iBrowserNodeInfo);
                    } else if (DSContentPage.this._list == DSContentPage.this._lastSelectedComponent) {
                        IBrowserNodeInfo iBrowserNodeInfo2;
                        DSContentPage.this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
                        TreePath treePath = DSContentPage.this.getLastSelectedPath();
                        if (treePath != null && (iBrowserNodeInfo2 = DSContentPage.this._controller.getNodeInfoFromPath(treePath)) != null) {
                            DSContentPage.this._controller.notifyChildEntryChanged(iBrowserNodeInfo2, string);
                        }
                    }
                    DSContentPage.this._attributeController.reset();
                    DSContentPage.this._activationCache.remove(Helper.getNodeInfoDN(iBrowserNodeInfo));
                    DSContentPage.this._menuController.updateMenuState();
                }
            }
        });
        thread.start();
    }

    private void actionEdit() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
        }
        catch (LDAPException lDAPException) {
            this.displayConnectionError(lDAPException, iBrowserNodeInfo);
        }
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection2 = null;
            try {
                lDAPConnection2 = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection2 != null) {
                LDAPConnection lDAPConnection3 = this.setReferralControl(lDAPConnection2);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection3.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection3.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.editObject(string, lDAPConnection3, false);
                if (bl) {
                    String string2 = this._entryEditor.getEditedObjectDn();
                    this.updateAfterModify(iBrowserNodeInfo, string2, lDAPConnection3);
                }
                this._connectionPool.releaseConnection(lDAPConnection2);
            }
        }
    }

    private void actionAdvancedEdit() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null && this.continueOperation(iBrowserNodeInfo)) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.editObject(string, lDAPConnection2, true);
                if (bl) {
                    String string2 = this._entryEditor.getEditedObjectDn();
                    this.updateAfterModify(iBrowserNodeInfo, string2, lDAPConnection2);
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewUser() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.createUser(string, lDAPConnection2);
                if (bl) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN(), lDAPConnection2);
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewGroup() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.createGroup(string, lDAPConnection2);
                if (bl) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN(), lDAPConnection2);
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewRole() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.createRole(string, lDAPConnection2);
                if (bl) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN(), lDAPConnection2);
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewCos() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.createCos(string, lDAPConnection2);
                if (bl) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN(), lDAPConnection2);
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionNewOrganizationalUnit() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.createOrganizationalUnit(string, lDAPConnection2);
                if (bl) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN(), lDAPConnection2);
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void actionCreateRootEntry(String string) {
        LDAPConnection lDAPConnection = this._framework.getServerObject().getServerInfo().getLDAPConnection();
        boolean bl = this._entryEditor.createRootObject(string, lDAPConnection);
        if (bl) {
            String string2 = this._databaseConfig.getParentSuffix(string);
            if (string2 != null) {
                if (!string2.equals("")) {
                    this._controller.addSuffix(string, string2);
                } else {
                    this._controller.addSuffix(string, null);
                }
            }
            this.checkObjectAdded(string, lDAPConnection);
        }
    }

    private void actionNewObject() {
        IBrowserNodeInfo iBrowserNodeInfo = this.getSelectedNodeInfo();
        if (iBrowserNodeInfo != null) {
            LDAPConnection lDAPConnection = null;
            try {
                lDAPConnection = this.getConnectionForNode(iBrowserNodeInfo);
            }
            catch (LDAPException lDAPException) {
                this.displayConnectionError(lDAPException, iBrowserNodeInfo);
            }
            if (lDAPConnection != null) {
                LDAPConnection lDAPConnection2 = this.setReferralControl(lDAPConnection);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
                String string = Helper.getNodeInfoDN(iBrowserNodeInfo);
                boolean bl = this._entryEditor.createObject(string, lDAPConnection2);
                if (bl) {
                    LDAPEntry lDAPEntry = this._entryEditor.getCreatedObject();
                    this.updateViewAfterAdd(lDAPEntry, iBrowserNodeInfo);
                    this.checkObjectAdded(lDAPEntry.getDN(), lDAPConnection2);
                }
                this._connectionPool.releaseConnection(lDAPConnection);
            }
        }
    }

    private void updateAfterModify(IBrowserNodeInfo iBrowserNodeInfo, String string, LDAPConnection lDAPConnection) {
        DN dN;
        String string2 = Helper.getNodeInfoDN(iBrowserNodeInfo);
        DN dN2 = new DN(string2);
        if (!dN2.equals(dN = new DN(string))) {
            this.checkObjectAdded(string, lDAPConnection);
            if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
                TreePath treePath = this._controller.notifyEntryDeleted(iBrowserNodeInfo);
                IBrowserNodeInfo iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath);
                TreePath treePath2 = this._controller.notifyEntryAdded(iBrowserNodeInfo2, string);
                this._tree.setSelectionPath(treePath2);
            } else if (this._list == this._lastSelectedComponent) {
                IBrowserNodeInfo iBrowserNodeInfo3;
                this._childrenController.notifyEntryDeleted(iBrowserNodeInfo);
                int n = this._childrenController.notifyEntryAdded(string);
                this._list.setSelectedIndex(n);
                TreePath treePath = this.getLastSelectedPath();
                if (treePath != null && (iBrowserNodeInfo3 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                    this._controller.notifyChildEntryDeleted(iBrowserNodeInfo3, string2);
                    this._controller.notifyChildEntryAdded(iBrowserNodeInfo3, string);
                }
            }
        } else if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
            this._controller.notifyEntryChanged(iBrowserNodeInfo);
        } else if (this._list == this._lastSelectedComponent) {
            IBrowserNodeInfo iBrowserNodeInfo4;
            this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
            TreePath treePath = this.getLastSelectedPath();
            if (treePath != null && (iBrowserNodeInfo4 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                this._controller.notifyChildEntryChanged(iBrowserNodeInfo4, string);
            }
        }
        this._attributeController.reset();
    }

    private boolean checkObjectAdded(String string, LDAPConnection lDAPConnection) {
        Object object;
        String string2;
        boolean bl = false;
        DN dN = new DN(string);
        Vector vector = this._databaseConfig.getRootSuffixesWithoutEntry();
        int n = 0;
        while (n < vector.size() && !bl) {
            string2 = (String)vector.elementAt(n);
            object = new DN(string2);
            if (dN.equals(object)) {
                this._databaseConfig.setHasRootEntry(string2, true);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this._menuController.recreateNewRootEntryMenus();
        }
        if (!this._selectedPartitionView.equals("ALL_PARTITIONS")) {
            string2 = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
            object = null;
            try {
                object = this._selectedPartitionView.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.println((String)("DSContentPage.checkObjectAdded() " + unsupportedEncodingException));
            }
            LDAPControl lDAPControl = new LDAPControl(SEARCH_OID, true, (byte[])object);
            string2.setServerControls(lDAPControl);
            string2.setMaxResults(0);
            try {
                String[] stringArray = new String[]{"dn"};
                LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray, (LDAPSearchConstraints)string2);
                if (lDAPEntry == null) {
                    DSUtil.showInformationDialog((Component)((Object)this._framework), "add-entry-to-different-partition", (String)null);
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) {
                    DSUtil.showInformationDialog((Component)((Object)this._framework), "add-entry-to-different-partition", (String)null);
                }
                Debug.println((String)("DSContentPage.checkObjectAdded() " + (Object)((Object)lDAPException)));
            }
        }
        return bl;
    }

    private void updateViewAfterAdd(LDAPEntry lDAPEntry, IBrowserNodeInfo iBrowserNodeInfo) {
        String string = lDAPEntry.getDN();
        if (!this._layout.equals("NODE_LEAF_LAYOUT") || this._tree == this._lastSelectedComponent) {
            if (this._layout.equals("NODE_LEAF_LAYOUT")) {
                this._childrenController.notifyEntryAdded(string);
                if (this.isContainerObject(lDAPEntry)) {
                    this._controller.notifyEntryAdded(iBrowserNodeInfo, string);
                }
            } else {
                this._controller.notifyEntryAdded(iBrowserNodeInfo, string);
            }
        } else if (this._list == this._lastSelectedComponent) {
            IBrowserNodeInfo iBrowserNodeInfo2;
            Debug.println((String)"updateViewAfterAdd, calling notifyEntryAdded");
            this._childrenController.notifyEntryChanged(iBrowserNodeInfo);
            TreePath treePath = this.getLastSelectedPath();
            if (treePath != null && (iBrowserNodeInfo2 = this._controller.getNodeInfoFromPath(treePath)) != null) {
                this._controller.notifyChildEntryAdded(iBrowserNodeInfo2, string);
            }
        }
    }

    private boolean isContainerObject(LDAPEntry lDAPEntry) {
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements() && !bl) {
                String string = (String)enumeration.nextElement();
                int n = 0;
                while (n < CONTAINER_OBJECTCLASSES.length && !bl) {
                    if (string.equalsIgnoreCase(CONTAINER_OBJECTCLASSES[n])) {
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    private void actionAuthenticate() {
        boolean bl = this.getNewAuthentication();
        if (bl) {
            this._controller.setLDAPConnection(this._framework.getServerObject().getServerInfo().getLDAPConnection());
            this.actionRefreshTree();
        } else {
            Debug.println((String)"ContentModel.actionAuthenticate(): could not reauthenticate");
        }
    }

    public LDAPSchema getSchema() {
        return DSUtil.getSchema(this._framework.getServerObject().getServerInfo());
    }

    public void setSchema(LDAPSchema lDAPSchema) {
        DSUtil.setSchema(this._framework.getServerObject().getServerInfo(), lDAPSchema);
    }

    protected boolean entryHasChildren(LDAPEntry lDAPEntry) {
        String string;
        int n;
        Object object;
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("numsubordinates");
        if (lDAPAttribute != null && (object = lDAPAttribute.getStringValues()).hasMoreElements() && (n = Integer.parseInt(string = (String)object.nextElement())) > 0) {
            bl = true;
        }
        if (!bl) {
            object = this._databaseConfig.getSuffixesWithEntryList();
            string = new DN(lDAPEntry.getDN());
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements() && !bl) {
                DN dN = new DN((String)enumeration.nextElement());
                if (!dN.getParent().equals((DN)string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected LDAPConnection getConnectionForNode(IBrowserNodeInfo iBrowserNodeInfo) throws LDAPException {
        LDAPConnection lDAPConnection = this._connectionPool.getConnection(iBrowserNodeInfo.getURL());
        return lDAPConnection;
    }

    protected LDAPConnection makeNoReferralConnection(LDAPConnection lDAPConnection) {
        LDAPConnection lDAPConnection2 = (LDAPConnection)lDAPConnection.clone();
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection2.getSearchConstraints().clone();
        lDAPSearchConstraints.setServerControls(_manageDSAITControl);
        lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
        return lDAPConnection2;
    }

    protected LDAPConnection makeReferralConnection(LDAPConnection lDAPConnection) {
        try {
            LDAPConnection lDAPConnection2 = (LDAPConnection)lDAPConnection.clone();
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection2.getSearchConstraints().clone();
            SimpleReferral simpleReferral = new SimpleReferral(lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword());
            lDAPConnection2.setOption(8, (Object)new Boolean(true));
            lDAPConnection2.setOption(9, (Object)simpleReferral);
            lDAPSearchConstraints.setRebindProc((LDAPRebind)simpleReferral);
            lDAPConnection2.setSearchConstraints(lDAPSearchConstraints);
            return lDAPConnection2;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSUtil.setDefaultReferralCredentials: " + (Object)((Object)lDAPException)));
            return lDAPConnection;
        }
    }

    protected boolean followReferrals() {
        return this._preferences.getBoolean(FOLLOW_REFERRALS_PREFERENCES, true);
    }

    protected LDAPConnection setReferralControl(LDAPConnection lDAPConnection) {
        if (this.followReferrals()) {
            return this.makeReferralConnection(lDAPConnection);
        }
        return this.makeNoReferralConnection(lDAPConnection);
    }

    protected IBrowserNodeInfo getSelectedNodeInfo() {
        int n;
        IBrowserNodeInfo iBrowserNodeInfo = null;
        if (this._lastSelectedComponent == this._tree || !this._layout.equals("NODE_LEAF_LAYOUT") || this.getLastSelectedIndex() < 0) {
            TreePath treePath = this.getLastSelectedPath();
            if (treePath != null) {
                iBrowserNodeInfo = this._controller.getNodeInfoFromPath(treePath);
            }
        } else if (this._layout.equals("NODE_LEAF_LAYOUT") && (n = this.getLastSelectedIndex()) >= 0) {
            iBrowserNodeInfo = this._childrenController.getNodeInfoFromIndex(n);
        }
        return iBrowserNodeInfo;
    }

    protected TreePath getLastSelectedPath() {
        return this._tree.getSelectionPath();
    }

    protected int getLastSelectedIndex() {
        return this._list.getSelectedIndex();
    }

    private void setBusyCursor(boolean bl) {
        int n = bl ? 3 : 0;
        Cursor cursor = Cursor.getPredefinedCursor(n);
        this.setCursor(this, cursor);
    }

    private void setCursor(Container container, Cursor cursor) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof Container) {
                    this.setCursor((Container)componentArray[n], cursor);
                }
                ++n;
            }
        }
        container.setCursor(cursor);
    }

    private void displayConnectionError(LDAPException lDAPException, IBrowserNodeInfo iBrowserNodeInfo) {
        String[] stringArray = new String[]{this.findDisplayNameFromNode(iBrowserNodeInfo), Helper.getLDAPErrorMessage(lDAPException)};
        DSUtil.showErrorDialog((Component)((Object)this._framework), "getting-connection-error-title", "getting-connection-error-msg", stringArray, "browser");
    }
}

