/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSResourcePage;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IAuthenticationChangeListener;
import com.netscape.admin.dirserv.IChangeClient;
import com.netscape.admin.dirserv.IDSEntryObject;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.IDSResourceSelectionListener;
import com.netscape.admin.dirserv.IDSResourceSelectionModel;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPSchema;

public abstract class DSBaseModel
extends ResourceModel
implements IDSModel,
IDSResourceSelectionModel,
IMenuInfo,
TreeExpansionListener,
IAuthenticationChangeListener {
    protected static ResourceSet _resource = DSUtil._resource;
    protected Vector _selectionListeners = new Vector();
    protected Vector _changeClients = new Vector();
    private ConsoleInfo _info = null;
    private ConsoleInfo _serverInfo = null;
    private JFrame _frame = null;
    private Vector _authListeners = new Vector();
    protected IResourceObject[] _selection;
    private IPage _viewInstance = null;
    private boolean _registeredExpansionListener = false;
    private boolean _refreshUponSelect = false;
    static final String OPEN = "open";
    static final String ACL = "acl";
    static final String ROLES = "roles";
    static final String AUTHENTICATE = "authenticate";
    static final String CUT = "cut";
    static final String COPY = "copy";
    static final String PASTE = "paste";
    static final String UNDO = "undo";
    static final String DELETE = "delete";
    static final String NEW_USER = "newuser";
    static final String NEW_GROUP = "newgroup";
    static final String NEW_ORGANIZATIONALUNIT = "newou";
    static final String NEW_ROLE = "newrole";
    static final String NEW_COS = "newcos";
    static final String NEW_OBJECT = "newobject";
    static final String REFRESH = "refresh";
    static final String SEARCH_UG = "search";
    protected Hashtable _cmdTable = new Hashtable();
    private boolean _authenticating = false;
    private DSUtil.DeferAuthListeners _deferAuthListeners;

    public DSBaseModel(ConsoleInfo consoleInfo, ConsoleInfo consoleInfo2) {
        this._info = consoleInfo;
        this._serverInfo = consoleInfo2;
        this._serverInfo.put("dsresmodel", this);
        this.addAuthenticationChangeListener(this);
    }

    public void initialize(Object object) {
    }

    public void removeElement(IDSEntryObject iDSEntryObject) {
    }

    public ConsoleInfo getConsoleInfo() {
        return this._info;
    }

    public ConsoleInfo getServerInfo() {
        return this._serverInfo;
    }

    public boolean getNewAuthentication() {
        return this.getNewAuthentication(true);
    }

    public boolean getNewAuthentication(boolean bl) {
        if (this._authenticating) {
            return false;
        }
        if (this._deferAuthListeners != null) {
            Debug.println((String)"DSBaseModel.getNewAuthentication: this method was previously called with the notifyListener flag set to false, but the notifyAuthChangeListeners method was not called to notify them.");
            this._deferAuthListeners = null;
        }
        boolean bl2 = false;
        try {
            this._authenticating = true;
            this.setWaitCursor(true);
            String string = (String)this.getServerInfo().get("rootdn");
            Debug.println((int)9, (String)("DSBaseModel.getNewAuthentication: number of authlisteners=" + this._authListeners.size()));
            this._deferAuthListeners = DSUtil.reauthenticateDefer(this._serverInfo.getLDAPConnection(), this.getFrame(), this._authListeners, string, null);
            boolean bl3 = bl2 = this._deferAuthListeners != null;
            if (bl2 && bl) {
                this.notifyAuthChangeListeners();
            }
            Object var5_4 = null;
            this.setWaitCursor(false);
            this._authenticating = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setWaitCursor(false);
            this._authenticating = false;
            throw throwable;
        }
        return bl2;
    }

    public void notifyAuthChangeListeners() {
        if (this._deferAuthListeners != null) {
            DSUtil.DeferAuthListeners deferAuthListeners = this._deferAuthListeners;
            this._deferAuthListeners = null;
            deferAuthListeners.notifyListeners();
        }
    }

    public void setFrame(JFrame jFrame) {
        if (jFrame == null) {
            Debug.println((int)0, (String)"DSBaseModel.setFrame: warning null frame specified");
        }
        this._frame = jFrame;
    }

    public JFrame getFrame() {
        if (this._frame == null) {
            Debug.println((int)0, (String)"DSBaseModel.getFrame: warning frame is not yet known");
            Thread.dumpStack();
        }
        return this._frame;
    }

    public void setSelectedNode(IResourceObject iResourceObject) {
        DSResourcePage dSResourcePage = (DSResourcePage)this.getSelectedPage();
        if (dSResourcePage != null && iResourceObject != null) {
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)iResourceObject).getPath());
            dSResourcePage.getTree().expandPath(treePath);
            dSResourcePage.getTree().makeVisible(treePath);
            dSResourcePage.getTree().scrollPathToVisible(treePath);
            dSResourcePage.getTree().repaint();
            dSResourcePage.getTree().setSelectionPath(treePath);
        }
    }

    public void actionObjectSelected(IPage iPage, IResourceObject[] iResourceObjectArray, IResourceObject[] iResourceObjectArray2) {
        super.actionObjectSelected(iPage, iResourceObjectArray, iResourceObjectArray2);
        this.setSelectedPage(iPage);
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        this.setSelectedPage(iPage);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void setSelected(IPage iPage, IResourceObject[] iResourceObjectArray, IResourceObject[] iResourceObjectArray2) {
        this.setSelectedPage(iPage);
    }

    public void addIDSResourceSelectionListener(IDSResourceSelectionListener iDSResourceSelectionListener) {
        this._selectionListeners.addElement(iDSResourceSelectionListener);
    }

    public void removeIDSResourceSelectionListener(IDSResourceSelectionListener iDSResourceSelectionListener) {
        this._selectionListeners.removeElement(iDSResourceSelectionListener);
    }

    public Enumeration getSelectionListeners() {
        return this._selectionListeners.elements();
    }

    public LDAPSchema getSchema() {
        return DSUtil.getSchema(this._serverInfo);
    }

    public void setSchema(LDAPSchema lDAPSchema) {
        DSUtil.setSchema(this._serverInfo, lDAPSchema);
    }

    public void addAuthenticationChangeListener(IAuthenticationChangeListener iAuthenticationChangeListener) {
        Debug.println((int)9, (String)("DSBaseModel.addAuthenticationChangeListener: new auth change listener=" + iAuthenticationChangeListener + " this=" + this));
        this._authListeners.addElement(iAuthenticationChangeListener);
    }

    public void setAuthenticationChangeListener(Vector vector) {
        Debug.println((int)9, (String)("DSBaseModel.setAuthenticationChangeListener: new auth change listeners=" + vector + " this=" + this));
        this._authListeners = vector;
    }

    public IPage getSelectedPage() {
        return this._viewInstance;
    }

    public void setSelectedPage(IPage iPage) {
        if (iPage != null) {
            this._viewInstance = iPage;
        }
    }

    public void addChangeClient(IChangeClient iChangeClient) {
        if (this._changeClients.indexOf(iChangeClient) == -1) {
            this._changeClients.addElement(iChangeClient);
        }
    }

    public void removeChangeClient(IChangeClient iChangeClient) {
        if (this._changeClients.indexOf(iChangeClient) == -1) {
            this._changeClients.removeElement(iChangeClient);
        }
    }

    public void setWaitCursor(boolean bl) {
        this.fireChangeFeedbackCursor(null, bl ? 3 : 0);
        if (bl) {
            this.fireChangeStatusItemState(this.getSelectedPage(), "StatusItemProgress", StatusItemProgress.STATE_BUSY);
        } else {
            this.fireChangeStatusItemState(this.getSelectedPage(), "StatusItemProgress", new Integer(0));
        }
    }

    public void pageSelected(IFramework iFramework, IPage iPage) {
        DSResourcePage dSResourcePage;
        Debug.println((int)9, (String)("DSBaseModel.pageSelected: framework=" + iFramework + " viewInstance=" + iPage + " this=" + this + " getRefreshUponSelect()=" + this.getRefreshUponSelect()));
        if (!this._registeredExpansionListener && (dSResourcePage = (DSResourcePage)iPage) != null) {
            dSResourcePage.getTree().addTreeExpansionListener(this);
            this._registeredExpansionListener = true;
        }
        if (this.getRefreshUponSelect()) {
            this.refreshView();
            Debug.println((int)9, (String)"DSBaseModel.pageSelected: the view was refreshed");
            this.setRefreshUponSelect(false);
        }
    }

    void actionSelected(String string, IResourceObject[] iResourceObjectArray, IPage iPage) {
        Debug.println((int)1, (String)"DSBaseModel.actionSelected should never be called");
        Thread.dumpStack();
    }

    public void rootDNChanged(String string) {
        this.getServerInfo().put("rootdn", string);
    }

    public void contentChanged() {
    }

    public boolean isModuleDisabled(String string) {
        return false;
    }

    public boolean isAttributeDisabled(String string) {
        return false;
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (iResourceObject instanceof TreeExpansionListener) {
            ((TreeExpansionListener)iResourceObject).treeExpanded(treeExpansionEvent);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (iResourceObject instanceof TreeExpansionListener) {
            ((TreeExpansionListener)iResourceObject).treeCollapsed(treeExpansionEvent);
        }
    }

    public void setRefreshUponSelect(boolean bl) {
        this._refreshUponSelect = bl;
    }

    public boolean getRefreshUponSelect() {
        return this._refreshUponSelect;
    }

    public void authenticationChanged(String string, String string2, String string3, String string4) {
        Debug.println((String)("DSBaseModel.authenticationChanged(): new bind DN = " + string2 + " old bind DN = " + string));
        IPage iPage = this.getSelectedPage();
        if (iPage != null && iPage instanceof DSResourcePage) {
            DSResourcePage dSResourcePage = (DSResourcePage)iPage;
            if (dSResourcePage.isPageSelected()) {
                this.refreshView();
            } else {
                this.setRefreshUponSelect(true);
            }
        }
    }

    public abstract void refreshView();

    public abstract IMenuItem[] getMenuItems(String var1);

    public abstract String[] getMenuCategoryIDs();
}

