/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.Clipboard;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.Helper;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

class CutDeleter
implements Runnable,
ActionListener {
    boolean _cut;
    boolean _isCancelled = false;
    JFrame _frame;
    GenericProgressDialog _progressDialog;
    int _numberDeletedObjects = 0;
    boolean _isWholeTreeDeleted = false;
    String _startDn;
    Clipboard _clipboard;
    LDAPConnection _ldc;
    String[] _attrs;
    String[] CUT_ATTRS = new String[]{"*"};
    String[] NOT_CUT_ATTRS = new String[]{"dn"};
    final String CHILDREN_FILTER = "|(objectclass=*)(objectclass=ldapsubentry)";

    public CutDeleter(LDAPConnection lDAPConnection, String string, JFrame jFrame, Clipboard clipboard, boolean bl) {
        this._frame = jFrame;
        this._ldc = lDAPConnection;
        this._startDn = string;
        this._cut = bl;
        this._clipboard = clipboard;
        if (this._cut) {
            this._attrs = this.CUT_ATTRS;
            this._clipboard.clean();
        } else {
            this._attrs = this.NOT_CUT_ATTRS;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._isCancelled = true;
            this._progressDialog.disableCancelButton();
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this._progressDialog.closeCallBack();
        }
    }

    public void execute() {
        if (this._startDn.equals("")) {
            DSUtil.showErrorDialog((Component)this._frame, "delete-root-error-title", "delete-root-error-msg", (String[])null, "browser");
        } else {
            boolean bl = false;
            try {
                bl = Helper.entryHasChildren(this._startDn, this._ldc);
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            boolean bl2 = this.confirmDelete(bl);
            if (bl2) {
                this.createDeleteProgressDialog(bl);
                Thread thread = new Thread(this);
                thread.start();
                this._progressDialog.packAndShow();
            }
        }
    }

    public boolean isWholeTreeDeleted() {
        return this._isWholeTreeDeleted;
    }

    public void run() {
        boolean bl = this.deleteTree(this._ldc, this._startDn);
        this._isWholeTreeDeleted = !this.entryExists(this._ldc, this._startDn);
        this.updateProgressDialogForEnd(bl);
    }

    private boolean confirmDelete(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        String[] stringArray = new String[]{DSUtil.abreviateString(this._startDn, 30)};
        String string = null;
        string = bl ? "confirmDeleteTree" : "confirmDeleteObject";
        boolean bl4 = bl3 = bl && DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_SUBTREE) || !bl && DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_ENTRY);
        if (bl3) {
            int n = DSUtil.showConfirmationDialog((Component)this._frame, string, stringArray, "browser");
            bl2 = n == 0;
        }
        return bl2;
    }

    private boolean deleteTree(LDAPConnection lDAPConnection, String string) {
        try {
            lDAPConnection.setOption(30, (Object)new Integer(0));
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        boolean bl = true;
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string, this._attrs);
            bl &= this.recursiveDelete(lDAPEntry, lDAPConnection);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("CutDeleter.deleteTree(): " + (Object)((Object)lDAPException)));
            this._progressDialog.appendTextToTextArea(string + ": " + (Object)((Object)lDAPException) + "\n");
            bl = false;
        }
        return bl;
    }

    private boolean recursiveDelete(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) throws LDAPException {
        Object object;
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        boolean bl = true;
        String string = lDAPEntry.getDN();
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "|(objectclass=*)(objectclass=ldapsubentry)", this._attrs, false);
        while (lDAPSearchResults.hasMoreElements() && !this._isCancelled) {
            String[] stringArray;
            Object object2 = lDAPSearchResults.nextElement();
            object = null;
            try {
                if (object2 instanceof LDAPEntry) {
                    object = (LDAPEntry)object2;
                    String string2 = object.getDN();
                    lDAPConnection.delete(string2);
                    if (this._numberDeletedObjects % 5 == 0) {
                        stringArray = new String[]{DSUtil.abreviateString(string2, 45)};
                        String string3 = DSUtil._resource.getString("browser", "deleting-object-label", stringArray);
                        this._progressDialog.setTextInLabel(string3);
                    }
                    ++this._numberDeletedObjects;
                    if (!this._cut) continue;
                    this._clipboard.putEntry((LDAPEntry)object);
                    continue;
                }
                if (!(object2 instanceof LDAPException)) continue;
                throw (LDAPException)((Object)object2);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 66) {
                    stringArray = Helper.getLDAPErrorMessage(lDAPException);
                    if (object != null) {
                        Debug.println((String)("CutDeleter.recursiveDelete: error deleting entry=" + object.getDN() + ":" + (String)stringArray));
                        this._progressDialog.appendTextToTextArea(object.getDN() + ": " + (String)stringArray + "\n");
                    } else {
                        Debug.println((String)("CutDeleter.recursiveDelete: error deleting " + (String)stringArray));
                        this._progressDialog.appendTextToTextArea((String)stringArray + "\n");
                    }
                    bl = false;
                    continue;
                }
                vector.addElement((LDAPEntry)object);
            }
        }
        if (this._isCancelled) {
            lDAPConnection.abandon(lDAPSearchResults);
        } else {
            int n = 0;
            while (n < vector.size() && !this._isCancelled) {
                bl &= this.recursiveDelete((LDAPEntry)vector.elementAt(n), lDAPConnection);
                ++n;
            }
        }
        if (!this._isCancelled) {
            try {
                lDAPConnection.delete(string);
                String[] stringArray = new String[]{DSUtil.abreviateString(string, 45)};
                object = DSUtil._resource.getString("browser", "deleting-object-label", stringArray);
                this._progressDialog.setTextInLabel((String)object);
                ++this._numberDeletedObjects;
                if (this._cut) {
                    this._clipboard.putEntry(lDAPEntry);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("CutDeleter.recursiveDelete: error deleting entry=" + string + ":" + (Object)((Object)lDAPException)));
                this._progressDialog.appendTextToTextArea(string + ": " + (Object)((Object)lDAPException) + "\n");
                bl = false;
            }
        }
        return bl;
    }

    private void updateProgressDialogForEnd(boolean bl) {
        if (this._isCancelled || this._numberDeletedObjects < 2 && bl) {
            this._progressDialog.closeCallBack();
        } else {
            String[] stringArray = new String[]{String.valueOf(this._numberDeletedObjects)};
            this._progressDialog.setTextInLabel(DSUtil._resource.getString("browser", "deleted-objects-label", stringArray));
            this._progressDialog.waitForClose();
        }
    }

    private void createDeleteProgressDialog(boolean bl) {
        String string = bl ? DSUtil._resource.getString("browser", "delete-objects-title") : DSUtil._resource.getString("browser", "delete-object-title");
        this._progressDialog = new GenericProgressDialog(this._frame, true, 7, string, null, null);
        this._progressDialog.setTextInTextAreaLabel(DSUtil._resource.getString("browser", "non-deleted-objects-label"));
        this._progressDialog.setTextAreaRows(3);
        this._progressDialog.setLabelColumns(50);
        this._progressDialog.addActionListener(this);
    }

    private boolean entryExists(LDAPConnection lDAPConnection, String string) {
        boolean bl;
        block2: {
            bl = false;
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read(string, this.NOT_CUT_ATTRS);
                bl = lDAPEntry != null;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block2;
                Debug.println((String)("CutDeleter.entryExists(): " + (Object)((Object)lDAPException)));
            }
        }
        return bl;
    }
}

