/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBasePanel;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.PasswordCellRenderer;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.AuthConfigDialog;
import com.netscape.admin.certsrv.ug.AuthPluginSelectionDialog;
import com.netscape.admin.certsrv.ug.AuthRuleDataModel;
import com.netscape.admin.certsrv.ug.AuthViewDialog;
import com.netscape.admin.certsrv.ug.CMSBaseUGTab;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.DefaultCellEditor;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AuthInstanceTab
extends CMSBaseUGTab {
    private static final String PANEL_NAME = "AUTHRULE";
    private static final String RULE_NAME = "RULENAME";
    private static final String RULE_IMPL = "IMPL";
    private static final String RULE_TYPE = "TYPE";
    private static final String token = ";";
    private static final String ADMINRULE = "adminAuth";
    private static final String AGENTRULE = "agentAuth";
    private AdminConnection mConnection;
    protected JScrollPane mScrollPane;
    protected JTable mTable;
    protected AuthRuleDataModel mDataModel;
    private boolean mPinDirExist = false;
    private boolean mUserDirExist = false;
    protected JButton mRefresh;
    protected JButton mEdit;
    protected JButton mAdd;
    protected JButton mDelete;
    protected JButton mHelp;
    private static final String HELPINDEX = "authentication-certsrv-authrules-help";

    public AuthInstanceTab(CMSBaseResourceModel model) {
        super(PANEL_NAME, model);
        this.mConnection = model.getServerInfo().getAdmin();
        this.mDataModel = new AuthRuleDataModel();
        this.mHelpToken = HELPINDEX;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mRefresh)) {
            Debug.println((String)"Refresh");
            this.refresh();
        }
        if (e.getSource().equals(this.mEdit)) {
            NameValuePairs response;
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
            String type = data.getValue(RULE_TYPE);
            this.mModel.progressStart();
            try {
                response = this.getConfig();
            }
            catch (EAdminException ex1) {
                this.showErrorDialog(ex1.getMessage());
                this.mModel.progressStop();
                return;
            }
            this.mModel.progressStop();
            Debug.println((String)response.toString());
            Object dialog = null;
            dialog = type.equals("edit") ? new AuthConfigDialog(this.mModel) : new AuthViewDialog(this.mModel);
            dialog.showDialog(response, data.getValue(RULE_NAME), this.mPinDirExist, this.mUserDirExist);
            this.refresh();
        }
        if (e.getSource().equals(this.mAdd)) {
            Debug.println((String)"Add");
            AuthPluginSelectionDialog dialog = new AuthPluginSelectionDialog(this.mModel);
            dialog.showDialog(this.mPinDirExist, this.mUserDirExist);
            this.refresh();
        }
        if (e.getSource().equals(this.mDelete)) {
            Debug.println((String)"Delete");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            int i = this.showConfirmDialog("DELETE");
            if (i == 0) {
                this.delete();
                Debug.println((String)"Deleted");
            }
        }
        if (e.getSource().equals(this.mHelp)) {
            this.helpCallback();
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
    }

    public void refresh() {
        this.mDataModel.removeAllRows();
        this.update();
        this.setButtons();
    }

    protected JPanel createUserButtonPanel() {
        this.mEdit = this.makeJButton("EDIT");
        this.mAdd = this.makeJButton("ADD");
        this.mDelete = this.makeJButton("DELETE");
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete, this.mEdit};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    protected JPanel createActionPanel() {
        this.mRefresh = this.makeJButton("REFRESH");
        this.mHelp = this.makeJButton("HELP");
        JButton[] buttons = new JButton[]{this.mRefresh, this.mHelp};
        return CMSBasePanel.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    protected JPanel createListPanel() {
        this.mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.mListPanel.setLayout(gb);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(0);
        this.mTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        this.mScrollPane.setBackground(Color.white);
        this.mTable.addMouseListener((MouseListener)((Object)this));
        this.setLabelCellRenderer(this.mTable, 0);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        this.mListPanel.add((Component)this.mScrollPane);
        JPanel buttonPanel = this.createUserButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gb.setConstraints((Component)buttonPanel, gbc);
        this.mListPanel.add((Component)buttonPanel);
        this.refresh();
        return this.mListPanel;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    protected void setLabelCellEditor(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new PasswordCellRenderer());
        table.getColumnModel().getColumn(index).setCellEditor((TableCellEditor)new DefaultCellEditor((JTextField)new JPasswordField()));
    }

    private void setButtons() {
        NameValuePairs nvp;
        String ruleType;
        if (this.mTable.getSelectionModel().isSelectionEmpty()) {
            this.mDelete.setEnabled(false);
            this.mEdit.setEnabled(false);
            return;
        }
        if (this.mDataModel.getRowCount() <= 0) {
            this.mDelete.setEnabled(false);
            this.mEdit.setEnabled(false);
            return;
        }
        int index = this.mTable.getSelectedRow();
        this.mDelete.setEnabled(true);
        this.mEdit.setEnabled(true);
        if (index >= 0 && ((ruleType = (nvp = (NameValuePairs)this.mDataModel.getObjectValueAt(index)).getValue(RULE_TYPE)).equals("view") || ruleType.equals("view"))) {
            this.mDelete.setEnabled(false);
        }
    }

    private void update() {
        NameValuePairs response;
        this.mModel.progressStart();
        try {
            response = this.mConnection.search("auths", "instance", new NameValuePairs());
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        Debug.println((String)response.toString());
        int i = 0;
        String[] vals = new String[response.size()];
        Hashtable<String, NameValuePairs> data = new Hashtable<String, NameValuePairs>();
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            String value = response.getValue(entry);
            if (entry.equals("PinDirEnrollment")) {
                this.mPinDirExist = true;
            } else if (entry.equals("UserDirEnrollment")) {
                this.mUserDirExist = true;
            }
            NameValuePairs obj = new NameValuePairs();
            obj.add(RULE_NAME, entry);
            if (!this.updateValue(obj, value)) continue;
            data.put(entry, obj);
            vals[i++] = entry;
        }
        if (i >= 1) {
            String[] valCopy = new String[i];
            System.arraycopy(vals, 0, valCopy, 0, i);
            CMSAdminUtil.bubbleSort((String[])valCopy);
            int y = 0;
            while (y < valCopy.length) {
                this.mDataModel.processData(data.get(valCopy[y]));
                ++y;
            }
            data.clear();
        }
        if (this.mDataModel.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
        this.mModel.progressStop();
    }

    private boolean updateValue(NameValuePairs nvp, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, token);
        int num = tokenizer.countTokens();
        if (num == 1) {
            nvp.add(RULE_IMPL, value);
            nvp.add(RULE_TYPE, "edit");
        } else if (num > 1) {
            nvp.add(RULE_IMPL, (String)tokenizer.nextElement());
            String type = (String)tokenizer.nextElement();
            if (type.equals("view")) {
                return false;
            }
            nvp.add(RULE_TYPE, type);
        } else {
            this.showMessageDialog("SERVERERROR");
        }
        return true;
    }

    private void delete() {
        this.mModel.progressStart();
        NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        try {
            this.mConnection.delete("auths", "instance", data.getValue(RULE_NAME));
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        this.mModel.progressStop();
        this.refresh();
    }

    private NameValuePairs getConfig() throws EAdminException {
        NameValuePairs data = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        NameValuePairs response = this.mConnection.read("auths", "instance", data.getValue(RULE_NAME), new NameValuePairs());
        return response;
    }
}

