/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.config.ConfigTableModel;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.DefaultCellEditor;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.table.DefaultTableCellRenderer;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import com.sun.java.swing.text.JTextComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class MapperConfigDialog
extends JDialog
implements ActionListener,
ItemListener {
    private String PREFIX = "MAPPERCONFIGDIALOG";
    private JFrame mParentFrame;
    private ResourceBundle mResource;
    protected ConfigTableModel mDataModel;
    protected boolean mIsOK = false;
    protected NameValuePairs mData;
    private JScrollPane mScrollPane;
    private JTable mTable;
    private String mRuleName;
    private String mDest;
    private String mScope;
    private AdminConnection mConn;
    private JButton mOK;
    private JButton mCancel;
    private JButton mHelp;
    private JComboBox mSelection;
    private static final String CAHELPINDEX = "configuration-ldappublish-camapper-dbox-help";
    private static final String RAHELPINDEX = "configuration-ldappublish-ramapper-dbox-help";
    static /* synthetic */ Class class$com$netscape$admin$certsrv$CMSAdminResources;

    public MapperConfigDialog(JFrame parent, AdminConnection conn) {
        super((Frame)parent, true);
        this.mConn = conn;
        this.mParentFrame = parent;
        this.mResource = ResourceBundle.getBundle((class$com$netscape$admin$certsrv$CMSAdminResources != null ? class$com$netscape$admin$certsrv$CMSAdminResources : (class$com$netscape$admin$certsrv$CMSAdminResources = MapperConfigDialog.class$("com.netscape.admin.certsrv.CMSAdminResources"))).getName());
        this.mDataModel = new ConfigTableModel();
        ((Component)((Object)this)).setSize(360, 216);
        ((Dialog)((Object)this)).setTitle(this.mResource.getString(String.valueOf(this.PREFIX) + "_TITLE"));
        this.setLocationRelativeTo((Component)parent);
        this.getRootPane().setDoubleBuffered(true);
        this.setDisplay();
    }

    public void showDialog(String name, String destination, String scope) {
        this.mIsOK = false;
        this.mDataModel.removeAllRows();
        this.mData = new NameValuePairs();
        this.mRuleName = name;
        this.mDest = destination;
        this.mScope = scope;
        Debug.println((String)("MapperConfigDialog: showDialog() - mapper: " + this.mRuleName + " dest: " + this.mDest + " scope: " + this.mScope));
        if (!this.refresh(name)) {
            return;
        }
        ((Dialog)((Object)this)).show();
    }

    public boolean isOK() {
        return this.mIsOK;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.mOK)) {
            Component component = this.mTable.getEditorComponent();
            if (component != null) {
                int col = this.mTable.getEditingColumn();
                int row = this.mTable.getEditingRow();
                if (col > -1 && row > -1) {
                    String str = ((JTextComponent)component).getText();
                    this.mTable.setValueAt((Object)str, row, col);
                }
            }
            try {
                this.saveConfiguration();
            }
            catch (EAdminException e) {
                CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
                return;
            }
            this.mIsOK = true;
            ((Window)((Object)this)).dispose();
        }
        if (evt.getSource().equals(this.mCancel)) {
            ((Window)((Object)this)).dispose();
        }
        if (evt.getSource().equals(this.mHelp)) {
            if (this.mDest.equals("ca")) {
                CMSAdminUtil.help((String)CAHELPINDEX);
            } else if (this.mDest.equals("ra")) {
                CMSAdminUtil.help((String)RAHELPINDEX);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.mSelection) && e.getStateChange() == 1) {
            this.mTable.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
            Debug.println((String)("Selected: " + (String)this.mSelection.getSelectedItem()));
            this.setupConfigUI((String)this.mSelection.getSelectedItem());
        }
    }

    private void saveEdit() {
        Component component = this.mTable.getEditorComponent();
    }

    private boolean refresh(String mapperName) {
        if (!this.getMapperListing(mapperName)) {
            return false;
        }
        return this.setupConfigUI(mapperName);
    }

    private boolean getMapperListing(String mapperName) {
        NameValuePairs response;
        try {
            response = this.getMapperList();
        }
        catch (EAdminException e) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
            return false;
        }
        Debug.println((String)("MapperList: " + response.toString()));
        this.mSelection.removeAllItems();
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            this.mSelection.addItem((Object)((String)e.nextElement()).trim());
        }
        this.mSelection.setSelectedItem((Object)mapperName);
        return true;
    }

    private boolean setupConfigUI(String mapperName) {
        try {
            this.mData = this.getConfiguration(mapperName);
        }
        catch (EAdminException e) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
            return false;
        }
        Debug.println((String)("MapperConfigDialog: showDialog() config: " + this.mData.toString()));
        this.mDataModel.removeAllRows();
        Enumeration e = this.mData.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            if (entry.equals("mapper")) continue;
            String value = this.mData.getValue(entry);
            Vector<String> v = new Vector<String>();
            v.addElement(entry);
            v.addElement(value);
            this.mDataModel.addRow(v);
        }
        this.mScrollPane.repaint();
        this.mTable.repaint();
        return true;
    }

    private void setDisplay() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);
        JPanel content = this.makeContentPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)content, gbc);
        center.add((Component)content);
        JPanel action = this.makeActionPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)action, gbc);
        center.add((Component)action);
        this.getContentPane().add("Center", (Component)center);
    }

    private JPanel makeActionPane() {
        this.mOK = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"OK", null, (ActionListener)this);
        this.mCancel = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"CANCEL", null, (ActionListener)this);
        this.mHelp = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"HELP", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mOK, this.mCancel, this.mHelp};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    private JPanel makeContentPane() {
        JPanel mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mListPanel.setLayout(gb);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        JLabel label3 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"IMPLNAME", null);
        this.mSelection = new JComboBox();
        this.mSelection.addItemListener((ItemListener)this);
        MapperConfigDialog.addEntryField(mListPanel, (JComponent)label3, (JComponent)this.mSelection, gbc);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(1);
        this.mScrollPane.setBackground(Color.white);
        this.setCellEditor(this.mTable, 1);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(9, 6, 0, 6);
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        mListPanel.add((Component)this.mScrollPane);
        return mListPanel;
    }

    private void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer());
    }

    private void setCellEditor(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellEditor((TableCellEditor)new DefaultCellEditor(new JTextField()));
    }

    private NameValuePairs getMapperList() throws EAdminException {
        return this.mConn.search(this.mDest, this.getMapperScope(), new NameValuePairs());
    }

    private NameValuePairs getConfiguration(String mapper) throws EAdminException {
        return this.mConn.read(this.mDest, this.getMapperScope(), mapper, new NameValuePairs());
    }

    private String getMapperScope() {
        if (this.mScope.equals("caCert")) {
            return "caMapper";
        }
        return "userMapper";
    }

    private void saveConfiguration() throws EAdminException {
        NameValuePairs nvp = this.getData();
        nvp.add("mapper", (String)this.mSelection.getSelectedItem());
        this.mConn.modify(this.mDest, this.mScope, "RS_ID_CONFIG", nvp);
    }

    private NameValuePairs getData() {
        NameValuePairs response = new NameValuePairs();
        int i = 0;
        while (i < this.mDataModel.getRowCount()) {
            response.add((String)this.mDataModel.getValueAt(i, 0), (String)this.mDataModel.getValueAt(i, 1));
            ++i;
        }
        return response;
    }

    private static void addEntryField(JPanel panel, JComponent label, JComponent field, GridBagConstraints gbc) {
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(6, 6, 0, 0);
        panel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(6, 6, 0, 6);
        panel.add((Component)field, gbc);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

