/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.AddClassDialog;
import com.sun.wbem.apps.cimworkshop.AddQualifierTypeDialog;
import com.sun.wbem.apps.cimworkshop.CIMTableTabbedPane;
import com.sun.wbem.apps.cimworkshop.CWSLoginDialog;
import com.sun.wbem.apps.cimworkshop.ClassTreePane;
import com.sun.wbem.apps.cimworkshop.InstanceFrame;
import com.sun.wbem.apps.cimworkshop.ObjectTreeFrame;
import com.sun.wbem.apps.cimworkshop.QualifierWindow;
import com.sun.wbem.apps.cimworkshop.QueryFrame;
import com.sun.wbem.apps.cimworkshop.QueryInputDialog;
import com.sun.wbem.apps.cimworkshop.ReferenceTraversalDialog;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import com.sun.wbem.apps.common.WaitDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;

public class ClassTreeActionPane
extends ClassTreePane {
    private CIMTableTabbedPane tablePane;
    private ObjectTreeFrame parentFrame;
    private CWSLoginDialog loginDialog;
    private Vector instanceFrameList = new Vector();
    private JMenuItem instanceMenuItem;
    private JMenuItem addClassMenuItem;
    private JMenuItem rootAddClassMenuItem;
    private JMenuItem addQualifierType;

    public ClassTreeActionPane(ObjectTreeFrame objectTreeFrame, CIMTableTabbedPane cIMTableTabbedPane) {
        this.parentFrame = objectTreeFrame;
        this.tablePane = cIMTableTabbedPane;
        ActionString actionString = new ActionString("MNU_ADD_CLASS");
        ActionString actionString2 = new ActionString("MNU_INSTANCES");
        ActionString actionString3 = new ActionString("MNU_QUALIFIERS");
        ActionString actionString4 = new ActionString("MNU_REFRESH_CLASS");
        ActionString actionString5 = new ActionString("MNU_ADD_QUALIFIER_TYPE");
        this.addClassMenuItem = this.popupMenu.add(new JMenuItem(actionString.getString()));
        this.addClassMenuItem.setActionCommand("ADD_CLASS");
        this.addClassMenuItem.addActionListener(this);
        this.instanceMenuItem = this.popupMenu.add(new JMenuItem(actionString2.getString()));
        this.instanceMenuItem.setActionCommand("INSTANCES");
        this.instanceMenuItem.addActionListener(this);
        JMenuItem jMenuItem = this.popupMenu.add(new JMenuItem(actionString3.getString()));
        jMenuItem.setActionCommand("QUALIFIERS");
        jMenuItem.addActionListener(this);
        this.popupMenu.addSeparator();
        jMenuItem = this.popupMenu.add(new JMenuItem(actionString4.getString()));
        jMenuItem.setActionCommand("REFRESH");
        jMenuItem.addActionListener(this);
        this.rootAddClassMenuItem = this.rootPopupMenu.add(new JMenuItem(actionString.getString()));
        this.rootAddClassMenuItem.setActionCommand("ADD_CLASS");
        this.rootAddClassMenuItem.addActionListener(this);
        this.addQualifierType = this.rootPopupMenu.add(new JMenuItem(actionString5.getString()));
        this.addQualifierType.setActionCommand("ADD_QUALIFIER_TYPE");
        this.addQualifierType.addActionListener(this);
        this.rootPopupMenu.addSeparator();
        jMenuItem = this.rootPopupMenu.add(new JMenuItem(actionString4.getString()));
        jMenuItem.setActionCommand("REFRESH");
        jMenuItem.addActionListener(this);
    }

    public void enableInstanceMenuItem(boolean bl) {
        this.instanceMenuItem.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block30: {
            Util.setWaitCursor(this);
            String string = actionEvent.getActionCommand();
            if (string.equals("hostDialog")) {
                this.getHostInfo();
            } else if (this.getSelectedNodeString() == null) {
                JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_CLASS_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
            } else if (string.equals("INSTANCES")) {
                String string2 = this.getSelectedNodeString();
                CIMObjectPath cIMObjectPath = new CIMObjectPath(string2);
                try {
                    CIMClass cIMClass = this.cimClient.getClass(cIMObjectPath, false, true, true, null);
                    if (!cIMClass.isKeyed()) {
                        JOptionPane.showMessageDialog(this, I18N.loadStringFormat("MSG_NOT_KEYED_CLASS", string2), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 1);
                        break block30;
                    }
                    InstanceFrame instanceFrame = new InstanceFrame(this.parentFrame, this.cimClient, cIMClass, true);
                    this.instanceFrameList.addElement(instanceFrame);
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            } else if (string.equals("QUALIFIERS")) {
                String string3 = this.getSelectedNodeString();
                CIMObjectPath cIMObjectPath = new CIMObjectPath(string3);
                try {
                    CIMClass cIMClass = this.cimClient.getClass(cIMObjectPath, false, true, true, null);
                    if (cIMClass.numberOfQualifiers() > 0) {
                        QualifierWindow qualifierWindow = new QualifierWindow((Frame)this.parentFrame, this.cimClient, (CIMElement)cIMClass, false);
                        break block30;
                    }
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_NO_QUALIFIERS", string3), I18N.loadString("TTL_CIM_ERROR"), 0);
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            } else if (string.equals("ASSOC_TRAVERSAL")) {
                String string4 = this.getSelectedNodeString();
                CIMObjectPath cIMObjectPath = new CIMObjectPath(string4);
                ReferenceTraversalDialog referenceTraversalDialog = new ReferenceTraversalDialog((Frame)this.parentFrame, cIMObjectPath, this.cimClient);
            } else if (string.equals("ADD_CLASS")) {
                AddClassDialog addClassDialog;
                String string5;
                Util.setWaitCursor(this);
                String string6 = this.getSelectedNodeString();
                if (this.isRootSelected()) {
                    string6 = "";
                }
                if ((string5 = (addClassDialog = new AddClassDialog((Frame)this.parentFrame, string6)).getClassName()) != null) {
                    ClassTreePane.ClassTreeNode classTreeNode = new ClassTreePane.ClassTreeNode(this, new CIMObjectPath(string5));
                    this.addNodeToSelected(classTreeNode);
                    TreePath treePath = new TreePath(classTreeNode.getPath());
                    this.tree.expandPath(treePath);
                    this.tree.setSelectionPath(treePath);
                }
            } else if (string.equals("DELETE_CLASS")) {
                String string7 = this.getSelectedNodeString();
                int n = JOptionPane.showConfirmDialog(this, I18N.loadStringFormat("ASK_DELETE_CLASS", string7), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3);
                if (n == 0) {
                    try {
                        this.cimClient.deleteClass(new CIMObjectPath(string7));
                        this.deleteSelectedNode();
                    }
                    catch (CIMException cIMException) {
                        CIMErrorDialog.display(this, cIMException);
                    }
                }
            } else if (string.equals("ADD_QUALIFIER_TYPE")) {
                AddQualifierTypeDialog addQualifierTypeDialog = new AddQualifierTypeDialog(this.parentFrame);
            } else if (string.equals("EXEC_QUERY")) {
                QueryInputDialog queryInputDialog = new QueryInputDialog(this.parentFrame);
                String string8 = queryInputDialog.getQueryString();
                if (string8 != null) {
                    QueryFrame queryFrame = new QueryFrame(this.parentFrame, this.cimClient, string8);
                    this.instanceFrameList.add(queryFrame);
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
        Util.setDefaultCursor(this);
    }

    public boolean getHostInfo() {
        this.loginDialog = new CWSLoginDialog(this.parentFrame);
        boolean bl = this.loginDialog.getLoggedIn();
        if (bl) {
            boolean bl2 = CIMClientObject.userHasWritePermission();
            this.addClassMenuItem.setEnabled(bl2);
            this.rootAddClassMenuItem.setEnabled(bl2);
            this.addQualifierType.setEnabled(bl2);
            this.parentFrame.initializeNewHost();
        }
        return bl;
    }

    public void initializeClassTree() {
        WaitDialog waitDialog = new WaitDialog((Frame)this.parentFrame, I18N.loadString("LBL_WAIT", "com.sun.wbem.apps.common.common"), I18N.loadString("MSG_ENUM_CLASSES"));
        waitDialog.setLocation(Util.getCenterPoint(this.parentFrame, waitDialog));
        waitDialog.start();
        this.refreshTree();
        waitDialog.stop();
        this.closeOpenInstanceFrames();
    }

    public void closeOpenInstanceFrames() {
        Enumeration enumeration = this.instanceFrameList.elements();
        while (enumeration.hasMoreElements()) {
            JFrame jFrame = (JFrame)enumeration.nextElement();
            jFrame.dispose();
        }
        this.instanceFrameList.removeAllElements();
    }

    protected void populateTables(CIMClass cIMClass) {
        this.tablePane.populateTables(this.cimClient, (CIMElement)cIMClass);
    }
}

