/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.ClassTreePane;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.AdminDialog;
import com.sun.wbem.apps.common.ColumnLayout;
import com.sun.wbem.apps.common.ContextHelpListener;
import com.sun.wbem.apps.common.GenInfoPanel;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ClassSelectionDialog
extends AdminDialog
implements TreeSelectionListener {
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton findBtn;
    protected String className = "";
    private JPanel mainPanel;
    private ClassTreePane treePane = new ClassTreePane();

    public ClassSelectionDialog(Frame frame) {
        super(frame, I18N.loadString("TTL_CLASS_SELECTION"), false);
        this.treePane.addTreeSelectionListener(this);
        this.okBtn = this.getOKBtn();
        this.okBtn.addActionListener(new OKCancelButtonListener());
        this.cancelBtn = this.getCancelBtn();
        this.cancelBtn.addActionListener(new OKCancelButtonListener());
        ActionString actionString = new ActionString("TIP_FIND_CLASS");
        this.findBtn = new JButton(actionString.getString());
        this.findBtn.setMnemonic(actionString.getMnemonic());
        this.findBtn.setActionCommand("FIND_CLASS");
        this.findBtn.addActionListener(this.treePane);
        JPanel jPanel = this.getbuttonPanel();
        jPanel.add(this.findBtn);
        this.mainPanel = this.getRightPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        this.mainPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.mainPanel.add(this.treePane);
        GenInfoPanel genInfoPanel = this.getInfoPanel();
        this.setDefaultFocusListener(new ContextHelpListener(genInfoPanel, "cimworkshop", "ClassSelection_000.htm"), true);
        this.okBtn.setEnabled(!this.treePane.isRootSelected());
        this.treePane.refreshTree();
        this.pack();
        this.setLocation(Util.getCenterPoint(frame, this));
        this.setVisible(true);
    }

    public void okClicked() {
        this.className = this.treePane.getSelectedNodeString();
        if (this.className == null) {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_NO_CLASS_SELECTED"), I18N.loadString("TTL_CIM_ERROR"), 0);
            return;
        }
        this.dispose();
    }

    public void cancelClicked() {
        this.className = "";
        this.dispose();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.okBtn.setEnabled(!this.treePane.isRootSelected());
    }

    public String getClassName() {
        return this.className;
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ClassSelectionDialog.this.cancelBtn) {
                ClassSelectionDialog.this.cancelClicked();
            } else if (actionEvent.getSource() == ClassSelectionDialog.this.okBtn) {
                ClassSelectionDialog.this.okClicked();
            }
        }
    }
}

