/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.compiler.mofc.BeanBaseWriter;
import com.sun.wbem.compiler.mofc.BeanGenerator;
import com.sun.wbem.compiler.mofc.CIM_Mofc;
import com.sun.wbem.compiler.mofc.I18N;
import com.sun.wbem.compiler.mofc.LocalCIMClient;
import com.sun.wbem.compiler.mofc.LogFile;
import com.sun.wbem.compiler.mofc.MofcCIMValue;
import com.sun.wbem.compiler.mofc.XmlWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class MofcBackend {
    private CIMOMHandle clientAPI;
    private CIMOMHandle rootClient;
    private CIM_Mofc parser;
    private UserPrincipal up;
    private PasswordCredential pc;
    public String fileName;
    public int lineNo;
    public int parsePhase;
    private String cimhost;
    private boolean setQual;
    private boolean setClass;
    private boolean setInstance;
    private boolean BEAN;
    private boolean deleteMode;
    private boolean XML;
    private boolean BUILD;
    private BufferedWriter xmlOut;
    private BufferedWriter bigxmlOut;
    private XmlWriter xmlwriter;
    private String qualDebug;
    private String classDebug;
    private String instanceDebug;
    private boolean connectToCimom;
    private String beanPackage;
    private String beanImports;
    private String beanExceptions;
    private String beanDir;
    private static final String NSDELETEMODE = "__delete";
    private static final String NSCREATEMODE = "__create";
    private static final String NSMODIFYMODE = "__modify";
    public Hashtable classAliases;
    public Hashtable instanceAliases;
    public Hashtable instanceAliasesNS;
    public Vector qualifiers;
    public Vector properties;
    public Vector methods;
    public Vector parameters;
    public boolean erroneousUnit;
    public boolean erroneousPart;
    public boolean erroneousQualifierList;
    public int refsRequired;
    public int keysRequired;
    public CIMNameSpace curNameSpace;
    public String curSchema;
    public CIMElement curSchemaEl;
    public CIMClass curClassEl;
    public CIMProperty curPropRefEl;
    public CIMMethod curMethodEl;
    public CIMQualifier curQualifierEl;
    public CIMQualifierType curQualifierTypeEl;
    public CIMParameter curParameterEl;
    public CIMInstance curInstanceEl;
    public CIMProperty curIPropertyEl;
    public String curLevel;
    public CIMDataType curType;
    public String curValueType;
    public MofcCIMValue curValues;
    public int size;
    public String curInstanceAlias;
    public String curClassAlias;
    public boolean print_MOFComp;

    void HOLG_START(String string) {
        LogFile.add(4, "METHOD_START", string);
    }

    void HOLG_PRINT(String string) {
        LogFile.add(4, "NONE", string);
    }

    void HOLG_PRINT_ELEMENT(CIMElement cIMElement) {
        LogFile.add(4, "NONE", cIMElement);
    }

    void HOLG_END(String string) {
        LogFile.add(4, "METHOD_END", string);
    }

    void reportWarning(String string, String string2, String string3) {
        Integer n = new Integer(this.parser.getCurrentLine());
        LogFile.add(0, "ERROR_WARNING", this.fileName, n);
        LogFile.add(0, string);
        LogFile.add(0, string2, new Object[]{new String(string3)});
        System.err.println(I18N.loadStringFormat("ERROR_WARNING", this.fileName, n));
        System.err.println(I18N.loadString(string));
        System.err.println(I18N.loadStringFormat(string2, string3));
    }

    void reportError(String string, String string2, int n, String string3) throws CIMException {
        Integer n2 = new Integer(this.parser.getCurrentLine());
        LogFile.add(0, "ERROR_LINE", this.fileName, n2);
        LogFile.add(0, string);
        LogFile.add(0, string2, new Object[]{new String(string3)});
        if (this.parser.isInvoked) {
            throw new CIMException("CIM_ERR_FAILED", new Object[]{this.fileName, n2, string, string2, string3});
        }
        System.err.println(I18N.loadStringFormat("ERROR_LINE", this.fileName, n2));
        System.err.println(I18N.loadString(string));
        System.err.println(I18N.loadStringFormat(string2, string3));
        System.exit(n);
    }

    void setParsePhase(int n) {
        if (n == 2 && (this.parser.mode == 1 || this.parser.mode == 2)) {
            this.deleteMode = false;
            this.setQual = false;
            this.setClass = false;
            this.setInstance = false;
            this.deleteMode = false;
        }
        this.parsePhase = n;
    }

    public void cleanup() throws CIMException {
        if (this.rootClient != null) {
            this.rootClient.close();
        }
        if (this.clientAPI != null) {
            this.clientAPI.close();
        }
    }

    public MofcBackend(Hashtable hashtable, CIM_Mofc cIM_Mofc) throws RemoteException, MalformedURLException, NotBoundException, Exception {
        Object object;
        block15: {
            this.clientAPI = null;
            this.rootClient = null;
            this.up = null;
            this.pc = null;
            this.fileName = "";
            this.lineNo = 0;
            this.parsePhase = 1;
            this.setQual = false;
            this.setClass = false;
            this.setInstance = false;
            this.BEAN = false;
            this.deleteMode = false;
            this.XML = false;
            this.BUILD = false;
            this.xmlwriter = new XmlWriter();
            this.qualDebug = "ADDING_QUALIFIERTYPE";
            this.classDebug = "ADDING_CLASS";
            this.instanceDebug = "ADDING_INSTANCE";
            this.connectToCimom = true;
            this.beanPackage = "";
            this.beanImports = "";
            this.beanExceptions = "";
            this.beanDir = "";
            this.curNameSpace = new CIMNameSpace();
            this.curSchema = "";
            this.parser = cIM_Mofc;
            String string = (String)hashtable.get("standalone");
            if (string != null) {
                boolean bl = this.connectToCimom = string.compareToIgnoreCase("true") != 0;
                if (!this.connectToCimom) {
                    System.setProperty("logdir", (String)hashtable.get("logdir"));
                    System.setProperty("passAllProviderCheck", "true");
                }
            }
            this.connectToCimom &= !cIM_Mofc.isInvoked;
            String string2 = (String)hashtable.get("username");
            String string3 = (String)hashtable.get("password");
            if (string2 != null && string2.length() != 0) {
                if (string3 == null) {
                    System.out.print(I18N.loadString("PASSWORD"));
                    object = new byte[20];
                    System.in.read((byte[])object, 0, 20);
                    int n = 0;
                    while (n < ((byte[])object).length) {
                        if (object[n] == 10) {
                            object[n] = 0;
                            break;
                        }
                        ++n;
                    }
                    string3 = new String((byte[])object);
                }
                this.up = new UserPrincipal(string2);
                this.pc = new PasswordCredential(string3);
            }
            this.cimhost = (String)hashtable.get("cimhost");
            if (this.cimhost == null || this.cimhost.length() == 0) {
                this.cimhost = "localhost";
            }
            Object object2 = this.rootClient = this.connectToCimom ? new CIMClient(new CIMNameSpace(this.cimhost, ""), (Principal)this.up, (Object)this.pc) : new LocalCIMClient(new CIMNameSpace(this.cimhost, ""), (Principal)this.up, this.pc, cIM_Mofc.callBack);
            if (hashtable.get("-j") != null) {
                this.BEAN = true;
                this.beanPackage = (String)hashtable.get("beanPackage");
                this.beanImports = (String)hashtable.get("beanImports");
                this.beanExceptions = (String)hashtable.get("beanExceptions");
                object = (String)hashtable.get("logdir");
                this.beanDir = object == null ? (Object)System.getProperty("user.dir") : object;
                BeanBaseWriter beanBaseWriter = new BeanBaseWriter(this.beanPackage, new File(this.beanDir));
            }
            if (hashtable.get("-x") != null) {
                this.XML = true;
            }
            if (hashtable.get("-b") != null) {
                this.BUILD = true;
            }
            if (hashtable.get("-Q") != null) {
                this.setQual = true;
                this.qualDebug = "SETTING_QUALIFIERTYPE";
            }
            if (hashtable.get("-C") != null) {
                this.setClass = true;
                this.classDebug = "SETTING_CLASS";
            }
            if (hashtable.get("-I") != null) {
                this.setInstance = true;
                this.instanceDebug = "SETTING_INSTANCE";
            }
            this.curNameSpace.setHost(this.cimhost);
            try {
                this.rootClient.createNameSpace(this.curNameSpace);
            }
            catch (CIMException cIMException) {
                if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS") || cIMException.getID().equals("CIM_ERR_ACCESS_DENIED")) break block15;
                throw cIMException;
            }
        }
        object = new CIMNameSpace();
        object.setHost(this.cimhost);
        this.clientAPI = this.connectToCimom ? new CIMClient((CIMNameSpace)object, (Principal)this.up, (Object)this.pc) : new LocalCIMClient((CIMNameSpace)object, (Principal)this.up, this.pc, cIM_Mofc.callBack);
        this.classAliases = new Hashtable();
        this.qualifiers = new Vector();
        this.properties = new Vector();
        this.methods = new Vector();
        this.instanceAliases = new Hashtable();
        this.instanceAliasesNS = new Hashtable();
        this.parameters = new Vector();
        this.erroneousUnit = false;
        this.erroneousPart = false;
        this.erroneousQualifierList = false;
        this.refsRequired = 0;
        this.keysRequired = 0;
        this.curSchemaEl = new CIMElement();
        this.curClassEl = new CIMClass();
        this.curPropRefEl = new CIMProperty();
        this.curMethodEl = new CIMMethod();
        this.curQualifierEl = new CIMQualifier();
        this.curQualifierTypeEl = new CIMQualifierType();
        this.curParameterEl = new CIMParameter();
        this.curInstanceEl = new CIMInstance();
        this.curIPropertyEl = new CIMProperty();
        this.curType = null;
        this.curInstanceAlias = null;
        this.curClassAlias = null;
        this.curValueType = new String("");
        this.curValues = new MofcCIMValue();
        this.size = 0;
        this.print_MOFComp = false;
    }

    public String toString() {
        return new String("MofcBackend:\nNamespaceTable:\nEnd of NamespaceTable\nQualifierTypesTable:\nEnd of QualifierTypesTable\nEnd of MofcBackend\n");
    }

    public void resetAfterSyntaxError() {
        this.HOLG_START("resetAfterSyntaxError");
        this.qualifiers = new Vector();
        this.properties = new Vector();
        this.methods = new Vector();
        this.parameters = new Vector();
        this.erroneousUnit = false;
        this.erroneousPart = false;
        this.erroneousQualifierList = false;
        this.refsRequired = 0;
        this.keysRequired = 0;
        this.curClassEl = new CIMClass();
        this.curSchemaEl = new CIMElement();
        this.curPropRefEl = new CIMProperty();
        this.curMethodEl = new CIMMethod();
        this.curQualifierEl = new CIMQualifier();
        this.curParameterEl = new CIMParameter();
        this.curInstanceEl = new CIMInstance();
        this.curIPropertyEl = new CIMProperty();
        this.curInstanceAlias = null;
        this.curClassAlias = null;
        this.curType = null;
        this.curValueType = new String("");
        this.curValues = new MofcCIMValue();
        this.size = 0;
        this.HOLG_END("resetAfterSyntaxError");
    }

    public void switchNamespace(String string) throws CIMException {
        this.HOLG_START("switchNamespace");
        if (this.parser.mode == 1 || this.parser.mode == 2) {
            if (string.equals(NSCREATEMODE)) {
                Debug.trace3((String)"Going to create mode");
                this.setQual = false;
                this.setClass = false;
                this.setInstance = false;
                this.deleteMode = false;
                return;
            }
            if (string.equals(NSMODIFYMODE)) {
                Debug.trace3((String)"Going to set mode");
                this.setQual = true;
                this.setClass = true;
                this.setInstance = true;
                this.deleteMode = false;
                return;
            }
            if (string.equals(NSDELETEMODE)) {
                this.deleteMode = true;
                return;
            }
        }
        if (this.parsePhase == 1) {
            return;
        }
        this.curNameSpace.setNameSpace(string);
        try {
            this.rootClient.createNameSpace(this.curNameSpace);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clientAPI.close();
            this.clientAPI = null;
            this.clientAPI = this.connectToCimom ? new CIMClient(this.curNameSpace, (Principal)this.up, (Object)this.pc) : new LocalCIMClient(this.curNameSpace, (Principal)this.up, this.pc, this.parser.callBack);
        }
        catch (Exception exception) {
            if (exception instanceof CIMException) {
                this.reportError("ERR_EXC", "ERR_CIMOM_CONNECTION", 1, this.parser.toStringCIMException((CIMException)((Object)exception)));
            }
            this.reportError("ERR_EXC", "ERR_CIMOM_CONNECTION", 1, exception.toString());
        }
        this.HOLG_END("switchNamespace");
    }

    public void assignSchemaName(String string) throws CIMException {
        this.HOLG_START("assignSchemaName");
        if (string.indexOf("_") >= 0) {
            this.reportError("ERR_SEM", "ERR_ILLEGAL_SCHEMA_NAME", 1, string);
        } else {
            this.curSchema = string.substring(1, string.length() - 1);
        }
        this.HOLG_END("assignSchemaName");
    }

    public void assignQualifierTypeScope(CIMScope cIMScope) {
        this.HOLG_START("assignQualifierTypeScope");
        this.curQualifierTypeEl.addScope(cIMScope);
        this.HOLG_END("assignQualifierTypeScope");
    }

    public void assignQualifierTypeFlavor(CIMFlavor cIMFlavor) {
        this.HOLG_START("assignQualifierTypeFlavor");
        this.curQualifierTypeEl.addFlavor(cIMFlavor);
        this.HOLG_END("assignQualifierTypeFlavor");
    }

    public void addQualifierType() throws CIMException {
        this.HOLG_START("addQualifierType");
        if (this.erroneousPart) {
            this.erroneousUnit = true;
        }
        if (!this.erroneousUnit) {
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curQualifierTypeEl);
            if (this.parsePhase == 2) {
                try {
                    LogFile.add(3, this.qualDebug, this.curQualifierTypeEl.getName());
                    if (this.parser.isVerbose()) {
                        System.out.println(I18N.loadStringFormat(this.qualDebug, this.curQualifierTypeEl.getName()));
                    }
                    if (this.setQual) {
                        this.clientAPI.setQualifierType(new CIMObjectPath(this.curQualifierTypeEl.getName()), this.curQualifierTypeEl);
                    } else {
                        this.clientAPI.createQualifierType(new CIMObjectPath(this.curQualifierTypeEl.getName()), this.curQualifierTypeEl);
                    }
                    if (this.XML && this.BUILD) {
                        this.xmlwriter.writeBigXml(this.curQualifierTypeEl, this.bigxmlOut);
                    }
                }
                catch (CIMException cIMException) {
                    if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setQual || cIMException.getID().equals("CIM_ERR_NOT_FOUND") && this.setQual) {
                        this.reportWarning("ERR_SEM", "ERR_SETTING_QUALIFIER_TYPE", this.parser.toStringCIMException(cIMException));
                    } else {
                        this.reportError("ERR_SEM", "ERR_SETTING_QUALIFIER_TYPE", 1, this.parser.toStringCIMException(cIMException));
                    }
                }
                catch (Exception exception) {
                    this.reportError("ERR_EXC", "ERR_SETTING_QUALIFIER_TYPE", 1, exception.toString());
                }
            }
        }
        this.curQualifierTypeEl = new CIMQualifierType();
        this.HOLG_END("addQualifierType");
    }

    public void assignQualifierNameType(String string) {
        this.HOLG_START("assignQualifierNameType");
        this.curQualifierEl.setName(string);
        this.HOLG_PRINT(string);
        this.HOLG_END("assignQualifierNameType");
    }

    public void assignQualifierParameter(boolean bl) {
        this.HOLG_START("assignQualifierParameter");
        if (!this.erroneousQualifierList && !this.curValues.isEmpty()) {
            CIMValue cIMValue = bl ? new CIMValue((Object)this.curValues.vVector) : new CIMValue(this.curValues.firstElement());
            this.curQualifierEl.setValue(cIMValue);
        }
        this.curValues = new MofcCIMValue();
        this.HOLG_END("assignQualifierParameter");
    }

    public void assignQualifierFlavor(CIMFlavor cIMFlavor) {
        this.HOLG_START("assignQualifierFlavor");
        this.curQualifierEl.addFlavor(cIMFlavor);
        this.HOLG_END("assignQualifierFlavor");
    }

    public void addQualifier() {
        this.HOLG_START("addQualifier");
        if (!this.erroneousQualifierList) {
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curQualifierEl);
            this.qualifiers.addElement(this.curQualifierEl);
        }
        this.curQualifierEl = new CIMQualifier();
        this.HOLG_END("addQualifier");
    }

    public void checkQualifierList() throws CIMException {
        this.HOLG_START("checkQualifierList");
        if (!this.erroneousQualifierList) {
            // empty if block
        }
        this.HOLG_END("checkQualifierList");
    }

    public void assignClassName(String string) throws CIMException {
        this.HOLG_START("assignClassName");
        if (string.indexOf("_") < 0) {
            if (this.curSchema.length() == 0) {
                this.reportError("ERR_SEM", "ERR_ILLEGAL_SCHEMA_NAME", 1, this.curSchema);
            } else {
                string = new String(this.curSchema + "_" + string);
            }
        }
        this.curClassEl.setName(string);
        this.HOLG_PRINT(string);
        this.HOLG_END("assignClassName");
    }

    public void assignClassAlias(String string) {
        this.HOLG_START("assignClassAlias");
        if (this.parsePhase == 1) {
            this.curClassAlias = string;
        }
        this.HOLG_END("assignClassAlias");
    }

    public void assignSuperclassName(String string) {
        this.HOLG_START("assignSuperclassName");
        this.curClassEl.setSuperClass(string);
        this.HOLG_PRINT(string);
        this.HOLG_END("assignSuperclassName");
    }

    public void assignClassQualifiers() {
        this.HOLG_START("assignClassQualifiers");
        if (!this.erroneousUnit) {
            CIMValue cIMValue;
            int n = this.qualifiers.indexOf(new CIMQualifier("association"));
            CIMQualifier cIMQualifier = n >= 0 ? (CIMQualifier)this.qualifiers.elementAt(n) : null;
            if (cIMQualifier != null && (cIMValue = cIMQualifier.getValue()) != null && cIMValue.equals((Object)CIMValue.TRUE)) {
                this.curClassEl.setIsAssociation(true);
                this.curLevel = new String("ASSOCIATION");
            }
            if (!this.erroneousPart) {
                this.curClassEl.setQualifiers(this.qualifiers);
            }
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignClassQualifiers");
    }

    public void setFile(BufferedWriter bufferedWriter) {
        this.xmlOut = bufferedWriter;
    }

    public void setBigFile(BufferedWriter bufferedWriter) {
        this.bigxmlOut = bufferedWriter;
    }

    public void addClass() throws CIMException {
        block21: {
            this.HOLG_START("addClass");
            this.HOLG_START("addClass");
            this.curClassEl.setProperties(this.properties);
            this.curClassEl.setMethods(this.methods);
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curClassEl);
            if (this.parser.mode == 1 && this.deleteMode) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)NSDELETEMODE);
            }
            if (this.parsePhase == 2) {
                try {
                    CIMClass cIMClass;
                    LogFile.add(3, this.classDebug, this.curClassEl.getName());
                    if (this.parser.isVerbose()) {
                        System.out.println(I18N.loadStringFormat(this.classDebug, this.curClassEl.getName()));
                    }
                    if (this.deleteMode) {
                        this.clientAPI.deleteClass(new CIMObjectPath(this.curClassEl.getName()));
                    } else if (this.setClass) {
                        this.clientAPI.setClass(new CIMObjectPath(this.curClassEl.getName()), this.curClassEl);
                    } else {
                        this.clientAPI.createClass(new CIMObjectPath(this.curClassEl.getName()), this.curClassEl);
                    }
                    if (this.XML) {
                        cIMClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), false, true, true, null);
                        this.xmlwriter.writeClass(cIMClass);
                        if (this.BUILD) {
                            this.xmlwriter.writeAllClasses(cIMClass, this.xmlOut);
                            this.xmlwriter.writeBigXml(cIMClass, this.bigxmlOut);
                        }
                    }
                    if (this.BEAN) {
                        cIMClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), true, true, true, null);
                        BeanGenerator beanGenerator = new BeanGenerator(this.clientAPI, cIMClass, this.beanPackage, this.beanImports, this.beanExceptions, new File(this.beanDir));
                    }
                }
                catch (CIMException cIMException) {
                    if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setClass || cIMException.getID().equals("CIM_ERR_NOT_FOUND") && (this.setClass || this.deleteMode)) {
                        CIMClass cIMClass;
                        this.reportWarning("ERR_SEM", "ERR_EXC_SET_CLASS", this.parser.toStringCIMException(cIMException));
                        if (this.XML && cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setClass) {
                            try {
                                cIMClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), false, true, true, null);
                                this.xmlwriter.writeClass(cIMClass);
                                if (this.BUILD) {
                                    this.xmlwriter.writeAllClasses(cIMClass, this.xmlOut);
                                    this.xmlwriter.writeBigXml(cIMClass, this.bigxmlOut);
                                }
                            }
                            catch (CIMException cIMException2) {
                                // empty catch block
                            }
                        }
                        if (this.BEAN && cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                            cIMClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), true, true, true, null);
                            BeanGenerator beanGenerator = new BeanGenerator(this.clientAPI, cIMClass, this.beanPackage, this.beanImports, this.beanExceptions, new File(this.beanDir));
                        }
                        break block21;
                    }
                    this.reportError("ERR_SEM", "ERR_EXC_SET_CLASS", 1, this.parser.toStringCIMException(cIMException));
                }
                catch (Exception exception) {
                    this.reportError("ERR_EXC", "ERR_EXC_SET_CLASS", 1, exception.toString());
                }
            } else if (this.curClassAlias != null) {
                this.classAliases.put(this.curClassAlias, this.curClassEl.getName());
            }
        }
        this.keysRequired = 0;
        this.curClassEl = new CIMClass();
        this.curClassAlias = null;
        this.properties = new Vector();
        this.methods = new Vector();
        this.HOLG_END("addClass");
    }

    public void assignFeatureName(String string) throws CIMException {
        this.HOLG_START("assignFeatureName");
        if (this.properties.contains(new CIMProperty(string)) || this.methods.contains(new CIMMethod(string))) {
            this.erroneousPart = true;
            this.reportError("ERR_SEM", "ERR_FEATURE_REDEFINED", 1, this.curClassEl.getName());
        } else {
            this.curPropRefEl.setName(string);
            this.curMethodEl.setName(string);
            this.HOLG_PRINT(string);
        }
        this.HOLG_END("assignFeatureName");
    }

    public void assignPropertyQualifiers() {
        this.HOLG_START("assignPropertyQualifiers");
        if (!this.erroneousPart) {
            this.curPropRefEl.setQualifiers(this.qualifiers);
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignPropertyQualifiers");
    }

    public void addProperty() {
        this.HOLG_START("addProperty");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curPropRefEl);
            this.properties.addElement(this.curPropRefEl);
        } else {
            this.erroneousUnit = true;
        }
        this.curPropRefEl = new CIMProperty();
        this.HOLG_END("addProperty");
    }

    public void assignRefClassName(CIMDataType cIMDataType) {
        this.HOLG_START("assignRefClassName");
        this.curPropRefEl.setType(cIMDataType);
        this.HOLG_PRINT(cIMDataType.toString());
        this.HOLG_END("assignRefClassName");
    }

    public void assignReferenceQualifiers() throws CIMException {
        this.HOLG_START("assignReferenceQualifiers");
        if (!this.erroneousPart) {
            try {
                this.curPropRefEl.setQualifiers(this.qualifiers);
            }
            catch (Exception exception) {
                this.reportError("ERR_EXC", "ERR_EXC_SET_QUAL", 1, exception.toString());
            }
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignReferenceQualifiers");
    }

    public void addReference() {
        this.HOLG_START("addReference");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            --this.refsRequired;
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curPropRefEl);
            this.properties.addElement(this.curPropRefEl);
        }
        this.curPropRefEl = new CIMProperty();
        this.HOLG_END("addReference");
    }

    public void assignMethodQualifiers() {
        this.HOLG_START("assignMethodQualifiers");
        this.curMethodEl.setQualifiers(this.qualifiers);
        this.qualifiers = new Vector();
        this.HOLG_END("assignMethodQualifiers");
    }

    public void assignMethodParameters() {
        this.HOLG_START("assignMethodParameters");
        if (!this.erroneousPart) {
            this.curMethodEl.setParameters(this.parameters);
        }
        this.parameters = new Vector();
        this.HOLG_END("assignMethodParameters");
    }

    public void addMethod() {
        this.HOLG_START("addMethod");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            this.methods.addElement(this.curMethodEl);
            this.HOLG_PRINT(this.curMethodEl.getName());
        } else {
            this.erroneousUnit = true;
        }
        this.curMethodEl = new CIMMethod();
        this.HOLG_END("addMethod");
    }

    public void assignParameterName(String string) throws CIMException {
        this.HOLG_START("assignParameterName");
        if (this.parameters.contains(new CIMParameter(string))) {
            this.reportError("ERR_SEM", "ERR_PARAMETER_EXISTS", 2, string);
        } else {
            this.curParameterEl.setName(string);
            this.HOLG_PRINT(string);
        }
        this.HOLG_END("assignParameterName");
    }

    public void assignParameterQualifiers() {
        this.HOLG_START("assignParameterQualifiers");
        if (!this.erroneousPart) {
            this.curParameterEl.setQualifiers(this.qualifiers);
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignParameterQualifiers");
    }

    public void addParameter() {
        this.HOLG_START("addParameter");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            this.parameters.addElement(this.curParameterEl);
            this.HOLG_PRINT(this.curParameterEl.getName());
        } else {
            this.erroneousUnit = true;
        }
        this.curParameterEl = new CIMParameter();
        this.HOLG_END("addParameter");
    }

    public void assignInstanceClass(String string) {
        this.HOLG_START("assignInstanceClass");
        this.curInstanceEl.setClassName(string);
        this.HOLG_PRINT(string);
        this.HOLG_END("assignInstanceClass");
    }

    public void assignInstanceAlias(String string) {
        this.HOLG_START("assignInstanceAlias");
        if (this.parsePhase == 1) {
            this.curInstanceAlias = string;
        }
        this.HOLG_END("assignInstanceAlias");
    }

    public void assignInstanceQualifiers() {
        this.HOLG_START("assignInstanceQualifiers");
        if (!this.erroneousUnit) {
            this.curInstanceEl.setQualifiers(this.qualifiers);
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignInstanceQualifiers");
    }

    public void assignInstancePropertyQualifiers() {
        this.HOLG_START("addInstancePropertyQualifiers");
        this.HOLG_END("addInstancePropertyQualifiers");
    }

    public void addInstanceProperty() {
        this.HOLG_START("addInstanceProperty");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curIPropertyEl);
            this.properties.addElement(this.curIPropertyEl);
        } else {
            this.erroneousUnit = true;
        }
        this.curIPropertyEl = new CIMProperty();
        this.HOLG_END("addInstanceProperty");
    }

    public void addInstance() throws CIMException {
        this.HOLG_START("addInstance");
        if (this.erroneousPart) {
            this.erroneousUnit = true;
        }
        if (!this.erroneousUnit) {
            block12: {
                this.curInstanceEl.setProperties(this.properties);
                if (this.parsePhase == 2) {
                    try {
                        LogFile.add(3, this.instanceDebug, this.curInstanceEl.getName());
                        if (this.parser.isVerbose()) {
                            System.out.println(I18N.loadStringFormat(this.instanceDebug, this.curInstanceEl.getName()));
                        }
                        if (this.deleteMode) {
                            CIMObjectPath cIMObjectPath = new CIMObjectPath();
                            cIMObjectPath.setObjectName(this.curInstanceEl.getClassName());
                            cIMObjectPath.setKeys(this.curInstanceEl.getProperties());
                            this.clientAPI.deleteInstance(cIMObjectPath);
                            break block12;
                        }
                        if (this.setInstance) {
                            this.clientAPI.setInstance(new CIMObjectPath(this.curInstanceEl.getClassName()), this.curInstanceEl);
                            break block12;
                        }
                        this.clientAPI.createInstance(new CIMObjectPath(this.curInstanceEl.getClassName()), this.curInstanceEl);
                    }
                    catch (CIMException cIMException) {
                        if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setInstance || cIMException.getID().equals("CIM_ERR_NOT_FOUND") && (this.setInstance || this.deleteMode)) {
                            this.reportWarning("ERR_SEM", "ERR_EXC_SET_INST", this.parser.toStringCIMException(cIMException));
                            break block12;
                        }
                        this.reportError("ERR_SEM", "ERR_EXC_SET_INST", 1, this.parser.toStringCIMException(cIMException));
                    }
                    catch (Exception exception) {
                        this.reportError("ERR_EXC", "ERR_EXC_SET_INST", 1, exception.toString());
                    }
                } else if (this.curInstanceAlias != null) {
                    this.instanceAliases.put(this.curInstanceAlias, this.curInstanceEl);
                    this.instanceAliasesNS.put(this.curInstanceAlias, this.curNameSpace);
                }
            }
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curInstanceEl);
        }
        this.curInstanceEl = new CIMInstance();
        this.curInstanceAlias = null;
        this.properties = new Vector();
        this.HOLG_END("addInstance");
    }

    public CIMObjectPath getInstanceName(String string) throws CIMException {
        if (this.parsePhase == 1) {
            return new CIMObjectPath();
        }
        Object var2_2 = null;
        CIMInstance cIMInstance = null;
        var2_2 = this.instanceAliases.get(string);
        if (var2_2 == null) {
            this.reportError("ERR_SEM", "NO_SUCH_ALIAS", 1, string);
        }
        if (var2_2 instanceof CIMObjectPath) {
            return var2_2;
        }
        cIMInstance = var2_2;
        CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName());
        CIMInstance cIMInstance2 = null;
        try {
            CIMClass cIMClass = this.clientAPI.getClass(cIMObjectPath, false, true, true, null);
            cIMInstance2 = cIMClass.newInstance();
        }
        catch (Exception exception) {
            this.reportError("ERR_SEM", "ERR_NO_SUCH_CLASS", 1, cIMInstance.getClassName());
        }
        cIMInstance2.updatePropertyValues(cIMInstance.getProperties());
        cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), "");
        cIMObjectPath.setKeys(cIMInstance2.getKeyValuePairs());
        cIMObjectPath.setNameSpace(((CIMNameSpace)this.instanceAliasesNS.get(string)).getNameSpace());
        this.instanceAliases.put(string, cIMObjectPath);
        return cIMObjectPath;
    }
}

