/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.wbem.cim.MOFFormatter;

public class CIMDateTime
implements Serializable {
    static final long serialVersionUID = 200L;
    private boolean isInterval = false;
    private String dateString = null;

    public CIMDateTime() {
        this(new Date());
    }

    public CIMDateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.dateString = this.getCalendarString(calendar);
    }

    public CIMDateTime(Calendar calendar) {
        this.dateString = this.getCalendarString(calendar);
    }

    public CIMDateTime(String string) throws IllegalArgumentException {
        boolean bl = true;
        if (string.length() != 25 || string.charAt(14) != '.') {
            bl = false;
        } else if (string.charAt(21) == ':') {
            this.isInterval = true;
            int n = Integer.valueOf(string.substring(0, 8));
            n = Integer.valueOf(string.substring(8, 10));
            bl = bl && n >= 0 && n <= 24;
            n = Integer.valueOf(string.substring(10, 12));
            bl = bl && n >= 0 && n <= 60;
            n = Integer.valueOf(string.substring(12, 14));
            bl = bl && n >= 0 && n <= 60;
            n = Integer.valueOf(string.substring(15, 21));
            bl = bl && n >= 0 && n <= 999999;
            this.dateString = string.substring(0, 22);
            this.dateString.concat("000");
        } else {
            this.dateString = string;
            Calendar calendar = this.getCalendar();
        }
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public Calendar getCalendar() throws IllegalArgumentException {
        Calendar calendar = null;
        if (this.dateString.charAt(21) != '+' && this.dateString.charAt(21) != '-') {
            throw new IllegalArgumentException(this.dateString);
        }
        try {
            int n = Integer.parseInt(this.dateString.substring(15, 21));
            calendar = Calendar.getInstance();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            simpleDateFormat.setLenient(false);
            Date date = simpleDateFormat.parse(this.dateString.substring(0, 18));
            calendar.setTime(date);
            Integer n2 = Integer.valueOf(this.dateString.substring(22));
            if (this.dateString.charAt(21) == '-') {
                n2 = new Integer(n2 * -1);
            }
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            timeZone.setRawOffset(n2 * 60 * 1000);
            calendar.setTimeZone(timeZone);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(this.dateString + " " + exception);
        }
        return calendar;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public boolean after(CIMDateTime cIMDateTime) throws IllegalArgumentException {
        if (this.isInterval() && !cIMDateTime.isInterval() || !this.isInterval() && cIMDateTime.isInterval()) {
            throw new IllegalArgumentException(cIMDateTime.toString());
        }
        if (this.isInterval()) {
            return this.toString().compareTo(cIMDateTime.toString()) > 0;
        }
        Calendar calendar = this.getCalendar();
        return calendar.after(cIMDateTime.getCalendar());
    }

    public boolean before(CIMDateTime cIMDateTime) throws IllegalArgumentException {
        if (this.isInterval() && !cIMDateTime.isInterval() || !this.isInterval() && cIMDateTime.isInterval()) {
            throw new IllegalArgumentException(cIMDateTime.toString());
        }
        if (this.isInterval()) {
            return this.toString().compareTo(cIMDateTime.toString()) < 0;
        }
        Calendar calendar = this.getCalendar();
        return calendar.before(cIMDateTime.getCalendar());
    }

    public boolean equals(Object object) throws IllegalArgumentException {
        CIMDateTime cIMDateTime = (CIMDateTime)object;
        if (this.isInterval() && !cIMDateTime.isInterval() || !this.isInterval() && cIMDateTime.isInterval()) {
            throw new IllegalArgumentException(cIMDateTime.toString());
        }
        return this.dateString.equals(cIMDateTime.getDateTimeString());
    }

    protected String getDateTimeString() {
        return this.dateString;
    }

    private String getCalendarString(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.padLeadingZeros(calendar.get(1), 4));
        stringBuffer.append(this.padLeadingZeros(calendar.get(2) + 1, 2));
        stringBuffer.append(this.padLeadingZeros(calendar.get(5), 2));
        stringBuffer.append(this.padLeadingZeros(calendar.get(11), 2));
        stringBuffer.append(this.padLeadingZeros(calendar.get(12), 2));
        stringBuffer.append(this.padLeadingZeros(calendar.get(13), 2));
        stringBuffer.append(".");
        stringBuffer.append(this.padTrailingZeros(calendar.get(14), 6));
        int n = calendar.get(15);
        if (n < 0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.padLeadingZeros(Math.abs(n / 60000), 3));
        return stringBuffer.toString();
    }

    private String padLeadingZeros(int n, int n2) {
        return this.padLeadingZeros(String.valueOf(n), n2);
    }

    private String padLeadingZeros(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.length();
        while (n2 < n) {
            stringBuffer.insert(0, 0);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String padTrailingZeros(int n, int n2) {
        return this.padTrailingZeros(String.valueOf(n), n2);
    }

    private String padTrailingZeros(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.length();
        while (n2 < n) {
            stringBuffer.append(0);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

