/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.project.ProjCommon;
import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.solarisprovider.project.SolarisProjectTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;

public class Solaris_ProjectGroup
implements Authorizable,
MethodProvider,
InstanceProvider,
AssociatorProvider {
    private static final String PROJECT_NAME = "ProjectName";
    private static final String PROJECT_ID = "ProjectID";
    private static final String PROJECT_DESCRIPTION = "Description";
    private static final String PROJECT_USERS = "Users";
    private static final String PROJECT_GROUPS = "Groups";
    private static final String PROJECT_ATTRIBUTES = "ProjectAttributes";
    private static final String PROJECT_USER_CLASS = "Solaris_ProjectGroup";
    private static final String SYSTEM_CCN = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String NAME_SPACE = "root/cimv2";
    private static final String PROJECT_CLASS = "Solaris_Project";
    private static final String USER_GROUP_CLASS = "Solaris_UserGroup";
    private static final String GROUP_NAME = "GroupName";
    private static final String PROJECT_REF = "Project";
    private static final String GROUP_REF = "Group";
    public static final String PROJECT_WRITE_RIGHT = "solaris.project.write";
    public static final String PROJECT_READ_RIGHT = "solaris.project.read";
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    public static final String PROVIDERNAME = "Project Group Provider";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, PROVIDERNAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMProperty cIMProperty;
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        Object var7_7 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string = this.provUtil.getMgmtScope(cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            if (cIMProperty.getName().equalsIgnoreCase(PROJECT_REF)) {
                cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
            }
            if (cIMProperty.getName().equalsIgnoreCase(GROUP_REF)) {
                cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
            }
            if (cIMProperty.getName().equalsIgnoreCase(SYSTEM_CCN)) {
                if (cIMProperty.getValue() != null) {
                    string2 = (String)cIMProperty.getValue().getValue();
                } else {
                    string4 = this.provUtil.writeLog(1, "LM_12006", "LM_12041", null, null, null, null);
                    throw new CIMException("GENERAL_EXCEPTION", (Object)string4);
                }
            }
            if (!cIMProperty.getName().equalsIgnoreCase(SYSTEM_NAME)) continue;
            if (cIMProperty.getValue() != null) {
                string3 = (String)cIMProperty.getValue().getValue();
                continue;
            }
            string4 = this.provUtil.writeLog(1, "LM_12006", "LM_12041", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)string4);
        }
        if (cIMObjectPath2 == null || cIMObjectPath3 == null) {
            string4 = this.provUtil.writeLog(1, "LM_12006", "LM_12016", null, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)string4);
        }
        cIMProperty = cIMClass.newInstance();
        cIMProperty.setProperty(PROJECT_REF, new CIMValue(cIMObjectPath2));
        cIMProperty.setProperty(GROUP_REF, new CIMValue((Object)cIMObjectPath3));
        cIMProperty.setProperty(SYSTEM_CCN, new CIMValue(string2));
        cIMProperty.setProperty(SYSTEM_NAME, new CIMValue((Object)string3));
        if (bl) {
            cIMProperty = cIMProperty.localElements();
        }
        return cIMProperty.filterProperties(stringArray, bl2, bl3);
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance cIMInstance;
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        String string = null;
        string = this.provUtil.getMgmtScope(cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = this.buildCOP(PROJECT_CLASS, cIMObjectPath);
        CIMObjectPath cIMObjectPath3 = new CIMObjectPath(USER_GROUP_CLASS);
        CIMObjectPath cIMObjectPath4 = null;
        try {
            cIMObjectPath2.setNameSpace(NAME_SPACE);
            cIMObjectPath3.setNameSpace(NAME_SPACE);
            Enumeration enumeration = this.cimomhandle.enumerateInstanceNames(cIMObjectPath2);
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                Enumeration enumeration2 = this.cimomhandle.enumerateInstanceNames(cIMObjectPath3);
                while (enumeration2.hasMoreElements()) {
                    cIMObjectPath4 = (CIMObjectPath)enumeration2.nextElement();
                    if (!this.projectContainsGroup(cIMObjectPath2, cIMObjectPath4, string)) continue;
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty(PROJECT_REF, new CIMValue((Object)cIMObjectPath2));
                    cIMInstance.setProperty(GROUP_REF, new CIMValue((Object)cIMObjectPath4));
                    cIMInstance.setProperty(SYSTEM_CCN, new CIMValue((Object)this.provUtil.getScopeClassType(string)));
                    cIMInstance.setProperty(SYSTEM_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(string)));
                    if (bl) {
                        cIMInstance = cIMInstance.localElements();
                    }
                    vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
                }
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        cIMInstance = new CIMInstance[vector.size()];
        vector.toArray((T[])cIMInstance);
        return cIMInstance;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        this.provUtil.checkRights(PROJECT_READ_RIGHT, cIMObjectPath);
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        String string = null;
        string = this.provUtil.getMgmtScope(cIMObjectPath);
        CIMObjectPath cIMObjectPath3 = this.buildCOP(PROJECT_CLASS, cIMObjectPath);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath(USER_GROUP_CLASS);
        CIMObjectPath cIMObjectPath5 = null;
        try {
            cIMObjectPath3.setNameSpace(NAME_SPACE);
            Enumeration enumeration = this.cimomhandle.enumerateInstanceNames(cIMObjectPath3);
            while (enumeration.hasMoreElements()) {
                cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                cIMObjectPath4.setNameSpace(NAME_SPACE);
                Enumeration enumeration2 = this.cimomhandle.enumerateInstanceNames(cIMObjectPath4);
                while (enumeration2.hasMoreElements()) {
                    cIMObjectPath5 = (CIMObjectPath)enumeration2.nextElement();
                    if (!this.projectContainsGroup(cIMObjectPath3, cIMObjectPath5, string)) continue;
                    cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                    cIMObjectPath2.addKey(PROJECT_REF, new CIMValue((Object)cIMObjectPath3));
                    cIMObjectPath2.addKey(GROUP_REF, new CIMValue((Object)cIMObjectPath5));
                    cIMObjectPath2.addKey(SYSTEM_CCN, new CIMValue((Object)this.provUtil.getScopeClassType(string)));
                    cIMObjectPath2.addKey(SYSTEM_NAME, new CIMValue((Object)this.provUtil.getScopeDomainName(string)));
                    vector.addElement(cIMObjectPath2);
                }
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
        }
        cIMObjectPath2 = new CIMObjectPath[vector.size()];
        vector.toArray((T[])cIMObjectPath2);
        return cIMObjectPath2;
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        SolarisProjectTable solarisProjectTable = null;
        String string = null;
        ProjectObj projectObj = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, cIMObjectPath);
        try {
            string = this.provUtil.getMgmtScope(cIMObjectPath);
            solarisProjectTable = new SolarisProjectTable(string);
            projectObj = this.getExistingProject(cIMObjectPath, solarisProjectTable);
            if (projectObj != null) {
                String string2 = this.getGroupName(cIMObjectPath);
                solarisProjectTable.modifyProjectRow(this.concatGroup(string2, projectObj));
                this.provUtil.writeLog(0, "LM_12049", "LM_12032", string2, projectObj.getProjectName(), null, null);
            }
        }
        catch (DirectoryTableRowSizeException directoryTableRowSizeException) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", projectObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableRowSizeException.getMessage());
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cIMException.getMessage());
        }
        return cIMObjectPath;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        SolarisProjectTable solarisProjectTable = null;
        String string = null;
        ProjectObj projectObj = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, cIMObjectPath);
        try {
            string = this.provUtil.getMgmtScope(cIMObjectPath);
            solarisProjectTable = new SolarisProjectTable(string);
            projectObj = this.getExistingProject(cIMObjectPath, solarisProjectTable);
            if (projectObj != null) {
                String string2 = this.getGroupName(cIMObjectPath);
                solarisProjectTable.modifyProjectRow(this.concatGroup(string2, projectObj));
                this.provUtil.writeLog(0, "LM_12034", "LM_12032", string2, projectObj.getProjectName(), null, null);
            }
        }
        catch (DirectoryTableRowSizeException directoryTableRowSizeException) {
            this.provUtil.writeLog(2, "LM_12052", "LM_12053", projectObj.getProjectName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableRowSizeException.getMessage());
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cIMException.getMessage());
        }
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        SolarisProjectTable solarisProjectTable = null;
        String string = null;
        this.provUtil.checkRights(PROJECT_WRITE_RIGHT, cIMObjectPath);
        try {
            string = this.provUtil.getMgmtScope(cIMObjectPath);
            solarisProjectTable = new SolarisProjectTable(string);
            ProjectObj projectObj = this.getExistingProject(cIMObjectPath, solarisProjectTable);
            if (projectObj != null) {
                String string2 = this.getGroupName(cIMObjectPath);
                solarisProjectTable.modifyProjectRow(this.delGroup(string2, projectObj));
                this.provUtil.writeLog(0, "LM_12051", "LM_12036", string2, projectObj.getProjectName(), null, null);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cIMException.getMessage());
        }
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector myExecQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        if (cIMObjectPath2.getObjectName().equalsIgnoreCase(USER_GROUP_CLASS)) {
            if (string2 != null && !string2.equalsIgnoreCase(GROUP_REF)) {
                return vector;
            }
            String string4 = this.provUtil.getMgmtScope(cIMObjectPath2);
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(PROJECT_CLASS);
            cIMObjectPath3.setNameSpace(cIMObjectPath.getNameSpace());
            CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath3, false, bl, bl2, stringArray);
            try {
                Enumeration enumeration = this.cimomhandle.enumerateInstanceNames(cIMObjectPath3);
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                    if (!this.projectContainsGroup(cIMObjectPath3, cIMObjectPath2, string4)) continue;
                    CIMInstance cIMInstance = this.cimomhandle.getInstance(cIMObjectPath3, false, bl, bl2, stringArray);
                    vector.addElement(cIMInstance);
                }
            }
            catch (Exception exception) {
                this.provUtil.writeLog(2, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
            }
        } else {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        return vector;
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        Vector<CIMObjectPath> vector;
        CIMObjectPath[] cIMObjectPathArray;
        if (cIMObjectPath2.getObjectName().equalsIgnoreCase(USER_GROUP_CLASS)) {
            if (string2 != null && !string2.equalsIgnoreCase(GROUP_REF)) {
                return new CIMObjectPath[0];
            }
            cIMObjectPathArray = this.provUtil.getMgmtScope(cIMObjectPath2);
            vector = new Vector<CIMObjectPath>();
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(PROJECT_CLASS);
            cIMObjectPath3.setNameSpace(cIMObjectPath.getNameSpace());
            try {
                Enumeration enumeration = this.cimomhandle.enumerateInstanceNames(cIMObjectPath3);
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                    if (!this.projectContainsGroup(cIMObjectPath3, cIMObjectPath2, (String)cIMObjectPathArray)) continue;
                    vector.addElement(cIMObjectPath3);
                }
            }
            catch (Exception exception) {
                this.provUtil.writeLog(2, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.getMessage());
            }
        } else {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath2);
        }
        cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private boolean projectContainsGroup(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        try {
            CIMProperty cIMProperty;
            ProjectObj projectObj = ProjCommon.opToProject(cIMObjectPath, string);
            SolarisProjectTable solarisProjectTable = new SolarisProjectTable(string);
            ProjectObj projectObj2 = solarisProjectTable.getProjectRow(projectObj);
            String string2 = null;
            Enumeration enumeration = cIMObjectPath2.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase(GROUP_NAME) || cIMProperty.getValue() == null) continue;
                string2 = (String)cIMProperty.getValue().getValue();
            }
            cIMProperty = projectObj2.getProjectGroups();
            if (cIMProperty == null || string2 == null) {
                return false;
            }
            int n = 0;
            while (n < ((CIMProperty)cIMProperty).length) {
                if (cIMProperty[n].equalsIgnoreCase(string2)) {
                    return true;
                }
                ++n;
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        return false;
    }

    private CIMObjectPath buildCOP(String string, CIMObjectPath cIMObjectPath) {
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string);
        Vector vector = null;
        if (cIMObjectPath != null) {
            vector = cIMObjectPath.getKeys();
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                CIMValue cIMValue;
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
                if (cIMProperty.getName().equalsIgnoreCase(SYSTEM_NAME) && (cIMValue = cIMProperty.getValue()) != null) {
                    cIMObjectPath2.addKey(SYSTEM_NAME, cIMValue);
                }
                if (cIMProperty.getName().equalsIgnoreCase(SYSTEM_CCN) && (cIMValue = cIMProperty.getValue()) != null) {
                    cIMObjectPath2.addKey(SYSTEM_CCN, cIMValue);
                }
                ++n;
            }
        }
        return cIMObjectPath2;
    }

    private ProjectObj getExistingProject(CIMObjectPath cIMObjectPath, SolarisProjectTable solarisProjectTable) throws CIMException {
        Object object;
        ProjectObj projectObj = new ProjectObj();
        CIMObjectPath cIMObjectPath2 = null;
        String string = null;
        String string2 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(PROJECT_REF) || object.getValue() == null) continue;
            cIMObjectPath2 = (CIMObjectPath)object.getValue().getValue();
        }
        cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
        object = cIMObjectPath2.getKeys().elements();
        while (object.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)object.nextElement();
            if (cIMProperty.getName().equalsIgnoreCase(PROJECT_NAME) && cIMProperty.getValue() != null) {
                string = (String)cIMProperty.getValue().getValue();
            }
            if (!cIMProperty.getName().equalsIgnoreCase(PROJECT_ID) || cIMProperty.getValue() == null) continue;
            string2 = (String)cIMProperty.getValue().getValue();
        }
        projectObj.setProjectName(string);
        projectObj.setProjectID(string2);
        try {
            projectObj = solarisProjectTable.getProjectRow(projectObj);
        }
        catch (DirectoryTableException directoryTableException) {
            this.provUtil.writeLog(2, (Exception)((Object)directoryTableException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)directoryTableException.getMessage());
        }
        catch (ProjectException projectException) {
            this.provUtil.writeLog(2, (Exception)((Object)projectException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)projectException.getMessage());
        }
        return projectObj;
    }

    private String getGroupName(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty;
        CIMObjectPath cIMObjectPath2 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(GROUP_REF) || cIMProperty.getValue() == null) continue;
            cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
        }
        cIMProperty = cIMObjectPath2.getKeys().elements();
        while (cIMProperty.hasMoreElements()) {
            CIMProperty cIMProperty2 = (CIMProperty)cIMProperty.nextElement();
            if (!cIMProperty2.getName().equalsIgnoreCase(GROUP_NAME) || cIMProperty2.getValue() == null) continue;
            String string = (String)cIMProperty2.getValue().getValue();
            return string;
        }
        return null;
    }

    private ProjectObj concatGroup(String string, ProjectObj projectObj) throws CIMException {
        try {
            Vector vector = ProjCommon.buildVector(projectObj.getProjectGroups());
            if (vector == null) {
                String[] stringArray = new String[]{string};
                projectObj.setProjectGroups(stringArray);
                return projectObj;
            }
            if (string == null || vector.contains(string)) {
                return projectObj;
            }
            vector.addElement(string);
            vector.trimToSize();
            String[] stringArray = new String[vector.size()];
            int n = 0;
            Object var6_9 = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
            projectObj.setProjectGroups(stringArray);
        }
        catch (Exception exception) {
            String string2 = this.provUtil.writeLog(1, "LM_12007", "LM_12017", string, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)string2);
        }
        return projectObj;
    }

    private ProjectObj delGroup(String string, ProjectObj projectObj) throws CIMException {
        try {
            Vector vector = ProjCommon.buildVector(projectObj.getProjectGroups());
            if (vector == null || string == null) {
                return projectObj;
            }
            if (vector.contains(string)) {
                vector.removeElement(string);
                vector.trimToSize();
                String[] stringArray = new String[vector.size()];
                int n = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    stringArray[n] = (String)enumeration.nextElement();
                    ++n;
                }
                projectObj.setProjectGroups(stringArray);
            }
        }
        catch (Exception exception) {
            String string2 = this.provUtil.writeLog(1, "LM_12005", "LM_12015", string, null, null, null);
            throw new CIMException("GENERAL_EXCEPTION", (Object)string2);
        }
        return projectObj;
    }
}

