/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.patchmgr.client.PatchAddWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class PatchReviewCard
extends VWizardCard {
    public static final int HELP_CACHE_SIZE = 4;
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private ActionString actionString;
    private SelectableLabel srcField;
    private SelectableLabel backoutField;
    private JList reviewList;
    private JLabel srcLbl = new JLabel();
    private JLabel patchLbl = new JLabel();
    private JLabel backoutLbl = new JLabel();
    private PatchAddWizard wiz;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private Color defaultColor;
    public static final int VISIBLE_ROWS = 5;

    public PatchReviewCard(VPatchMgr vPatchMgr, PatchAddWizard patchAddWizard) {
        this.theApp = vPatchMgr;
        this.wiz = patchAddWizard;
        this.bundle = vPatchMgr.getResourceBundle();
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"patch_add_step5_title"));
        this.constructStep();
    }

    private void constructStep() {
        this.defaultColor = this.getBackground();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.initLabel(this.srcLbl, "src_lbl");
        this.srcField = new SelectableLabel("", 25);
        this.srcLbl.setLabelFor((Component)this.srcField);
        this.initLabel(this.patchLbl, "patch_lbl");
        this.reviewList = new JList();
        this.reviewList.setVisibleRowCount(5);
        this.reviewList.setBackground(this.defaultColor);
        this.reviewList.setSelectionBackground(this.defaultColor);
        this.reviewList.clearSelection();
        String string = "";
        int n = 0;
        while (n < 25) {
            string = string + "A";
            ++n;
        }
        this.reviewList.setPrototypeCellValue(string);
        this.patchLbl.setLabelFor(this.reviewList);
        JScrollPane jScrollPane = new JScrollPane(this.reviewList);
        jScrollPane.getViewport().add(this.reviewList, null, -1);
        double d = 5 * this.reviewList.getFixedCellHeight();
        double d2 = jScrollPane.getPreferredSize().getHeight() - jScrollPane.getViewport().getPreferredSize().getHeight();
        d += d2;
        d2 = jScrollPane.getVerticalScrollBar().getPreferredSize().getWidth();
        double d3 = (double)this.reviewList.getFixedCellWidth() + d2;
        jScrollPane.setPreferredSize(new Dimension((int)d3, (int)d));
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        this.initLabel(this.backoutLbl, "backout_lbl");
        this.backoutField = new SelectableLabel("", 25);
        this.backoutLbl.setLabelFor((Component)this.backoutField);
        int n2 = 0;
        Constraints.constrain((Container)((Object)this), (Component)this.srcLbl, (int)0, (int)n2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.srcField, (int)1, (int)n2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.patchLbl, (int)0, (int)(++n2), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)jScrollPane, (int)1, (int)n2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.backoutLbl, (int)0, (int)(++n2), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)this.backoutField, (int)1, (int)n2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0, (int)5, (int)12, (int)0, (int)0);
    }

    private void initLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    protected void updateStatus() {
        this.setProperty("vwp.canmoveforward", "vwp.true");
    }

    public void loadHelp() {
        Vector vector = new Vector(4);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s4_overview");
        PatchContextHelpListener patchContextHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s4_source");
        this.srcField.addFocusListener((FocusListener)((Object)patchContextHelpListener));
        PatchContextHelpListener patchContextHelpListener2 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s4_patches");
        this.reviewList.addFocusListener((FocusListener)((Object)patchContextHelpListener2));
        PatchContextHelpListener patchContextHelpListener3 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s4_backout");
        this.backoutField.addFocusListener((FocusListener)((Object)patchContextHelpListener3));
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        String string;
        super.start();
        this.updateStatus();
        if (this.wiz.getWPatchDir().length() > 0) {
            this.srcField.setText(this.wiz.getWPatchDir());
        } else {
            string = this.wiz.getWNetserverName() + ":" + this.wiz.getWSharedDir();
            this.srcField.setText(string);
        }
        string = this.wiz.getWBackoutDir();
        if (string.equals("")) {
            this.backoutField.setText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"cmn_default"));
        } else {
            this.backoutField.setText(string);
        }
        Vector vector = this.wiz.getWPatchList();
        this.reviewList.setListData(vector);
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.true");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            this.setProperty("vwp.finishstate", "vwp.true");
        } else {
            this.wiz.doMultiFinish();
        }
        return true;
    }

    public void reset() {
    }

    public boolean isSubStep() {
        return false;
    }
}

