/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.CommonLocCard;
import com.sun.admin.patchmgr.client.PatchAddWizard;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import java.awt.Cursor;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class PatchLocCard
extends CommonLocCard {
    private PatchAddWizard wiz;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    private String currNetDir = null;
    public static final int HELP_CACHE_SIZE = 4;

    public PatchLocCard(VPatchMgr vPatchMgr, PatchAddWizard patchAddWizard) {
        super(vPatchMgr, patchAddWizard);
        this.theApp = vPatchMgr;
        this.wiz = patchAddWizard;
        this.bundle = vPatchMgr.getResourceBundle();
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"patch_add_step1_title"));
    }

    protected void updateStatus() {
        if (this.localBtn.isSelected() && this.dirTextf.getText() != null && this.dirTextf.getText().length() > 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else if (this.netservBtn.isSelected() && this.svrTextf.getText() != null && this.svrTextf.getText().length() > 0 && this.dir1Textf.getText() != null && this.dir1Textf.getText().length() > 0) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        }
    }

    public void loadHelp() {
        Vector vector = new Vector(4);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s1_overview");
        PatchContextHelpListener patchContextHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s1_radio");
        this.localBtn.addFocusListener((FocusListener)((Object)patchContextHelpListener));
        this.netservBtn.addFocusListener((FocusListener)((Object)patchContextHelpListener));
        PatchContextHelpListener patchContextHelpListener2 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s1_directory");
        this.dirTextf.addFocusListener((FocusListener)((Object)patchContextHelpListener2));
        PatchContextHelpListener patchContextHelpListener3 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s1_server_name");
        this.svrTextf.addFocusListener((FocusListener)((Object)patchContextHelpListener3));
        PatchContextHelpListener patchContextHelpListener4 = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, "add_wiz_s1_sharedir");
        this.dir1Textf.addFocusListener((FocusListener)((Object)patchContextHelpListener4));
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        this.updateStatus();
        if (this.localBtn.isSelected()) {
            this.localBtn.requestFocus();
            String string = this.wiz.getWPatchDir();
            if (string == null || string.length() == 0) {
                this.setProperty("vwp.canmoveforward", "vwp.false");
            } else {
                this.setProperty("vwp.canmoveforward", "vwp.true");
            }
        } else if (this.netservBtn.isSelected()) {
            this.netservBtn.requestFocus();
            String string = this.wiz.getWNetserverName();
            String string2 = this.wiz.getWSharedDir();
            if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
                this.setProperty("vwp.canmoveforward", "vwp.false");
            } else {
                this.setProperty("vwp.canmoveforward", "vwp.true");
            }
        }
        this.setProperty("vwp.canmovebackward", "vwp.false");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stop(boolean bl) {
        this.wiz.setCursor(Cursor.getPredefinedCursor(3));
        String string = "";
        if (this.localBtn.isSelected()) {
            Vector vector;
            string = this.dirTextf.getText();
            try {
                vector = this.theApp.getpatchM().getPatchIdsFromSpool(string);
            }
            catch (Exception exception) {
                this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                this.theApp.reportErrorException(exception);
                return false;
            }
            if (vector == null) {
                this.wiz.setAvailablePatches(null);
                String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_bad_dir_name");
                Object[] objectArray = new Object[]{string};
                this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                new ErrorDialog(null, MessageFormat.format(string2, objectArray));
                return false;
            }
            if (vector.size() != 0) {
                this.wiz.setWPatchDir(string);
                this.wiz.setWNetserverName("");
                this.wiz.setWSharedDir("");
                this.wiz.setAvailablePatches(vector);
            }
        } else if (this.netservBtn.isSelected()) {
            String string3 = "";
            string3 = this.svrTextf.getText();
            if (string3 == null || string3.length() == 0) {
                String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_missing_srvr_name");
                this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                new ErrorDialog(this.theApp.getFrame(), string4);
                this.svrTextf.setText("");
                return false;
            }
            this.wiz.setWNetserverName(string3);
            String string5 = "";
            string5 = this.dir1Textf.getText();
            if (string5 == null || string5.length() == 0) {
                String string6 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_missing_srvr_dir");
                this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                new ErrorDialog(null, string6);
                this.dir1Textf.setText("");
                return false;
            }
            this.wiz.setWSharedDir(string5);
            this.wiz.setWPatchDir("");
            String string7 = string3 + ":" + string5;
            if (this.currNetDir == null || !this.currNetDir.equals(string7)) {
                this.wiz.setAvailablePatches(null);
                try {
                    if (this.currNetDir != null) {
                        this.theApp.getpatchM().unmountPatchServer(this.currNetDir);
                    }
                    this.currNetDir = string7;
                    this.theApp.getpatchM().mountPatchServer(string7);
                    this.wiz.setWMountedResource(string7);
                }
                catch (AdminException adminException) {
                    this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                    this.currNetDir = null;
                    this.wiz.setWMountedResource(null);
                    return false;
                }
                try {
                    Vector vector = this.theApp.getpatchM().getPatchIdsFromSpool(null);
                    this.wiz.setAvailablePatches(vector);
                }
                catch (AdminException adminException) {
                    this.wiz.setCursor(Cursor.getPredefinedCursor(0));
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                    this.wiz.setAvailablePatches(null);
                    return false;
                }
            }
        }
        this.wiz.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public void reset() {
        if (!this.wiz.getFinishState() && this.currNetDir != null) {
            try {
                this.theApp.getpatchM().unmountPatchServer(this.currNetDir);
                this.currNetDir = null;
            }
            catch (AdminException adminException) {
                return;
            }
        }
        this.theApp.getToolBar().enableDelete();
        this.theApp.getMenuBar().enableDelete();
        this.theApp.getMenuBar().enableMultiSysAdd();
        this.theApp.getMenuBar().enableAnalyzeAdd();
        this.theApp.getMenuBar().enableDownload();
    }

    public boolean isSubStep() {
        return false;
    }
}

