/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.client.Debug;

class UnregHandler {
    OutputStream out;
    List opList = new ArrayList();

    UnregHandler(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void createNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
    }

    public void createQualifierType(CIMObjectPath cIMObjectPath, CIMQualifierType cIMQualifierType) throws CIMException {
    }

    public void setClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass, CIMClass cIMClass2) throws CIMException {
        this.opList.add(0, new SetClassOp(cIMObjectPath, cIMClass));
        Debug.trace3((String)"Added SetClassOp to list");
    }

    public void createClass(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        this.opList.add(0, new CreateClassOp(cIMObjectPath, cIMClass));
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, CIMInstance cIMInstance2) throws CIMException {
        this.opList.add(0, new SetInstanceOp(cIMObjectPath, cIMInstance));
    }

    public void createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.opList.add(0, new CreateInstanceOp(cIMObjectPath, cIMInstance));
        Debug.trace3((String)"Added CreateInstanceOp to list");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.opList.add(0, new DeleteInstanceOp(cIMObjectPath, cIMInstance));
        Debug.trace3((String)"Added DeleteInstanceOp to list");
    }

    public void outputUnreg() {
        Iterator iterator = this.opList.iterator();
        UndoOperation undoOperation = null;
        PrintStream printStream = new PrintStream(this.out);
        while (iterator.hasNext()) {
            UndoOperation undoOperation2 = (UndoOperation)iterator.next();
            String string = undoOperation2.undo(undoOperation);
            printStream.print(string);
            undoOperation = undoOperation2;
        }
    }

    private static class SetInstanceOp
    extends UndoOperation {
        CIMInstance oldci;

        public String undo(UndoOperation undoOperation) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getDirectives(undoOperation));
            stringBuffer.append("\n" + this.oldci);
            return stringBuffer.toString();
        }

        public SetInstanceOp(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
            super(cIMObjectPath, 2);
            Debug.trace3((String)"Set instance op created");
            this.oldci = cIMInstance;
        }
    }

    private static class DeleteInstanceOp
    extends UndoOperation {
        CIMInstance ci;

        public String undo(UndoOperation undoOperation) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getDirectives(undoOperation));
            stringBuffer.append("\n" + this.ci);
            return stringBuffer.toString();
        }

        public DeleteInstanceOp(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
            super(cIMObjectPath, 3);
            Debug.trace3((String)"Delete instance op created");
            this.ci = cIMInstance;
        }
    }

    private static class CreateInstanceOp
    extends UndoOperation {
        CIMInstance ci;

        public String undo(UndoOperation undoOperation) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getDirectives(undoOperation));
            stringBuffer.append("\n" + this.ci);
            return stringBuffer.toString();
        }

        public CreateInstanceOp(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
            super(cIMObjectPath, 1);
            Debug.trace3((String)"Create instance op created");
            this.ci = cIMInstance;
        }
    }

    private static class CreateClassOp
    extends UndoOperation {
        String cName;

        public String undo(UndoOperation undoOperation) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getDirectives(undoOperation));
            stringBuffer.append("\n" + new CIMClass(this.cName));
            return stringBuffer.toString();
        }

        public CreateClassOp(CIMObjectPath cIMObjectPath, CIMClass cIMClass) {
            super(cIMObjectPath, 1);
            Debug.trace3((String)"Create class op created");
            this.cName = cIMClass.getName();
        }
    }

    private static class SetClassOp
    extends UndoOperation {
        CIMClass oldcc;

        public String undo(UndoOperation undoOperation) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getDirectives(undoOperation));
            stringBuffer.append("\n" + this.oldcc);
            return stringBuffer.toString();
        }

        public SetClassOp(CIMObjectPath cIMObjectPath, CIMClass cIMClass) {
            super(cIMObjectPath, 2);
            Debug.trace3((String)"Set class op created");
            this.oldcc = cIMClass;
        }
    }

    private static abstract class UndoOperation {
        static final int DELETEMODE = 1;
        static final int SETMODE = 2;
        static final int CREATEMODE = 3;
        protected int mode = 0;
        protected CIMObjectPath nameSpace = null;

        int getMode() {
            return this.mode;
        }

        private String getModeString() {
            switch (this.mode) {
                case 1: {
                    return "__delete";
                }
                case 3: {
                    return "__create";
                }
                case 2: {
                    return "__modify";
                }
            }
            throw new IllegalArgumentException(this.mode + "");
        }

        void setMode(int n) {
            this.mode = n;
        }

        CIMObjectPath getNameSpace() {
            return this.nameSpace;
        }

        void setNameSpace(CIMObjectPath cIMObjectPath) {
            this.nameSpace = cIMObjectPath;
        }

        String getDirectives(UndoOperation undoOperation) {
            StringBuffer stringBuffer = new StringBuffer("");
            String string = this.getNameSpace().getNameSpace();
            if (undoOperation == null) {
                string = string.replace('\\', '/');
                stringBuffer.append("\n#pragma namespace(\"" + string + "\")");
                stringBuffer.append("\n#pragma namespace(\"" + this.getModeString() + "\")");
                return stringBuffer.toString();
            }
            String string2 = undoOperation.getNameSpace().getNameSpace();
            if (!string2.equals(string)) {
                string = string.replace('\\', '/');
                stringBuffer.append("\n#pragma namespace(\"" + string + "\")");
            }
            if (this.getMode() != undoOperation.getMode()) {
                stringBuffer.append("\n#pragma namespace(\"" + this.getModeString() + "\")");
            }
            return stringBuffer.toString();
        }

        abstract String undo(UndoOperation var1);

        public UndoOperation(CIMObjectPath cIMObjectPath, int n) {
            this.setNameSpace(cIMObjectPath);
            this.setMode(n);
        }
    }
}

