/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.AddQualifierDialog;
import com.sun.wbem.apps.cimworkshop.CIMElementsTable;
import com.sun.wbem.apps.cimworkshop.CIMFlavorDialog;
import com.sun.wbem.apps.cimworkshop.CIMScopeDialog;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.client.CIMClient;

public class CIMQualifiersPanel
extends CIMElementsTable {
    private Vector cim = null;
    private boolean newElement;

    public CIMQualifiersPanel(CIMClient cIMClient, CIMElement cIMElement, boolean bl) {
        super(1, bl);
        this.newElement = bl;
        this.populateTable(cIMClient, cIMElement);
        ActionString actionString = new ActionString("LBL_QUALIFIERS");
        JLabel jLabel = new JLabel(actionString.getString() + ":");
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.setColumnHeaderView(jLabel);
        jLabel.setLabelFor(this.table);
        ActionString actionString2 = new ActionString("MNU_SCOPE");
        ActionString actionString3 = new ActionString("MNU_FLAVOR");
        JMenuItem jMenuItem = this.popupMenu.add(new JMenuItem(actionString2.getString()));
        jMenuItem.setActionCommand("SCOPE");
        jMenuItem.addActionListener(this);
        jMenuItem = this.popupMenu.add(new JMenuItem(actionString3.getString()));
        jMenuItem.setActionCommand("FLAVOR");
        jMenuItem.addActionListener(this);
        if (bl) {
            ActionString actionString4 = new ActionString("MNU_ADD_QUALIFIER");
            ActionString actionString5 = new ActionString("MNU_DELETE_QUALIFIER");
            jMenuItem = this.popupMenu.add(new JMenuItem(actionString4.getString()));
            jMenuItem.setActionCommand("ADD_QUALIFIER");
            jMenuItem.addActionListener(this);
            jMenuItem = this.popupMenu.add(new JMenuItem(actionString5.getString()));
            jMenuItem.setActionCommand("DELETE_QUALIFIER");
            jMenuItem.addActionListener(this);
        } else {
            ActionString actionString6 = new ActionString("MNU_SHOW_VALUE");
            jMenuItem = this.popupMenu.add(new JMenuItem(actionString6.getString()));
            jMenuItem.setActionCommand("SHOW_VALUE");
            jMenuItem.addActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("ADD_QUALIFIER")) {
            try {
                String string2;
                boolean bl;
                Object object;
                Enumeration enumeration = this.cimClient.enumQualifierTypes(new CIMObjectPath(""));
                Vector<String> vector = new Vector<String>();
                while (enumeration.hasMoreElements()) {
                    object = (CIMQualifierType)enumeration.nextElement();
                    vector.addElement(object.getName());
                }
                Util.sortVector(vector);
                do {
                    bl = true;
                    object = new AddQualifierDialog(Util.getFrame(this), vector);
                    string2 = ((AddQualifierDialog)object).getName();
                    if (!this.isNameDefined(string2)) continue;
                    JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_DUP_QUALIFIER", string2), I18N.loadString("TTL_CIM_ERROR"), 0);
                    bl = false;
                } while (!bl);
                if (string2 != null) {
                    CIMQualifierType cIMQualifierType = this.cimClient.getQualifierType(new CIMObjectPath(string2));
                    CIMQualifier cIMQualifier = new CIMQualifier(string2, cIMQualifierType);
                    this.cimElements.addElement(cIMQualifier);
                    this.elementsDataModel.setNumRows(this.cimElements.size());
                }
            }
            catch (CIMException cIMException) {
                CIMErrorDialog.display(this, cIMException);
            }
        } else if (string.equals("DELETE_QUALIFIER")) {
            this.cimElements.removeElementAt(this.getSelectedRow());
            this.elementsDataModel.setNumRows(this.cimElements.size());
        } else if (string.equals("SCOPE")) {
            CIMQualifier cIMQualifier = (CIMQualifier)this.cimElements.elementAt(this.getSelectedRow());
            CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMQualifier.getName());
            try {
                CIMQualifierType cIMQualifierType = this.cimClient.getQualifierType(cIMObjectPath);
                Vector vector = cIMQualifierType.getScope();
                CIMScopeDialog cIMScopeDialog = new CIMScopeDialog(Util.getFrame(this), vector, cIMQualifier.getName(), false);
            }
            catch (CIMException cIMException) {
                CIMErrorDialog.display(this, cIMException);
            }
        } else if (string.equals("FLAVOR")) {
            CIMQualifier cIMQualifier = (CIMQualifier)this.cimElements.elementAt(this.getSelectedRow());
            CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMQualifier.getName());
            try {
                CIMQualifierType cIMQualifierType = this.cimClient.getQualifierType(cIMObjectPath);
                Vector vector = cIMQualifierType.getFlavor();
                CIMFlavorDialog cIMFlavorDialog = new CIMFlavorDialog(Util.getFrame(this), vector, cIMQualifier.getName(), false);
            }
            catch (CIMException cIMException) {
                CIMErrorDialog.display(this, cIMException);
            }
        }
    }

    public void populateTable(CIMClient cIMClient, CIMElement cIMElement) {
        Util.setWaitCursor(this);
        this.cimClient = cIMClient;
        this.parentElement = cIMElement;
        if (cIMElement == null) {
            this.cimElements = null;
        } else if (cIMElement instanceof CIMInstance) {
            this.cimElements = ((CIMInstance)this.parentElement).getQualifiers();
        } else if (cIMElement instanceof CIMClass) {
            this.cimElements = ((CIMClass)this.parentElement).getQualifiers();
        } else if (cIMElement instanceof CIMProperty) {
            this.cimElements = ((CIMProperty)this.parentElement).getQualifiers();
        } else if (cIMElement instanceof CIMMethod) {
            this.cimElements = ((CIMMethod)this.parentElement).getQualifiers();
        }
        if (this.elementsDataModel != null && this.cimElements != null) {
            this.elementsDataModel.setNumRows(this.cimElements.size());
            this.table.repaint();
        } else {
            this.elementsDataModel.setNumRows(0);
            this.table.repaint();
        }
        Util.setDefaultCursor(this);
    }

    public Vector getQualifiers() {
        return this.cimElements;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }
}

