/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.network.NetworkConfigData;
import com.sun.wbem.solarisprovider.network.NetworkConfigInfo;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;

public class Solaris_IPProtocolEndpoint
implements InstanceProvider {
    private static final String SOLARIS_IPPE = "Solaris_IPProtocolEndpoint";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String IP_ADDRESS = "Address";
    private static final String NETMASK = "SubnetMask";
    private static final String ADDRESS_TYPE = "AddressType";
    private static final String IPVERSION_SUPPORT = "IPVersionSupport";
    private static final String DESCRIPTION = "Description";
    private static final String STATUS = "Status";
    private static final String MAX_DATA_SIZE = "MaxDataSize";
    private static final String INDEX = "Index";
    private static final String BROADCAST = "Broadcast";
    private static final String OPTIONS = "OptionsEnabled";
    private static final String NAME = "Name";
    private static final String SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private static final String providerName = "Solaris_IPProtocolEndpoint";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        try {
            this.cimomhandle = cIMOMHandle;
            this.provUtil = new ProviderUtility(cIMOMHandle, "Solaris_IPProtocolEndpoint");
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cIMException.toString());
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            CIMProperty cIMProperty;
            String string = null;
            NetworkConfigData networkConfigData = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase(NAME)) continue;
                string = (String)cIMProperty.getValue().getValue();
            }
            if (string == null) {
                return null;
            }
            networkConfigData = this.getNetworkConfigData(string);
            cIMProperty = this.createNewInstance(cIMClass, networkConfigData);
            if (bl) {
                cIMProperty = cIMProperty.localElements();
            }
            return cIMProperty.filterProperties(stringArray, bl2, bl3);
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        try {
            this.hash = this.getData();
            if (this.hash == null) {
                return null;
            }
            cIMInstanceArray = this.hash.elements();
            while (cIMInstanceArray.hasMoreElements()) {
                NetworkConfigData networkConfigData = (NetworkConfigData)cIMInstanceArray.nextElement();
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, networkConfigData);
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath[] cIMObjectPathArray;
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            this.hash = this.getData();
            if (this.hash == null) {
                return null;
            }
            cIMObjectPathArray = this.hash.elements();
            while (cIMObjectPathArray.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                NetworkConfigData networkConfigData = (NetworkConfigData)cIMObjectPathArray.nextElement();
                cIMObjectPath2.addKey(NAME, new CIMValue((Object)networkConfigData.getInterfaceName()));
                cIMObjectPath2.addKey(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPProtocolEndpoint"));
                cIMObjectPath2.addKey(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
                try {
                    cIMObjectPath2.addKey(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                vector.addElement(cIMObjectPath2);
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        return null;
    }

    private Hashtable getData() throws Exception {
        try {
            NetworkConfigInfo networkConfigInfo = new NetworkConfigInfo(this.provUtil);
            Hashtable hashtable = networkConfigInfo.initData();
            if (hashtable != null) {
                return hashtable;
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        return null;
    }

    private NetworkConfigData getNetworkConfigData(String string) throws Exception {
        Hashtable hashtable = null;
        NetworkConfigData networkConfigData = null;
        try {
            hashtable = this.getData();
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        if (hashtable == null) {
            return null;
        }
        networkConfigData = (NetworkConfigData)hashtable.get(string);
        if (networkConfigData == null) {
            return null;
        }
        return networkConfigData;
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, NetworkConfigData networkConfigData) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty(NAME, new CIMValue((Object)networkConfigData.getInterfaceName()));
        cIMInstance.setProperty(IP_ADDRESS, new CIMValue((Object)networkConfigData.getIPAddress()));
        int n = 0;
        String string = networkConfigData.getAddressType();
        if (string.equalsIgnoreCase("IPv4")) {
            n = 1;
        }
        cIMInstance.setProperty(ADDRESS_TYPE, new CIMValue((Object)new UnsignedInt16(n)));
        cIMInstance.setProperty(IPVERSION_SUPPORT, new CIMValue((Object)new UnsignedInt16(n)));
        cIMInstance.setProperty(NETMASK, new CIMValue((Object)networkConfigData.getNetmask()));
        cIMInstance.setProperty(MAX_DATA_SIZE, new CIMValue((Object)networkConfigData.getMtu()));
        cIMInstance.setProperty(INDEX, new CIMValue((Object)networkConfigData.getIndex()));
        cIMInstance.setProperty(OPTIONS, new CIMValue((Object)networkConfigData.getOptionsEnabled()));
        cIMInstance.setProperty(DESCRIPTION, new CIMValue((Object)networkConfigData.getDescription()));
        cIMInstance.setProperty(BROADCAST, new CIMValue((Object)networkConfigData.getBroadcast()));
        cIMInstance.setProperty(STATUS, new CIMValue((Object)"Running"));
        cIMInstance.setProperty(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPProtocolEndpoint"));
        cIMInstance.setProperty(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
        try {
            cIMInstance.setProperty(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cIMInstance;
    }
}

