/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.adapter.rmi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;

public class CheckSumGen
implements Serializable {
    static final long serialVersionUID = 200L;
    private static final int QUALS = 0;
    private static final int CPROPERTIES = 1;
    private static final int IPROPERTIES = 2;
    private static final int METHODS = 3;
    private static final int VALVECTOR = 4;
    private static final int PARAMETER = 5;
    private static final int FLAVOR = 6;
    private static final int SCOPE = 7;
    private static final String NULL = "null";
    static final String INDENT = "    ";
    static final String TAB = "\t";
    static final String QUOTE = "\"";
    static final String SPACE = " ";
    static final String COLON = ":";
    static final String LINE = "\n";
    private static final String ANY = "any";
    private static final String AS = "as";
    private static final String ASSOCIATION = "association";
    private static final String CLASS = "class";
    private static final String DISABLEOVERRIDE = "disableoverride";
    private static final String DT_BOOL = "boolean";
    private static final String DT_CHAR16 = "char16";
    private static final String DT_DATETIME = "datetime";
    private static final String DT_REAL32 = "real32";
    private static final String DT_REAL64 = "real64";
    private static final String DT_SINT16 = "sint16";
    private static final String DT_SINT32 = "sint32";
    private static final String DT_SINT64 = "sint64";
    private static final String DT_SINT8 = "sint8";
    private static final String DT_STR = "string";
    private static final String DT_UINT16 = "uint16";
    private static final String DT_UINT32 = "uint32";
    private static final String DT_UINT64 = "uint64";
    private static final String DT_UINT8 = "uint8";
    private static final String ENABLEOVERRIDE = "enableoverride";
    private static final String FALSE = "false";
    private static final String CIMFLAVOR = "Flavor";
    private static final String INDICATION = "indication";
    private static final String INSTANCE = "instance";
    private static final String METHOD = "method";
    private static final String OF = "of";
    private static final String CIMPARAMETER = "parameter";
    private static final String PRAGMA = "#pragma";
    private static final String PROPERTY = "property";
    private static final String QUALIFIER = "qualifier";
    private static final String REF = "ref";
    private static final String REFERENCE = "reference";
    private static final String RESTRICTED = "restricted";
    private static final String SCHEMA = "schema";
    private static final String CIMSCOPE = "Scope";
    private static final String TOSUBCLASS = "tosubclass";
    private static final String TRANSLATABLE = "translatable";
    private static final String TRUE = "true";
    boolean cimclass = true;

    public String vectorToMOFString(Vector vector, int n) {
        return this.vectorToMOFString(vector, INDENT, false, false, true, n);
    }

    public String vectorToMOFString(Vector vector, String string, int n) {
        return this.vectorToMOFString(vector, string, false, false, true, n);
    }

    public String vectorToMOFString(Vector vector, boolean bl, int n) {
        return this.vectorToMOFString(vector, INDENT, bl, false, true, n);
    }

    public String vectorToMOFString(Vector vector, boolean bl, boolean bl2, int n) {
        return this.vectorToMOFString(vector, INDENT, bl, bl2, true, n);
    }

    public String vectorToMOFString(Vector vector, boolean bl, boolean bl2, boolean bl3, int n) {
        return this.vectorToMOFString(vector, INDENT, bl, bl2, bl3, n);
    }

    public String vectorToMOFString(Vector vector, String string, boolean bl, boolean bl2, boolean bl3, int n) {
        String string2 = "";
        string2 = bl3 ? ",\n" : ", ";
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector != null && !vector.isEmpty()) {
            if (bl) {
                stringBuffer.append(string);
                stringBuffer.append("[");
            }
            int n2 = vector.size() - 1;
            int n3 = 0;
            while (n3 <= n2) {
                if (n3 > 0) {
                    stringBuffer = bl2 ? stringBuffer.append(string2 + string) : stringBuffer.append(LINE);
                }
                Object e = vector.elementAt(n3);
                switch (n) {
                    case 0: {
                        stringBuffer.append(this.toString((CIMQualifier)e));
                        break;
                    }
                    case 1: {
                        stringBuffer.append(this.toString((CIMProperty)e, true));
                        break;
                    }
                    case 2: {
                        stringBuffer.append(this.toString((CIMProperty)e, false));
                        break;
                    }
                    case 3: {
                        stringBuffer.append(this.toString((CIMMethod)e));
                        break;
                    }
                    case 5: {
                        stringBuffer.append(this.toString((CIMParameter)e));
                        break;
                    }
                    case 6: {
                        stringBuffer.append(this.toString((CIMFlavor)e));
                        break;
                    }
                    case 7: {
                        stringBuffer.append(this.toString((CIMScope)e));
                        break;
                    }
                    case 4: {
                        stringBuffer.append(QUOTE);
                        stringBuffer.append(this.values(e));
                        stringBuffer.append(QUOTE);
                    }
                }
                ++n3;
            }
            if (bl) {
                stringBuffer = stringBuffer.append("]\n");
            }
        }
        return stringBuffer.toString();
    }

    public String toString(Vector vector) {
        if (vector == null) {
            return NULL;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = vector.iterator();
        stringBuffer.append("[");
        int n = vector.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            Object e = iterator.next();
            if (e instanceof CIMValue) {
                stringBuffer.append(this.toString((CIMValue)e));
            } else if (e instanceof CIMProperty) {
                stringBuffer.append(this.toString((CIMProperty)e, false));
            } else {
                stringBuffer.append(e.toString());
            }
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString(CIMClass cIMClass) {
        if (cIMClass == null) {
            return NULL;
        }
        String string = "class " + cIMClass.getName();
        if (cIMClass.getSuperClass().length() > 0) {
            string = string.concat(COLON + cIMClass.getSuperClass());
        }
        return new String(this.vectorToMOFString(cIMClass.getQualifiers(), true, true, 0) + string + LINE + "{" + LINE + this.vectorToMOFString(cIMClass.getProperties(), 1) + LINE + this.vectorToMOFString(cIMClass.getMethods(), 3) + LINE + "};");
    }

    private String values(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof CIMObjectPath) {
            return this.toString((CIMObjectPath)object);
        }
        if (object instanceof CIMDateTime) {
            return this.toString((CIMDateTime)object);
        }
        if (object instanceof CIMInstance) {
            return this.toString((CIMInstance)object);
        }
        return object.toString();
    }

    public String toString(CIMValue cIMValue) {
        String string = NULL;
        if (cIMValue == null) {
            return NULL;
        }
        Object object = cIMValue.getValue();
        if (object != null) {
            if (cIMValue.isArrayValue()) {
                string = this.vectorToMOFString((Vector)object, "", false, true, false, 4);
            } else {
                String string2 = "";
                if (new CIMDataType(8).equals(cIMValue.getType())) {
                    string2 = QUOTE;
                }
                string = string2 + this.values(object) + string2;
            }
        }
        return string;
    }

    public String toString(CIMQualifierType cIMQualifierType) {
        if (cIMQualifierType == null) {
            return NULL;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        if (!cIMQualifierType.getScope().isEmpty()) {
            string = "Scope(" + this.vectorToMOFString(cIMQualifierType.getScope(), "", false, true, false, 7) + ")";
        }
        if (!cIMQualifierType.getFlavor().isEmpty()) {
            string2 = ", Flavor(" + this.vectorToMOFString(cIMQualifierType.getFlavor(), "", false, true, false, 6) + ")";
        }
        if (!cIMQualifierType.getType().isArrayType()) {
            string3 = " = " + this.toString(cIMQualifierType.getDefaultValue());
        }
        return new String("qualifier " + cIMQualifierType.getName() + " : " + this.toString(cIMQualifierType.getType()) + string3 + ", " + string + string2 + ";");
    }

    public String toString(CIMQualifier cIMQualifier) {
        if (cIMQualifier == null) {
            return NULL;
        }
        if (cIMQualifier.getValue() == null) {
            return new String(cIMQualifier.getName());
        }
        return new String(cIMQualifier.getName() + "(" + this.toString(cIMQualifier.getValue()) + ")");
    }

    public String toString(CIMDateTime cIMDateTime) {
        if (cIMDateTime == null) {
            return NULL;
        }
        return cIMDateTime.toString();
    }

    public String toString(CIMDataType cIMDataType) {
        if (cIMDataType == null) {
            return NULL;
        }
        switch (cIMDataType.getType()) {
            case 0: {
                return new String(DT_UINT8);
            }
            case 1: {
                return new String(DT_SINT8);
            }
            case 2: {
                return new String(DT_UINT16);
            }
            case 3: {
                return new String(DT_SINT16);
            }
            case 4: {
                return new String(DT_UINT32);
            }
            case 5: {
                return new String(DT_SINT32);
            }
            case 6: {
                return new String(DT_UINT64);
            }
            case 7: {
                return new String(DT_SINT64);
            }
            case 10: {
                return new String(DT_REAL32);
            }
            case 11: {
                return new String(DT_REAL64);
            }
            case 8: {
                return new String(DT_STR);
            }
            case 13: {
                return new String(DT_CHAR16);
            }
            case 12: {
                return new String(DT_DATETIME);
            }
            case 9: {
                return new String(DT_BOOL);
            }
            case 14: {
                return new String("uint8[]");
            }
            case 15: {
                return new String("sint8[]");
            }
            case 16: {
                return new String("uint16[]");
            }
            case 17: {
                return new String("sint16[]");
            }
            case 18: {
                return new String("uint32[]");
            }
            case 19: {
                return new String("sint32[]");
            }
            case 20: {
                return new String("uint64[]");
            }
            case 21: {
                return new String("sint64[]");
            }
            case 24: {
                return new String("real32[]");
            }
            case 25: {
                return new String("real64[]");
            }
            case 22: {
                return new String("string[]");
            }
            case 27: {
                return new String("char16[]");
            }
            case 26: {
                return new String("datetime[]");
            }
            case 23: {
                return new String("boolean[]");
            }
            case 30: {
                return new String(NULL);
            }
            case 28: {
                return new String("reference(" + cIMDataType.getRefClassName() + ")");
            }
        }
        return "";
    }

    public String toString(CIMFlavor cIMFlavor) {
        if (cIMFlavor == null) {
            return NULL;
        }
        switch (cIMFlavor.getFlavor()) {
            case 0: {
                return ENABLEOVERRIDE;
            }
            case 1: {
                return DISABLEOVERRIDE;
            }
            case 2: {
                return RESTRICTED;
            }
            case 3: {
                return TOSUBCLASS;
            }
            case 4: {
                return TRANSLATABLE;
            }
        }
        return "UNKNOWN";
    }

    public String toString(CIMInstance cIMInstance) {
        if (cIMInstance == null) {
            return NULL;
        }
        this.cimclass = false;
        String string = new String("instance of " + cIMInstance.getClassName() + SPACE + "{" + LINE + this.vectorToMOFString(cIMInstance.getProperties(), 2) + LINE + "};");
        this.cimclass = true;
        return string;
    }

    public String toString(CIMMethod cIMMethod) {
        if (cIMMethod == null) {
            return NULL;
        }
        return new String(INDENT + this.toString(cIMMethod.getType()) + SPACE + cIMMethod.getName() + "(" + this.vectorToMOFString(cIMMethod.getParameters(), "", false, true, false, 5) + ");");
    }

    public String toString(CIMNameSpace cIMNameSpace) {
        if (cIMNameSpace == null) {
            return NULL;
        }
        return "\\\\" + cIMNameSpace.getHost() + "\\" + cIMNameSpace.getNameSpace();
    }

    private String pqToString(Vector vector) {
        if (vector == null) {
            return NULL;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = vector.iterator();
        stringBuffer.append("[");
        int n = vector.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            Object e = iterator.next();
            stringBuffer.append(this.toString((CIMQualifier)e));
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString(CIMParameter cIMParameter) {
        if (cIMParameter == null) {
            return NULL;
        }
        return new String(this.pqToString(cIMParameter.getQualifiers()) + SPACE + this.toString(cIMParameter.getType()) + SPACE + cIMParameter.getName());
    }

    public String toString(CIMProperty cIMProperty, boolean bl) {
        if (cIMProperty == null) {
            return NULL;
        }
        if (bl) {
            return new String(this.vectorToMOFString(cIMProperty.getQualifiers(), TAB, true, true, true, 0) + INDENT + this.toString(cIMProperty.getType()) + SPACE + cIMProperty.getName() + ";");
        }
        return new String(INDENT + cIMProperty.getName() + " = " + this.toString(cIMProperty.getValue()) + ";");
    }

    public String toString(CIMScope cIMScope) {
        if (cIMScope == null) {
            return NULL;
        }
        switch (cIMScope.getScope()) {
            case 0: {
                return SCHEMA;
            }
            case 1: {
                return CLASS;
            }
            case 2: {
                return ASSOCIATION;
            }
            case 3: {
                return INDICATION;
            }
            case 4: {
                return PROPERTY;
            }
            case 5: {
                return REFERENCE;
            }
            case 6: {
                return METHOD;
            }
            case 7: {
                return CIMPARAMETER;
            }
            case 8: {
                return ANY;
            }
        }
        return "UNKNOWN";
    }

    public String toString(CIMObjectPath cIMObjectPath) {
        if (cIMObjectPath == null) {
            return NULL;
        }
        Vector vector = cIMObjectPath.getKeys();
        String string = cIMObjectPath.getNameSpace();
        String string2 = cIMObjectPath.getObjectName();
        if (vector == null || vector.size() == 0) {
            if (string2 != null && string2.length() != 0) {
                return string + "\\" + string2;
            }
            return string;
        }
        String string3 = "";
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (cIMProperty == null) continue;
            String string4 = cIMProperty.getOriginClass();
            string3 = string4 != null && string4.length() != 0 ? string3 + string4 + "." + cIMProperty.getName() : string3 + cIMProperty.getName();
            string3 = string3 + "=" + this.toString(cIMProperty.getValue()) + COLON;
            ++n;
        }
        if (n > 0) {
            return string + "\\" + string2 + COLON + string3.substring(0, string3.lastIndexOf(COLON));
        }
        return string + "\\" + string2;
    }
}

