/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import sun.servlet.http.SessionContextImpl;

public class HttpSessionImpl
implements HttpSession {
    private String sessionID;
    private long creationTime;
    private long lastAccessedTime;
    private Hashtable sessionObjects = new Hashtable();
    private SessionContextImpl sc;
    private boolean cookieSupportDetermined;
    private boolean usingCookies;
    private boolean usingURL;
    private Cookie cookie;
    private boolean isNew;
    private boolean isValid;

    public HttpSessionImpl(SessionContextImpl sessionContextImpl, Cookie cookie) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.sc = sessionContextImpl;
        this.cookieSupportDetermined = false;
        this.cookie = cookie;
        this.sessionID = sessionContextImpl.setSession(this);
        cookie.setValue(this.sessionID);
        this.isNew = true;
        this.isValid = true;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public long getCreationTime() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.creationTime;
    }

    public String getId() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.sessionID;
    }

    public long getLastAccessedTime() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.lastAccessedTime;
    }

    public HttpSessionContext getSessionContext() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.sc;
    }

    public Object getValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.sessionObjects.get(string);
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        String[] stringArray = new String[this.sessionObjects.size()];
        int n = 0;
        Enumeration enumeration = this.sessionObjects.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        this.sc.removeSession(this.sessionID);
        this.isValid = false;
    }

    public boolean isCookieSupportDetermined() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.cookieSupportDetermined;
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.isNew;
    }

    public boolean isUsingCookies() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return true;
    }

    public boolean isUsingUrlRewriting() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void putValue(String string, Object object) {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        this.removeValue(string);
        this.sessionObjects.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent(this, string));
        }
    }

    public void removeValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        Object v = this.sessionObjects.get(string);
        if (v != null) {
            this.sessionObjects.remove(string);
        }
        if (v instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent(this, string));
        }
    }

    public void setCookieSupported(boolean bl) {
        this.cookieSupportDetermined = true;
        this.usingCookies = bl;
    }

    public void setLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }
}

