/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.Resource;

public class ApplicationContext
implements ServletContext {
    private HashMap attributes = new HashMap();
    private HashMap readOnlyAttributes = new HashMap();
    private StandardContext context = null;
    private static final ArrayList empty = new ArrayList();
    private ServletContext facade = new ApplicationContextFacade(this);
    private HashMap parameters = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private String basePath = null;

    public ApplicationContext(String basePath, StandardContext context) {
        this.context = context;
        this.basePath = basePath;
    }

    public void clearAttributes() {
        ArrayList list = new ArrayList();
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Iterator iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        Iterator keys = ((AbstractList)list).iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.removeAttribute(key);
        }
    }

    public Object getAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Object v = this.attributes.get(name);
            Object var4_4 = null;
            return v;
        }
    }

    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Enumerator enumerator = new Enumerator(this.attributes.keySet());
            Object var3_3 = null;
            return enumerator;
        }
    }

    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        String contextPath = this.context.getPath();
        if (!contextPath.endsWith("/")) {
            contextPath = String.valueOf(contextPath) + "/";
        }
        if (contextPath.length() > 0 && uri.startsWith(contextPath)) {
            return this;
        }
        if (!this.context.getCrossContext()) {
            return null;
        }
        try {
            Host host = (Host)this.context.getParent();
            Context child = host.map(uri);
            if (child != null) {
                return child.getServletContext();
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    ServletContext getFacade() {
        return this.facade;
    }

    public String getInitParameter(String name) {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String string = (String)this.parameters.get(name);
            Object var4_4 = null;
            return string;
        }
    }

    public Enumeration getInitParameterNames() {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            Enumerator enumerator = new Enumerator(this.parameters.keySet());
            Object var3_3 = null;
            return enumerator;
        }
    }

    public static String getJNDIUri(String hostName, String path) {
        if (!path.startsWith("/")) {
            return "/" + hostName + "/" + path;
        }
        return "/" + hostName + path;
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(extension);
    }

    public int getMinorVersion() {
        return 3;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(name);
        if (wrapper == null) {
            return null;
        }
        ApplicationDispatcher dispatcher = new ApplicationDispatcher(wrapper, null, null, null, name);
        return dispatcher;
    }

    public String getRealPath(String path) {
        if (!this.context.isFilesystemBased()) {
            return null;
        }
        File file = new File(this.basePath, path);
        return file.getAbsolutePath();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        if (this.normalize(path) == null) {
            return null;
        }
        String contextPath = this.context.getPath();
        if (contextPath == null) {
            contextPath = "";
        }
        String relativeURI = path;
        String queryString = null;
        int question = path.indexOf(63);
        if (question >= 0) {
            relativeURI = path.substring(0, question);
            queryString = path.substring(question + 1);
        }
        if (System.getSecurityManager() != null) {
            PrivilegedGetRequestDispatcher dp = new PrivilegedGetRequestDispatcher(contextPath, relativeURI, queryString);
            return (RequestDispatcher)AccessController.doPrivileged(dp);
        }
        HttpRequestBase request = new HttpRequestBase();
        request.setContext(this.context);
        request.setContextPath(this.context.getPath());
        request.setRequestURI(String.valueOf(contextPath) + relativeURI);
        request.setQueryString(queryString);
        Wrapper wrapper = (Wrapper)this.context.map(request, true);
        if (wrapper == null) {
            return null;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        return new ApplicationDispatcher(wrapper, hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString(), null);
    }

    public URL getResource(String path) throws MalformedURLException {
        DirContext resources = this.context.getResources();
        if (resources != null) {
            String fullPath = String.valueOf(this.context.getName()) + path;
            String hostName = this.context.getParent().getName();
            try {
                resources.lookup(path);
                if (System.getSecurityManager() != null) {
                    try {
                        PrivilegedGetResource dp = new PrivilegedGetResource(hostName, fullPath, resources);
                        return (URL)AccessController.doPrivileged(dp);
                    }
                    catch (PrivilegedActionException pe) {
                        throw pe.getException();
                    }
                }
                return new URL("jndi", null, 0, ApplicationContext.getJNDIUri(hostName, fullPath), (URLStreamHandler)new DirContextURLStreamHandler(resources));
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        block3: {
            DirContext resources = this.context.getResources();
            if (resources == null) break block3;
            try {
                Object resource = resources.lookup(path);
                if (resource instanceof Resource) {
                    return ((Resource)resource).streamContent();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        DirContext resources = this.context.getResources();
        if (resources != null) {
            if (System.getSecurityManager() != null) {
                PrivilegedGetResourcePaths dp = new PrivilegedGetResourcePaths(resources, path);
                return (Set)AccessController.doPrivileged(dp);
            }
            return this.getResourcePathsInternal(resources, path);
        }
        return null;
    }

    private Set getResourcePathsInternal(DirContext resources, String path) {
        ResourceSet set = new ResourceSet();
        try {
            ApplicationContext.listCollectionPaths(set, resources, path);
        }
        catch (NamingException namingException) {
            return null;
        }
        set.setLocked(true);
        return set;
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    public String getServerInfo() {
        return "Apache Tomcat/4.0.5";
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    public Enumeration getServletNames() {
        return new Enumerator(empty);
    }

    public Enumeration getServlets() {
        return new Enumerator(empty);
    }

    private void internalLog(Exception exception, String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(exception, message);
        }
    }

    private void internalLog(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(message);
        }
    }

    private void internalLog(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(message, throwable);
        }
    }

    private static void listCollectionPaths(Set set, DirContext resources, String path) throws NamingException {
        NamingEnumeration<Binding> childPaths = resources.listBindings(path);
        while (childPaths.hasMoreElements()) {
            Binding binding = (Binding)childPaths.nextElement();
            String name = binding.getName();
            StringBuffer childPath = new StringBuffer(path);
            if (!"/".equals(path)) {
                childPath.append("/");
            }
            childPath.append(name);
            Object object = binding.getObject();
            if (object instanceof DirContext) {
                childPath.append("/");
            }
            set.add(childPath.toString());
        }
    }

    private static void listPaths(Set set, DirContext resources, String path) throws NamingException {
        NamingEnumeration<Binding> childPaths = resources.listBindings(path);
        while (childPaths.hasMoreElements()) {
            Binding binding = (Binding)childPaths.nextElement();
            String name = binding.getName();
            String childPath = String.valueOf(path) + "/" + name;
            set.add(childPath);
            Object object = binding.getObject();
            if (!(object instanceof DirContext)) continue;
            ApplicationContext.listPaths(set, resources, childPath);
        }
    }

    public void log(Exception exception, String message) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogException dp = new PrivilegedLogException(exception, message);
            AccessController.doPrivileged(dp);
        } else {
            this.internalLog(exception, message);
        }
    }

    public void log(String message) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogMessage dp = new PrivilegedLogMessage(message);
            AccessController.doPrivileged(dp);
        } else {
            this.internalLog(message);
        }
    }

    public void log(String message, Throwable throwable) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogThrowable dp = new PrivilegedLogThrowable(message, throwable);
            AccessController.doPrivileged(dp);
        } else {
            this.internalLog(message, throwable);
        }
    }

    private void mergeParameters() {
        if (this.parameters != null) {
            return;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        String[] names = this.context.findParameters();
        int i = 0;
        while (i < names.length) {
            results.put(names[i], this.context.findParameter(names[i]));
            ++i;
        }
        ApplicationParameter[] params = this.context.findApplicationParameters();
        int i2 = 0;
        while (i2 < params.length) {
            if (params[i2].getOverride()) {
                if (results.get(params[i2].getName()) == null) {
                    results.put(params[i2].getName(), params[i2].getValue());
                }
            } else {
                results.put(params[i2].getName(), params[i2].getValue());
            }
            ++i2;
        }
        this.parameters = results;
    }

    private String normalize(String path) {
        int index;
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAttribute(String name) {
        Object value;
        block11: {
            value = null;
            boolean found = false;
            HashMap hashMap = this.attributes;
            synchronized (hashMap) {
                block10: {
                    if (this.readOnlyAttributes.containsKey(name)) {
                        return;
                    }
                    found = this.attributes.containsKey(name);
                    if (!found) break block10;
                    value = this.attributes.get(name);
                    this.attributes.remove(name);
                    break block11;
                }
                return;
            }
        }
        Object[] listeners = this.context.getApplicationListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof ServletContextAttributeListener) {
                ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
                try {
                    this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                    listener.attributeRemoved(event);
                    this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                }
                catch (Throwable t) {
                    this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                    this.log(sm.getString("applicationContext.attributeEvent"), t);
                }
            }
            ++i;
        }
        return;
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            if (this.readOnlyAttributes.containsKey(name)) {
                Object var6_6 = null;
                return;
            }
            oldValue = this.attributes.get(name);
            if (oldValue != null) {
                replaced = true;
            }
            this.attributes.put(name, value);
        }
        Object[] listeners = this.context.getApplicationListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof ServletContextAttributeListener) {
                ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
                try {
                    if (replaced) {
                        this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                        listener.attributeReplaced(event);
                        this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    } else {
                        this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                        listener.attributeAdded(event);
                        this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                    }
                }
                catch (Throwable t) {
                    if (replaced) {
                        this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    } else {
                        this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                    }
                    this.log(sm.getString("applicationContext.attributeEvent"), t);
                }
            }
            ++i;
        }
    }

    public void setAttributeReadOnly(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            if (this.attributes.containsKey(name)) {
                this.readOnlyAttributes.put(name, name);
            }
        }
    }

    protected class PrivilegedGetRequestDispatcher
    implements PrivilegedAction {
        private String contextPath;
        private String relativeURI;
        private String queryString;

        PrivilegedGetRequestDispatcher(String contextPath, String relativeURI, String queryString) {
            this.contextPath = contextPath;
            this.relativeURI = relativeURI;
            this.queryString = queryString;
        }

        public Object run() {
            HttpRequestBase request = new HttpRequestBase();
            request.setContext(ApplicationContext.this.context);
            request.setContextPath(ApplicationContext.this.context.getPath());
            request.setRequestURI(String.valueOf(this.contextPath) + this.relativeURI);
            request.setQueryString(this.queryString);
            Wrapper wrapper = (Wrapper)ApplicationContext.this.context.map(request, true);
            if (wrapper == null) {
                return null;
            }
            HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
            return new ApplicationDispatcher(wrapper, hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString(), null);
        }
    }

    protected class PrivilegedGetResource
    implements PrivilegedExceptionAction {
        private String path;
        private String host;
        private DirContext resources;

        PrivilegedGetResource(String host, String path, DirContext resources) {
            this.host = host;
            this.path = path;
            this.resources = resources;
        }

        public Object run() throws Exception {
            return new URL("jndi", null, 0, ApplicationContext.getJNDIUri(this.host, this.path), (URLStreamHandler)new DirContextURLStreamHandler(this.resources));
        }
    }

    protected class PrivilegedGetResourcePaths
    implements PrivilegedAction {
        private String path;
        private DirContext resources;

        PrivilegedGetResourcePaths(DirContext resources, String path) {
            this.resources = resources;
            this.path = path;
        }

        public Object run() {
            return ApplicationContext.this.getResourcePathsInternal(this.resources, this.path);
        }
    }

    protected class PrivilegedLogMessage
    implements PrivilegedAction {
        private String message;

        PrivilegedLogMessage(String message) {
            this.message = message;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.message);
            return null;
        }
    }

    protected class PrivilegedLogException
    implements PrivilegedAction {
        private String message;
        private Exception exception;

        PrivilegedLogException(Exception exception, String message) {
            this.message = message;
            this.exception = exception;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.exception, this.message);
            return null;
        }
    }

    protected class PrivilegedLogThrowable
    implements PrivilegedAction {
        private String message;
        private Throwable throwable;

        PrivilegedLogThrowable(String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.message, this.throwable);
            return null;
        }
    }
}

