/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http10;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.connector.http10.HttpConnector;
import org.apache.catalina.connector.http10.HttpRequestImpl;
import org.apache.catalina.connector.http10.HttpResponseImpl;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

final class HttpProcessor
implements Lifecycle,
Runnable {
    private boolean available = false;
    private HttpConnector connector = null;
    private int debug = 0;
    private int id = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final String match = ";jsessionid=";
    private String proxyName = null;
    private int proxyPort = 0;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private int serverPort = 0;
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector.http10");
    private Socket socket = null;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();

    public HttpProcessor(HttpConnector connector, int id) {
        this.connector = connector;
        this.debug = connector.getDebug();
        this.id = id;
        this.proxyName = connector.getProxyName();
        this.proxyPort = connector.getProxyPort();
        this.request = (HttpRequestImpl)connector.createRequest();
        this.response = (HttpResponseImpl)connector.createResponse();
        this.serverPort = connector.getPort();
        this.threadName = "HttpProcessor[" + connector.getPort() + "][" + id + "]";
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    synchronized void assign(Socket socket) {
        while (this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.socket = socket;
        this.available = true;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log(" An incoming request is being assigned");
        }
    }

    private synchronized Socket await() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Socket socket = this.socket;
        this.available = false;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log("  The incoming request has been awaited");
        }
        return socket;
    }

    private void log(String message) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.threadName) + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.threadName) + " " + message, throwable);
        }
    }

    private void parseConnection(Socket socket) throws IOException, ServletException {
        if (this.debug >= 2) {
            this.log("  parseConnection: address=" + socket.getInetAddress() + ", port=" + this.connector.getPort());
        }
        this.request.setInet(socket.getInetAddress());
        if (this.proxyPort != 0) {
            this.request.setServerPort(this.proxyPort);
        } else {
            this.request.setServerPort(this.serverPort);
        }
        this.request.setSocket(socket);
    }

    private void parseHeaders(InputStream input) throws IOException, ServletException {
        String line;
        while ((line = this.read(input)) != null && line.length() >= 1) {
            int colon = line.indexOf(58);
            if (colon < 0) {
                throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.colon"));
            }
            String name = line.substring(0, colon).trim();
            String match = name.toLowerCase();
            String value = line.substring(colon + 1).trim();
            if (this.debug >= 1) {
                this.log(" Header " + name + " = " + value);
            }
            if (match.equals("authorization")) {
                this.request.setAuthorization(value);
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("accept-language")) {
                this.request.addHeader(name, value);
                Hashtable<String, Vector<Object>> languages = new Hashtable<String, Vector<Object>>();
                StringTokenizer languageTokenizer = new StringTokenizer(value, ",");
                while (languageTokenizer.hasMoreTokens()) {
                    String language = languageTokenizer.nextToken().trim();
                    int qValueIndex = language.indexOf(59);
                    int qIndex = language.indexOf(113);
                    int equalIndex = language.indexOf(61);
                    Double qValue = new Double(1.0);
                    if (qValueIndex > -1 && qValueIndex < qIndex && qIndex < equalIndex) {
                        String qValueStr = language.substring(qValueIndex + 1);
                        language = language.substring(0, qValueIndex);
                        qValueStr = qValueStr.trim().toLowerCase();
                        qValueIndex = qValueStr.indexOf(61);
                        qValue = new Double(0.0);
                        if (qValueStr.startsWith("q") && qValueIndex > -1) {
                            qValueStr = qValueStr.substring(qValueIndex + 1);
                            try {
                                qValue = new Double(qValueStr.trim());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    if (language.equals("*")) continue;
                    String key = qValue.toString();
                    Vector<Object> v = languages.containsKey(key) ? languages.get(key) : new Vector();
                    v.addElement(language);
                    languages.put(key, v);
                }
                Vector l = new Vector();
                Enumeration e = languages.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Vector v = (Vector)languages.get(key);
                    Enumeration le = v.elements();
                    while (le.hasMoreElements()) {
                        String language = (String)le.nextElement();
                        String country = "";
                        String variant = "";
                        int countryIndex = language.indexOf(45);
                        if (countryIndex > -1) {
                            country = language.substring(countryIndex + 1).trim();
                            language = language.substring(0, countryIndex).trim();
                            int vDash = country.indexOf("-");
                            if (vDash > 0) {
                                String cTemp = country.substring(0, vDash);
                                variant = country.substring(vDash + 1);
                                country = cTemp;
                            }
                        }
                        this.request.addLocale(new Locale(language, country, variant));
                    }
                }
                continue;
            }
            if (match.equals("cookie")) {
                Cookie[] cookies = RequestUtil.parseCookieHeader(value);
                int i = 0;
                while (i < cookies.length) {
                    if (cookies[i].getName().equals("JSESSIONID") && !this.request.isRequestedSessionIdFromCookie()) {
                        this.request.setRequestedSessionId(cookies[i].getValue());
                        this.request.setRequestedSessionCookie(true);
                        this.request.setRequestedSessionURL(false);
                        if (this.debug >= 1) {
                            this.log(" Requested cookie session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
                        }
                    }
                    this.request.addCookie(cookies[i]);
                    ++i;
                }
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("content-length")) {
                int n = -1;
                try {
                    n = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.contentLength"));
                }
                this.request.setContentLength(n);
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("content-type")) {
                this.request.setContentType(value);
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("host")) {
                int n = value.indexOf(58);
                if (n < 0) {
                    this.request.setServerName(value);
                } else {
                    this.request.setServerName(value.substring(0, n).trim());
                    int port = 80;
                    try {
                        port = Integer.parseInt(value.substring(n + 1).trim());
                    }
                    catch (Exception exception) {
                        throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.portNumber"));
                    }
                    this.request.setServerPort(port);
                }
                this.request.addHeader(name, value);
                continue;
            }
            this.request.addHeader(name, value);
        }
    }

    private void parseRequest(InputStream input) throws IOException, ServletException {
        String line = this.read(input);
        if (line == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.read"));
        }
        StringTokenizer st = new StringTokenizer(line);
        String method = null;
        try {
            method = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            method = null;
        }
        String uri = null;
        try {
            uri = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            uri = null;
        }
        String protocol = null;
        try {
            protocol = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            protocol = "HTTP/0.9";
        }
        if (method == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.method"));
        }
        if (uri == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.uri"));
        }
        int question = uri.indexOf(63);
        if (question >= 0) {
            this.request.setQueryString(uri.substring(question + 1));
            if (this.debug >= 1) {
                this.log(" Query string is " + ((HttpServletRequest)this.request.getRequest()).getQueryString());
            }
            uri = uri.substring(0, question);
        } else {
            this.request.setQueryString(null);
        }
        int semicolon = uri.indexOf(match);
        if (semicolon >= 0) {
            String rest = uri.substring(semicolon + match.length());
            int semicolon2 = rest.indexOf(59);
            if (semicolon2 >= 0) {
                this.request.setRequestedSessionId(rest.substring(0, semicolon2));
                rest = rest.substring(semicolon2);
            } else {
                this.request.setRequestedSessionId(rest);
                rest = "";
            }
            this.request.setRequestedSessionURL(true);
            uri = String.valueOf(uri.substring(0, semicolon)) + rest;
            if (this.debug >= 1) {
                this.log(" Requested URL session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
            }
        } else {
            this.request.setRequestedSessionId(null);
            this.request.setRequestedSessionURL(false);
        }
        this.request.setMethod(method);
        this.request.setProtocol(protocol);
        this.request.setRequestURI(uri);
        this.request.setSecure(false);
        this.request.setScheme("http");
        if (this.debug >= 1) {
            this.log(" Request is " + method + " for " + uri);
        }
    }

    private void process(Socket socket) {
        boolean ok = true;
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            input = new BufferedInputStream(socket.getInputStream(), this.connector.getBufferSize());
            this.request.setStream(input);
            this.request.setResponse(this.response);
            output = socket.getOutputStream();
            this.response.setStream(output);
            this.response.setRequest(this.request);
            ((HttpServletResponse)this.response.getResponse()).setHeader("Server", "Apache Tomcat/4.0.5 (HTTP/1.0 Connector)");
        }
        catch (Exception e) {
            this.log("process.create", e);
            ok = false;
        }
        try {
            if (ok) {
                this.parseConnection(socket);
                this.parseRequest(input);
                if (!this.request.getRequest().getProtocol().startsWith("HTTP/0")) {
                    this.parseHeaders(input);
                }
            }
        }
        catch (Exception e) {
            try {
                this.log("process.parse", e);
                ((HttpServletResponse)this.response.getResponse()).sendError(400);
            }
            catch (Exception exception) {}
        }
        try {
            if (ok) {
                this.connector.getContainer().invoke(this.request, this.response);
            }
        }
        catch (ServletException e) {
            this.log("process.invoke", e);
            try {
                ((HttpServletResponse)this.response.getResponse()).sendError(500);
            }
            catch (Exception exception) {}
            ok = false;
        }
        catch (Throwable e) {
            this.log("process.invoke", e);
            try {
                ((HttpServletResponse)this.response.getResponse()).sendError(500);
            }
            catch (Exception exception) {}
            ok = false;
        }
        try {
            if (ok) {
                this.response.finishResponse();
            }
        }
        catch (IOException e) {
            this.log("FIXME-Exception from finishResponse", e);
        }
        try {
            if (output != null) {
                output.flush();
            }
        }
        catch (IOException e) {
            this.log("FIXME-Exception flushing output", e);
        }
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            this.log("FIXME-Exception closing output", e);
        }
        try {
            if (ok) {
                this.request.finishRequest();
            }
        }
        catch (IOException e) {
            this.log("FIXME-Exception from finishRequest", e);
        }
        try {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
        catch (IOException e) {
            this.log("FIXME-Exception closing input", e);
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            this.log("FIXME-Exception closing socket", e);
        }
        socket = null;
    }

    private String read(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = input.read()) < 0) {
                if (sb.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        if (this.debug >= 2) {
            this.log("  Read: " + sb.toString());
        }
        return sb.toString();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        while (!this.stopped) {
            Socket socket = this.await();
            if (socket == null) continue;
            this.process(socket);
            this.request.recycle();
            this.response.recycle();
            this.connector.recycle(this);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    private void threadStart() {
        this.log(this.sm.getString("httpProcessor.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.debug >= 1) {
            this.log(" Background thread has been started");
        }
    }

    private void threadStop() {
        this.log(this.sm.getString("httpProcessor.stopping"));
        this.stopped = true;
        this.assign(null);
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }
}

