/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.service.Service;
import org.apache.service.ServiceController;

public final class BootstrapService
implements Service {
    private static int debug = 0;
    private static Object catalina = null;
    private Object catalinaService = null;

    private static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    public void load(ServiceController controller, String[] arguments) throws Throwable {
        System.out.println("Create Catalina server");
        this.setCatalinaHome();
        this.setCatalinaBase();
        ClassLoader commonLoader = null;
        ClassLoader catalinaLoader = null;
        ClassLoader sharedLoader = null;
        try {
            File[] unpacked = new File[1];
            File[] packed = new File[1];
            ClassLoaderFactory.setDebug(debug);
            unpacked[0] = new File(BootstrapService.getCatalinaHome(), "common" + File.separator + "classes");
            packed[0] = new File(BootstrapService.getCatalinaHome(), "common" + File.separator + "lib");
            commonLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, null);
            unpacked[0] = new File(BootstrapService.getCatalinaHome(), "server" + File.separator + "classes");
            packed[0] = new File(BootstrapService.getCatalinaHome(), "server" + File.separator + "lib");
            catalinaLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
            unpacked[0] = new File(BootstrapService.getCatalinaHome(), "classes");
            packed[0] = new File(BootstrapService.getCatalinaHome(), "lib");
            sharedLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
        }
        catch (Throwable t) {
            BootstrapService.log("Class loader creation threw exception", t);
        }
        Thread.currentThread().setContextClassLoader(catalinaLoader);
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.catalina.";
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetRequestDispatcher");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetResource");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetResourcePaths");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogMessage");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogException");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogThrowable");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationDispatcher$PrivilegedForward");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationDispatcher$PrivilegedInclude");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "connector.HttpRequestBase$PrivilegedGetSession");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "loader.WebappClassLoader$PrivilegedFindResource");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "session.StandardSession");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "util.CookieTools");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "util.URL");
            catalinaLoader.loadClass(String.valueOf(basePackage) + "util.Enumerator");
            catalinaLoader.loadClass("javax.servlet.http.Cookie");
        }
        if (debug >= 1) {
            BootstrapService.log("Loading startup class");
        }
        Class<?> startupClass = catalinaLoader.loadClass("org.apache.catalina.startup.CatalinaService");
        Object startupInstance = startupClass.newInstance();
        if (debug >= 1) {
            BootstrapService.log("Setting startup class properties");
        }
        String methodName = "setParentClassLoader";
        Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
        Object[] paramValues = new Object[]{sharedLoader};
        Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
        method.invoke(startupInstance, paramValues);
        this.catalinaService = startupInstance;
        if (debug >= 1) {
            BootstrapService.log("Calling startup class load() method");
        }
        methodName = "load";
        method = this.catalinaService.getClass().getMethod(methodName, null);
        method.invoke(this.catalinaService, null);
    }

    private static void log(String message) {
        System.out.print("Bootstrap: ");
        System.out.println(message);
    }

    private static void log(String message, Throwable exception) {
        BootstrapService.log(message);
        exception.printStackTrace(System.out);
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            if ("-debug".equals(args[i])) {
                debug = 1;
            }
            ++i;
        }
        try {
            if (catalina == null) {
                System.out.println("Create Catalina server");
                ClassLoader commonLoader = null;
                ClassLoader catalinaLoader = null;
                ClassLoader sharedLoader = null;
                try {
                    File[] unpacked = new File[1];
                    File[] packed = new File[1];
                    ClassLoaderFactory.setDebug(debug);
                    unpacked[0] = new File(BootstrapService.getCatalinaHome(), "common" + File.separator + "classes");
                    packed[0] = new File(BootstrapService.getCatalinaHome(), "common" + File.separator + "lib");
                    commonLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, null);
                    unpacked[0] = new File(BootstrapService.getCatalinaHome(), "server" + File.separator + "classes");
                    packed[0] = new File(BootstrapService.getCatalinaHome(), "server" + File.separator + "lib");
                    catalinaLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
                    unpacked[0] = new File(BootstrapService.getCatalinaHome(), "classes");
                    packed[0] = new File(BootstrapService.getCatalinaHome(), "lib");
                    sharedLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
                }
                catch (Throwable t) {
                    BootstrapService.log("Class loader creation threw exception", t);
                    System.exit(1);
                }
                Thread.currentThread().setContextClassLoader(catalinaLoader);
                if (System.getSecurityManager() != null) {
                    String basePackage = "org.apache.catalina.";
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetRequestDispatcher");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetResource");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetResourcePaths");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogMessage");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogException");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogThrowable");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationDispatcher$PrivilegedForward");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationDispatcher$PrivilegedInclude");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "connector.HttpRequestBase$PrivilegedGetSession");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "loader.WebappClassLoader$PrivilegedFindResource");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "session.StandardSession");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "util.CookieTools");
                    catalinaLoader.loadClass(String.valueOf(basePackage) + "util.Enumerator");
                    catalinaLoader.loadClass("javax.servlet.http.Cookie");
                }
                if (debug >= 1) {
                    BootstrapService.log("Loading startup class");
                }
                Class<?> startupClass = catalinaLoader.loadClass("org.apache.catalina.startup.CatalinaService");
                Object startupInstance = startupClass.newInstance();
                if (debug >= 1) {
                    BootstrapService.log("Setting startup class properties");
                }
                String methodName = "setParentClassLoader";
                Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
                Object[] paramValues = new Object[]{sharedLoader};
                Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
                method.invoke(startupInstance, paramValues);
                catalina = startupInstance;
            }
            if (debug >= 1) {
                BootstrapService.log("Calling startup class process() method");
            }
            String methodName = "process";
            Class[] paramTypes = new Class[]{args.getClass()};
            Object[] paramValues = new Object[]{args};
            Method method = catalina.getClass().getMethod(methodName, paramTypes);
            method.invoke(catalina, paramValues);
        }
        catch (Exception e) {
            System.out.println("Exception during startup processing");
            e.printStackTrace(System.out);
            System.exit(2);
        }
    }

    private void setCatalinaBase() {
        if (System.getProperty("catalina.base") != null) {
            return;
        }
        if (System.getProperty("catalina.home") != null) {
            System.setProperty("catalina.base", System.getProperty("catalina.home"));
        } else {
            System.setProperty("catalina.base", System.getProperty("user.dir"));
        }
    }

    private void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        System.setProperty("catalina.home", System.getProperty("user.dir"));
    }

    public void start() throws Throwable {
        if (debug >= 1) {
            BootstrapService.log("Calling startup class start() method");
        }
        String methodName = "start";
        Method method = this.catalinaService.getClass().getMethod(methodName, null);
        method.invoke(this.catalinaService, null);
    }

    public void stop() throws Throwable {
        if (debug >= 1) {
            BootstrapService.log("Calling startup class stop() method");
        }
        String methodName = "stop";
        Method method = this.catalinaService.getClass().getMethod(methodName, null);
        method.invoke(this.catalinaService, null);
    }
}

