/*
 * Decompiled with CFR 0.152.
 */
package tyrex.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import tyrex.jdbc.TyrexConnection;
import tyrex.jdbc.TyrexConnectionListener;
import tyrex.jdbc.TyrexStatementImpl;

public final class TyrexResultSetImpl
implements ResultSet,
TyrexConnectionListener {
    private ResultSet _resultSet;
    private TyrexStatementImpl _statement;
    private TyrexConnection _connection;
    private boolean _isClosed;

    public TyrexResultSetImpl(ResultSet resultSet, TyrexConnection tyrexConnection) {
        if (resultSet == null) {
            throw new IllegalArgumentException("The argument 'resultSet' is null.");
        }
        if (tyrexConnection == null) {
            throw new IllegalArgumentException("The argument 'connection' is null.");
        }
        this._resultSet = resultSet;
        this._connection = tyrexConnection;
        this._statement = null;
        this._isClosed = false;
    }

    public TyrexResultSetImpl(ResultSet resultSet, TyrexStatementImpl tyrexStatementImpl) {
        if (resultSet == null) {
            throw new IllegalArgumentException("The argument 'resultSet' is null.");
        }
        if (tyrexStatementImpl == null) {
            throw new IllegalArgumentException("The argument 'statement' is null.");
        }
        this._resultSet = resultSet;
        this._statement = tyrexStatementImpl;
        this._connection = null;
        this._isClosed = false;
    }

    public synchronized boolean absolute(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.absolute(n);
    }

    public synchronized void afterLast() throws SQLException {
        this.validateOpen();
        this._resultSet.afterLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        this.validateOpen();
        this._resultSet.beforeFirst();
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        this.validateOpen();
        this._resultSet.cancelRowUpdates();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.validateOpen();
        this._resultSet.clearWarnings();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws SQLException {
        TyrexStatementImpl tyrexStatementImpl = null;
        ResultSet resultSet = null;
        TyrexConnection tyrexConnection = null;
        try {
            try {
                TyrexResultSetImpl tyrexResultSetImpl = this;
                synchronized (tyrexResultSetImpl) {
                    tyrexStatementImpl = this._statement;
                    resultSet = this._resultSet;
                    tyrexConnection = this._connection;
                    this._statement = null;
                    this._resultSet = null;
                    this._connection = null;
                    resultSet.close();
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            Object var5_5 = null;
            if (tyrexStatementImpl != null) {
                tyrexStatementImpl.resultSetIsClosed(this);
            }
            if (tyrexConnection == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (tyrexStatementImpl != null) {
                tyrexStatementImpl.resultSetIsClosed(this);
            }
            if (tyrexConnection == null) throw throwable;
            tyrexConnection.removeListener(this);
            throw throwable;
        }
        tyrexConnection.removeListener(this);
    }

    public void connectionClosed() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {}
    }

    public synchronized void deleteRow() throws SQLException {
        this.validateOpen();
        this._resultSet.deleteRow();
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.close();
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.findColumn(string);
    }

    public synchronized boolean first() throws SQLException {
        this.validateOpen();
        return this._resultSet.first();
    }

    public synchronized Array getArray(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getArray(n);
    }

    public synchronized Array getArray(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getArray(string);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getAsciiStream(n);
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getAsciiStream(string);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBigDecimal(n);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBigDecimal(n, n2);
    }

    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBigDecimal(string);
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBigDecimal(string, n);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBinaryStream(n);
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBinaryStream(string);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBlob(n);
    }

    public synchronized Blob getBlob(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBlob(string);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBoolean(n);
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBoolean(string);
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getByte(n);
    }

    public synchronized byte getByte(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getByte(string);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBytes(n);
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getBytes(string);
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getCharacterStream(n);
    }

    public synchronized Reader getCharacterStream(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getCharacterStream(string);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getClob(n);
    }

    public synchronized Clob getClob(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getClob(string);
    }

    public synchronized int getConcurrency() throws SQLException {
        this.validateOpen();
        return this._resultSet.getConcurrency();
    }

    public synchronized String getCursorName() throws SQLException {
        this.validateOpen();
        return this._resultSet.getCursorName();
    }

    public synchronized Date getDate(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getDate(n);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.validateOpen();
        return this._resultSet.getDate(n, calendar);
    }

    public synchronized Date getDate(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getDate(string);
    }

    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        this.validateOpen();
        return this._resultSet.getDate(string, calendar);
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getDouble(n);
    }

    public synchronized double getDouble(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getDouble(string);
    }

    public synchronized int getFetchDirection() throws SQLException {
        this.validateOpen();
        return this._resultSet.getFetchDirection();
    }

    public synchronized int getFetchSize() throws SQLException {
        this.validateOpen();
        return this._resultSet.getFetchSize();
    }

    public synchronized float getFloat(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getFloat(n);
    }

    public synchronized float getFloat(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getFloat(string);
    }

    public synchronized int getInt(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getInt(n);
    }

    public synchronized int getInt(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getInt(string);
    }

    public synchronized long getLong(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getLong(n);
    }

    public synchronized long getLong(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getLong(string);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.validateOpen();
        return this._resultSet.getMetaData();
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getObject(n);
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        this.validateOpen();
        return this._resultSet.getObject(n, map);
    }

    public synchronized Object getObject(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getObject(string);
    }

    public synchronized Object getObject(String string, Map map) throws SQLException {
        this.validateOpen();
        return this._resultSet.getObject(string, map);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getRef(n);
    }

    public synchronized Ref getRef(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getRef(string);
    }

    public synchronized int getRow() throws SQLException {
        this.validateOpen();
        return this._resultSet.getRow();
    }

    public synchronized short getShort(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getShort(n);
    }

    public synchronized short getShort(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getShort(string);
    }

    public synchronized Statement getStatement() throws SQLException {
        this.validateOpen();
        if (this._statement == null) {
            Statement statement = this._resultSet.getStatement();
            if (statement == null) {
                return null;
            }
            this._statement = new TyrexStatementImpl(statement, this._connection);
            this._statement.setResultSet(this);
        }
        return this._statement;
    }

    public synchronized String getString(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getString(n);
    }

    public synchronized String getString(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getString(string);
    }

    public synchronized Time getTime(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTime(n);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTime(n, calendar);
    }

    public synchronized Time getTime(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTime(string);
    }

    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTime(string, calendar);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTimestamp(n);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTimestamp(n, calendar);
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTimestamp(string);
    }

    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.validateOpen();
        return this._resultSet.getTimestamp(string, calendar);
    }

    public synchronized int getType() throws SQLException {
        this.validateOpen();
        return this._resultSet.getType();
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.getUnicodeStream(n);
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        this.validateOpen();
        return this._resultSet.getUnicodeStream(string);
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.validateOpen();
        return this._resultSet.getWarnings();
    }

    public synchronized void insertRow() throws SQLException {
        this.validateOpen();
        this._resultSet.insertRow();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        this.validateOpen();
        return this._resultSet.isAfterLast();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.validateOpen();
        return this._resultSet.isBeforeFirst();
    }

    boolean isClosed() {
        return this._resultSet == null;
    }

    public synchronized boolean isFirst() throws SQLException {
        this.validateOpen();
        return this._resultSet.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        this.validateOpen();
        return this._resultSet.isLast();
    }

    public synchronized boolean last() throws SQLException {
        this.validateOpen();
        return this._resultSet.last();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.validateOpen();
        this._resultSet.moveToCurrentRow();
    }

    public synchronized void moveToInsertRow() throws SQLException {
        this.validateOpen();
        this._resultSet.moveToInsertRow();
    }

    public synchronized boolean next() throws SQLException {
        this.validateOpen();
        return this._resultSet.next();
    }

    public synchronized boolean previous() throws SQLException {
        this.validateOpen();
        return this._resultSet.previous();
    }

    public synchronized void refreshRow() throws SQLException {
        this.validateOpen();
        this._resultSet.refreshRow();
    }

    public synchronized boolean relative(int n) throws SQLException {
        this.validateOpen();
        return this._resultSet.relative(n);
    }

    public synchronized boolean rowDeleted() throws SQLException {
        this.validateOpen();
        return this._resultSet.rowDeleted();
    }

    public synchronized boolean rowInserted() throws SQLException {
        this.validateOpen();
        return this._resultSet.rowInserted();
    }

    public synchronized boolean rowUpdated() throws SQLException {
        this.validateOpen();
        return this._resultSet.rowUpdated();
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        this.validateOpen();
        this._resultSet.setFetchDirection(n);
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.validateOpen();
        this._resultSet.setFetchSize(n);
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateOpen();
        this._resultSet.updateAsciiStream(n, inputStream, n2);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.validateOpen();
        this._resultSet.updateAsciiStream(string, inputStream, n);
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBigDecimal(n, bigDecimal);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBigDecimal(string, bigDecimal);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBinaryStream(n, inputStream, n2);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBinaryStream(string, inputStream, n);
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBoolean(n, bl);
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBoolean(string, bl);
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.validateOpen();
        this._resultSet.updateByte(n, by);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.validateOpen();
        this._resultSet.updateByte(string, by);
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBytes(n, byArray);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.validateOpen();
        this._resultSet.updateBytes(string, byArray);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.validateOpen();
        this._resultSet.updateCharacterStream(n, reader, n2);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.validateOpen();
        this._resultSet.updateCharacterStream(string, reader, n);
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.validateOpen();
        this._resultSet.updateDate(n, date);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.validateOpen();
        this._resultSet.updateDate(string, date);
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.validateOpen();
        this._resultSet.updateDouble(n, d);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.validateOpen();
        this._resultSet.updateDouble(string, d);
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.validateOpen();
        this._resultSet.updateFloat(n, f);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.validateOpen();
        this._resultSet.updateFloat(string, f);
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.validateOpen();
        this._resultSet.updateInt(n, n2);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        this.validateOpen();
        this._resultSet.updateInt(string, n);
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        this.validateOpen();
        this._resultSet.updateLong(n, l);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        this.validateOpen();
        this._resultSet.updateLong(string, l);
    }

    public synchronized void updateNull(int n) throws SQLException {
        this.validateOpen();
        this._resultSet.updateNull(n);
    }

    public synchronized void updateNull(String string) throws SQLException {
        this.validateOpen();
        this._resultSet.updateNull(string);
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.validateOpen();
        this._resultSet.updateObject(n, object);
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        this.validateOpen();
        this._resultSet.updateObject(n, object, n2);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.validateOpen();
        this._resultSet.updateObject(string, object);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.validateOpen();
        this._resultSet.updateObject(string, object, n);
    }

    public synchronized void updateRow() throws SQLException {
        this.validateOpen();
        this._resultSet.updateRow();
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        this.validateOpen();
        this._resultSet.updateShort(n, s);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        this.validateOpen();
        this._resultSet.updateShort(string, s);
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        this.validateOpen();
        this._resultSet.updateString(n, string);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        this.validateOpen();
        this._resultSet.updateString(string, string2);
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.validateOpen();
        this._resultSet.updateTime(n, time);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.validateOpen();
        this._resultSet.updateTime(string, time);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.validateOpen();
        this._resultSet.updateTimestamp(n, timestamp);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.validateOpen();
        this._resultSet.updateTimestamp(string, timestamp);
    }

    private void validateOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The result set is closed.");
        }
    }

    public synchronized boolean wasNull() throws SQLException {
        return this._resultSet.wasNull();
    }
}

