/*
 * Decompiled with CFR 0.152.
 */
package tyrex.connector.transaction;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import tyrex.connector.ConnectionEvent;
import tyrex.connector.ConnectionEventListener;
import tyrex.connector.ConnectionEventListenerAdapter;
import tyrex.connector.ConnectionException;
import tyrex.connector.LocalTransaction;
import tyrex.connector.ManagedConnection;
import tyrex.connector.ManagedConnectionFactory;
import tyrex.connector.transaction.AbstractConnectionTransactionManager;
import tyrex.connector.transaction.ConnectionTransactionManager;
import tyrex.connector.transaction.EnlistedResourceFactory;
import tyrex.connector.transaction.EnlistedResourceListener;
import tyrex.connector.transaction.TransactionMediator;
import tyrex.connector.transaction.TransactionType;
import tyrex.tm.EnlistedResource;
import tyrex.tm.TyrexTransactionManager;

public class ConnectionTransactionManagerImpl
extends AbstractConnectionTransactionManager
implements ConnectionTransactionManager,
EnlistedResourceListener {
    private TransactionMediator transactionMediator;
    private TransactionManager transactionManager;
    private final Map entries = new HashMap();
    private final LocalTransactionListener localTransactionListener = new LocalTransactionListener();
    private boolean canEnlistResources;

    public ConnectionTransactionManagerImpl(TransactionMediator transactionMediator, TransactionManager transactionManager) {
        this(transactionMediator, transactionManager, null);
    }

    public ConnectionTransactionManagerImpl(TransactionMediator transactionMediator, TransactionManager transactionManager, PrintWriter printWriter) {
        class Tyrex_connector_transaction_ConnectionTransactionManagerImpl$1 {
            /* synthetic */ Tyrex_connector_transaction_ConnectionTransactionManagerImpl$1() {
            }
        }
        if (transactionMediator == null) {
            throw new IllegalArgumentException("The argument 'transactionMediator' is null.");
        }
        if (transactionManager == null) {
            throw new IllegalArgumentException("The argument 'transactionManager' is null.");
        }
        this.transactionMediator = transactionMediator;
        this.transactionManager = transactionManager;
        this.canEnlistResources = transactionManager instanceof TyrexTransactionManager;
        this.setLogWriter(printWriter);
    }

    protected final void addManagedConnectionEntry(ManagedConnection managedConnection, ManagedConnectionEntry managedConnectionEntry) {
        Map map = this.entries;
        synchronized (map) {
            this.entries.put(managedConnection, managedConnectionEntry);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canBeShared(ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory) throws ConnectionException {
        ManagedConnection managedConnection2 = managedConnection;
        synchronized (managedConnection2) {
            ManagedConnectionEntry managedConnectionEntry = this.getManagedConnectionEntry(managedConnection);
            if (managedConnectionEntry == null) return true;
            if (managedConnectionEntry.transactionType == TransactionType.localTransactionType) {
                return this.getTransactionMediator().canShareLocalTransactions(managedConnectionFactory);
            }
            if (managedConnectionEntry.hasEnlistedResources) return false;
            if (managedConnectionEntry.transaction == this.getCurrentTransaction()) return true;
            return false;
        }
    }

    protected final boolean canEnlistResources() {
        return this.canEnlistResources;
    }

    public final boolean delist(ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory) throws ConnectionException {
        return this.delist(managedConnection, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean delist(ManagedConnection managedConnection, boolean bl) throws ConnectionException {
        ManagedConnection managedConnection2 = managedConnection;
        synchronized (managedConnection2) {
            ManagedConnectionEntry managedConnectionEntry = this.getManagedConnectionEntry(managedConnection);
            if (managedConnectionEntry == null) return true;
            if (managedConnectionEntry.transactionType == TransactionType.localTransactionType) return this.delistLocalTransaction(managedConnection, managedConnectionEntry, bl);
            return this.delistXATransaction(managedConnection, managedConnectionEntry, bl);
        }
    }

    protected boolean delistLocalTransaction(ManagedConnection managedConnection, ManagedConnectionEntry managedConnectionEntry, boolean bl) throws ConnectionException {
        if (managedConnectionEntry.localTransaction == null) {
            this.removeManagedConnectionEntry(managedConnection);
            managedConnection.removeConnectionEventListener(this.getLocalTransactionListener());
            return true;
        }
        if (bl) {
            try {
                try {
                    managedConnectionEntry.localTransaction.rollback();
                    boolean bl2 = true;
                    Object var6_5 = null;
                    managedConnectionEntry.localTransaction = null;
                    this.removeManagedConnectionEntry(managedConnection);
                    managedConnection.removeConnectionEventListener(this.getLocalTransactionListener());
                    return bl2;
                }
                catch (Exception exception) {
                    throw new ConnectionException("Exception occurred while trying delist the manged connection <" + managedConnection + "> in the local transaction <" + managedConnectionEntry.localTransaction + ">", exception);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                managedConnectionEntry.localTransaction = null;
                this.removeManagedConnectionEntry(managedConnection);
                managedConnection.removeConnectionEventListener(this.getLocalTransactionListener());
                throw throwable;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean delistXATransaction(ManagedConnection managedConnection, ManagedConnectionEntry managedConnectionEntry, boolean bl) throws ConnectionException {
        if (managedConnectionEntry.transaction != null) {
            block10: {
                boolean bl2;
                try {
                    try {
                        if (managedConnectionEntry.transaction.getStatus() != 0 && managedConnectionEntry.transaction.getStatus() != 1) break block10;
                        if (managedConnectionEntry.hasEnlistedResources) {
                            if (bl) {
                                ((TyrexTransactionManager)this.getTransactionManager()).discardResource(managedConnectionEntry.xaResource);
                            } else {
                                ((TyrexTransactionManager)this.getTransactionManager()).delistResource(managedConnectionEntry.xaResource);
                            }
                            boolean bl3 = false;
                            Object var6_6 = null;
                            managedConnectionEntry.transaction = null;
                            return bl3;
                        }
                        bl2 = managedConnectionEntry.transaction.delistResource(managedConnectionEntry.xaResource, bl ? 0x20000000 : 0x4000000) && !managedConnectionEntry.hasEnlistedResources;
                    }
                    catch (Exception exception) {
                        if (!(exception instanceof ConnectionException)) {
                            throw new ConnectionException("Exception occurred while trying delist xa resource for <" + managedConnection + "> in the transaction <" + managedConnectionEntry.transaction + ">", exception);
                        }
                        throw (ConnectionException)exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    managedConnectionEntry.transaction = null;
                    throw throwable;
                }
                Object var6_7 = null;
                managedConnectionEntry.transaction = null;
                return bl2;
            }
            Object var6_8 = null;
            managedConnectionEntry.transaction = null;
        }
        if (managedConnectionEntry.hasEnlistedResources && !bl) {
            return false;
        }
        this.removeManagedConnectionEntry(managedConnection);
        return true;
    }

    public final void delisted(ManagedConnection managedConnection) {
        ManagedConnection managedConnection2 = managedConnection;
        synchronized (managedConnection2) {
            ManagedConnectionEntry managedConnectionEntry = this.getManagedConnectionEntry(managedConnection);
            if (managedConnectionEntry != null) {
                managedConnectionEntry.transaction = null;
            } else if (this.getLogWriter() != null) {
                this.getLogWriter().println("Internal error: The entry for the managed connection <" + managedConnection + "> is not found.");
            }
        }
    }

    public final void discard(ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory) throws ConnectionException {
        this.delist(managedConnection, true);
    }

    public final Object enlist(Object object, ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory) throws ConnectionException {
        TransactionType transactionType = this.getTransactionMediator().getTransactionType(managedConnectionFactory);
        if (TransactionType.localTransactionType != transactionType) {
            return this.enlistXATransaction(object, managedConnection, managedConnectionFactory, transactionType);
        }
        return this.enlistLocalTransaction(object, managedConnection, managedConnectionFactory, transactionType);
    }

    protected Object enlistLocalTransaction(Object object, ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory, TransactionType transactionType) throws ConnectionException {
        ManagedConnection managedConnection2 = managedConnection;
        synchronized (managedConnection2) {
            ManagedConnectionEntry managedConnectionEntry = this.getManagedConnectionEntry(managedConnection);
            if (managedConnectionEntry == null) {
                LocalTransaction localTransaction = managedConnection.getLocalTransaction();
                managedConnection.addConnectionEventListener(this.getLocalTransactionListener());
                managedConnectionEntry = new ManagedConnectionEntry(localTransaction, transactionType);
                this.addManagedConnectionEntry(managedConnection, managedConnectionEntry);
            }
            Object object2 = object;
            Object var7_9 = null;
            return object2;
        }
    }

    protected Object enlistXATransaction(Object object, ManagedConnection managedConnection, ManagedConnectionFactory managedConnectionFactory, TransactionType transactionType) throws ConnectionException {
        ManagedConnection managedConnection2 = managedConnection;
        synchronized (managedConnection2) {
            Object object2;
            Object object3 = object;
            XAResource xAResource = managedConnection.getXAResource();
            Transaction transaction = this.getCurrentTransaction();
            boolean bl = false;
            try {
                if (this.canEnlistResources() && (object2 = EnlistedResourceFactory.build(object, managedConnection, this)) != null) {
                    ((TyrexTransactionManager)this.getTransactionManager()).enlistResource(xAResource, (EnlistedResource)object2);
                    object3 = object2;
                    bl = true;
                }
                if (!bl && transaction != null) {
                    transaction.enlistResource(xAResource);
                }
            }
            catch (Exception exception) {
                throw new ConnectionException("Failed to enlist connection <" + object + "> from the managed connection < " + managedConnection + "> with transaction manager <" + this.transactionManager + ">.", exception);
            }
            object2 = this.getManagedConnectionEntry(managedConnection);
            if (object2 == null) {
                object2 = new ManagedConnectionEntry(xAResource, transaction, transactionType, object3 != object);
                this.addManagedConnectionEntry(managedConnection, (ManagedConnectionEntry)object2);
            } else {
                if (((ManagedConnectionEntry)object2).hasEnlistedResources) {
                    throw new ConnectionException("Internal Error: Cannot share managed connections that are enlisted automatically in transactions.");
                }
                if (((ManagedConnectionEntry)object2).transaction != transaction) {
                    throw new ConnectionException("Internal Error: Cannot share managed connections that are not in the same transaction.");
                }
                if (((ManagedConnectionEntry)object2).transactionType != transactionType) {
                    throw new ConnectionException("Internal Error: Cannot share managed connections that are don't have the same transaction type.");
                }
            }
            Object object4 = object3;
            Object var7_13 = null;
            return object4;
        }
    }

    public final void enlisted(ManagedConnection managedConnection, Transaction transaction) {
        ManagedConnection managedConnection2 = managedConnection;
        synchronized (managedConnection2) {
            ManagedConnectionEntry managedConnectionEntry = this.getManagedConnectionEntry(managedConnection);
            if (managedConnectionEntry != null) {
                managedConnectionEntry.transaction = transaction;
            } else if (this.getLogWriter() != null) {
                this.getLogWriter().println("Internal error: The entry for the managed connection <" + managedConnection + "> is not found.");
            }
        }
    }

    protected final Transaction getCurrentTransaction() throws ConnectionException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException systemException) {
            throw new ConnectionException("Failed to get the current transaction", systemException);
        }
    }

    protected final LocalTransactionListener getLocalTransactionListener() {
        return this.localTransactionListener;
    }

    protected final ManagedConnectionEntry getManagedConnectionEntry(ManagedConnection managedConnection) {
        Map map = this.entries;
        synchronized (map) {
            ManagedConnectionEntry managedConnectionEntry = (ManagedConnectionEntry)this.entries.get(managedConnection);
            Object var4_4 = null;
            return managedConnectionEntry;
        }
    }

    protected final TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected final TransactionMediator getTransactionMediator() {
        return this.transactionMediator;
    }

    protected void localTransactionBoundary(ManagedConnection managedConnection) {
        ManagedConnection managedConnection2 = managedConnection;
        synchronized (managedConnection2) {
            ManagedConnectionEntry managedConnectionEntry = this.getManagedConnectionEntry(managedConnection);
            if (managedConnectionEntry != null) {
                managedConnectionEntry.localTransaction = null;
                try {
                    this.delistLocalTransaction(managedConnection, managedConnectionEntry, false);
                }
                catch (ConnectionException connectionException) {
                    if (this.getLogWriter() != null) {
                        this.getLogWriter().println("Internal error: Failed to delist local transaction for <" + managedConnection + ">.");
                        connectionException.printStackTrace(this.getLogWriter());
                    }
                }
            } else if (this.getLogWriter() != null) {
                this.getLogWriter().println("Internal error: The entry for the managed connection <" + managedConnection + "> is not found.");
            }
        }
    }

    protected final void removeManagedConnectionEntry(ManagedConnection managedConnection) {
        Map map = this.entries;
        synchronized (map) {
            this.entries.remove(managedConnection);
        }
    }

    private class LocalTransactionListener
    extends ConnectionEventListenerAdapter
    implements ConnectionEventListener {
        private LocalTransactionListener() {
        }

        public void localTransactionBegun(ConnectionEvent connectionEvent) {
        }

        public void localTransactionCommitted(ConnectionEvent connectionEvent) {
            ConnectionTransactionManagerImpl.this.localTransactionBoundary(connectionEvent.getManagedConnection());
        }

        public void localTransactionRolledback(ConnectionEvent connectionEvent) {
            ConnectionTransactionManagerImpl.this.localTransactionBoundary(connectionEvent.getManagedConnection());
        }
    }

    protected static class ManagedConnectionEntry {
        protected final XAResource xaResource;
        protected Transaction transaction;
        protected LocalTransaction localTransaction;
        protected final TransactionType transactionType;
        protected final boolean hasEnlistedResources;

        protected ManagedConnectionEntry(XAResource xAResource, Transaction transaction, TransactionType transactionType, boolean bl) {
            this.xaResource = xAResource;
            this.transaction = transaction;
            this.transactionType = transactionType;
            this.hasEnlistedResources = bl;
            this.localTransaction = null;
        }

        protected ManagedConnectionEntry(LocalTransaction localTransaction, TransactionType transactionType) {
            this.xaResource = null;
            this.transaction = null;
            this.localTransaction = localTransaction;
            this.hasEnlistedResources = false;
            this.transactionType = transactionType;
        }
    }
}

