/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ParserXJspSax;
import org.xml.sax.Attributes;

public class ParserController {
    private JspCompilationContext ctxt;
    private Stack baseDirStack = new Stack();
    private ParseEventListener jspHandler = null;
    private boolean isXml;
    private static final String JSP_ROOT_TAG = "<jsp:root";
    private boolean isTopFile = true;
    private String topFileEncoding = "ISO-8859-1";
    private String newEncoding;

    public ParserController(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
        this.jspHandler = new JspParseEventListener(ctxt, this);
    }

    private void figureOutJspDocument(String file, String encoding, InputStreamReader reader) throws JasperException {
        JspReader jspReader;
        try {
            jspReader = new JspReader(this.ctxt, file, encoding, reader);
        }
        catch (FileNotFoundException ex) {
            throw new JasperException((Throwable)ex);
        }
        jspReader.setSingleFile(true);
        Mark startMark = jspReader.mark();
        jspReader.reset(startMark);
        Mark mark = jspReader.skipUntil(JSP_ROOT_TAG);
        this.isXml = mark != null;
        this.newEncoding = null;
        if (!this.isXml) {
            jspReader.reset(startMark);
            while (jspReader.skipUntil("<%@") != null) {
                jspReader.skipSpaces();
                if (!jspReader.matches("page")) continue;
                jspReader.advance(4);
                jspReader.skipSpaces();
                Attributes attrs = jspReader.parseTagAttributes();
                String attribute = "pageEncoding";
                this.newEncoding = attrs.getValue("pageEncoding");
                if (this.newEncoding == null) {
                    int loc;
                    String contentType = attrs.getValue("contentType");
                    if (contentType == null || (loc = contentType.indexOf("charset=")) == -1) continue;
                    this.newEncoding = contentType.substring(loc + 8);
                    return;
                }
                return;
            }
        }
    }

    public ParseEventListener getParseEventListener() {
        return this.jspHandler;
    }

    private InputStreamReader getReader(String file, String encoding) throws FileNotFoundException, JasperException {
        try {
            InputStream in = this.ctxt.getResourceAsStream(file);
            if (in == null) {
                throw new FileNotFoundException(file);
            }
            return new InputStreamReader(in, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JasperException(Constants.getString((String)"jsp.error.unsupported.encoding", (Object[])new Object[]{encoding}));
        }
    }

    private void p(String s) {
        System.out.println("[ParserController] " + s);
    }

    private void p(String s, Throwable ex) {
        this.p(s);
        this.p(ex.getMessage());
        ex.printStackTrace();
    }

    public void parse(String inFileName) throws FileNotFoundException, JasperException {
        String absFileName = this.resolveFileName(inFileName);
        String encoding = this.topFileEncoding;
        InputStreamReader reader = null;
        try {
            reader = this.getReader(absFileName, encoding);
            this.figureOutJspDocument(absFileName, encoding, reader);
            String string = encoding = this.newEncoding != null ? this.newEncoding : encoding;
            if (this.isTopFile) {
                this.topFileEncoding = encoding;
                this.isTopFile = false;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            reader = this.getReader(absFileName, encoding);
            this.jspHandler.setDefault(this.isXml);
            if (this.isXml) {
                new ParserXJspSax(absFileName, reader, this.jspHandler).parse();
            } else {
                new Parser(this.ctxt, absFileName, encoding, reader, this.jspHandler).parse();
            }
            this.baseDirStack.pop();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        Object var6_5 = null;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    private String resolveFileName(String inFileName) {
        String fileName = inFileName.replace('\\', '/');
        boolean isAbsolute = fileName.startsWith("/");
        fileName = isAbsolute ? fileName : String.valueOf((String)this.baseDirStack.peek()) + fileName;
        String baseDir = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        this.baseDirStack.push(baseDir);
        return fileName;
    }
}

