/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _MDIOX_H_RPCGEN
#define	_MDIOX_H_RPCGEN

#include <rpc/rpc.h>
#ifndef _KERNEL
#ifdef _REENTRANT
#include <synch.h>
#endif	/* _REENTRANT */
#ifdef _REENTRANT
#include <thread.h>
#endif	/* _REENTRANT */
#endif /* !_KERNEL */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)mdiox.x	2.15	03/10/10 SMI"

/*
 *	MDD interface definitions
 */
/* pick up multihost ioctl definitions */
#include <sys/lvm/md_mhdx.h>
/* get the basic XDR types */
#include <sys/lvm/md_basic.h>
/* pick up device id information */
#include <sys/dditypes.h>

/*
 * fundamental types
 */

/*
 *
 * NOTE: THESE ARE ON-DISK VALUES DO NOT CHANGE THE ORDER
 */

enum mddb_type_t {
	MDDB_ALL = 0,
	MDDB_NM_HDR = 1,
	MDDB_NM = 2,
	MDDB_SHR_NM = 3,
	MDDB_VTOC = 4,
	MDDB_USER = 5,
	MDDB_DID_NM_HDR = 6,
	MDDB_DID_NM = 7,
	MDDB_DID_SHR_NM = 8,
	MDDB_EFILABEL = 9,
	MDDB_FIRST_MODID = 1000
};
typedef enum mddb_type_t mddb_type_t;

/*
 * Configuration commands.
 */

enum mddb_cfgcmd_t {
	MDDB_USEDEV = 0,
	MDDB_NEWDEV = 1,
	MDDB_DELDEV = 2,
	MDDB_GETDEV = 3,
	MDDB_ENDDEV = 4,
	MDDB_GETDRVRNAME = 5,
	MDDB_RELEASESET = 6,
	MDDB_NEWSIDE = 7,
	MDDB_DELSIDE = 8,
	MDDB_SETDID = 9
};
typedef enum mddb_cfgcmd_t mddb_cfgcmd_t;

/*
 * Return codes from DB record operations.
 */

enum mddb_recstatus_t {
	MDDB_NORECORD = 0,
	MDDB_NODATA = 1,
	MDDB_OK = 2,
	MDDB_STALE = 3
};
typedef enum mddb_recstatus_t mddb_recstatus_t;

/*
 * Commands for DB accesses from user land.
 */

enum mddb_usercmd_t {
	MD_DB_GETNEXTREC = 0,
	MD_DB_COMMIT_ONE = 1,
	MD_DB_COMMIT_MANY = 2,
	MD_DB_GETDATA = 3,
	MD_DB_DELETE = 4,
	MD_DB_CREATE = 5,
	MD_DB_GETSTATUS = 6,
	MD_DB_GETSIZE = 7,
	MD_DB_SETDATA = 8,
	MD_DB_MAKEID = 9
};
typedef enum mddb_usercmd_t mddb_usercmd_t;

/*
 * MDDB_USER record subtypes, set records and drive records.
 */

enum mddb_userrec_t {
	MDDB_UR_ALL = 0,
	MDDB_UR_SR = 1,
	MDDB_UR_DR = 2
};
typedef enum mddb_userrec_t mddb_userrec_t;

/*
 * MDDB_USER record get commands.
 */

enum md_ur_get_cmd_t {
	MD_UR_GET_NEXT = 0,
	MD_UR_GET_WKEY = 1
};
typedef enum md_ur_get_cmd_t md_ur_get_cmd_t;

/* 
 * These are the options for mddb_createrec()
 */

enum md_create_rec_option_t {
	MD_CRO_NOOPT = 0x000,
	MD_CRO_OPTIMIZE = 0x001,
	MD_CRO_32BIT = 0x002,
	MD_CRO_64BIT = 0x004,
	MD_CRO_STRIPE = 0x008,
	MD_CRO_MIRROR = 0x010,
	MD_CRO_RAID = 0x020,
	MD_CRO_SOFTPART = 0x040,
	MD_CRO_TRANS_MASTER = 0x080,
	MD_CRO_TRANS_LOG = 0x100,
	MD_CRO_HOTSPARE = 0x200,
	MD_CRO_HOTSPARE_POOL = 0x400
};
typedef enum md_create_rec_option_t md_create_rec_option_t;

/*
 * This SKEW value is used to skew the sideno of
 * the share device names that are put into each
 * local set's namespace.  This will prevent the
 * wrong name to be picked up via a devno, when
 * we really wanted a local device name.
 */
#define	SKEW 1
#define	MD_DRIVE_RECORD_REVISION 0x00010000

#define	MD_DR_ADD	0x00000001U
#define	MD_DR_DEL	0x00000002U
#define	MD_DR_OK	0x80000000U

struct md_drive_record {
	u_int dr_revision;
	u_int dr_flags;
	mddb_recid_t dr_selfid;
	md_timeval32_t dr_ctime;
	u_long dr_genid;
	struct md_drive_record *dr_next;
	mddb_recid_t dr_nextrec;
	int dr_dbcnt;
	int dr_dbsize;
	mdkey_t dr_key;
};
typedef struct md_drive_record md_drive_record;
#define	MD_SET_RECORD_REVISION 0x00010000

#define	MD_SR_ADD	0x00000001U
#define	MD_SR_DEL	0x00000002U
#define	MD_SR_CHECK	0x00000004U
#define	MD_SR_CVT	0x00000008U
#define	MD_SR_LOCAL	0x00000010U
#define	MD_SR_AUTO_TAKE	0x20000000U
#define	MD_SR_OK	0x80000000U
#define	MD_SR_STATE_FLAGS (MD_SR_ADD | \
				   MD_SR_DEL | \
				   MD_SR_CHECK | \
				   MD_SR_CVT | \
				   MD_SR_OK)

struct md_set_record {
	u_int sr_revision;
	u_int sr_flags;
	mddb_recid_t sr_selfid;
	struct md_set_record *sr_next;
	set_t sr_setno;
	md_set_nm_t sr_setname;
	md_timeval32_t sr_ctime;
	u_long sr_genid;
	md_node_nm_arr_t sr_nodes;
	md_drive_record *sr_drivechain;
	mddb_recid_t sr_driverec;
	mhd_mhiargs_t sr_mhiargs;
	md_h_arr_t sr_med;
};
typedef struct md_set_record md_set_record;

#define	MD_SETOWNER_NO		0
#define	MD_SETOWNER_YES		1
#define	MD_SETOWNER_NONE	2

/* Gate key type */

struct md_setkey_t {
	char *sk_host;
	set_t sk_setno;
	char *sk_setname;
	md_timeval32_t sk_key;
	struct md_setkey_t *sk_next;
};
typedef struct md_setkey_t md_setkey_t;

/* metadevice ID */

typedef minor_t unit_t;

/* component ID */

struct comp_t {
	minor_t mnum;
	md_dev64_t dev;
};
typedef struct comp_t comp_t;

/* hotspare pool ID */

typedef u_int hsp_t;

#define	MD_HSP_NONE	((hsp_t)~0U)

/* hotspare ID */

struct hs_t {
	hsp_t hsp;
	md_dev64_t dev;
};
typedef struct hs_t hs_t;

/* mnum or hsp */

typedef u_int minor_or_hsp_t;

/*
 * name service stuff
 */
#define	MD_MAXPREFIX 127

#define	MD_MAX_CTDLEN	64

struct md_name_prefix {
	u_char pre_len;
	char pre_data[MD_MAXPREFIX];
};
typedef struct md_name_prefix md_name_prefix;
#define	MD_MAXSUFFIX 40


struct md_name_suffix {
	u_char suf_prefix;
	u_char suf_len;
	char suf_data[MD_MAXSUFFIX];
};
typedef struct md_name_suffix md_name_suffix;

struct md_splitname {
	md_name_prefix sn_prefix;
	md_name_suffix sn_suffix;
};
typedef struct md_splitname md_splitname;

#define	SPN_PREFIX(spn)	((spn)->sn_prefix)
#define	SPN_SUFFIX(spn)	((spn)->sn_suffix)

/*
 * Number of bits to represent a setno
 * this gives us all info to define masks and shifts ...
 * Also used for minor #, hsp id, recid mask and shifts.
 */
#define	MD_BITSSET 5
#define	MD_DEFAULTSETS 4


#define	MD_MAXSETS	(1 << MD_BITSSET)
#define	MD_SETMASK	(MD_MAXSETS - 1)

/*
 * Define a file descriptor for lockfd
 * when the lock is not held.
 */
#define	MD_NO_LOCK -2

/*
 * accumulated setname
 */

struct mdsetname_t {
	char *setname;
	set_t setno;
	struct md_set_desc *setdesc;
	int lockfd;
};
typedef struct mdsetname_t mdsetname_t;

struct mdsetnamelist_t {
	struct mdsetnamelist_t *next;
	mdsetname_t *sp;
};
typedef struct mdsetnamelist_t mdsetnamelist_t;

/*
 * device name
 */
#define	MD_FULLNAME_ONLY	0x0
#define	MD_BASICNAME_OK	0x1
#define	MD_BYPASS_DAEMON	0x2

#define	MD_SLICE0		0
#define	MD_SLICE6		6
#define	MD_SLICE7		7

#define	MD_MAX_PARTS		17

struct mdname_t {
	struct mddrivename_t *drivenamep;
	char *cname;
	char *bname;
	char *rname;
	char *devicesname;
	md_dev64_t dev;
	mdkey_t key;
	diskaddr_t end_blk;
	diskaddr_t start_blk;
};
typedef struct mdname_t mdname_t;

struct mdnamelist_t {
	struct mdnamelist_t *next;
	mdname_t *namep;
};
typedef struct mdnamelist_t mdnamelist_t;

/*
 * drive name
 */
/* name types */

enum mdnmtype_t {
	MDT_UNKNOWN = 0,
	MDT_ACCES = 0 + 1,
	MDT_META = 0 + 2,
	MDT_COMP = 0 + 3,
	MDT_FAST_META = 0 + 4,
	MDT_FAST_COMP = 0 + 5
};
typedef enum mdnmtype_t mdnmtype_t;
/* metadevice types */

enum md_types_t {
	MD_UNDEFINED = 0,
	MD_DEVICE = 0 + 1,
	MD_METAMIRROR = 0 + 2,
	MD_METATRANS = 0 + 3,
	MD_METARAID = 0 + 4,
	MD_METASP = 0 + 5
};
typedef enum md_types_t md_types_t;

/* misc module names */
#define	MD_STRIPE	"md_stripe"
#define	MD_MIRROR	"md_mirror"
#define	MD_TRANS	"md_trans"
#define	MD_HOTSPARES	"md_hotspares"
#define	MD_RAID		"md_raid"
#define	MD_VERIFY	"md_verify"
#define	MD_SP		"md_sp"
#define	MD_NOTIFY	"md_notify"
/* generic device info */

struct mdgeom_t {
	u_int ncyl;
	u_int nhead;
	u_int nsect;
	u_int rpm;
	u_int write_reinstruct;
	u_int read_reinstruct;
	u_int blk_sz;
};
typedef struct mdgeom_t mdgeom_t;

struct mdcinfo_t {
	char cname[16];
	mhd_ctlrtype_t ctype;
	u_int cnum;
	u_int tray;
	u_int bus;
	u_longlong_t wwn;
	char dname[16];
	u_int unit;
	u_int maxtransfer;
};
typedef struct mdcinfo_t mdcinfo_t;

struct mdpart_t {
	diskaddr_t start;
	diskaddr_t size;
	u_short tag;
	u_short flag;
	diskaddr_t label;
};
typedef struct mdpart_t mdpart_t;

struct mdvtoc_t {
	u_int nparts;
	diskaddr_t first_lba;
	diskaddr_t last_lba;
	diskaddr_t lbasize;
	mdpart_t parts[MD_MAX_PARTS];
	char *typename;
};
typedef struct mdvtoc_t mdvtoc_t;

/*
 * List of drivename cnames per side,
 * also the driver name, mnum (for slice 7).
 */

struct mdsidenames_t {
	struct mdsidenames_t *next;
	side_t sideno;
	minor_t mnum;
	char *dname;
	char *cname;
};
typedef struct mdsidenames_t mdsidenames_t;

struct mddrivename_t {
	char *cachenm;
	char *cname;
	char *rname;
	mdnmtype_t type;
	int errnum;
	mdgeom_t geom;
	mdcinfo_t cinfo;
	mdvtoc_t vtoc;
	struct {
		u_int parts_len;
		mdname_t *parts_val;
	} parts;
	mdsidenames_t *side_names;
	mdkey_t side_names_key;
	char *miscname;
	struct md_common_t *unitp;
};
typedef struct mddrivename_t mddrivename_t;

struct mddrivenamelist_t {
	struct mddrivenamelist_t *next;
	mddrivename_t *drivenamep;
};
typedef struct mddrivenamelist_t mddrivenamelist_t;

/*
 * replica struct
 */

typedef u_int replica_flags_t;

#define	MDDB_F_EREAD	0x00001	/* a read error occurred */
#define	MDDB_F_TOOSMALL	0x00002	/* replica is too small to hold db */
#define	MDDB_F_EFMT	0x00004	/* something is wrong with the data */
#define	MDDB_F_EDATA	0x00008	/* error in data blocks */
#define	MDDB_F_EMASTER	0x00010	/* error in master block(s) */
#define	MDDB_F_ACTIVE	0x00020	/* this replica is currently in use */
#define	MDDB_F_EWRITE	0x00040	/* a write error occurred */
#define	MDDB_F_MASTER	0x00080	/* the copy which was used as input */
#define	MDDB_F_SUSPECT	0x00100	/* replica write ability is suspect */
#define	MDDB_F_PTCHED	0x00400	/* db location was patched in kernel */
#define	MDDB_F_IOCTL	0x00800	/* db location passed in from ioctl */
#define	MDDB_F_GOTTEN	0x01000	/* getdev has been done on this dev */
#define	MDDB_F_LOCACC	0x02000	/* the locator has been accessed */
#define	MDDB_F_UP2DATE	0x04000	/* this copy of db is up to date */
#define	MDDB_F_OLDACT	0x08000	/* this copy was active previously */
#define	MDDB_F_DELETED	0x10000 /* place holder in empty slot */
#define	MDDB_F_TAGDATA	0x20000 /* Data is tagged */
#define	MDDB_F_BADTAG	0x40000 /* Data tag was not valid */
#define	MDDB_F_NODEVID	0x80000 /* No devid associated with replica */

/*
 * These are used in de_flags only
 * Do not change these values, they are stored on-disk
 */
#define	MDDB_F_STRIPE		0x00001 /* record is a stripe record */
#define	MDDB_F_MIRROR		0x00002 /* record is a mirror record */
#define	MDDB_F_RAID		0x00004 /* record is a raid record */
#define	MDDB_F_SOFTPART		0x00008 /* record is a sp record */
#define	MDDB_F_TRANS_MASTER	0x00010 /* trans master record */
#define	MDDB_F_TRANS_LOG	0x00020 /* trans log record */
#define	MDDB_F_HOTSPARE		0x00040 /* hotspare record */
#define	MDDB_F_HOTSPARE_POOL	0x00080 /* hotspare record */
#define	MDDB_F_OPT		0x00200	/* optimization record */
/* used by metadb(1m) for printing */
#define	MDDB_FLAGS_STRING	"RSFDMaWm  pc luo tBr"
#define	MDDB_FLAGS_LEN		(strlen(MDDB_FLAGS_STRING))

/*
 * See meta_prbits() in SUNWmd/lib/libmeta/meta_print.c for a description of
 * the way this is used
 */
#define	MDDB_F_BITNAMES	"\020\001EREAD\002TOOSMALL\003EFMT\004EDATA" \
				"\005EMASTER\006ACTIVE\007EWRITE\010MASTER" \
				"\011SUSPECT\012OPT\013PTCHED\014IOCTL" \
				"\015GOTTEN\016LOCACC\017UP2DATE\020OLDACT" \
				"\021DELETED\022TAGDATA\023BADTAG\024NORELOC"


struct md_replica_t {
	mdname_t *r_namep;
	replica_flags_t r_flags;
	daddr_t r_blkno;
	daddr_t r_nblk;
	ddi_devid_t r_devid;
	char r_driver_name[MD_MAXDRVNM];
	char r_minor_name[MDDB_MINOR_NAME_MAX];
};
typedef struct md_replica_t md_replica_t;

struct md_replicalist_t {
	struct md_replicalist_t *rl_next;
	md_replica_t *rl_repp;
};
typedef struct md_replicalist_t md_replicalist_t;

/*
 * set/drive structs exposed by the library routines
 */

struct md_drive_desc {
	md_timeval32_t dd_ctime;
	u_long dd_genid;
	u_int dd_flags;
	struct md_drive_desc *dd_next;
	mddrivename_t *dd_dnp;
	int dd_dbcnt;
	int dd_dbsize;
};
typedef struct md_drive_desc md_drive_desc;

struct md_set_desc {
	md_timeval32_t sd_ctime;
	u_long sd_genid;
	set_t sd_setno;
	u_int sd_flags;
	md_node_nm_arr_t sd_nodes;
	int sd_isown[MD_MAXSIDES];
	md_h_arr_t sd_med;
	md_drive_desc *sd_drvs;
};
typedef struct md_set_desc md_set_desc;

/*
 * hotspare pool name
 */

struct mdhspname_t {
	char *hspname;
	hsp_t hsp;
	struct md_hsp_t *unitp;
};
typedef struct mdhspname_t mdhspname_t;

struct mdhspnamelist_t {
	struct mdhspnamelist_t *next;
	mdhspname_t *hspnamep;
};
typedef struct mdhspnamelist_t mdhspnamelist_t;

/*
 *	generic metadevice descriptions for status and init
 */

/*
 * following used with un_status
 * bottom 16 bits are global definitions
 * top 16 bits are defined by sub device
 */

typedef u_int md_status_t;

#define	MD_UN_GROW_PENDING	0x0008	/* grow mirror pending */
#define	MD_UN_BEING_RESET	0x0040	/* reset at snarf time */

/*
 * following are used with un_parent
 *	MD_NO_PARENT	- Not a sub-device.
 *	MD_MULTI_PARENT	- A sub-device with one or more parents, like a log.
 *	other		- A sub-device with only one parent, like a submirror.
 *			  The number is the parent's unit number.
 */

typedef unit_t md_parent_t;

#define	MD_NO_PARENT		0xffffffffu
#define	MD_MULTI_PARENT		0xfffffffeu
#define	MD_HAS_PARENT(p)	((p) != MD_NO_PARENT)

typedef u_int md_stackcap_t;

#define	MD_CANT_PARENT		0x00	/* cannot have a parent */
#define	MD_CAN_PARENT		0x01	/* can have a parent */
#define	MD_CAN_SUB_MIRROR	0x02	/* can be a sub-mirror */
#define	MD_CAN_META_CHILD	0x04	/* can have metadev. children */
#define	MD_CAN_SP		0x08	/* can be soft partitioned */

struct md_common_t {
	mdname_t *namep;
	md_types_t type;
	md_status_t state;
	md_stackcap_t capabilities;
	md_parent_t parent;
	diskaddr_t size;
	u_long user_flags;
	u_longlong_t revision;
};
typedef struct md_common_t md_common_t;

/*
 *	stripe
 */

struct ms_params_t {
	int change_hsp_id;
	hsp_t hsp_id;
};
typedef struct ms_params_t ms_params_t;

typedef u_int comp_state_t;

#define	CS_OKAY		0x0001
#define	CS_ERRED	0x0002
#define	CS_RESYNC	0x0004
#define	CS_LAST_ERRED	0x0008

/* interlace values (in bytes) */
#define	MININTERLACE	(16 * 512)
#define	MAXINTERLACE	(100 * 1024 * 1024)

struct md_comp_t {
	mdname_t *compnamep;
	mdname_t *hsnamep;
	comp_state_t state;
	u_int lasterrcnt;
	md_timeval32_t timestamp;
};
typedef struct md_comp_t md_comp_t;

struct md_row_t {
	diskaddr_t interlace;
	diskaddr_t row_size;
	struct {
		u_int comps_len;
		md_comp_t *comps_val;
	} comps;
};
typedef struct md_row_t md_row_t;

struct md_stripe_t {
	md_common_t common;
	mdhspname_t *hspnamep;
	struct {
		u_int rows_len;
		md_row_t *rows_val;
	} rows;
};
typedef struct md_stripe_t md_stripe_t;

/*
 *	soft partition
 */

typedef uint64_t xsp_offset_t;

typedef uint64_t xsp_length_t;

typedef u_int xsp_status_t;

#define	SP_INIT		0x0001
#define	SP_OK		0x0002
#define	SP_LASTERR	0x0004


struct md_sp_ext_t {
	xsp_offset_t voff;
	xsp_offset_t poff;
	xsp_length_t len;
};
typedef struct md_sp_ext_t md_sp_ext_t;

struct md_sp_t {
	md_common_t common;
	mdname_t *compnamep;
	xsp_status_t status;
	struct {
		u_int ext_len;
		md_sp_ext_t *ext_val;
	} ext;
};
typedef struct md_sp_t md_sp_t;

/*
 *	mirror
 */

enum mm_wr_opt_t {
	WR_PARALLEL = 0,
	WR_SERIAL = 0 + 1
};
typedef enum mm_wr_opt_t mm_wr_opt_t;

enum mm_rd_opt_t {
	RD_LOAD_BAL = 0,
	RD_GEOMETRY = 0 + 1,
	RD_FIRST = 0 + 2
};
typedef enum mm_rd_opt_t mm_rd_opt_t;

typedef short mm_pass_num_t;
#define	MD_PASS_DEFAULT 1
#define	MD_PASS_MAX 9

struct mm_params_t {
	int change_read_option;
	mm_rd_opt_t read_option;
	int change_write_option;
	mm_wr_opt_t write_option;
	int change_pass_num;
	mm_pass_num_t pass_num;
};
typedef struct mm_params_t mm_params_t;

typedef u_int sm_state_t;

#define	SMS_UNUSED		0x0000
#define	SMS_RUNNING		0x0001
#define	SMS_COMP_ERRED		0x0002
#define	SMS_COMP_RESYNC		0x0004
#define	SMS_ATTACHED		0x0008
#define	SMS_ATTACHED_RESYNC	0x0010
#define	SMS_OFFLINE		0x0020
#define	SMS_OFFLINE_RESYNC	0x0040
#define	SMS_ALL_ERRED		0x0080
#define	SMS_INUSE		(0xffff)
#define	SMS_LIMPING		(SMS_COMP_ERRED | SMS_COMP_RESYNC)
#define	SMS_IGNORE		0x4000
#define	SMS_ACTIVE (SMS_RUNNING | SMS_COMP_ERRED | SMS_COMP_RESYNC \
			    SMS_ATTACHED_RESYNC | SMS_OFFLINE_RESYNC)

typedef u_int sm_flags_t;

#define	MD_SM_RESYNC_TARGET	0x0001
#define	MD_SM_FAILFAST		0x0002

struct md_submirror_t {
	mdname_t *submirnamep;
	sm_state_t state;
	sm_flags_t flags;
	md_timeval32_t timestamp;
};
typedef struct md_submirror_t md_submirror_t;

#define	MD_UN_RESYNC_ACTIVE	0x00010000
#define	MD_UN_WAR		0x00020000
#define	MD_UN_OFFLINE_SM	0x00040000
#define	MD_UN_OPT_NOT_DONE	0x00080000
#define	MD_UN_KEEP_DIRTY	(MD_UN_OFFLINE_SM | MD_UN_OPT_NOT_DONE)
#define	MD_UN_RESYNC_CANCEL	0x00100000
#define	MD_UN_REPLAYED		0x00200000
#define	MD_UN_RENAMING		0x00400000
#define	MD_UN_MOD_INPROGRESS	(MD_UN_RESYNC_ACTIVE	|	\
					 MD_UN_OPT_NOT_DONE	|	\
					 MD_UN_RENAMING)
#define	NMIRROR 4

struct md_mirror_t {
	md_common_t common;
	mm_rd_opt_t read_option;
	mm_wr_opt_t write_option;
	mm_pass_num_t pass_num;
	int percent_done;
	int percent_dirty;
	md_submirror_t submirrors[NMIRROR];
};
typedef struct md_mirror_t md_mirror_t;

/*
 *	trans
 */
/*
 * unit structure
 */

typedef u_int mt_flags_t;

#define	TRANS_NEED_OPEN		0x0001	/* subdevs are unopened */
#define	TRANS_OPENED		0x0002	/* open at snarf succeeded */
#define	TRANS_DETACHING		0x0004	/* detaching the log */
#define	TRANS_DETACHED		0x0008	/* log successfully detached */
#define	TRANS_DETACH_SKIP	0x0010	/* already processed; skip */
#define	TRANS_ATTACHING		0x0020	/* attaching the log */
#define	TRANS_ROLL_ON_WRITE	0x0040	/* roll on physio write */
#define	TRANS_NEED_SCANROLL	0x0080	/* roll on physio write */

typedef u_int mt_l_error_t;

#define	LDL_ERROR	0x0001	/* error state */
#define	LDL_HERROR	0x0002	/* hard error state */
#define	LDL_ANYERROR	0x0003	/* any error state */
#define	LDL_NOERROR	0x0004	/* dont error transition during scan */
#define	LDL_SAVERROR	0x0008	/* transition to error after scan */

typedef u_int mt_debug_t;

struct md_trans_t {
	md_common_t common;
	mdname_t *masternamep;
	mdname_t *lognamep;
	mt_flags_t flags;
	md_timeval32_t timestamp;
	mt_l_error_t log_error;
	md_timeval32_t log_timestamp;
	daddr_t log_size;
	mt_debug_t debug;
};
typedef struct md_trans_t md_trans_t;

/*
 *	RAID
 */

struct mr_params_t {
	int change_hsp_id;
	hsp_t hsp_id;
};
typedef struct mr_params_t mr_params_t;

enum rcs_state_t {
	RCS_UNUSED = 0x0,
	RCS_INIT = 0x1,
	RCS_OKAY = 0x2,
	RCS_ERRED = 0x4,
	RCS_LAST_ERRED = 0x8,
	RCS_RESYNC = 0x10,
	RCS_INIT_ERRED = 0x20,
	RCS_REGEN = 0x40
};
typedef enum rcs_state_t rcs_state_t;

typedef u_int rcs_flags_t;

#define	MD_RAID_DEV_ISOPEN	0x00001
#define	MD_RAID_ALT_ISOPEN	0x00002
#define	MD_RAID_RESYNC		0x00004
#define	MD_RAID_RESYNC_ERRED	0x00008
#define	MD_RAID_FORCE_REPLACE   0x00010
#define	MD_RAID_WRITE_ALT       0x00020
#define	MD_RAID_DEV_ERRED       0x00040
#define	MD_RAID_COPY_RESYNC	0x00080
#define	MD_RAID_REGEN_RESYNC	0x00100
#define	MD_RAID_DEV_PROBEOPEN	0x00200
#define	MD_RAID_HAS_LABEL       0x40000

struct md_raidcol_t {
	mdname_t *colnamep;
	mdname_t *hsnamep;
	rcs_state_t state;
	rcs_flags_t flags;
	md_timeval32_t timestamp;
};
typedef struct md_raidcol_t md_raidcol_t;

enum rus_state_t {
	RUS_UNUSED = 0x0,
	RUS_INIT = 0x1,
	RUS_OKAY = 0x2,
	RUS_ERRED = 0x4,
	RUS_LAST_ERRED = 0x8,
	RUS_DOI = 0x10,
	RUS_REGEN = 0x20
};
typedef enum rus_state_t rus_state_t;

typedef u_int md_riflags_t;

#define	MD_RI_INPROGRESS	0x0001
#define	MD_GROW_INPROGRESS	0x0002
#define	MD_RAID_MIN 3

struct md_raid_t {
	md_common_t common;
	rus_state_t state;
	md_timeval32_t timestamp;
	diskaddr_t interlace;
	diskaddr_t column_size;
	size_t orig_ncol;
	mdhspname_t *hspnamep;
	md_riflags_t resync_flags;
	int percent_dirty;
	int percent_done;
	int pw_count;
	struct {
		u_int cols_len;
		md_raidcol_t *cols_val;
	} cols;
};
typedef struct md_raid_t md_raid_t;

/*
 *	shared
 */

struct md_shared_t {
	md_common_t common;
};
typedef struct md_shared_t md_shared_t;

/*
 *	hotspare
 */

enum hotspare_states_t {
	HSS_UNUSED = 0,
	HSS_AVAILABLE = 1,
	HSS_RESERVED = 2,
	HSS_BROKEN = 3
};
typedef enum hotspare_states_t hotspare_states_t;

struct md_hs_t {
	mdname_t *hsnamep;
	hotspare_states_t state;
	diskaddr_t size;
	md_timeval32_t timestamp;
	u_longlong_t revision;
};
typedef struct md_hs_t md_hs_t;

struct md_hsp_t {
	mdhspname_t *hspnamep;
	u_int refcount;
	struct {
		u_int hotspares_len;
		md_hs_t *hotspares_val;
	} hotspares;
};
typedef struct md_hsp_t md_hsp_t;

/*
 * specific error info
 */

/*
 * simple errors
 */

enum md_void_errno_t {
	MDE_NONE = 0,
	MDE_UNIT_NOT_FOUND = 0 + 1,
	MDE_DUPDRIVE = 0 + 2,
	MDE_INVAL_HSOP = 0 + 3,
	MDE_NO_SET = 0 + 4,
	MDE_SET_DIFF = 0 + 5,
	MDE_BAD_RD_OPT = 0 + 6,
	MDE_BAD_WR_OPT = 0 + 7,
	MDE_BAD_PASS_NUM = 0 + 8,
	MDE_BAD_INTERLACE = 0 + 9,
	MDE_NO_HSPS = 0 + 10,
	MDE_NOTENOUGH_DB = 0 + 11,
	MDE_DELDB_NOTALLOWED = 0 + 12,
	MDE_DEL_VALIDDB_NOTALLOWED = 0 + 13,
	MDE_SYSTEM_FILE = 0 + 14,
	MDE_MDDB_FILE = 0 + 15,
	MDE_MDDB_CKSUM = 0 + 16,
	MDE_VFSTAB_FILE = 0 + 17,
	MDE_NOSLICE = 0 + 18,
	MDE_SYNTAX = 0 + 19,
	MDE_OPTION = 0 + 20,
	MDE_TAKE_OWN = 0 + 21,
	MDE_NOT_DRIVENAME = 0 + 22,
	MDE_RESERVED = 0 + 23,
	MDE_DVERSION = 0 + 24,
	MDE_MVERSION = 0 + 25,
	MDE_TESTERROR = 0 + 26,
	MDE_BAD_ORIG_NCOL = 0 + 27,
	MDE_RAID_INVALID = 0 + 28,
	MDE_MED_ERROR = 0 + 29,
	MDE_TOOMANYMED = 0 + 30,
	MDE_NOMED = 0 + 31,
	MDE_ONLYNODENAME = 0 + 32,
	MDE_RAID_BAD_PW_CNT = 0 + 33,
	MDE_DEVID_TOOBIG = 0 + 34,
	MDE_NOPERM = 0 + 35,
	MDE_NODEVID = 0 + 36,
	MDE_NOROOT = 0 + 37
};
typedef enum md_void_errno_t md_void_errno_t;

struct md_void_error_t {
	md_void_errno_t errnum;
};
typedef struct md_void_error_t md_void_error_t;

/*
 * system errors
 */

struct md_sys_error_t {
	int errnum;
};
typedef struct md_sys_error_t md_sys_error_t;

/*
 * RPC errors
 */

struct md_rpc_error_t {
	enum clnt_stat errnum;
};
typedef struct md_rpc_error_t md_rpc_error_t;

/*
 * device errors
 */

enum md_dev_errno_t {
	MDE_INVAL_HS = 1,
	MDE_FIX_INVAL_STATE = 1 + 1,
	MDE_FIX_INVAL_HS_STATE = 1 + 2,
	MDE_NOT_META = 1 + 3,
	MDE_IS_META = 1 + 4,
	MDE_IS_SWAPPED = 1 + 5,
	MDE_NAME_SPACE = 1 + 6,
	MDE_IN_SHARED_SET = 1 + 7,
	MDE_NOT_IN_SET = 1 + 8,
	MDE_NOT_DISK = 1 + 9,
	MDE_CANT_CONFIRM = 1 + 10,
	MDE_INVALID_PART = 1 + 11,
	MDE_HAS_MDDB = 1 + 12,
	MDE_NO_DB = 1 + 13,
	MDE_CANTVERIFY_VTOC = 1 + 14,
	MDE_NOT_LOCAL = 1 + 15,
	MDE_DEVICES_NAME = 1 + 16,
	MDE_REPCOMP_INVAL = 1 + 17,
	MDE_REPCOMP_ONLY = 1 + 18,
	MDE_INV_ROOT = 1 + 19,
	MDE_MULTNM = 1 + 20,
	MDE_TOO_MANY_PARTS = 1 + 21
};
typedef enum md_dev_errno_t md_dev_errno_t;

struct md_dev_error_t {
	md_dev_errno_t errnum;
	md_dev64_t dev;
};
typedef struct md_dev_error_t md_dev_error_t;

/*
 * use errors
 */

enum md_use_errno_t {
	MDE_IS_MOUNTED = 1,
	MDE_ALREADY = 1 + 1,
	MDE_OVERLAP = 1 + 2
};
typedef enum md_use_errno_t md_use_errno_t;


struct md_use_error_t {
	md_use_errno_t errnum;
	md_dev64_t dev;
	char *where;
};
typedef struct md_use_error_t md_use_error_t;

/*
 * metadevice errors
 */

enum md_md_errno_t {
	MDE_INVAL_UNIT = 1,
	MDE_UNIT_NOT_SETUP = 1 + 1,
	MDE_UNIT_ALREADY_SETUP = 1 + 2,
	MDE_NOT_MM = 1 + 3,
	MDE_NOT_ENOUGH_DBS = 1 + 4,
	MDE_IS_SM = 1 + 5,
	MDE_IS_OPEN = 1 + 6,
	MDE_C_WITH_INVAL_SM = 1 + 7,
	MDE_RESYNC_ACTIVE = 1 + 8,
	MDE_LAST_SM_RE = 1 + 9,
	MDE_MIRROR_FULL = 1 + 10,
	MDE_IN_USE = 1 + 11,
	MDE_SM_TOO_SMALL = 1 + 12,
	MDE_NO_LABELED_SM = 1 + 13,
	MDE_SM_OPEN_ERR = 1 + 14,
	MDE_CANT_FIND_SM = 1 + 15,
	MDE_LAST_SM = 1 + 16,
	MDE_NO_READABLE_SM = 1 + 17,
	MDE_SM_FAILED_COMPS = 1 + 18,
	MDE_ILLEGAL_SM_STATE = 1 + 19,
	MDE_RR_ALLOC_ERROR = 1 + 20,
	MDE_MIRROR_OPEN_FAILURE = 1 + 21,
	MDE_MIRROR_THREAD_FAILURE = 1 + 22,
	MDE_GROW_DELAYED = 1 + 23,
	MDE_NOT_MT = 1 + 24,
	MDE_HS_IN_USE = 1 + 25,
	MDE_HAS_LOG = 1 + 26,
	MDE_UNKNOWN_TYPE = 1 + 27,
	MDE_NOT_STRIPE = 1 + 28,
	MDE_NOT_RAID = 1 + 29,
	MDE_NROWS = 1 + 30,
	MDE_NCOMPS = 1 + 31,
	MDE_NSUBMIRS = 1 + 32,
	MDE_BAD_STRIPE = 1 + 33,
	MDE_BAD_MIRROR = 1 + 34,
	MDE_BAD_TRANS = 1 + 35,
	MDE_BAD_RAID = 1 + 36,
	MDE_RAID_OPEN_FAILURE = 1 + 37,
	MDE_RAID_THREAD_FAILURE = 1 + 38,
	MDE_RAID_NEED_FORCE = 1 + 39,
	MDE_NO_LOG = 1 + 40,
	MDE_RAID_DOI = 1 + 41,
	MDE_RAID_LAST_ERRED = 1 + 42,
	MDE_RAID_NOT_OKAY = 1 + 43,
	MDE_RENAME_BUSY = 1 + 44,
	MDE_RENAME_SOURCE_BAD = 1 + 45,
	MDE_RENAME_TARGET_BAD = 1 + 46,
	MDE_RENAME_TARGET_UNRELATED = 1 + 47,
	MDE_RENAME_CONFIG_ERROR = 1 + 48,
	MDE_RENAME_ORDER = 1 + 49,
	MDE_RECOVER_FAILED = 1 + 50,
	MDE_NOT_SP = 1 + 51,
	MDE_SP_NOSPACE = 1 + 52,
	MDE_SP_BADWMREAD = 1 + 53,
	MDE_SP_BADWMWRITE = 1 + 54,
	MDE_SP_BADWMMAGIC = 1 + 55,
	MDE_SP_BADWMCRC = 1 + 56,
	MDE_SP_OVERLAP = 1 + 57,
	MDE_SP_BAD_LENGTH = 1 + 58,
	MDE_UNIT_TOO_LARGE = 1 + 59,
	MDE_LOG_TOO_LARGE = 1 + 60,
	MDE_SP_NOSP = 1 + 61
};
typedef enum md_md_errno_t md_md_errno_t;

struct md_md_error_t {
	md_md_errno_t errnum;
	minor_t mnum;
};
typedef struct md_md_error_t md_md_error_t;

/*
 * component errors
 */

enum md_comp_errno_t {
	MDE_CANT_FIND_COMP = 1,
	MDE_REPL_INVAL_STATE = 1 + 1,
	MDE_COMP_TOO_SMALL = 1 + 2,
	MDE_COMP_OPEN_ERR = 1 + 3,
	MDE_RAID_COMP_ERRED = 1 + 4,
	MDE_MAXIO = 1 + 5,
	MDE_SP_COMP_OPEN_ERR = 1 + 6
};
typedef enum md_comp_errno_t md_comp_errno_t;

struct md_comp_error_t {
	md_comp_errno_t errnum;
	comp_t comp;
};
typedef struct md_comp_error_t md_comp_error_t;

/*
 * hotspare pool errors
 */

enum md_hsp_errno_t {
	MDE_HSP_CREATE_FAILURE = 1,
	MDE_HSP_IN_USE = 1 + 1,
	MDE_INVAL_HSP = 1 + 2,
	MDE_HSP_BUSY = 1 + 3,
	MDE_HSP_REF = 1 + 4,
	MDE_HSP_ALREADY_SETUP = 1 + 5,
	MDE_BAD_HSP = 1 + 6,
	MDE_HSP_UNIT_TOO_LARGE = 1 + 7
};
typedef enum md_hsp_errno_t md_hsp_errno_t;

struct md_hsp_error_t {
	md_hsp_errno_t errnum;
	hsp_t hsp;
};
typedef struct md_hsp_error_t md_hsp_error_t;

/*
 * hotspare errors
 */

enum md_hs_errno_t {
	MDE_HS_RESVD = 1,
	MDE_HS_CREATE_FAILURE = 1 + 1,
	MDE_HS_INUSE = 1 + 2,
	MDE_HS_UNIT_TOO_LARGE = 1 + 3
};
typedef enum md_hs_errno_t md_hs_errno_t;

struct md_hs_error_t {
	md_hs_errno_t errnum;
	hs_t hs;
};
typedef struct md_hs_error_t md_hs_error_t;

/*
 * MDDB errors
 */

enum md_mddb_errno_t {
	MDE_TOOMANY_REPLICAS = 1,
	MDE_REPLICA_TOOSMALL = 1 + 1,
	MDE_NOTVERIFIED = 1 + 2,
	MDE_DB_INVALID = 1 + 3,
	MDE_DB_EXISTS = 1 + 4,
	MDE_DB_MASTER = 1 + 5,
	MDE_DB_TOOSMALL = 1 + 6,
	MDE_DB_NORECORD = 1 + 7,
	MDE_DB_NOSPACE = 1 + 8,
	MDE_DB_NOTNOW = 1 + 9,
	MDE_DB_NODB = 1 + 10,
	MDE_DB_NOTOWNER = 1 + 11,
	MDE_DB_STALE = 1 + 12,
	MDE_DB_TOOFEW = 1 + 13,
	MDE_DB_TAGDATA = 1 + 14,
	MDE_DB_ACCOK = 1 + 15,
	MDE_DB_NTAGDATA = 1 + 16,
	MDE_DB_ACCNOTOK = 1 + 17,
	MDE_DB_NOLOCBLK = 1 + 18,
	MDE_DB_NOLOCNMS = 1 + 19,
	MDE_DB_NODIRBLK = 1 + 20,
	MDE_DB_NOTAGREC = 1 + 21,
	MDE_DB_NOTAG = 1 + 22
};
typedef enum md_mddb_errno_t md_mddb_errno_t;


struct md_mddb_error_t {
	md_mddb_errno_t errnum;
	minor_t mnum;
	set_t setno;
	u_int size;
};
typedef struct md_mddb_error_t md_mddb_error_t;

/*
 * diskset (ds) errors
 */

enum md_ds_errno_t {
	MDE_DS_DUPHOST = 1,
	MDE_DS_NOTNODENAME = 1 + 1,
	MDE_DS_SELFNOTIN = 1 + 2,
	MDE_DS_NODEHASSET = 1 + 3,
	MDE_DS_NODENOSET = 1 + 4,
	MDE_DS_NOOWNER = 1 + 5,
	MDE_DS_NOTOWNER = 1 + 6,
	MDE_DS_NODEISNOTOWNER = 1 + 7,
	MDE_DS_NODEINSET = 1 + 8,
	MDE_DS_NODENOTINSET = 1 + 9,
	MDE_DS_SETNUMBUSY = 1 + 10,
	MDE_DS_SETNUMNOTAVAIL = 1 + 11,
	MDE_DS_SETNAMEBUSY = 1 + 12,
	MDE_DS_DRIVENOTCOMMON = 1 + 13,
	MDE_DS_DRIVEINSET = 1 + 14,
	MDE_DS_DRIVENOTINSET = 1 + 15,
	MDE_DS_DRIVEINUSE = 1 + 16,
	MDE_DS_DUPDRIVE = 1 + 17,
	MDE_DS_INVALIDSETNAME = 1 + 18,
	MDE_DS_HASDRIVES = 1 + 19,
	MDE_DS_SIDENUMNOTAVAIL = 1 + 20,
	MDE_DS_SETNAMETOOLONG = 1 + 21,
	MDE_DS_NODENAMETOOLONG = 1 + 22,
	MDE_DS_OHACANTDELSELF = 1 + 23,
	MDE_DS_HOSTNOSIDE = 1 + 24,
	MDE_DS_SETLOCKED = 1 + 25,
	MDE_DS_ULKSBADKEY = 1 + 26,
	MDE_DS_LKSBADKEY = 1 + 27,
	MDE_DS_WRITEWITHSULK = 1 + 28,
	MDE_DS_SETCLEANUP = 1 + 29,
	MDE_DS_CANTDELSELF = 1 + 30,
	MDE_DS_HASMED = 1 + 31,
	MDE_DS_TOOMANYALIAS = 1 + 32,
	MDE_DS_ISMED = 1 + 33,
	MDE_DS_ISNOTMED = 1 + 34,
	MDE_DS_INVALIDMEDNAME = 1 + 35,
	MDE_DS_ALIASNOMATCH = 1 + 36,
	MDE_DS_NOMEDONHOST = 1 + 37,
	MDE_DS_SINGLEHOST = 1 + 38,
	MDE_DS_AUTONOTSET = 1 + 39
};
typedef enum md_ds_errno_t md_ds_errno_t;


struct md_ds_error_t {
	md_ds_errno_t errnum;
	set_t setno;
	u_int xnode;
	u_int xdrive;
};
typedef struct md_ds_error_t md_ds_error_t;

/*
 * fundamental error type
 */

enum md_errclass_t {
	MDEC_VOID = 0,
	MDEC_SYS = 0 + 1,
	MDEC_RPC = 0 + 2,
	MDEC_DEV = 0 + 3,
	MDEC_USE = 0 + 4,
	MDEC_MD = 0 + 5,
	MDEC_COMP = 0 + 6,
	MDEC_HSP = 0 + 7,
	MDEC_HS = 0 + 8,
	MDEC_MDDB = 0 + 9,
	MDEC_DS = 0 + 10
};
typedef enum md_errclass_t md_errclass_t;

/*
 * error info
 */

struct md_error_info_t {
	md_errclass_t errclass;
	union {
		md_void_error_t void_error;
		md_sys_error_t sys_error;
		md_rpc_error_t rpc_error;
		md_dev_error_t dev_error;
		md_use_error_t use_error;
		md_md_error_t md_error;
		md_comp_error_t comp_error;
		md_hsp_error_t hsp_error;
		md_hs_error_t hs_error;
		md_mddb_error_t mddb_error;
		md_ds_error_t ds_error;
	} md_error_info_t_u;
};
typedef struct md_error_info_t md_error_info_t;


struct md_error_t {
	md_error_info_t info;
	u_int xhost;
	u_int xextra;
	u_int xname;
};
typedef struct md_error_t md_error_t;

/*
 * Null error constant
 */
#define	MDNULLERROR		{{MDEC_VOID}, NULL, NULL, NULL}

/*
 * External reference to constant null error struct. (declared in mdiox_xdr.c)
 */
extern	const	md_error_t		mdnullerror;

/*
 * External declarations
 */
extern	void	mdclrerror(md_error_t *ep);	/* clear error */
extern	int	mdstealerror(md_error_t *to, md_error_t *from);

#define	mdiserror(ep, num)	(((ep)->info.errclass == MDEC_VOID) &&\
	((ep)->info.md_error_info_t_u.void_error.errnum == (num)))
#define	mdisok(ep)	mdiserror(ep, MDE_NONE)

#define	mdissyserror(ep, num)	(((ep)->info.errclass == MDEC_SYS) && \
	((ep)->info.md_error_info_t_u.sys_error.errnum == (num)))
#define	mdisrpcerror(ep, num)	(((ep)->info.errclass == MDEC_RPC) && \
	((ep)->info.md_error_info_t_u.rpc_error.errnum == (num)))
#define	mdisdeverror(ep, num)	(((ep)->info.errclass == MDEC_DEV) && \
	((ep)->info.md_error_info_t_u.dev_error.errnum == (num)))
#define	mdisuseerror(ep, num)	(((ep)->info.errclass == MDEC_USE) && \
	((ep)->info.md_error_info_t_u.use_error.errnum == (num)))
#define	mdismderror(ep, num)	(((ep)->info.errclass == MDEC_MD) && \
	((ep)->info.md_error_info_t_u.md_error.errnum == (num)))
#define	mdiscomperror(ep, num)	(((ep)->info.errclass == MDEC_COMP) &&\
	((ep)->info.md_error_info_t_u.comp_error.errnum == (num)))
#define	mdishsperror(ep, num)	(((ep)->info.errclass == MDEC_HSP) && \
	((ep)->info.md_error_info_t_u.hsp_error.errnum == (num)))
#define	mdishserror(ep, num)	(((ep)->info.errclass == MDEC_HS) && \
	((ep)->info.md_error_info_t_u.hs_error.errnum == (num)))
#define	mdismddberror(ep, num)	(((ep)->info.errclass == MDEC_MDDB) &&\
	((ep)->info.md_error_info_t_u.mddb_error.errnum == (num)))
#define	mdisdserror(ep, num)	(((ep)->info.errclass == MDEC_DS) && \
	((ep)->info.md_error_info_t_u.ds_error.errnum == (num)))

#define	mdanysyserror(ep)	((ep)->info.errclass == MDEC_SYS)
#define	mdanyrpcerror(ep)	((ep)->info.errclass == MDEC_RPC)
#define	mdanydeverror(ep)	((ep)->info.errclass == MDEC_DEV)
#define	mdanyuseerror(ep)	((ep)->info.errclass == MDEC_USE)
#define	mdanymderror(ep)	((ep)->info.errclass == MDEC_MD)
#define	mdanycomperror(ep)	((ep)->info.errclass == MDEC_COMP)
#define	mdanyhsperror(ep)	((ep)->info.errclass == MDEC_HSP)
#define	mdanyhserror(ep)	((ep)->info.errclass == MDEC_HS)
#define	mdanymddberror(ep)	((ep)->info.errclass == MDEC_MDDB)
#define	mdanydserror(ep)	((ep)->info.errclass == MDEC_DS)


extern	int	mderror(md_error_t *ep, md_void_errno_t errnum);
extern	int	mdsyserror(md_error_t *ep, int errnum);
extern	int	mddeverror(md_error_t *ep, md_dev_errno_t errnum,
		    md_dev64_t dev);
extern	int	mdmderror(md_error_t *ep, md_md_errno_t errnum, minor_t mnum);
extern	int	mdcomperror(md_error_t *ep, md_comp_errno_t errnum,
		    minor_t mnum, md_dev64_t dev);
extern	int	mdhsperror(md_error_t *ep, md_hsp_errno_t errnum, hsp_t hsp);
extern	int	mdhserror(md_error_t *ep, md_hs_errno_t errnum,
		    hsp_t hsp, md_dev64_t dev);
extern	int	mdmddberror(md_error_t *ep, md_mddb_errno_t errnum,
		    minor_t mnum, set_t setno);
extern	int	mddbstatus2error(md_error_t *ep, int status, minor_t mnum,
		    set_t setno);


/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_mddb_type_t(XDR *, mddb_type_t*);
extern  bool_t xdr_mddb_cfgcmd_t(XDR *, mddb_cfgcmd_t*);
extern  bool_t xdr_mddb_recstatus_t(XDR *, mddb_recstatus_t*);
extern  bool_t xdr_mddb_usercmd_t(XDR *, mddb_usercmd_t*);
extern  bool_t xdr_mddb_userrec_t(XDR *, mddb_userrec_t*);
extern  bool_t xdr_md_ur_get_cmd_t(XDR *, md_ur_get_cmd_t*);
extern  bool_t xdr_md_create_rec_option_t(XDR *, md_create_rec_option_t*);
extern  bool_t xdr_md_drive_record(XDR *, md_drive_record*);
extern  bool_t xdr_md_set_record(XDR *, md_set_record*);
extern  bool_t xdr_md_setkey_t(XDR *, md_setkey_t*);
extern  bool_t xdr_unit_t(XDR *, unit_t*);
extern  bool_t xdr_comp_t(XDR *, comp_t*);
extern  bool_t xdr_hsp_t(XDR *, hsp_t*);
extern  bool_t xdr_hs_t(XDR *, hs_t*);
extern  bool_t xdr_minor_or_hsp_t(XDR *, minor_or_hsp_t*);
extern  bool_t xdr_md_name_prefix(XDR *, md_name_prefix*);
extern  bool_t xdr_md_name_suffix(XDR *, md_name_suffix*);
extern  bool_t xdr_md_splitname(XDR *, md_splitname*);
extern  bool_t xdr_mdsetname_t(XDR *, mdsetname_t*);
extern  bool_t xdr_mdsetnamelist_t(XDR *, mdsetnamelist_t*);
extern  bool_t xdr_mdname_t(XDR *, mdname_t*);
extern  bool_t xdr_mdnamelist_t(XDR *, mdnamelist_t*);
extern  bool_t xdr_mdnmtype_t(XDR *, mdnmtype_t*);
extern  bool_t xdr_md_types_t(XDR *, md_types_t*);
extern  bool_t xdr_mdgeom_t(XDR *, mdgeom_t*);
extern  bool_t xdr_mdcinfo_t(XDR *, mdcinfo_t*);
extern  bool_t xdr_mdpart_t(XDR *, mdpart_t*);
extern  bool_t xdr_mdvtoc_t(XDR *, mdvtoc_t*);
extern  bool_t xdr_mdsidenames_t(XDR *, mdsidenames_t*);
extern  bool_t xdr_mddrivename_t(XDR *, mddrivename_t*);
extern  bool_t xdr_mddrivenamelist_t(XDR *, mddrivenamelist_t*);
extern  bool_t xdr_replica_flags_t(XDR *, replica_flags_t*);
extern  bool_t xdr_md_replica_t(XDR *, md_replica_t*);
extern  bool_t xdr_md_replicalist_t(XDR *, md_replicalist_t*);
extern  bool_t xdr_md_drive_desc(XDR *, md_drive_desc*);
extern  bool_t xdr_md_set_desc(XDR *, md_set_desc*);
extern  bool_t xdr_mdhspname_t(XDR *, mdhspname_t*);
extern  bool_t xdr_mdhspnamelist_t(XDR *, mdhspnamelist_t*);
extern  bool_t xdr_md_status_t(XDR *, md_status_t*);
extern  bool_t xdr_md_parent_t(XDR *, md_parent_t*);
extern  bool_t xdr_md_stackcap_t(XDR *, md_stackcap_t*);
extern  bool_t xdr_md_common_t(XDR *, md_common_t*);
extern  bool_t xdr_ms_params_t(XDR *, ms_params_t*);
extern  bool_t xdr_comp_state_t(XDR *, comp_state_t*);
extern  bool_t xdr_md_comp_t(XDR *, md_comp_t*);
extern  bool_t xdr_md_row_t(XDR *, md_row_t*);
extern  bool_t xdr_md_stripe_t(XDR *, md_stripe_t*);
extern  bool_t xdr_xsp_offset_t(XDR *, xsp_offset_t*);
extern  bool_t xdr_xsp_length_t(XDR *, xsp_length_t*);
extern  bool_t xdr_xsp_status_t(XDR *, xsp_status_t*);
extern  bool_t xdr_md_sp_ext_t(XDR *, md_sp_ext_t*);
extern  bool_t xdr_md_sp_t(XDR *, md_sp_t*);
extern  bool_t xdr_mm_wr_opt_t(XDR *, mm_wr_opt_t*);
extern  bool_t xdr_mm_rd_opt_t(XDR *, mm_rd_opt_t*);
extern  bool_t xdr_mm_pass_num_t(XDR *, mm_pass_num_t*);
extern  bool_t xdr_mm_params_t(XDR *, mm_params_t*);
extern  bool_t xdr_sm_state_t(XDR *, sm_state_t*);
extern  bool_t xdr_sm_flags_t(XDR *, sm_flags_t*);
extern  bool_t xdr_md_submirror_t(XDR *, md_submirror_t*);
extern  bool_t xdr_md_mirror_t(XDR *, md_mirror_t*);
extern  bool_t xdr_mt_flags_t(XDR *, mt_flags_t*);
extern  bool_t xdr_mt_l_error_t(XDR *, mt_l_error_t*);
extern  bool_t xdr_mt_debug_t(XDR *, mt_debug_t*);
extern  bool_t xdr_md_trans_t(XDR *, md_trans_t*);
extern  bool_t xdr_mr_params_t(XDR *, mr_params_t*);
extern  bool_t xdr_rcs_state_t(XDR *, rcs_state_t*);
extern  bool_t xdr_rcs_flags_t(XDR *, rcs_flags_t*);
extern  bool_t xdr_md_raidcol_t(XDR *, md_raidcol_t*);
extern  bool_t xdr_rus_state_t(XDR *, rus_state_t*);
extern  bool_t xdr_md_riflags_t(XDR *, md_riflags_t*);
extern  bool_t xdr_md_raid_t(XDR *, md_raid_t*);
extern  bool_t xdr_md_shared_t(XDR *, md_shared_t*);
extern  bool_t xdr_hotspare_states_t(XDR *, hotspare_states_t*);
extern  bool_t xdr_md_hs_t(XDR *, md_hs_t*);
extern  bool_t xdr_md_hsp_t(XDR *, md_hsp_t*);
extern  bool_t xdr_md_void_errno_t(XDR *, md_void_errno_t*);
extern  bool_t xdr_md_void_error_t(XDR *, md_void_error_t*);
extern  bool_t xdr_md_sys_error_t(XDR *, md_sys_error_t*);
extern  bool_t xdr_md_rpc_error_t(XDR *, md_rpc_error_t*);
extern  bool_t xdr_md_dev_errno_t(XDR *, md_dev_errno_t*);
extern  bool_t xdr_md_dev_error_t(XDR *, md_dev_error_t*);
extern  bool_t xdr_md_use_errno_t(XDR *, md_use_errno_t*);
extern  bool_t xdr_md_use_error_t(XDR *, md_use_error_t*);
extern  bool_t xdr_md_md_errno_t(XDR *, md_md_errno_t*);
extern  bool_t xdr_md_md_error_t(XDR *, md_md_error_t*);
extern  bool_t xdr_md_comp_errno_t(XDR *, md_comp_errno_t*);
extern  bool_t xdr_md_comp_error_t(XDR *, md_comp_error_t*);
extern  bool_t xdr_md_hsp_errno_t(XDR *, md_hsp_errno_t*);
extern  bool_t xdr_md_hsp_error_t(XDR *, md_hsp_error_t*);
extern  bool_t xdr_md_hs_errno_t(XDR *, md_hs_errno_t*);
extern  bool_t xdr_md_hs_error_t(XDR *, md_hs_error_t*);
extern  bool_t xdr_md_mddb_errno_t(XDR *, md_mddb_errno_t*);
extern  bool_t xdr_md_mddb_error_t(XDR *, md_mddb_error_t*);
extern  bool_t xdr_md_ds_errno_t(XDR *, md_ds_errno_t*);
extern  bool_t xdr_md_ds_error_t(XDR *, md_ds_error_t*);
extern  bool_t xdr_md_errclass_t(XDR *, md_errclass_t*);
extern  bool_t xdr_md_error_info_t(XDR *, md_error_info_t*);
extern  bool_t xdr_md_error_t(XDR *, md_error_t*);

#else /* K&R C */
extern bool_t xdr_mddb_type_t();
extern bool_t xdr_mddb_cfgcmd_t();
extern bool_t xdr_mddb_recstatus_t();
extern bool_t xdr_mddb_usercmd_t();
extern bool_t xdr_mddb_userrec_t();
extern bool_t xdr_md_ur_get_cmd_t();
extern bool_t xdr_md_create_rec_option_t();
extern bool_t xdr_md_drive_record();
extern bool_t xdr_md_set_record();
extern bool_t xdr_md_setkey_t();
extern bool_t xdr_unit_t();
extern bool_t xdr_comp_t();
extern bool_t xdr_hsp_t();
extern bool_t xdr_hs_t();
extern bool_t xdr_minor_or_hsp_t();
extern bool_t xdr_md_name_prefix();
extern bool_t xdr_md_name_suffix();
extern bool_t xdr_md_splitname();
extern bool_t xdr_mdsetname_t();
extern bool_t xdr_mdsetnamelist_t();
extern bool_t xdr_mdname_t();
extern bool_t xdr_mdnamelist_t();
extern bool_t xdr_mdnmtype_t();
extern bool_t xdr_md_types_t();
extern bool_t xdr_mdgeom_t();
extern bool_t xdr_mdcinfo_t();
extern bool_t xdr_mdpart_t();
extern bool_t xdr_mdvtoc_t();
extern bool_t xdr_mdsidenames_t();
extern bool_t xdr_mddrivename_t();
extern bool_t xdr_mddrivenamelist_t();
extern bool_t xdr_replica_flags_t();
extern bool_t xdr_md_replica_t();
extern bool_t xdr_md_replicalist_t();
extern bool_t xdr_md_drive_desc();
extern bool_t xdr_md_set_desc();
extern bool_t xdr_mdhspname_t();
extern bool_t xdr_mdhspnamelist_t();
extern bool_t xdr_md_status_t();
extern bool_t xdr_md_parent_t();
extern bool_t xdr_md_stackcap_t();
extern bool_t xdr_md_common_t();
extern bool_t xdr_ms_params_t();
extern bool_t xdr_comp_state_t();
extern bool_t xdr_md_comp_t();
extern bool_t xdr_md_row_t();
extern bool_t xdr_md_stripe_t();
extern bool_t xdr_xsp_offset_t();
extern bool_t xdr_xsp_length_t();
extern bool_t xdr_xsp_status_t();
extern bool_t xdr_md_sp_ext_t();
extern bool_t xdr_md_sp_t();
extern bool_t xdr_mm_wr_opt_t();
extern bool_t xdr_mm_rd_opt_t();
extern bool_t xdr_mm_pass_num_t();
extern bool_t xdr_mm_params_t();
extern bool_t xdr_sm_state_t();
extern bool_t xdr_sm_flags_t();
extern bool_t xdr_md_submirror_t();
extern bool_t xdr_md_mirror_t();
extern bool_t xdr_mt_flags_t();
extern bool_t xdr_mt_l_error_t();
extern bool_t xdr_mt_debug_t();
extern bool_t xdr_md_trans_t();
extern bool_t xdr_mr_params_t();
extern bool_t xdr_rcs_state_t();
extern bool_t xdr_rcs_flags_t();
extern bool_t xdr_md_raidcol_t();
extern bool_t xdr_rus_state_t();
extern bool_t xdr_md_riflags_t();
extern bool_t xdr_md_raid_t();
extern bool_t xdr_md_shared_t();
extern bool_t xdr_hotspare_states_t();
extern bool_t xdr_md_hs_t();
extern bool_t xdr_md_hsp_t();
extern bool_t xdr_md_void_errno_t();
extern bool_t xdr_md_void_error_t();
extern bool_t xdr_md_sys_error_t();
extern bool_t xdr_md_rpc_error_t();
extern bool_t xdr_md_dev_errno_t();
extern bool_t xdr_md_dev_error_t();
extern bool_t xdr_md_use_errno_t();
extern bool_t xdr_md_use_error_t();
extern bool_t xdr_md_md_errno_t();
extern bool_t xdr_md_md_error_t();
extern bool_t xdr_md_comp_errno_t();
extern bool_t xdr_md_comp_error_t();
extern bool_t xdr_md_hsp_errno_t();
extern bool_t xdr_md_hsp_error_t();
extern bool_t xdr_md_hs_errno_t();
extern bool_t xdr_md_hs_error_t();
extern bool_t xdr_md_mddb_errno_t();
extern bool_t xdr_md_mddb_error_t();
extern bool_t xdr_md_ds_errno_t();
extern bool_t xdr_md_ds_error_t();
extern bool_t xdr_md_errclass_t();
extern bool_t xdr_md_error_info_t();
extern bool_t xdr_md_error_t();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_MDIOX_H_RPCGEN */
