#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)transport_add.pl 1.11     03/02/26 SMI"
#
# Transport add component pages

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Transport;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Create a transport object
my $transport = new Cluster::Transport;

# Check if in cluster mode
if ($transport->is_clustermode() != 0) {
        # not in cluster mode
        $transport->print_nonclustermode_error($q);
        exit;
}

my $type = $q->param('type');
my $step = $q->param('step');

# Set the page title
my $title = gettext("Add Transport");

# Print the query header
print $q->header();

# Start the document
print $q->start_html({  TITLE => $title,
			STYLE  => { 'src' => '/css/clustmgr-style.css'},
                        CLASS  => "default-body",
                        SCRIPT => $transport->transport_jscript() .
				    $q->yoke_jscript("t")
                        });

# Check for transport modify authorization
if (!$rbac->check_auth($CL_AUTH_TRANSPORT_MODIFY)) {
	$rbac->auth_error($q, $title);
	exit;
}

if (!(defined $step || defined $type)) {
	goto DONE;
}

$transport->get_commandoutput();
if ($type eq "Adapter") {
	my $node_name = "";
	my $adp_name = "";
	my $trtype = "";
	$node_name = $q->param('node_name');
	$adp_name = $q->param('adp_name');
	$trtype = $q->param('trtype');
	$transport->add_adapter($q, $step, $node_name, $adp_name, $trtype);
} elsif ($type eq "Junction") {
	my $junction_name = "";
	my $junction_type = "";
	$junction_name = $q->param('junction_name');
	$junction_type = $q->param('junction_type');
	$transport->add_junction($q, $step, $junction_name, $junction_type);
} elsif ($type eq "Cable") {
	my $endpoint1 = "";
	my $endpoint2 = ""; 
	$endpoint1 = $q->param('endpoint1');
	$endpoint2 = $q->param('endpoint2');
	$transport->add_cable($q, $step, $endpoint1, $endpoint2);
}

# End the html document
DONE: $transport->footer($q);
