#!/usr/perl5/bin/perl -w
#
# Copyright (c) 2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident	"@(#)step2.pl	1.17	03/01/07 SMI"
#
# Ask for the cluster name and size

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Get global values
my $cluster_name = $q->param('cluster_name');
my $error = 0;
my $cluster_size = $q->param('cluster_size');

if (!defined $cluster_name || $cluster_name eq "") {
    # Start the html document
    $install->header($q, [gettext("Sun Cluster Installation"),
	"/cgi-bin/installation/step0.pl",
	gettext("Cluster Name (Step 1 of 8)")]);
    $install->start_message_table($q, "/images/error_32.gif",
	gettext("Error"), gettext("Missing Cluster Name"), "");
    $install->end_message_table($q);
    print $q->p({class => "action-window-normal-text"});
    print gettext("Please return to the previous page and enter a cluster name.");
    $error = 1;
} elsif (!defined $cluster_size ||
	    $cluster_size < $install->get_min_cluster_size() ||
	    $cluster_size > $install->get_max_cluster_size()) {
    # Start the html document
    $install->header($q, [gettext("Sun Cluster Installation"),
	"/cgi-bin/installation/step0.pl",
	gettext("Cluster Name (Step 1 of 8)")]);
    $install->start_message_table($q, "/images/error_32.gif",
	gettext("Error"), gettext("Invalid Cluster Size"),
	    $q->sprintfn(
	gettext("The cluster size must be between %1 and %2."),
	$install->get_min_cluster_size(), $install->get_max_cluster_size()));
    $install->end_message_table($q);
    print $q->p({class => "action-window-normal-text"});
    print gettext("Please return to the previous page and enter a valid size.");
    $error =1;
}

if ($error) {
    print $q->start_form();

    $install->start_button_table($q);

    print $q->button({ value   => gettext("  < Back  "),
		       onClick => "history.back()"
		       });


    $install->end_button_table($q, "cancel");

    print $q->end_form();
    
    # End the html document
    $install->footer($q);

    # Exit gracefully
    exit(0);
}

# Start the html document
$install->header($q, [gettext("Sun Cluster Installation"),
    "/cgi-bin/installation/step0.pl",
    gettext("Node Names (Step 2 of 8)")]);
print $q->p({class => "action-window-normal-text"});

print gettext("Assign a physical hostname to each server node.  ");
print gettext("The physical hostname must be its primary machine name; " .
    "use <tt>uname -n</tt> to determine the primary machine name.");

# Print the form
print $q->start_form({ action => '/cgi-bin/installation/step3.pl' });
print $q->start_table({	CELLPADDING => 5,
			CELLSPACING => 0,
			CLASS => "action-table",
			});

$install->determine_nodes($q);

for (my $i=1; $i<=$q->param('cluster_size'); $i++) {
    print $q->start_Tr();
    print $q->start_td({ NOWRAP => undef});
    print $q->CGI::div({CLASS => "action-window-label-text"},
	sprintf(gettext("Name for node %s: "), $i));
    print $q->end_td();     

    print $q->start_td();
    print $q->textfield({ name => "node_$i.name", 
			  value => "phys-$cluster_name-$i",
			  size => 20 });
    print $q->end_td();     
    print $q->end_Tr();
}

print $q->end_table();

$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });


# Put spaces between the buttons
print "&nbsp;" ;

print $q->submit({ name  => 'submit_step_2',
		   value => gettext("  Next >  ")
		   });

# Print the hidden cluster fields
print $q->hidden({ name    => "cluster_name",
    value => $q->param('cluster_name')});
print $q->hidden({ name    => "cluster_size",
    value => $q->param('cluster_size')});

$install->end_button_table($q, "cancel");

print $q->end_form();

# End the html document
$install->footer($q);
