#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)cluster_status.pl 1.21     03/02/27 SMI"
#
# Cluster status page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Rg;
use Cluster::RBAC;
use Cluster::Cgi;
use Cluster::Node;
use Cluster::Common;
use Cluster::Device;
use Cluster::Transport;
use Sun::Solaris::Utils qw(gettext);

# Create the cluster objects
my $q = new Cluster::Cgi;
my $rg = new Cluster::Rg;
my $node = new Cluster::Node;
my $device = new Cluster::Device;
my $cluster = new Cluster::Common;
my $rbac = new Cluster::RBAC;

# Get cluster info
my $clustername = $cluster->get_clustername();
my $clustersize = $cluster->get_clustersize();

my $title = sprintf(gettext("%s Cluster"), $clustername);

# Print the query header and make the page expire now
print $q->header(-expires => "now");

# Start the document
print $q->start_html({ TITLE  => $title,
		       STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       CLASS  => "default-body",
		       ONUNLOAD => $q->unregister_jscript(),
		       SCRIPT => "top.helpMarker=\"cluster_status-top\"\n" . 
			         $q->jump_menu_jscript() .
				 $q->yoke_jscript("c") .
$q->refresh_jscript('content', 'ESC_cluster_rg_config_change,'.
    'ESC_cluster_node_state_change,ESC_cluster_dcs_')
		       });

##############################################################################
#
# Action Bar Table
#
##############################################################################

# Start the action bar table
$q->start_action_bar_table($title);

# Only provide the links to the topological views if we don't have too many
# nodes in the cluster.
my @viewlinks;

if ($clustersize <= 4 && ($rg->get_num_rgs() <= 4)) {

	# Add the general cluster view
	@viewlinks = (gettext("Overall Status Tables"),
		      "/cgi-bin/cluster/cluster_status.pl");

	# Add the resource group topology view
	if ($rbac->check_auth($CL_AUTH_RESOURCE_READ)) {
		push (@viewlinks, gettext("Resource Group Topology"),
		      "/cgi-bin/rg/rg_view.pl\?view=topological");
	}

	# Add the device group topology view
	if ($rbac->check_auth($CL_AUTH_DEVICE_READ)) {
		push (@viewlinks, gettext("Device Group Topology"),
		      "/cgi-bin/device/device_view.pl\?view=topological");
	}

	# Add the transport topology view
	if ($rbac->check_auth($CL_AUTH_TRANSPORT_READ)) {
		push (@viewlinks, gettext("Transport Topology"),
		      "/cgi-bin/transport/transport_view.pl\?view=topological");
	}

	# Instantiate the menu
	if ($rbac->check_auth($CL_AUTH_TRANSPORT_READ) ||
	    $rbac->check_auth($CL_AUTH_DEVICE_READ) ||
	    $rbac->check_auth($CL_AUTH_RESOURCE_READ)) {
		$q->view_menu(\@viewlinks,
			      "/cgi-bin/cluster/cluster_status.pl");
	}

} elsif ($clustersize <= 8) {

	# Add the general cluster view
	@viewlinks = (gettext("Overall Status Tables"),
		      "/cgi-bin/cluster/cluster_status.pl");

	# Add the device group topology view
	if ($rbac->check_auth($CL_AUTH_DEVICE_READ)) {
		push (@viewlinks, gettext("Device Group Topology"),
		      "/cgi-bin/device/device_view.pl\?view=topological");
	}

	# Add the transport topology view
	if ($rbac->check_auth($CL_AUTH_TRANSPORT_READ)) {
		push (@viewlinks, gettext("Transport Topology"),
		      "/cgi-bin/transport/transport_view.pl\?view=topological");
	}

	# Instantiate the menu
	if ($rbac->check_auth($CL_AUTH_TRANSPORT_READ) ||
	    $rbac->check_auth($CL_AUTH_DEVICE_READ)) {
		$q->view_menu(\@viewlinks,
			      "/cgi-bin/cluster/cluster_status.pl");
	}
}

# Print the middle of the action table
$q->mid_action_bar_table();

# Create the actions menu links
my @actionslinks = (gettext("Oracle Database"), "/cgi-bin/ds/oracle.pl",
		    gettext("Apache Web Server"), "/cgi-bin/ds/apache.pl",
		    gettext("Sun ONE Web Server"), "/cgi-bin/ds/iplanet.pl",
		    gettext("Sun ONE LDAP Server"), "/cgi-bin/ds/ldap.pl",
		    gettext("DNS"), "/cgi-bin/ds/dns.pl",
		    gettext("NFS"), "/cgi-bin/ds/nfs.pl"
		    );

# Create the help links
my @action_helpMarkers = ("cluster_status-ds-oracle",
			  "cluster_status-ds-apache",
			  "cluster_status-ds-sunone-webserver",
			  "cluster_status-ds-sunone-directory-server",
			  "cluster_status-ds-dns",
			  "cluster_status-ds-nfs");

# Add the help links
$q->load_action_helpMarkers(\@action_helpMarkers);

# Print the ds install menu if the user has solaris.cluster.appinstall
if ($rbac->check_auth($CL_AUTH_APPINSTALL)) {
	$q->actions_menu(gettext("Install Data Service"), \@actionslinks);
}

# End the action bar table
$q->end_action_bar_table();

##############################################################################
#
# Status tables for nodes, resource groups, and global devices. For
# cluster-framework items such as transports and quorum, the users
# will have to drill-down into the menus.
#
##############################################################################

# Print the node status table if the user has solaris.cluster.node.read
if ($rbac->check_auth($CL_AUTH_NODE_READ)) {
	$node->node_status_table($q);
}

# Print the resource groups table if the user has solaris.cluster.resource.read
if ($rbac->check_auth($CL_AUTH_RESOURCE_READ)) {
	$rg->resource_groups_table($q);
}

# Print the global devices table if the user has solaris.device.read
if ($rbac->check_auth($CL_AUTH_DEVICE_READ)) {
	$device->get_commandoutput();
	$device->global_devices_table($q);
}

# End the html
print $q->end_html();
