/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Client;
import com.sun.cluster.sccheck.ClientProtocol;
import com.sun.cluster.sccheck.ExplorerWrapper;
import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.KEWrapper;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.ProtocolException;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.Server;
import com.sun.cluster.sccheck.ServerProtocol;
import com.sun.cluster.sccheck.Session;
import com.sun.cluster.sccheck.Utils;
import com.sun.cluster.sccheck.WrapperException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class SessionV1
implements Session,
Globals {
    private ClientProtocol clientProt = null;
    private String publicName = null;
    private String privateName = null;
    private String resultsFilenameDest = null;
    private String reportsFilenameBaseDest = null;
    private Client clientParent = null;
    private ProgressListener progressListener = null;
    private Vector serverProts = null;
    private Server serverParent = null;
    private String explorergzip = null;
    private String[] explorerDirA = null;
    private String report1 = null;
    private String report2 = null;
    private boolean clusterMode = false;
    private boolean brief = false;
    private int minSeverity = 0;
    private Logger logger = Logger.getLogger();

    public SessionV1() {
        this.serverProts = new Vector();
    }

    private boolean doExplorer() throws ProtocolException, WrapperException {
        this.logger.trace("SessionV1.doExplorer() -- ENTER -- ");
        boolean bl = true;
        ExplorerWrapper explorerWrapper = new ExplorerWrapper(this.progressListener, null);
        try {
            this.explorergzip = explorerWrapper.runExplorer();
            this.explorerDirA = new String[1];
            this.explorerDirA[0] = explorerWrapper.getExplorerDir();
            this.logger.info("SessionV1.doExplorer() explorerDirA: " + Utils.dumpStringArray(this.explorerDirA));
            if (this.explorergzip != null && this.explorerDirA[0] != null) {
                this.serverSendFiles();
            } else {
                this.sendExecErrExit();
                bl = false;
            }
        }
        catch (IOException iOException) {
            this.logger.error("ServerThread.doExplorer() IOException: " + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
        catch (WrapperException wrapperException) {
            Object[] objectArray = new Object[]{wrapperException.getMessage()};
            String string = I18n.getLocalized("explorerRunFailed", objectArray);
            throw new WrapperException(string);
        }
        this.logger.trace("SessionV1.doExplorer() -- EXIT -- " + bl);
        return bl;
    }

    private void doKE(boolean bl, int n) throws ProtocolException, WrapperException {
        this.logger.trace("SessionV1.doKE() -- ENTER -- ");
        String string = "/var/cluster/sccheck/tmp/server/results-tmp";
        try {
            String[] stringArray = null;
            try {
                KEWrapper kEWrapper = this.runKE(string, bl, n);
                stringArray = new String[]{String.valueOf(string) + ".xml", String.valueOf(string) + ".txt"};
                if (stringArray[0] != null) {
                    this.report1 = stringArray[0];
                    this.serverSendFiles();
                } else {
                    this.sendExecErrExit();
                }
                if (stringArray[1] != null) {
                    this.report2 = stringArray[1];
                    this.serverSendFiles();
                } else {
                    this.sendExecErrExit();
                }
                int n2 = kEWrapper.getMaxSeverity();
                this.serverSendData(n2);
                String string2 = kEWrapper.getGenDate();
                this.serverSendData(string2);
            }
            catch (ProtocolException protocolException) {
                this.logger.error("SessionV1.doKE() ProtocolException: " + protocolException.getMessage());
                Object[] objectArray = new Object[]{protocolException.getMessage()};
                String string3 = I18n.getLocalized("KE.RunFailedProtocolException", objectArray);
                throw new ProtocolException(string3);
            }
            catch (WrapperException wrapperException) {
                this.logger.error("SessionV1.doKE() WrapperException: " + wrapperException.getMessage());
                Object[] objectArray = new Object[]{wrapperException.getMessage()};
                String string4 = I18n.getLocalized("KE.RunFailedWrapperException", objectArray);
                throw new WrapperException(string4);
            }
        }
        catch (IOException iOException) {
            this.logger.error("ServerThread.doKE() IOException: " + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
        this.logger.trace("SessionV1.doKE() -- EXIT -- ");
    }

    private void getRemoteFile(String string, ClientProtocol clientProtocol, String string2) throws ProtocolException, SCException {
        if (!clientProtocol.getRemoteFile(string2)) {
            Object[] objectArray = new Object[]{string2, string};
            String string3 = I18n.getLocalized("noResultsFile", objectArray);
            throw new SCException(string3);
        }
    }

    public void initClient(Client client, ClientProtocol clientProtocol, String string, String string2, String string3, String string4, boolean bl, int n) throws ProtocolException, SCException {
        this.clientParent = client;
        this.clientProt = clientProtocol;
        this.publicName = string;
        this.privateName = string2;
        this.resultsFilenameDest = string3;
        this.reportsFilenameBaseDest = string4;
        this.brief = bl;
        this.minSeverity = n;
        try {
            clientProtocol.sendString(this.publicName);
            clientProtocol.sendLocale();
            clientProtocol.sendAuth();
            clientProtocol.sendBoolean(bl);
            clientProtocol.sendInt(n);
            if (!clientProtocol.getPermission()) {
                Object[] objectArray = new Object[]{clientProtocol.readMessage()};
                String string5 = I18n.getLocalized("sessionPermissionDenied", objectArray);
                throw new SCException(string5);
            }
        }
        catch (IOException iOException) {
            this.logger.error("SessionV1.initClient() IOException: " + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
    }

    public void initServer(Server server, ServerProtocol serverProtocol, boolean bl) throws ProtocolException {
        this.logger.trace("SessionV1.initServer() -- ENTER -- ");
        this.serverParent = server;
        this.clusterMode = bl;
        this.logger.info("SessionV1.initServer() clusterMode: " + this.clusterMode);
        this.serverProts.addElement(new ServerProtocolState(serverProtocol));
        try {
            this.publicName = serverProtocol.readString();
            serverProtocol.readLocale();
            serverProtocol.readAuthStr();
            this.brief = serverProtocol.readBoolean();
            this.minSeverity = serverProtocol.readInt();
        }
        catch (IOException iOException) {
            throw new ProtocolException(iOException.getMessage());
        }
        this.logger.trace("SessionV1.initServer() -- EXIT -- ");
    }

    public void joinSession(ServerProtocol serverProtocol) throws ProtocolException {
        this.logger.trace("SessionV1.joinSession() -- ENTER -- sprot" + serverProtocol.getID());
        try {
            String string = I18n.getLocalized("joiningExistingSession");
            serverProtocol.sendProgress(string);
        }
        catch (IOException iOException) {
            throw new ProtocolException(iOException.getMessage());
        }
        this.serverProts.addElement(new ServerProtocolState(serverProtocol));
        try {
            this.serverSendFiles();
        }
        catch (ProtocolException protocolException) {
            this.serverParent.setBusy(false);
            throw protocolException;
        }
        this.logger.trace("SessionV1.joinSession() -- EXIT -- sprot" + serverProtocol.getID());
    }

    private boolean purgeClientList(Iterator iterator, ServerProtocolState serverProtocolState) {
        boolean bl = true;
        if (this.serverProts.size() == 1) {
            this.logger.trace("SessionV1.purgeClientList() exception on last sprot: sprot" + serverProtocolState.sprot.getID());
            bl = false;
        } else {
            this.logger.trace("SessionV1.purgeClientList() removing sprot" + serverProtocolState.sprot.getID() + " from serverProts list.");
            iterator.remove();
        }
        return bl;
    }

    public void runClient(ProgressListener progressListener) throws ProtocolException, SCException {
        this.logger.trace("SessionV1.runClient() -- ENTER -- ");
        this.progressListener = progressListener;
        this.logger.trace("SessionV1.runClient() sending run vars");
        this.logger.trace("SessionV1.runClient() starting Explorer wait loop for " + this.publicName);
        this.getRemoteFile(this.publicName, this.clientProt, this.resultsFilenameDest);
        this.clientParent.addZippedExplorer(this.resultsFilenameDest);
        Object[] objectArray = new Object[]{this.publicName};
        String string = I18n.getLocalized("explorerFinished", objectArray);
        this.progressListener.postProgress(1, string);
        string = I18n.getLocalized("startingSingleNodeChecks", objectArray);
        this.progressListener.postProgress(1, string);
        this.logger.trace("SessionV1.runClient() starting KE wait loop for " + this.publicName);
        this.getRemoteFile(this.publicName, this.clientProt, String.valueOf(this.reportsFilenameBaseDest) + ".xml");
        this.getRemoteFile(this.publicName, this.clientProt, String.valueOf(this.reportsFilenameBaseDest) + ".txt");
        try {
            int n = this.clientProt.readInt();
            this.logger.info("SessionV1.runClient() maxSeverity: " + n);
            this.clientParent.addServerExitCode(this.publicName, n);
            String string2 = this.clientProt.readString();
            this.logger.info("SessionV1.runClient() genDate: " + string2);
            this.clientParent.addGenDate(this.publicName, string2);
        }
        catch (IOException iOException) {
            this.logger.error("SessionV1.runClient() IOException: " + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
        string = I18n.getLocalized("singleNodeChecksFinished", objectArray);
        this.progressListener.postProgress(1, string);
        this.logger.trace("SessionV1.runClient() -- EXIT -- ");
    }

    private KEWrapper runKE(String string, boolean bl, int n) throws ProtocolException, WrapperException {
        this.logger.trace("SessionV1.runKE() --ENTER--");
        String string2 = null;
        string2 = this.clusterMode ? "/usr/cluster/lib/sccheck/checklist.cluster.singlenode.xml" : "/usr/cluster/lib/sccheck/checklist.noncluster.xml";
        this.logger.info("SessionV1.runKE() checklist: " + string2);
        KEWrapper kEWrapper = new KEWrapper(this.progressListener, string, this.explorerDirA, string2, bl, n);
        kEWrapper.runKE();
        this.logger.trace("SessionV1.runKE() --EXIT-- ");
        return kEWrapper;
    }

    public void runServer(ProgressListener progressListener) throws ProtocolException, WrapperException {
        this.logger.trace("SessionV1.runServer() -- ENTER -- ");
        this.progressListener = progressListener;
        boolean bl = this.doExplorer();
        if (bl) {
            this.doKE(this.brief, this.minSeverity);
        }
        this.logger.trace("SessionV1.serverRun() -- EXIT -- ");
    }

    private void sendExecErrExit() throws IOException {
        Iterator iterator = ((AbstractList)this.serverProts).iterator();
        ServerProtocolState serverProtocolState = null;
        while (iterator.hasNext()) {
            serverProtocolState = (ServerProtocolState)iterator.next();
            try {
                serverProtocolState.sprot.sendExecErrExit();
            }
            catch (IOException iOException) {
                this.logger.trace("SessionV1.sendExecErrExit() in ioex: " + iOException.getMessage());
                if (this.purgeClientList(iterator, serverProtocolState)) continue;
                this.logger.trace("SessionV1.sendExecErrExit() ioex on last sprot: sprot" + serverProtocolState.sprot.getID() + " Forwarding ioex.");
                throw iOException;
            }
        }
    }

    private void serverSendData(int n) throws IOException {
        this.logger.info("SessionV1.serverSendData(int)  -- ENTER -- " + n);
        Iterator iterator = ((AbstractList)this.serverProts).iterator();
        ServerProtocolState serverProtocolState = null;
        while (iterator.hasNext()) {
            serverProtocolState = (ServerProtocolState)iterator.next();
            try {
                serverProtocolState.sprot.sendInt(n);
            }
            catch (IOException iOException) {
                this.logger.trace("SessionV1.serverSendData() in ioex: " + iOException.getMessage());
                if (this.purgeClientList(iterator, serverProtocolState)) continue;
                this.logger.trace("SessionV1.serverSendData() ioex on last sprot: sprot" + serverProtocolState.sprot.getID() + " Forwarding ioex.");
                throw iOException;
            }
        }
        this.logger.trace("SessionV1.serverSendData(int)  -- EXIT -- ");
    }

    private void serverSendData(String string) throws IOException {
        this.logger.info("SessionV1.serverSendData(String)  -- ENTER -- " + string);
        Iterator iterator = ((AbstractList)this.serverProts).iterator();
        ServerProtocolState serverProtocolState = null;
        while (iterator.hasNext()) {
            serverProtocolState = (ServerProtocolState)iterator.next();
            try {
                serverProtocolState.sprot.sendString(string);
            }
            catch (IOException iOException) {
                this.logger.trace("SessionV1.serverSendData() in ioex: " + iOException.getMessage());
                if (this.purgeClientList(iterator, serverProtocolState)) continue;
                this.logger.trace("SessionV1.serverSendData() ioex on last sprot: sprot" + serverProtocolState.sprot.getID() + " Forwarding ioex.");
                throw iOException;
            }
        }
        this.logger.trace("SessionV1.serverSendData(String)  -- EXIT -- ");
    }

    private synchronized void serverSendFiles() throws ProtocolException {
        this.logger.trace("SessionV1.serverSendFiles()  -- ENTER -- ");
        Iterator iterator = ((AbstractList)this.serverProts).iterator();
        ServerProtocolState serverProtocolState = null;
        while (iterator.hasNext()) {
            serverProtocolState = (ServerProtocolState)iterator.next();
            try {
                if (this.explorergzip != null && !serverProtocolState.sentExplFile) {
                    this.logger.info("SessionV1.serverSendFiles() sending explorergzip via sprot" + serverProtocolState.sprot.getID());
                    serverProtocolState.sprot.sendFile(this.explorergzip);
                    serverProtocolState.sentExplFile = true;
                }
                if (this.report1 != null && !serverProtocolState.sentReport1) {
                    this.logger.info("SessionV1.serverSendFiles() sending report1 via sprot" + serverProtocolState.sprot.getID());
                    serverProtocolState.sprot.sendFile(this.report1);
                    serverProtocolState.sentReport1 = true;
                }
                if (this.report2 == null || serverProtocolState.sentReport2) continue;
                this.logger.info("SessionV1.serverSendFiles() sending report2 via sprot" + serverProtocolState.sprot.getID());
                serverProtocolState.sprot.sendFile(this.report2);
                serverProtocolState.sentReport2 = true;
            }
            catch (ProtocolException protocolException) {
                this.logger.trace("SessionV1.serverSendFiles() in pex: " + protocolException.getMessage());
                if (this.purgeClientList(iterator, serverProtocolState)) continue;
                this.logger.trace("SessionV1.serverSendFiles() pex on last sprot: sprot" + serverProtocolState.sprot.getID() + " Forwarding pex.");
                throw protocolException;
            }
        }
        this.logger.trace("SessionV1.serverSendFiles()  -- EXIT -- ");
    }

    class ServerProtocolState {
        ServerProtocol sprot = null;
        boolean sentExplFile = false;
        boolean sentReport1 = false;
        boolean sentReport2 = false;

        ServerProtocolState(ServerProtocol serverProtocol) {
            this.sprot = serverProtocol;
        }
    }
}

