/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Client;
import com.sun.cluster.sccheck.ClientProtocol;
import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.ProtocolException;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.SCProperties;
import com.sun.cluster.sccheck.Session;
import com.sun.cluster.sccheck.SessionFactory;

public class ClientThread
extends Thread
implements Globals {
    private ProgressListener progresslistener;
    private Client parent;
    private String publicName;
    private String privateName;
    private String resultsFilename;
    private String reportFilename;
    private boolean brief = false;
    private int minSeverity = 0;
    private Logger logger = Logger.getLogger();
    private SCProperties props = SCProperties.getSCProperties();

    public ClientThread(ProgressListener progressListener, Client client, String string, String string2, String string3, String string4, boolean bl, int n) {
        this.logger.info("ClientThread() -- ENTER -- " + string);
        this.logger.info("ClientThread() resultsFilename: " + string3);
        this.logger.info("ClientThread() reportFilename: " + string4);
        this.logger.info("ClientThread() brief: " + bl);
        this.logger.info("ClientThread() minSeverity: " + n);
        this.progresslistener = progressListener;
        this.parent = client;
        this.publicName = string;
        this.privateName = string2;
        this.resultsFilename = string3;
        this.reportFilename = string4;
        this.brief = bl;
        this.minSeverity = n;
        this.logger.trace("ClientThread() -- EXIT -- " + string);
    }

    public void die() {
        this.logger.trace("ClientThread.die(): killing thread for: " + this.publicName);
        this.destroy();
    }

    private void remoteOperations() throws SCException {
        String string = null;
        ClientProtocol clientProtocol = null;
        Session session = null;
        try {
            clientProtocol = new ClientProtocol(this.progresslistener, this.parent, this.publicName, this.privateName, this.parent.getClientHostname());
            int n = clientProtocol.getCommonVersion(1);
            session = SessionFactory.getSession(n);
            this.logger.trace("ClientThread.remoteOperations() initializing SessionV" + n);
            switch (n) {
                case 1: {
                    session.initClient(this.parent, clientProtocol, this.publicName, this.privateName, this.resultsFilename, this.reportFilename, this.brief, this.minSeverity);
                    break;
                }
                default: {
                    this.logger.error("ClientThread.remoteOperations(): init: unknown version: " + n);
                    Object[] objectArray = new Object[]{String.valueOf(n)};
                    String string2 = I18n.getLocalized("unsupportedSessionVersion", objectArray);
                    throw new SCException(string2);
                }
            }
            this.logger.info("ClientThread.remoteOperations() running SessionV" + n);
            switch (n) {
                case 1: {
                    session.runClient(this.progresslistener);
                    break;
                }
                default: {
                    this.logger.error("ClientThread.remoteOperations(): run: unknown version: " + n);
                    Object[] objectArray = new Object[]{String.valueOf(n)};
                    String string3 = I18n.getLocalized("unsupportedSessionVersion", objectArray);
                    throw new SCException(string3);
                }
            }
        }
        catch (ProtocolException protocolException) {
            String string4 = string = protocolException.getMessage();
            if (string == null) {
                string = "Unexpected early return from server.";
                string4 = I18n.getLocalized("unexpectedEarlyReturnFromServer");
            }
            this.logger.error("ClientThread.remoteOperations() in ProtocolException: " + string);
            throw new SCException(string4);
        }
    }

    public void run() {
        try {
            this.remoteOperations();
        }
        catch (SCException sCException) {
            this.logger.error("ClientThread.run() SCException on: " + this.publicName + ": " + sCException.getMessage());
            Object[] objectArray = new Object[]{this.publicName, sCException.getMessage()};
            String string = I18n.getLocalized("clientThreadRunError", objectArray);
            this.progresslistener.postErrMsg(string);
            this.parent.postFailure(this.publicName);
        }
    }
}

