#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)Help.pm	1.24	03/02/27 SMI"
#
# Online help-related methods
#

package Cluster::Help;
use strict;
use Cluster::Common;
use vars qw(@ISA $VERSION);
$VERSION = '1.00';
@ISA = qw(Cluster::Common);

#
# Class constructor
#

sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self  = {};
    bless ($self, $class);
    return $self;
}

#
# Class variables
#

my $HELP_WIDTH = 650;
my $HELP_HEIGHT = 650;
my $HELP_DIR = "/help/"; #  htdocs/$locale/$HELP_DIR
my $BASIC_URL = "welcome.html";

#
# Javascript function for opening a help window
#

#
#     - the invoker is in the banner frame which is a child to the frame named
#       'top' which holds the javascript var helpMarker
#     - ask 'top' for helpMarker; provide a default if !defined
#     - map helpMarker to actual file#anchor
#
#     - in the case where Help() needs to instantiate the helpWindow it calls
#	help/start_help.pl with url=whatever.html with possible anchor #foo. The
#	'#' is filtered out by the Cgi:param() call on the perl side so we map it to
#	comma in Help() and start_help.pl maps it back.
#
sub get_help_function_jscript {
    my ($self, $q) = @_;
    my $locale = extract_locale($q);
    return "" . 
        "var helpURL\n" .
        "var helpWindow\n" .
	"function Help() {\n" .
         "    winprops='width=$HELP_WIDTH,height=$HELP_HEIGHT,scrollbars,resizable,toolbar'\n" .
         "    helpURL=top.helpMarker\n" .
         "    helpURL=top.map_helpMarker(helpURL) \n" .
         "    if (helpURL == \"unmapped\") {\n" .
         "      helpURL=\"" . $BASIC_URL . "\"\n" .
         "    }\n" .
         "    helpURL = \"/" . $locale . $HELP_DIR . "\" + helpURL\n" .
       #  "    confirm(\"Help() loading \" + helpURL) \n" .
         "    if (!helpWindow || helpWindow.closed) {\n" .
	 "      // the '#'anchor marker won't survive the param() call in start_help.pl \n" .
	 "      // so we map it to comma here then start_help.pl will map it back. \n" .
         "    var i = helpURL.indexOf(\"#\") \n" .
         "    if (i != -1) { \n" .
         "        var tmp = helpURL.substring(0,i) + \",\" + helpURL.substring(i+1) \n" .
         "        helpURL = tmp \n" .
         "    } \n" .
	 "      helpWindow = window.open(\"/cgi-bin/help/start_help.pl?url=\" + helpURL, 'HelpWindow', winprops)\n" .
         "    } else {\n" .
         "      helpWindow.frames[2].location = helpURL\n" .
         "    }\n" .
         "    if (parseInt(navigator.appVersion) >= 4) { \n" .
         "        helpWindow.window.focus()\n" .
         "    }\n" .
         "    return false\n" .
         "}"
	   ;
} # get_help_function_jscript

sub get_helpMarker_mapping {
    my ($self, $q) = @_;
    return " 
		var mappings = new Array(
			new Array(\"index\",			\"welcome.html\"),
			new Array(\"rbac\",			\"roles.html\"),
			new Array(\"cluster_status-top\",      	\"cluster.html\"),

			new Array(\"node_status-top\",	       	\"node.html\"),
			new Array(\"node_info-top\",		\"node.html\"),

			new Array(\"network_view-top\",		\"nodeIPMP.html\"),
			new Array(\"networkpm-add-group\",	\"nodeIPMP.html#cg\"),
			new Array(\"networkpm-add-adapter\",	\"nodeIPMP.html#aa\"),
			new Array(\"networkpm-remove-adapter\",	\"nodeIPMP.html#ra\"),

			new Array(\"process-top\",		\"nodeProcess.html\"),
			new Array(\"logs-top\",			\"nodeLogs.html\"),

			new Array(\"rs_view-top\",		\"rgResource.html\"),

			new Array(\"rg_view-top\",		\"rg.html\"),
			new Array(\"rg_view-single\",		\"rg.html\"),
			new Array(\"rg_view-topo\",		\"rg.html\"),
			new Array(\"rg_view-table\",		\"rg.html\"),

			new Array(\"rgpm-online\",		\"rg.html#bo\"),
			new Array(\"rgpm-offline\",		\"rg.html#to\"),
			new Array(\"rgpm-restart\",		\"rg.html#r\"),
			new Array(\"rgpm-manage\",		\"rg.html#pms\"),
			new Array(\"rgpm-unmanage\",		\"rg.html#pus\"),
			new Array(\"rgpm-create-group\",       	\"rg.html#cnrg\"),
			new Array(\"rgpm-delete-group\",       	\"rg.html#d\"),
			new Array(\"rgpm-modify-group\",       	\"rg.html#mod\"),

			new Array(\"rgpm-enable-resource\",		\"rgResource.html#er\"),
			new Array(\"rgpm-disable-resource\",		\"rgResource.html#sr\"),
			new Array(\"rgpm-enable-resmonitor\",		\"rgResource.html#em\"),
			new Array(\"rgpm-disable-resmonitor\",		\"rgResource.html#dm\"),
			new Array(\"rgpm-resource-properties\",		\"rgResource.html#mr\"),
			new Array(\"rgpm-resource-weights\",		\"rgResource.html#cw\"),
			new Array(\"rgpm-resource-clear-stop-failed\",	\"rgResource.html#cs\"),
			new Array(\"rgpm-create-resource\",		\"rgResource.html#cnr\"),
			new Array(\"rgpm-delete-resource\",		\"rgResource.html#dr\"),

			new Array(\"transport_view-topo\",		\"transport.html\"),
			new Array(\"transport_view-tables\",		\"transport.html\"),

			new Array(\"transportpm-add-adapter\",		\"transportAdapter.html#aa\"),
			new Array(\"transportpm-remove-adapter\",	\"transportAdapter.html#ra\"),
			new Array(\"transportpm-enable-adapter\",	\"transportAdapter.html#ea\"),
			new Array(\"transportpm-disable-adapter\",	\"transportAdapter.html#da\"),
			new Array(\"transportpm-add-cable\",		\"transportCable.html#ac\"),
			new Array(\"transportpm-remove-cable\",		\"transportCable.html#rc\"),
			new Array(\"transportpm-enable-cable\",		\"transportCable.html#ec\"),
			new Array(\"transportpm-disable-cable\",	\"transportCable.html#dc\"),
			new Array(\"transportpm-add-junction\",		\"transportJunction.html#aj\"),
			new Array(\"transportpm-remove-junction\",	\"transportJunction.html#rj\"),
			new Array(\"transportpm-enable-junction\",	\"transportJunction.html#ej\"),
			new Array(\"transportpm-disable-junction\",	\"transportJunction.html#dj\"),

			new Array(\"device_view-topo\",			\"gd.html\"),
			new Array(\"device_view-tables\",		\"gd.html\"),
			new Array(\"devicepm-online-switch\",		\"gd.html#bo\"),
			new Array(\"devicepm-offline\",			\"gd.html#to\"),
			new Array(\"devicepm-props\",			\"gd.html#pr\"),

			new Array(\"quorum-top\",			\"quorum.html\"),
			new Array(\"quorumpm-maint\",			\"quorum.html#ms\"),
			new Array(\"quorumpm-reset\",			\"quorum.html#rqd\"),
			new Array(\"quorumpm-add\",			\"quorum.html#aqd\"),
			new Array(\"quorumpm-remove\",			\"quorum.html#dqd\"),

			new Array(\"cluster_status-ds-oracle\",		\"dsOracle.html\"),
			new Array(\"cluster_status-ds-apache\",		\"dsApache.html\"),
			new Array(\"cluster_status-ds-sunone-webserver\",	        \"dsiPlanet.html\"),
			new Array(\"cluster_status-ds-sunone-directory-server\",		\"dsiPlanetLDAP.html\"),
			new Array(\"cluster_status-ds-dns\",		\"dsDNS.html\"),
			new Array(\"cluster_status-ds-nfs\",		\"dsNFS.html\"),
			new Array(\"separator\",	\"welcome.html\")
			//new Array(\"\",	\"\"),
		)

	function map_helpMarker(marker) {
		var url = \"unmapped\"

		var i
		for (i=0; i < mappings.length; i++) {
			if (marker == mappings[i][0]) {
				url = mappings[i][1]
				break
			}
		}
	        // confirm(\"map_helpMarker() IN: \" + marker + \"   OUT: \" + url)

		return url
         }";
} # get_helpMarker_mapping

#
# Javascript function call to be embedded in link or form
#   is a call to the above help invocation function
#
sub get_help_link_jscript {
  return "Help()" 
}

sub get_basic_help_url() {
    my ($self, $q) = @_;
    my $locale = extract_locale($q);
    return "/" . $locale . $HELP_DIR . $BASIC_URL;
}

sub get_help_dir() {
    my ($self, $q) = @_;
    my $locale = extract_locale($q);
    return "/" . $locale . $HELP_DIR;
}

sub extract_locale {
  my ($q) = @_;
  my @info = $q->getlocale();
  my $locale = $info[3];
  return $locale;
}
