#!/usr/perl5/bin/perl -w
#
# Copyright 2002-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)login.pl	1.3	03/02/26 SMI"
#
# Login page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Help;
use Cluster::Banner;
use Cluster::Common;
use Sun::Solaris::Utils qw(gettext);

# Global constants
use constant TRUE  => 0;
use constant FALSE => 1;

# Create the needed objects
my $q = new Cluster::Cgi;
my $help = new Cluster::Help;
my $banner = new Cluster::Banner;
my $cluster = new Cluster::Common;

my $user = gettext("User Name:");
my $password = gettext("Password:");
my $login = gettext("&nbsp;Log In&nbsp;");

# Get the apache request object
my $r = Apache->request;

my $uri = "";
my $text = "";
if ((defined($r->prev)) && 
    ($r->prev->subprocess_env("AuthCookieReason") eq "bad_cookie" ||
     $r->prev->subprocess_env("AuthCookieReason") eq "bad_credentials")) {
	
    if (defined $r->prev->subprocess_env("AuthInfo")) {
	if ($r->prev->subprocess_env("AuthInfo") eq "authentication") {
	    $text = $q->login_alert(gettext("Authentication Failed"),
			    gettext("Enter your user name and password."));
	} elsif ($r->prev->subprocess_env("AuthInfo") eq "authorization") {
	    $text = $q->login_alert(gettext("Authorization Failed"),
		gettext("Enter your user name and password."));
	} elsif ($r->prev->subprocess_env("AuthInfo") eq "logout") {
	    $text = $q->login_info(gettext("Logged Out"),
		gettext("You are logged out of SunPlex Manager."));
        } else {
            $text = $q->login_info(gettext("Connection Expired"),
            gettext("Enter your user name and password."));
	}
    } else {
        $text = $q->login_info(gettext("Connection Expired"),
        gettext("Enter your user name and password."));
    }
}

# Get the help javascript functions
my $script = "var helpMarker=\"rbac\"\n";
my $basic_help_url = $help->get_basic_help_url($q);
my $help_link_jscript = $help->get_help_link_jscript();

# Print the login banner
$banner->print_login_banner($q, "document.Login.credential_0.focus();",
			    $script);

print $q->start_script();
print <<EOF;
  if (window != top) {
    top.location.href = "/";
  }
EOF
print $q->end_script();
print $q->start_form({ NAME   => "Login",
		       METHOD => "post",
		       ACTION => "/LOGIN"
		       });

# Start the table for layout of images and form fields
print $q->start_table({ BORDER => 0,
			CELLSPACING => 0,
			CELLPADDING => 0
			});

# Print the warning text
if ($text ne "") {
	print $text;
}

# Spacer
print $q->start_Tr();
print $q->start_td({ COLSPAN => 4 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Begin inline help
print $q->start_Tr();
print $q->start_td({ COLSPAN => 2 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 20,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->start_div({ CLASS => "help-text" });
print gettext("Log in to the SunPlex Manager.");

if ($cluster->is_clustermode() == TRUE) {
	print gettext("Your available roles, if any, will appear after " .
		      "you complete this login. Use ");
	print $q->start_a({ ONCLICK => "return " . $help_link_jscript,
			    ONMOUSEOVER => "window.status='" .
				    gettext("Help") . "'; return true",
			    HREF => $basic_help_url,
			    });
	print gettext("Role-Based Access Control (RBAC)");
	print $q->end_a();
	print gettext(" for enhanced security.");
}

print $q->end_div();
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td({ COLSPAN => 4 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
  
# Login form fields
print $q->start_Tr();
print $q->start_td({ COLSPAN => 2 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->start_table({ BORDER => 0,
			CELLSPACING => 0,
			CELLPADDING => 0
			});

# Begin user prompt
print $q->start_Tr();
print $q->start_td({ WIDTH => 100 });
print $user;
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->input({ TYPE => "text",
		  NAME => "credential_0",
		  VALUE => ""
		  });
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->end_table();
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 40,
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 50,
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => "100%",
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 10,
		HEIGHT => 1,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Begin login form fields
print $q->start_Tr();
print $q->start_td({ COLSPAN => 2 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		BORDER => 0
		});
print $q->end_td();
print $q->start_td();
print $q->start_table({ BORDER => 0,
			CELLSPACING => 0,
			CELLPADDING => 0
			});

# Begin password prompt
print $q->start_Tr();
print $q->start_td({ WIDTH => 100,
		     NOWRAP => 1
		     });
print $password;
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		WIDTH  => 10
		});
print $q->end_td();
print $q->start_td({ ALIGN => "right" });
print $q->input({ TYPE => "password",
		  NAME => "credential_1",
		  VALUE => ""
		  });
print $q->end_td();
print $q->end_Tr();
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Submit button row
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3,
		     ALIGN => "right"
		     });

# Print submit button
$q->html_button("/LOGIN", $login, "document.Login.submit();return false;");

print $q->end_td();
print $q->end_Tr();

# End login form fields
print $q->start_Tr();
print $q->start_td({ COLSPAN => 3 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 10,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->end_table();
print $q->end_td();
print $q->start_td();
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();

# Spacer
print $q->start_Tr();
print $q->start_td({ COLSPAN => 4 });
print $q->img({ SRC    => "/images/dot.gif",
		ALT    => " ",
		HEIGHT => 20,
		BORDER => 0
		});
print $q->end_td();
print $q->end_Tr();
print $q->end_table();

# Hidden destination field
print $q->input({ TYPE => "hidden",
		  NAME => "destination",
		  VALUE => "/cgi-bin/index.pl"
		  });

# End the submit form
print $q->end_form();

# End the page
print $q->end_html();
