#!/usr/perl5/bin/perl -w
#
# Copyright (c) 2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#ident	"@(#)step1.pl	1.18	03/01/07 SMI"
#
# Ask for the cluster name and size

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Create the cluster size values array
# my @cluster_size_values = $install->get_min_cluster_size() .. $install->get_max_cluster_size();
my @cluster_size_values = 2 .. 12;

# Start the html document
$install->header($q, [gettext("Sun Cluster Installation"),
    "/cgi-bin/installation/step0.pl",
    gettext("Cluster Name (Step 1 of 8)")]);
print $q->p({class => "action-window-normal-text"});

# Generate a default name for the cluster
my ($hostname) = `hostname`;
chop $hostname;
my ($defaultname) = "";
if ($hostname =~ /(.*)-\d+$/) {
    $defaultname = $1;
    if ($defaultname =~ /^phys-(.*)/) {
	$defaultname = $1;
    }
}

# Print the form
print gettext("Enter the cluster name and the total number of nodes.")."<BR>";

# Autodiscover cluster size
$q->param('cluster_size', $install->determine_nodes($q));

print $q->start_form({ action => '/cgi-bin/installation/step2.pl',
		       method => 'get'
		       });

print $q->start_table();
print $q->start_Tr();

print $q->start_td({ NOWRAP => undef});
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Cluster Name: "));
print $q->end_td();     

print $q->start_td();
print $q->textfield({ name => 'cluster_name', size => 20,
    default => $defaultname });
print $q->end_td();     
print $q->end_Tr();

print $q->start_Tr();
print $q->start_td({ NOWRAP => undef});
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Number of nodes: "));
print $q->end_td();

print $q->start_td();
print $q->popup_menu({ name   => 'cluster_size',
		       values => \@cluster_size_values
		       });

print $q->end_td();
print $q->end_Tr();
print $q->end_table();

$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });


# Put spaces between the buttons
print "&nbsp;" ;

print $q->submit({ name  => 'submit_step_1',
		   value => gettext("  Next >  ")
		   });
$install->end_button_table($q, "cancel");

print $q->end_form();

# End the html document
$install->footer($q);
