#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)sds_step1.pl	1.27	03/01/07 SMI"
#
# SDS Install Step 1

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use FileHandle;
use Sun::Solaris::Utils qw(gettext);

# Set constants
use constant TRUE          => 0;
use constant FALSE         => 1;

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Create the page title based on the OS version
my $title;
if ($install->is_solaris8() == TRUE) {
	$title = gettext("Solstice DiskSuite (Step 4 of 8)");
} else {
	$title = gettext("Solaris Volume Manager (Step 4 of 8)");
}

# Start the html document
$install->header($q, [gettext("Sun Cluster Installation"),
    "/cgi-bin/installation/step0.pl", $title]);
print $q->p({class => "action-window-normal-text"});

# Validate transport selections, unless novalidate is set
my ($errors, $warnings);
if (defined($q->param('novalidate'))) {
    $errors = [];
    $warnings = [];
} else {
    # Don't buffer STDOUT
    STDOUT->autoflush(1);

    print gettext("Validating transport configuration...")."<br><br>\n";

    STDOUT->autoflush(0);

    ($errors, $warnings) = $install->validate_transport($q);
}

# If we found errors, print them
if ($#{@{$errors}} > -1) {
    $install->start_message_table($q, "/images/error_32.gif",
	gettext("Error"), gettext("Incorrect Transport Configuration"), "");
    print $q->br();

    print $q->start_ul();

    # Print information
    foreach my $error (@{$errors}) {
	print $q->li($error);
    }
    print $q->end_ul();
    $install->end_message_table($q);
    print $q->p({class => "action-window-normal-text"});

    print gettext("Please return to the previous page and correct this problem.");

    print $q->start_form();

    $install->start_button_table($q);

    print $q->button({ value   => gettext("  < Back  "),
		       onClick => "history.back()"
		       });
    $install->end_button_table($q, "cancel");

    print $q->end_form();
    
    # End the html document
    $install->footer($q);

    # Exit gracefully
    exit(0);
}

# If we found warnings, print them
if ($#{@{$warnings}} > -1) {

    $install->start_message_table($q, "/images/warning_32.gif",
	gettext("Warning"), gettext("Incorrect Transport Configuration"),
	gettext("The following potential problems were detected with " .
	"the specified transport configuration:"));

    print $q->br();

    print $q->start_ul();

    # Print information
    foreach my $warning (@{$warnings}) {
	print $q->li($warning);
    }
    print $q->end_ul();

    $install->end_message_table($q);
    print $q->p({class => "action-window-normal-text"});

    print gettext("Please return to the previous page and correct this problem.");
    print $q->br();
    print gettext("If you are sure the configuration is correct, " .
	"you may continue.");

    print $q->start_form({ action => '/cgi-bin/installation/sds_step1.pl' });

    # Print the hidden cluster fields
    $q->print_hidden_cluster_fields();
    print $q->hidden({ name    => "novalidate", value => 1});

    $install->start_button_table($q);

    print $q->button({ value   => gettext("  < Back  "),
		       onClick => "history.back()"
		       });


    # Put spaces between the buttons
    print "&nbsp;" ;

    print $q->submit({ name  => 'submit_step_3',
		       value => gettext("  Next >  ")
		       });
    $install->end_button_table($q, "cancel");

    print $q->end_form();
    print $q->end_form();
    print $q->end_td();
    print $q->end_Tr();
    print $q->end_table();
    
    # End the html document
    $install->footer($q);

    # Exit gracefully
    exit(0);
}

# Print stuff
if ($install->is_solaris8() == TRUE) {
	print gettext("Select whether or not to install Solstice DiskSuite " .
		      "and configure mirrored disksets. ");
} else {
	print gettext("Select whether or not to configure Solaris Volume " .
		      "Manager mirrored disksets. ");
}

print gettext("In order to configure mirrored disksets, your cluster must " .
	      "have at least two disks which are shared between two or " .
	      "more nodes and hosted across multiple controllers on " .
	      "each node. ");

print gettext("If you plan to install either the Scalable Apache or HA " .
	      "NFS data services, then you must select \"Yes\" here.");

# Get global values
my $cluster_name = $q->param('cluster_name');

# Print the form
print $q->start_form({ action => '/cgi-bin/installation/ds_step1.pl' });
print $q->start_table({ cellpadding => 5,
			class => "action-table"});
print $q->start_Tr(), $q->start_td({nowrap => undef});
print $q->start_div({ class => "action-window-label-text" });

# Word the question based on OS version
if ($install->is_solaris8() == TRUE) {
	print gettext("Would you like to install Solstice DiskSuite?");	
} else {
	print gettext("Would you like to create mirrored disksets?");	
}

print $q->end_div(), $q->end_td();

print $q->start_td();

print $q->radio_group({ name => 'install_sds',
			values => ['yes', 'no'],
			default => 'yes',
			# linebreak => 'false',
			labels => { yes => gettext(" Yes "),  ### part of radio group
				    no => gettext(" No ") }  ### part of radio group
			});

print $q->end_td();
print $q->end_Tr();

# End the table
print $q->end_table();

# Print the hidden cluster fields
$q->print_hidden_cluster_fields();

$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });


# Put spaces between the buttons
print "&nbsp;" ;

print $q->submit({ name  => 'submit_step_3',
		   value => gettext("  Next >  ")
		   });
$install->end_button_table($q, "cancel");

# End the form
print $q->end_form();

# End the html document
$install->footer($q);
