#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)ldap.pl	1.12	03/02/25 SMI"
#

use lib '/opt/SUNWscvw/lib/perl';
use Socket;
use Cluster::common;
use Cluster::Common;
use strict;
use Sun::Solaris::Utils qw(gettext);

&do_page("Configure Sun ONE Directory Server"); # gettext("Configure Sun ONE Directory Server")
exit;

sub cmd_mainpage {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();
    if (! $errpos) {

	if (! &checktype("SUNW.nsldap")) {
		return;
	}
    }

    if (! &getlh()) {
	return;
    }

    &action_table_start();

    if ($errpos == 5) {
	&errmsg();
    }
    &action_table_row_start(gettext("Installation Source Directory:"));
    &input("setupdir");
    &action_table_supplement(gettext("(i.e. directory holding the \"setup\" command)"));
    &action_table_row_end();

    if ($errpos == 21) {
	&errmsg();
    }
    &action_table_row_start(gettext("Desired Administrative Server Password:"));
    &password("nspassword");
    &action_table_supplement(
	gettext("(password must have at least 8 characters)"));
    &action_table_row_end();


    if ($errpos == 3) {
	&errmsg();
    }
    &action_table_row_start(gettext("Desired Directory Manager Password:"));
    &password("dmpassword");
    &action_table_supplement(
	gettext("(password must have at least 8 characters)"));
    &action_table_row_end();

    if ($FORM{"aport"} eq "") {
	$FORM{"aport"} = 8888;
    }

    if ($errpos == 2) {
	&errmsg();
    }
    &action_table_row_start(gettext("LDAP Administrative Server Port:"));
    &input("aport", 8);
    &action_table_row_end();

    if ($FORM{"wport"} eq "") {
	    if (! &portinuse(389)) {
		$FORM{"wport"} = 389;
	    } else {
		$FORM{"wport"} = &freeport(2000);
	    }
    }
    if ($errpos == 104) {
	&errmsg();
    }
    &action_table_row_start(gettext("LDAP Server Port:"));
    &input("wport", 8);
    &action_table_row_end();

    if ($errpos == 8) {
	&errmsg();
    }
    if ($FORM{"id"} eq "") {
	$FORM{"id"} = "ldap";
    }
    &action_table_row_start(gettext("LDAP Server ID:"));
    &input("id");
    &action_table_row_end();

    if ($errpos == 9) {
	&errmsg();
    }
    if ($FORM{"suffix"} eq "") {
	if (&domain =~ /([^\.]+\.[^\.]+$)/) { # foo.bar
	    $FORM{"suffix"} = "o=$1";
	} else {
	    $FORM{"suffix"} = "o=".&domain;
	}
    }
    &action_table_row_start(gettext("LDAP Directory Suffix:"));
    &input("suffix");
    &action_table_row_end();

    if ($errpos == 6) {
	&errmsg();
    }
    if ($FORM{"loc"} eq "") {
	my $i;
	for ($i = ""; $i < 10; $i++) {
	    $FORM{"loc"} = &getglobal()."/nsldap$i";
	    if (! -e $FORM{"loc"}."/setup/setup.inf") {
		last;
	    }
	}
    }
    &action_table_row_start(gettext("Destination Installation Directory:"));
    &input("loc", 35);
    &action_table_supplement(gettext("(Note: the install will fail if LDAP is already installed in this directory.)"));
    &action_table_row_end();

    if ($errpos == 101) {
	&errmsg();
    }
    &action_table_row_start(gettext("Network Resource:"));
    &hostnameoption();
    &action_table_row_end();

    if ($errpos == 102) {
	&errmsg();
    }
    &action_table_row_start(gettext("LDAP Resource Name:"));
    if ($FORM{"rs"} eq "") {
	# Find a resource name that is not in use
	for (my $i = 1; $i<10; $i++) {
	    $FORM{"rs"} = "ldap-$i";
	    if (! defined $rsdesc{$FORM{"rs"}}) {
		last;
	    }
	    $FORM{"rs"} = "";
	}
    }
    &input("rs");
    &action_table_row_end();
    &action_table_end();

    &submit_table_start();
    &submit("cmd_setup", gettext("Continue"));
    &submit_table_end();
    &wizard_end();
}

# Next part of configuration
sub cmd_setup {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    &getscrgconfig();

    if ($FORM{"setupdir"} eq "") {
	&errpage(gettext("Location must be specified"), 5, "cmd_mainpage");
    }

    if (! -d $FORM{"setupdir"}) {
	&errpage(gettext("Setup directory does not exist"), 5, "cmd_mainpage");
    }
    my $CMD;
    if (! -f $FORM{"setupdir"}."/setup") {
	&errpage(gettext("Directory does not contain \"setup\" command"), 5, "cmd_mainpage");
    }

    &validateport("cmd_mainpage", "aport", 2, "localhost");

    &validatepassword("cmd_mainpage", 8, "nspassword", 21);

    if ($FORM{"dmpassword"} eq "") {
	$FORM{"dmpassword"} = $FORM{"nspassword"};
    }

    &validatepassword("cmd_mainpage", 8, "dmpassword", 3);

    &validatelh("cmd_mainpage", "lh");
    &validateport("cmd_mainpage", "wport");

    if (-e $FORM{"loc"}."/setup/setup.inf") {
	&errpage(gettext("Already installed in that location (setup/setup.inf exists)"), 6, "cmd_mainpage");
    }

    if ($FORM{"loc"} eq "") {
	&errpage(gettext("Location must be specified"), 6, "cmd_mainpage");
    }

    if (!&isglobal($FORM{"loc"})) {
	&errpage(gettext("Directory must be global\n"), 6, "cmd_mainpage");
    }

    if ($FORM{"id"} eq "") {
	&errpage(gettext("Server id must be specified"), 8, "cmd_mainpage");
    }

    if ($FORM{"suffix"} eq "") {
	&errpage(gettext("Suffix must be specified"), 9, "cmd_mainpage");
    }

    if ($FORM{"rs"} eq "") {
	&errpage(gettext("Resource must be specified"), 102, "cmd_mainpage");
    }

    if (defined $rsrg{$FORM{"rs"}}) {
	&errpage(sprintf(gettext("Resource %s in use"), $FORM{"rs"}), 102, "cmd_mainpage");
    }

    my($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});

    # Find which node lh is running on, since the LDAP install must
    # take place on the active node
    &getscstatrg;
    my $active = "";
    my $i;
    for ($i = 0; $i <= $#nodes; $i++) {
	if ($rsstate{$lh, $nodes[$i]} eq "Online") {
	    $active = $nodes[$i];
	    last;
	}
    }
    if ($active eq "") {
	&errpage(sprintf(gettext("Logical hostname %s is not active on any nodes.  It must be active before LDAP can be installed.  Start it, or select a different hostname."), $lh),
	    101, "cmd_mainpage");
    }

    &validateport("cmd_mainpage", "aport", 2, $lh);
    &validateport("cmd_mainpage", "wport", 104, $lh);

    undef @nodes;
    $nodes[0] = $active;
    $FORM{"ahost"} = $active;
    &hidden("ahost");

    print "<h2>".sprintf(gettext("Install of LDAP server to global directory %s"), $FORM{"loc"})."</h2>\n";
    print "<p>";
    print $q->sprintfn(gettext("Install taking place on node %1 which is " .
	"serving %2.\n"), , $active, $lh);
    print "<p>".gettext("This may take several minutes.")."<p>\n";


    $FORM{"server"} = $lh.".".&domain;

    my $err;
    $CMD = "/cgi-bin/ds/ldap-script.pl";
    $cmd_save = $FORM{"setupdir"}."/setup";
    my $cluster = new Cluster::Common;
    $FORM{"mode"} = "install";

    $err = $cluster->run_parallel($CMD, 1, \%FORM);
    if ($err =~ /Unable to bind to/) {
	&errpage(gettext("Selected port in use"), 104, "cmd_mainpage");
    } elsif ($err =~ /suffix must be a valid DN/) {
	&errpage(gettext("Suffix must be a valid DN"), 9, "cmd_mainpage");
    } elsif ($err) {
	&errmsg(gettext("Install did not work"));
	return;
    }

    print "\n";
    print gettext("Stopping server\n");
    $CMD = "/cgi-bin/ds/ldap-script.pl";
    $FORM{"mode"} = "stop";
    $err = $cluster->run_parallel($CMD, 1, \%FORM);
    $CMD = $FORM{"loc"}."/slapd-".$FORM{"id"}."/stop-slapd";
    $cmd_save = join("\n", $cmd_save, $CMD);

    if ($err) {
	&errmsg(gettext("stop-slapd did not work"));
    }

    &okmsg(gettext("LDAP installed"));

    # Pass info to the next page
    &hidden("loc");
    &hidden("id");
    &hidden("lh");
    &hidden("wport");
    &hidden("rs");
    &hidden("aport");
    &hidden("suffix");
    print "<p>".gettext("Press to configure and start resource:\n");
    &submit("cmd_run", gettext("Continue"));

}

sub cmd_run {
    &wizard_start;
    print $q->_script($q->yoke_jscript("c"));
    my ($conf, $args, $status);
    my ($lh, $lhrg, $lhrs, $lhmode) = split(/:/, $FORM{"lh"});
    $conf = $FORM{"loc"}."/slapd-".$FORM{"id"};
    $args = "-t SUNW.nsldap ".
	    " -x Confdir_list=$conf".
	    " -y Port_list=".$FORM{"wport"}."/tcp".
	    " -y Network_resources_used=$lh";

    $status = &createservice($args);
    if ($status) {
	return;
    }

    my $port = "";
    if ($FORM{"wport"} != 389) {
	$port = " -p ".$FORM{"wport"};
    }
    print "<p>".gettext("You can test it with, e.g.")."<br>\n";
    print "<tt>cd ".$FORM{"loc"}."/shared/bin; ./ldapsearch -h $lh$port -b \"".$FORM{"suffix"}."\" \"objectclass=*\"</tt>\n";
    my $aurl = "http://".$FORM{"ahost"}.".".&domain().":".$FORM{"aport"};
    print "<p>".sprintf(gettext("The admin server can be accessed at <a target=\"new\" href=\"%s\">%s</a>\n"), $aurl, $aurl);
    &reloadmenu();
    print $q->_script($q->yoke_jscript("rg-rs-".$FORM{"rs"}));
}
