/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProtocolException;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.SCProperties;
import com.sun.cluster.sccheck.Server;
import com.sun.cluster.sccheck.ServerProtocol;
import com.sun.cluster.sccheck.ServerThread;
import com.sun.cluster.sccheck.Session;
import com.sun.cluster.sccheck.SessionFactory;
import com.sun.cluster.sccheck.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SccheckServer
implements Server,
Globals {
    private static boolean busy = false;
    private String localeLang = null;
    private String localeCountry = null;
    private String localeVariant = null;
    private String auth = null;
    private String explorerVer = null;
    private ServerProtocol sprot = null;
    private String privateSubnet = "";
    private String privateNetMask = "";
    private String clustername = "";
    private boolean inClusterMode = false;
    private Session sessionInProgress = null;
    private ServerThread serverThread = null;
    private Logger logger = null;
    private SCProperties props = null;

    public SccheckServer(String[] stringArray) {
        Object var2_2 = null;
        try {
            this.props = SCProperties.getSCProperties("/etc/default/sccheck");
        }
        catch (IOException iOException) {}
        boolean bl = SCProperties.booleanFromProps("LOGGING", true, this.props);
        this.logger = new Logger("/var/cluster/logs/sccheck/server.log", bl);
        this.logger.trace("SccheckServer() -- ENTER -- ");
        if (!bl) {
            System.setProperty("logging.FileHandler.path", "/dev/null");
        }
        int n = 0;
        while (n < stringArray.length) {
            this.logger.info("SccheckServer(): " + stringArray[n]);
            ++n;
        }
        try {
            this.checkRequiredDefines();
        }
        catch (SCException sCException) {
            this.logger.toSyslog("daemon.error", "sccheckd", sCException.getMessage());
            this.serverExit();
        }
        this.mainServer();
    }

    private void checkRequiredDefines() throws SCException {
        String string = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement("configSuffix");
        vector.addElement("kae.kce.KCEFactFactory.KCEre");
        vector.addElement("kae.Explorer.LocalDB");
        vector.addElement("kae.kce.KCEFactFactory.useDBStore");
        vector.addElement("kae.useRMI");
        vector.addElement("logging.handlers");
        vector.addElement("logging.FileHandler.level");
        vector.addElement("logging.FileHandler.path");
        vector.addElement("sccheck.clustermode");
        vector.addElement("sccheck.clustername");
        vector.addElement("sccheck.privatenet");
        vector.addElement("sccheck.privatenetmask");
        vector.addElement("sccheck.explorerVer");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = System.getProperty(string2);
            if (string3 != null && string3.length() != 0) continue;
            string = string == null ? string2 : String.valueOf(string) + " " + string2;
        }
        if (string != null) {
            Object[] objectArray = new Object[]{string};
            String string4 = I18n.getLocalized("requiredDefinesMissing", objectArray);
            throw new SCException(string4);
        }
        this.clustername = System.getProperty("sccheck.clustername");
        this.privateSubnet = System.getProperty("sccheck.privatenet");
        this.privateNetMask = System.getProperty("sccheck.privatenetmask");
        this.inClusterMode = Boolean.getBoolean("sccheck.clustermode");
        this.logger.info("SccheckServer.checkRequiredDefines() inClusterMode: " + this.inClusterMode);
        this.explorerVer = System.getProperty("sccheck.explorerVer");
        this.logger.info("SccheckServer.checkRequiredDefines() explorerVer: " + this.explorerVer);
    }

    private int compareIntArrays(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if (nArray[n2] < nArray2[n2]) {
                n = -1;
                break;
            }
            if (nArray[n2] > nArray2[n2]) {
                n = 1;
                break;
            }
            ++n2;
        }
        return n;
    }

    private void conditionalServerExit() {
        if (!this.isBusy()) {
            this.serverExit();
        }
    }

    private int fieldToInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    private InetAddress getLocalAddr(Socket socket) {
        InetAddress inetAddress = socket.getLocalAddress();
        this.logger.info("SccheckServer.getLocalAddr(): " + inetAddress.toString());
        return inetAddress;
    }

    private int getRemotePort(Socket socket) {
        int n = socket.getPort();
        this.logger.info("SccheckServer.getRemotePort(): " + n);
        return n;
    }

    public boolean isBusy() {
        return busy;
    }

    private boolean isLocalhost(InetAddress inetAddress) {
        boolean bl = false;
        this.logger.trace("SccheckServer.isLocalhost() localAddr: " + inetAddress.toString());
        if (inetAddress.toString().endsWith("/127.0.0.1")) {
            bl = true;
        }
        this.logger.trace("SccheckServer.isLocalhost(): " + bl);
        return bl;
    }

    private boolean isNetAddressOK(String string, String string2, InetAddress inetAddress) {
        this.logger.trace("SccheckServer.isNetAddressOK() -- ENTER-- ");
        boolean bl = false;
        bl = this.inClusterMode ? this.isPrivateNet(string, string2, inetAddress) : this.isLocalhost(inetAddress);
        this.logger.trace("SccheckServer.isNetAddressOK() -- EXIT-- " + bl);
        return bl;
    }

    private boolean isPrivateNet(String string, String string2, InetAddress inetAddress) {
        this.logger.trace("SccheckServer.isPrivateNet() -- ENTER --");
        boolean bl = false;
        this.logger.info("SccheckServer.isPrivateNet() privateSubnet: " + string);
        this.logger.info("SccheckServer.isPrivateNet() privateNetMask: " + string2);
        this.logger.info("SccheckServer.isPrivateNet() localAddr: " + inetAddress.toString());
        int n = Utils.inetAddressToInt(inetAddress);
        this.logger.info("SccheckServer.isPrivateNet() hostVal: " + n);
        int n2 = Utils.dottedQuadToInt(string2);
        this.logger.info("SccheckServer.isPrivateNet() maskVal: " + n2);
        int n3 = Utils.dottedQuadToInt(string);
        this.logger.info("SccheckServer.isPrivateNet() privateSubnetVal: " + n3);
        int n4 = n2 & n;
        this.logger.info("SccheckServer.isPrivateNet() hostSubnet: " + n4);
        if (n4 == n3) {
            bl = true;
        }
        this.logger.trace("SccheckServer.isPrivateNet() -- EXIT --: " + bl);
        return bl;
    }

    private boolean isRemotePortOK(int n) {
        this.logger.trace("SccheckServer.isRemotePortOK() -- ENTER: " + n);
        boolean bl = false;
        bl = n <= 1023 && n >= 513;
        this.logger.trace("SccheckServer.isRemotePortOK() -- EXIT--: " + bl);
        return bl;
    }

    public static void main(String[] stringArray) {
        SccheckServer sccheckServer = new SccheckServer(stringArray);
    }

    private void mainServer() {
        int n = SCProperties.intFromProps("SERVER_PORT", 7124, this.props);
        ServerSocket serverSocket = null;
        this.sprot = null;
        try {
            this.logger.info("**  SccheckServer.mainServer() making ServerSocket on port " + n);
            serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            this.logger.error("SccheckServer.mainServer() in IOException ioex1: " + iOException.getMessage());
            this.logger.toSyslog("daemon.error", "sccheckd", "sccheckd: Unable to create  ServerSocket; exiting.");
            this.serverExit();
        }
        while (true) {
            Socket socket = null;
            this.logger.trace("--------------------------------");
            this.logger.trace(" ***  SccheckServer.mainServer() waiting...");
            try {
                Object object;
                socket = serverSocket.accept();
                this.logger.trace(" **   SccheckServer.mainServer() have a client...");
                this.logger.trace("");
                this.logger.trace("SccheckServer.mainServer() about to make SProt");
                this.sprot = new ServerProtocol(this, socket);
                int n2 = this.sprot.getCommonVersion(1);
                this.logger.info("SccheckServer.mainServer() common version: " + n2);
                Session session = SessionFactory.getSession(n2);
                this.logger.info("SccheckServer.mainServer() made session: com.sun.cluster.sccheck.SessionV" + n2);
                this.logger.trace("SccheckServer.mainServer() initializing SessionV" + n2);
                switch (n2) {
                    case 1: {
                        session.initServer(this, this.sprot, this.inClusterMode);
                        break;
                    }
                    default: {
                        object = "sccheckd: Unsupported Session version: " + n2;
                        this.logger.toSyslog("daemon.error", "sccheckd", (String)object);
                        this.conditionalServerExit();
                    }
                }
                this.logger.trace("SccheckServer.mainServer() did session.initServer() ");
                object = this.getLocalAddr(socket);
                int n3 = this.getRemotePort(socket);
                this.logger.trace("SccheckServer.mainServer() validating request for session");
                Locale locale = new Locale(this.localeLang, this.localeCountry, this.localeVariant);
                Locale.setDefault(locale);
                this.logger.info("SccheckServer.mainServer() set userLocale: " + locale.getDisplayName());
                try {
                    this.testPermission(this.auth, this.privateSubnet, this.privateNetMask, (InetAddress)object, n3);
                    this.testExplorerVer();
                }
                catch (SCException sCException) {
                    this.logger.error("SccheckServer.mainServer() permission red light: ProtocolException pex1: " + sCException.getMessage());
                    this.sprot.sendErrPerm(sCException.getMessage());
                    this.conditionalServerExit();
                }
                this.logger.trace("SccheckServer.mainServer() permission green light; sending permOK");
                this.sprot.sendPermOK();
                if (this.isBusy()) {
                    this.logger.trace("SccheckServer.mainServer() joining session in progress");
                    this.sessionInProgress.joinSession(this.sprot);
                    this.serverThread.addServerProtocol(this.sprot);
                    continue;
                }
                this.setBusy(true);
                this.logger.trace("SccheckServer.mainServer() starting new session");
                this.sessionInProgress = session;
                this.startService(session, n2, this.sprot);
                continue;
            }
            catch (IOException iOException) {
                this.logger.error("SccheckServer.mainServer() in IOException ioex2: " + iOException.getMessage());
                this.logger.toSyslog("daemon.error", "sccheckd", "sccheckd: Unable to accept socket connection: exiting.");
                this.conditionalServerExit();
                continue;
            }
            catch (ProtocolException protocolException) {
                this.logger.error("SccheckServer.mainServer() in ProtocolException pex: " + protocolException.getMessage());
                this.logger.toSyslog("daemon.error", "sccheckd", "sccheckd: Session init failed (pex).");
                this.conditionalServerExit();
                continue;
            }
            catch (SCException sCException) {
                this.logger.error("SccheckServer.mainServer() in SCException scex: " + sCException.getMessage());
                this.logger.toSyslog("daemon.error", "sccheckd", "sccheckd: Session init failed (scex).");
                this.conditionalServerExit();
                continue;
            }
            break;
        }
    }

    private boolean processAuthStr(String string) {
        boolean bl = string.equals("") ? true : true;
        return bl;
    }

    public void serverExit() {
        this.logger.trace(" ***  SccheckServer.serverExit()");
        this.logger.close();
        System.exit(0);
    }

    public void setAuth(String string) {
        this.auth = string;
    }

    public void setBusy(boolean bl) {
        this.logger.info(" ***  SccheckServer.setBusy(): " + bl);
        busy = bl;
    }

    public void setLocaleCountry(String string) {
        this.localeCountry = string;
    }

    public void setLocaleLang(String string) {
        this.localeLang = string;
    }

    public void setLocaleVariant(String string) {
        this.localeVariant = string;
    }

    private void startService(Session session, int n, ServerProtocol serverProtocol) {
        this.logger.trace("SccheckServer.startService() -- ENTER-- ");
        this.serverThread = new ServerThread(this, session, n, serverProtocol);
        this.serverThread.start();
        this.logger.trace("SccheckServer.startService() -- EXIT-- ");
    }

    private void testExplorerVer() throws SCException {
        this.logger.trace("SccheckServer.testExplorerVer() -- ENTER -- " + this.explorerVer + " vs. " + "3.5.1");
        StringTokenizer stringTokenizer = new StringTokenizer(this.explorerVer, ",");
        String string = stringTokenizer.nextToken();
        int[] nArray = new int[3];
        stringTokenizer = new StringTokenizer(this.explorerVer, ".");
        int n = 0;
        while (n < 3) {
            try {
                nArray[n] = this.fieldToInt(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {}
            ++n;
        }
        int[] nArray2 = new int[3];
        stringTokenizer = new StringTokenizer("3.5.1", ".");
        int n2 = 0;
        while (n2 < 3) {
            try {
                nArray2[n2] = this.fieldToInt(stringTokenizer.nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {}
            ++n2;
        }
        if (this.compareIntArrays(nArray, nArray2) < 0) {
            String string2 = "";
            Object[] objectArray = new Object[]{this.explorerVer, "3.5.1"};
            this.logger.error("SccheckServer.testExplorerVer() explorer version too old.");
            string2 = I18n.getLocalized("explorerVersionFailure", objectArray);
            throw new SCException(string2);
        }
        this.logger.trace("SccheckServer.testExplorerVer() -- EXIT -- ");
    }

    private void testPermission(String string, String string2, String string3, InetAddress inetAddress, int n) throws SCException {
        this.logger.trace("SccheckServer.testPermission() -- ENTER -- ");
        String string4 = "";
        if (!this.processAuthStr(string)) {
            this.logger.error("SccheckServer.testPermission() authentication failure");
            string4 = I18n.getLocalized("authenticationFailure");
            throw new SCException(string4);
        }
        this.logger.info("SccheckServer.testPermission() authentication succeeded");
        if (!this.isRemotePortOK(n)) {
            this.logger.error("SccheckServer.testPermission() not 'root port' from client");
            string4 = I18n.getLocalized("mustConnectViaPrivilegedPort");
            throw new SCException(string4);
        }
        this.logger.info("SccheckServer.testPermission() remote port is privileged");
        if (!this.isNetAddressOK(string2, string3, inetAddress)) {
            this.logger.error("SccheckServer.testPermission() not private net and not localhost");
            string4 = I18n.getLocalized("mustConnectViaPrivateNetworkOrLocalhost");
            throw new SCException(string4);
        }
        this.logger.info("SccheckServer.testPermission() network connection granted");
        this.logger.trace("SccheckServer.testPermission() -- EXIT -- ");
    }
}

