#!/usr/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)node_info.pl	1.9	03/02/26 SMI"
#
# Node property page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Node;
use Cluster::RBAC;
use Sun::Solaris::Utils qw(gettext);

# Create the cluster objects
my $q = new Cluster::Cgi;
my $rbac = new Cluster::RBAC;
my $node = new Cluster::Node;

# Set the page title
my $title = gettext("Nodes");

# Get the nodename
my $nodename = $q->param("node");

# Print the query header and make the page expire now
print $q->header(-expires => "now");

# Start the document
print $q->start_html({ TITLE => gettext("Node Information"),
		       STYLE  => { 'src' => '/css/clustmgr-style.css'},
		       CLASS  => "default-body",
		       ONUNLOAD => $q->unregister_jscript(),
		       SCRIPT => "top.helpMarker=\"node_info-top\"\n" .
			$q->yoke_jscript("n-$nodename") .
$q->refresh_jscript('content', 'ESC_cluster_node_state_change')
		       });

# Check for node read authorization
if (!$rbac->check_auth($CL_AUTH_NODE_READ)) {
	$rbac->auth_error($q, $title);
	exit;
}

##############################################################################
#
# Action Bar Table
#
##############################################################################

# Start the action bar table
$q->start_action_bar_table([$title, "/cgi-bin/node/node_status.pl",
	$nodename], undef,
	{NOWRAP => undef, ALIGN => "right", WIDTH => "99%"});

# Print the telnet link to the node
$q->telnet_link($nodename);

# Print the middle of the action table
$q->mid_action_bar_table();

# End the action bar table
$q->end_action_bar_table();

##############################################################################
#
# Status table for nodes
#
##############################################################################

# Print the node status table
$node->node_info_table($q, $nodename);
