/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.UNIXDomainSocket;
import com.sun.wbem.wdr.WDRIndication;
import com.sun.wbem.wdr.XCEvent;
import com.sun.wbem.wdr.XCEventProvider;
import java.io.DataInputStream;
import java.io.IOException;

class XCEventHandler
extends Thread {
    private static final String m_EFEServerPath = "/var/opt/SUNWSMS/data/efeSock";
    private UNIXDomainSocket m_EFESocket;
    private DataInputStream m_DataIn;
    private XCEventProvider m_EventProvider;
    protected String m_PackageName;
    protected static XCEventHandler m_SingleInst = null;

    protected XCEventHandler() {
    }

    protected XCEventHandler(XCEventProvider eventProvider) throws IOException {
        this.m_EventProvider = eventProvider;
        this.m_EFESocket = new UNIXDomainSocket(m_EFEServerPath);
        this.m_DataIn = new DataInputStream(this.m_EFESocket.getInputStream());
        this.m_PackageName = this.getClass().getPackage().getName();
    }

    protected WDRIndication createIndication(XCEvent event, String indication) throws CIMException {
        String indicationPrefix = "Solaris_";
        int prefixLen = "Solaris_".length();
        String jIndicationName = String.valueOf(this.m_PackageName) + "." + indication.substring(prefixLen);
        try {
            Class<?> jIndicationClass = Class.forName(jIndicationName);
            WDRIndication wdrInd = (WDRIndication)jIndicationClass.newInstance();
            wdrInd.initialize(event, indication);
            return wdrInd;
        }
        catch (Exception e) {
            Logger.logErr("Exception in createIndication " + e);
            throw new CIMException("CIM_ERR_INVALID_CLASS", (Object)e.getLocalizedMessage());
        }
    }

    public static XCEventHandler getReference(XCEventProvider eventProvider) throws IOException {
        if (m_SingleInst == null) {
            m_SingleInst = new XCEventHandler(eventProvider);
        }
        return m_SingleInst;
    }

    protected XCEvent readEvent() throws IOException, CIMException {
        byte[] packet;
        int packetSize = 0;
        int bytesRead = 0;
        XCEvent event = null;
        packetSize = this.m_DataIn.readInt();
        Logger.logDebug("readEvent: packetSize is " + packetSize);
        if (packetSize > 0 && (bytesRead = this.m_DataIn.read(packet = new byte[packetSize], 0, packetSize)) > 0) {
            event = new XCEvent(new String(packet));
        }
        return event;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        String ind = null;
        XCEvent event = null;
        try {
            try {
                while (true) {
                    if ((ind = this.m_EventProvider.eventToIndication(event = this.readEvent())) == null || !this.m_EventProvider.isActiveEvent(ind.toLowerCase())) {
                        continue;
                    }
                    WDRIndication wdrInd = this.createIndication(event, ind);
                    CIMInstance ci = wdrInd.createCIMInstance();
                    Logger.logDebug("Delivering " + ci);
                    this.m_EventProvider.deliverEvent(ci);
                }
            }
            catch (IOException ioe) {
                Logger.logDebug(ioe.getMessage());
            }
            catch (CIMException ce) {
                Logger.logDebug(ce.getMessage());
            }
            Object var4_9 = null;
            if (m_SingleInst == null) return;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            if (m_SingleInst == null) throw throwable;
            try {
                this.terminate();
                throw throwable;
            }
            catch (IOException ioe1) {
                Logger.logErr(ioe1.getMessage());
            }
            throw throwable;
        }
        try {
            this.terminate();
            return;
        }
        catch (IOException ioe1) {
            Logger.logErr(ioe1.getMessage());
        }
    }

    public void terminate() throws IOException {
        Logger.logDebug("terminating the XCEventHandler");
        m_SingleInst = null;
        if (this.m_EFESocket != null) {
            this.m_EFESocket.close();
            this.m_EFESocket = null;
        }
        if (this.m_DataIn != null) {
            this.m_DataIn.close();
            this.m_DataIn = null;
        }
    }
}

