/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.UDSInputStream;
import com.sun.wbem.wdr.UDSOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

public class UNIXDomainSocket
extends Logger {
    private int socketDescriptor;
    private String socketPath;
    private boolean connected = false;

    public UNIXDomainSocket(String socketPath) throws IOException {
        Logger.logDebug(String.valueOf(this.getClass().getName()) + " constructor");
        this.socketPath = socketPath;
        this.socketDescriptor = this.createEndPoint();
        if (this.socketDescriptor < 0) {
            String errorMsg = "Failed to create end point";
            throw new SocketException(errorMsg);
        }
        Logger.logDebug("socketDescriptor " + this.socketDescriptor);
        if (!this.connect(this.socketDescriptor, socketPath)) {
            this.close();
            String errorMsg = "Failed to connect to " + socketPath;
            throw new SocketException();
        }
        this.connected = true;
        Logger.logDebug("connected " + this.connected);
    }

    protected native int availableBytes(int var1);

    public void close() throws IOException {
        if (!this.connected) {
            throw new IOException();
        }
        this.close(this.socketDescriptor);
        this.connected = false;
    }

    protected native int close(int var1);

    protected native boolean connect(int var1, String var2);

    protected native int createEndPoint();

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            throw new IOException();
        }
        return new UDSInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            throw new IOException();
        }
        return new UDSOutputStream(this);
    }

    protected int getSockDescriptor() {
        return this.socketDescriptor;
    }

    protected native int readByte(int var1);

    protected native void writeByte(int var1, int var2);
}

