/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.ResourceProvider;
import com.sun.wbem.wdr.Slot;
import com.sun.wbem.wdr.UserPermission;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public abstract class SlotProvider
extends ResourceProvider {
    protected String m_ProviderClass;

    public SlotProvider() {
        Logger.logDebug("SlotProvider constructor");
        this.m_ProviderClass = this.getClass().getName();
    }

    private void copyKeys(CIMObjectPath op, Slot slot) {
        CIMProperty property = (CIMProperty)op.getKeys().elementAt(0);
        CIMValue value = property.getValue();
        String logicalID = (String)value.getValue();
        slot.setLogicalID(logicalID);
    }

    protected abstract Slot createSlot() throws CIMException;

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc) throws CIMException {
        Logger.logDebug("enumInstances called with out localOnly");
        Logger.logDebug("Object - " + op);
        Logger.logDebug("Deep - " + deep);
        Vector<CIMObjectPath> copVector = null;
        Vector resVector = null;
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            StringBuffer error = new StringBuffer();
            Slot slot = this.createSlot();
            resVector = slot.getResources(error);
            if (resVector == null) {
                if (error.length() == 0) {
                    Logger.logErr("getResources failed");
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                Logger.logErr("getResources failed with error: " + error);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)error.toString());
            }
            Logger.logDebug("Number of Slots - " + resVector.size());
            Iterator resIter = ((AbstractList)resVector).iterator();
            copVector = new Vector<CIMObjectPath>(resVector.size());
            while (resIter.hasNext()) {
                slot = (Slot)resIter.next();
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                cop.addKey("LogicalID", new CIMValue((Object)slot.getLogicalID()));
                copVector.add(cop);
            }
            Logger.logDebug("Number of Slots - " + copVector.size());
        }
        return copVector;
    }

    public Vector enumInstances(CIMObjectPath op, boolean deep, CIMClass cc, boolean localOnly) throws CIMException {
        Logger.logDebug("enumInstances called with localOnly");
        Logger.logDebug("Object - " + op);
        Logger.logDebug("Deep - " + deep);
        Vector<CIMInstance> instVector = null;
        Vector resVector = null;
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            StringBuffer error = new StringBuffer();
            Slot slot = this.createSlot();
            resVector = slot.getResources(error);
            if (resVector == null) {
                if (error.length() == 0) {
                    Logger.logErr("getResources failed");
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                Logger.logErr("getResources failed with error: " + error);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)error.toString());
            }
            Logger.logDebug("Number of slots - " + resVector.size());
            Iterator resIter = ((AbstractList)resVector).iterator();
            CIMInstance inst = null;
            instVector = new Vector<CIMInstance>(resVector.size());
            while (resIter.hasNext()) {
                slot = (Slot)resIter.next();
                inst = cc.newInstance();
                this.updateInstance(inst, slot);
                if (localOnly) {
                    inst = inst.localElements();
                }
                instVector.add(inst);
            }
            Logger.logDebug("Number of slots - " + instVector.size());
        }
        return instVector;
    }

    protected int getDomainIDArg(Vector inParams) throws CIMException {
        if (inParams.size() < 1) {
            throw new CIMException(ResourceMessage.getMsg("WDR.missDomainID"));
        }
        Integer domainID = (Integer)((CIMValue)inParams.firstElement()).getValue();
        return domainID;
    }

    public CIMInstance getInstance(CIMObjectPath op, CIMClass cc, boolean localOnly) throws CIMException {
        CIMInstance inst = null;
        Logger.logDebug("SlotProvider.getInstance called");
        Logger.logDebug("Object - " + op);
        Slot slot = this.createSlot();
        this.validateSlotName(op, slot);
        CIMValue providerCls = cc.getQualifier("Provider").getValue();
        if (providerCls.contains((Object)this.m_ProviderClass)) {
            StringBuffer error = new StringBuffer();
            this.copyKeys(op, slot);
            if (!slot.getResource(error)) {
                if (error.length() == 0) {
                    Logger.logErr("getResource failed");
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                Logger.logErr("getResource failed with error: " + error);
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)error.toString());
            }
            Logger.logDebug("Slot - " + slot.toString());
            inst = cc.newInstance();
            this.updateInstance(inst, slot);
            if (localOnly) {
                inst = inst.localElements();
            }
            Logger.logDebug("Current inst - " + inst);
        }
        return inst;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, Vector inParams, Vector outParams) throws CIMException {
        Logger.logDebug("SlotProvider.invokeMethod called");
        Logger.logDebug("ObjectPath - " + op);
        Logger.logDebug("methodName - " + methodName);
        Slot slot = this.createSlot();
        this.validateSlotName(op, slot);
        Integer status = new Integer(12);
        this.copyKeys(op, slot);
        if (methodName.equalsIgnoreCase("Assign")) {
            int domainID = this.getDomainIDArg(inParams);
            if (!UserPermission.mayAssignBoard(this.m_Provider.getCurrentUser(), domainID, slot.getLogicalID())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToAssignSlotToDomain", new Object[]{this.m_Provider.getCurrentUser(), slot.getLogicalID(), new Integer(domainID)}));
            }
            status = slot.assign(inParams, outParams);
        } else if (methodName.equalsIgnoreCase("Unassign")) {
            int domainID = this.getDomainIDArg(inParams);
            if (!UserPermission.mayUnassignBoard(this.m_Provider.getCurrentUser(), domainID, slot.getLogicalID())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToUnassignSlotFromDomain", new Object[]{this.m_Provider.getCurrentUser(), slot.getLogicalID(), new Integer(domainID)}));
            }
            status = slot.unassign(inParams, outParams);
        } else {
            status = this.invokeSubclassMethod(slot, methodName, inParams, outParams);
        }
        return new CIMValue((Object)status);
    }

    protected Integer invokeSubclassMethod(Slot attachPoint, String methodName, Vector inParams, Vector outParams) {
        return new Integer(3);
    }

    protected void updateInstance(CIMInstance inst, Slot slot) {
        Logger.logDebug("Slot.updateInstance");
        inst.setProperty("LogicalID", new CIMValue((Object)slot.getLogicalID()));
        inst.setProperty("AssignedDomain", new CIMValue((Object)new Integer(slot.getAssignedDomain())));
        inst.setProperty("AssignmentState", new CIMValue((Object)new UnsignedInt32((long)slot.getAssignmentState())));
        inst.setProperty("BoardType", new CIMValue((Object)new UnsignedInt32((long)slot.getBoardType())));
        inst.setProperty("PowerState", new CIMValue((Object)new UnsignedInt32((long)slot.getPowerState())));
        inst.setProperty("TestState", new CIMValue((Object)new UnsignedInt32((long)slot.getTestState())));
        inst.setProperty("Empty", new CIMValue((Object)slot.getEmpty()));
        this.updateLocalProps(inst, slot);
    }

    protected void updateLocalProps(CIMInstance inst, Slot ap) {
    }

    protected void validateSlotName(CIMObjectPath op, Slot slot) throws CIMException {
        if (!slot.isValidSlotName(op)) {
            Logger.logErr(String.valueOf(this.m_Provider.getCurrentUser()) + " has specified an " + "invalid Slot name: " + op);
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)op);
        }
    }
}

