/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.SGSNMP;
import com.sun.wbem.wdr.Slot;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.management.snmp.SnmpStatusException;

public class SGSlot
extends Slot {
    protected static SGSNMP m_SGSNMP = null;
    public static final int MAX_SB_BOARD = 5;
    public static final int MAX_IB_BOARD = 9;
    public static final int MAX_NUMBER_SGSLOTS = 10;
    protected static final String[] numberToSlotID = new String[]{"SB0", "SB1", "SB2", "SB3", "SB4", "SB5", "IB6", "IB7", "IB8", "IB9"};
    protected static final int SB_BOARD_BASE = 400;
    protected static final int IB_BOARD_BASE = 500;
    protected static final int UNKNOWNSTATE = 1;
    protected int m_slotIndex;
    protected static final int ASSIGNEDDOMAIN_NONE = -1;
    protected static final int ASSIGNEDDOMAIN_A = 0;
    protected static final int ASSIGNEDDOMAIN_B = 1;
    protected static final int ASSIGNEDDOMAIN_C = 2;
    protected static final int ASSIGNEDDOMAIN_D = 3;
    static final int BOARDTYPE_UNKNOWN = 1;
    static final int BOARDTYPE_EMPTY = 2;
    static final int ASSIGNMENTSTATE_FREE = 2;
    static final int ASSIGNMENTSTATE_ASSIGNED = 3;
    static final int ASSIGNMENTSTATE_ACTIVE = 4;

    SGSlot() throws CIMException {
        Logger.logDebug("SGSlot constructor");
        if (m_SGSNMP == null) {
            try {
                m_SGSNMP = new SGSNMP();
            }
            catch (UnknownHostException uhe) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ResourceMessage.getMsg("WDR.unknownHost", new Object[]{uhe.getLocalizedMessage()}));
            }
            catch (SnmpStatusException e) {
                throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.snmpFailedInSGSlot", new Object[]{e.getLocalizedMessage()}));
            }
        }
    }

    SGSlot(Slot slot) {
        super(slot);
        Logger.logDebug("Slot copy constructor");
    }

    protected String assignedDomainToString(int assignedDomain) {
        switch (assignedDomain) {
            case -1: {
                return "None(-1)";
            }
            case 0: {
                return "A(0)";
            }
            case 1: {
                return "B(1)";
            }
            case 2: {
                return "C(2)";
            }
            case 3: {
                return "D(3)";
            }
        }
        return "Unknown(" + assignedDomain + ")";
    }

    protected String assignmentStateToString(int assignmentState) {
        switch (assignmentState) {
            case 1: {
                return "Unknown(1)";
            }
            case 2: {
                return "Free(2)";
            }
            case 3: {
                return "Assigned(3)";
            }
            case 4: {
                return "Active(4)";
            }
        }
        return "Unknown(" + assignmentState + ")";
    }

    protected String boardTypeToString(int boardType) {
        switch (boardType) {
            case 1: {
                return "Unknown(1)";
            }
            case 2: {
                return "Empty(2)";
            }
            case 3: {
                return "CPU(3)";
            }
            case 4: {
                return "IO(4)";
            }
            case 5: {
                return "CPUWIB(5)";
            }
            case 6: {
                return "IOWIB(6)";
            }
            case 7: {
                return "SC(7)";
            }
            case 8: {
                return "L2(8)";
            }
            case 9: {
                return "Fan(9)";
            }
            case 10: {
                return "Power Supply(10)";
            }
            case 11: {
                return "Logic Analyzer(11)";
            }
        }
        return "Unknown(" + boardType + ")";
    }

    protected boolean getResource(String logicalID, StringBuffer error) throws CIMException {
        Logger.logDebug(String.valueOf(this.getClass().getName()) + ".getResource(" + logicalID + ")");
        if (error == null) {
            error = new StringBuffer();
        }
        error.setLength(0);
        this.setLogicalID(logicalID);
        try {
            this.m_Empty = null;
            this.m_AssignedDomain = -1;
            this.m_AssignmentState = 1;
            this.m_PowerState = 1;
            this.m_TestState = 1;
            int r = m_SGSNMP.getSerengetiMibItemInt(this.m_slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.5.0", error);
            if (r == -1 || error.length() != 0) {
                Logger.logErr("getSerengetiMibItemInt(" + this.m_slotIndex + ", slotState0) failed" + " for LogicalID " + logicalID);
                if (error.length() != 0) {
                    Logger.logErr("Error: " + error);
                }
                return false;
            }
            this.m_AssignmentState = r;
            r = m_SGSNMP.getSerengetiMibItemInt(this.m_slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.4.0", error);
            if (r == -1 || error.length() != 0) {
                Logger.logErr("getSerengetiMibItemInt(" + this.m_slotIndex + ", slotBoardType0) failed" + " for LogicalID " + logicalID);
                if (error.length() != 0) {
                    Logger.logErr("Error: " + error);
                }
                return false;
            }
            this.m_BoardType = r;
            this.m_Empty = this.m_BoardType == 1 ? null : (this.m_BoardType == 2 ? new Boolean(true) : new Boolean(false));
            r = m_SGSNMP.getSerengetiMibItemInt(this.m_slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.7.0", error);
            if (r == -1 || error.length() != 0) {
                Logger.logErr("getSerengetiMibItemInt(" + this.m_slotIndex + ", slotPowerStatus0) failed" + " for LogicalID " + logicalID);
                if (error.length() != 0) {
                    Logger.logErr("Error: " + error);
                }
                return false;
            }
            this.m_PowerState = r;
            r = m_SGSNMP.getSerengetiMibItemInt(this.m_slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.6.0", error);
            if (r == -1 || error.length() != 0) {
                Logger.logErr("getSerengetiMibItemInt(" + this.m_slotIndex + ", slotTestStatus0) failed" + " for LogicalID " + logicalID);
                if (error.length() != 0) {
                    Logger.logErr("Error: " + error);
                }
                return false;
            }
            this.m_TestState = r;
            r = m_SGSNMP.getSerengetiMibItemInt(this.m_slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.8.0", error);
            if (r == -1 || error.length() != 0) {
                Logger.logErr("getSerengetiMibItemInt(" + this.m_slotIndex + ", slotDomain0) failed" + " for LogicalID " + logicalID);
                if (error.length() != 0) {
                    Logger.logErr("Error: " + error);
                }
                return false;
            }
            this.m_AssignedDomain = r - 2;
            Logger.logDebug(String.valueOf(this.getClass().getName()) + ".getResource(" + logicalID + "):" + "SGSlot = " + this);
        }
        catch (SnmpStatusException sse) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.snmpGetFailed", new Object[]{new Integer(this.m_LogicalID), sse.getLocalizedMessage()}));
        }
        return true;
    }

    public boolean getResource(StringBuffer error) throws CIMException {
        return this.getResource(this.m_LogicalID, error);
    }

    public Vector getResources(StringBuffer error) throws CIMException {
        Vector<SGSlot> v = new Vector<SGSlot>(10);
        SGSlot[] slots = new SGSlot[10];
        int i = 0;
        while (i < 10) {
            SGSlot s = slots[i];
            if (s == null && !(s = new SGSlot()).getResource(numberToSlotID[i], error)) {
                s = null;
            } else {
                v.add(s);
            }
            ++i;
        }
        return v;
    }

    public int hardwareFunc(int domainId, int function, StringBuffer error) {
        String mibItemToSet;
        boolean success = false;
        int slotIndex = -1;
        int newMibValue = -1;
        if (domainId < 0 || domainId > 3) {
            Logger.logErr("nativeHardwareFunc called with invalid domainId " + domainId);
            return 12;
        }
        if (error == null) {
            error = new StringBuffer();
        }
        error.setLength(0);
        slotIndex = SGSlot.logicalIDToSlotIndex(this.m_LogicalID);
        if (slotIndex == -1) {
            Logger.logErr("nativeHardwareFunc called with invalid LogicalID " + this.m_LogicalID);
            return 13;
        }
        switch (function) {
            case 0: 
            case 1: {
                mibItemToSet = "1.3.6.1.4.1.42.2.70.2.1.1.8.0";
                if (function == 0) {
                    newMibValue = domainId + 2;
                    break;
                }
                newMibValue = 1;
                break;
            }
            case 2: 
            case 3: {
                newMibValue = function;
                mibItemToSet = "1.3.6.1.4.1.42.2.70.2.1.1.7.0";
                break;
            }
            default: {
                Logger.logErr("nativeHardwareFunc called with invalid function " + function);
                return 12;
            }
        }
        try {
            success = m_SGSNMP.setSerengetiMibItemInt(this.m_slotIndex, mibItemToSet, newMibValue, error);
        }
        catch (SnmpStatusException snmpStatusException) {
            return 12;
        }
        if (!success || error.length() != 0) {
            Logger.logErr("setSerengetiMibItemInt(slotIndex " + this.m_slotIndex + ", mibItemToSet " + mibItemToSet + ", domainID " + domainId + ") failed" + " for LogicalID " + this.m_LogicalID + ", newMibValue " + newMibValue + ", and function " + function);
            if (error.length() != 0) {
                Logger.logErr("Error: " + error);
            }
            return 12;
        }
        return 0;
    }

    protected Integer hardwareFunc(int function, Vector inParams, Vector outParams) {
        boolean expectedParamCount = true;
        int status = 12;
        Integer domainId = null;
        if (inParams.size() != 1) {
            Logger.logErr("hardwareFunc called with the wrong number of arguments");
        } else {
            int i = 0;
            while (i < inParams.size()) {
                Object obj = ((CIMValue)inParams.elementAt(i)).getValue();
                switch (i) {
                    case 0: {
                        domainId = (Integer)obj;
                        break;
                    }
                }
                ++i;
            }
            StringBuffer error = new StringBuffer();
            status = this.hardwareFunc((int)domainId, function, error);
            outParams.add(new CIMValue((Object)error.toString()));
        }
        return new Integer(status);
    }

    boolean isValidSlotName(CIMObjectPath op) {
        CIMProperty property = (CIMProperty)op.getKeys().elementAt(0);
        CIMValue value = property.getValue();
        String slotName = (String)value.getValue();
        String SysBoardPrefix = "SB";
        String IOBoardPrefix = "IB";
        int slotNum = 0;
        boolean validSlot = false;
        String slotNumStr = slotName.substring("SB".length());
        try {
            slotNum = Integer.parseInt(slotNumStr);
        }
        catch (NumberFormatException numberFormatException) {
            return validSlot;
        }
        if (slotName.startsWith("SB") && slotNum >= 0 && slotNum <= 5) {
            validSlot = true;
        } else if (slotName.startsWith("IB") && slotNum > 5 && slotNum <= 9) {
            validSlot = true;
        }
        return validSlot;
    }

    static int logicalIDToSlotIndex(String logicalID) {
        int boardTypeBase = Integer.MIN_VALUE;
        int boardInstance = Integer.MIN_VALUE;
        String logicalIDPrefix = logicalID.substring(0, 2);
        if (logicalIDPrefix.equals("SB")) {
            boardTypeBase = 400;
        } else if (logicalIDPrefix.equals("IB")) {
            boardTypeBase = 500;
        } else if (logicalIDPrefix.equals("SC")) {
            boardTypeBase = 100;
        } else if (logicalIDPrefix.equals("FT")) {
            boardTypeBase = 200;
        } else if (logicalIDPrefix.equals("PS")) {
            boardTypeBase = 300;
        } else if (logicalIDPrefix.equals("RP")) {
            boardTypeBase = 610;
        } else {
            return -1;
        }
        try {
            boardInstance = Integer.parseInt(logicalID.substring(2));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (boardInstance < 0 || boardInstance > 9) {
            return -1;
        }
        return boardTypeBase + boardInstance;
    }

    public void populateSubclassMembers() {
    }

    protected String powerStateToString(int powerState) {
        switch (powerState) {
            case 1: {
                return "Unknown(1)";
            }
            case 2: {
                return "On(2)";
            }
            case 3: {
                return "Off(3)";
            }
            case 4: {
                return "Failed(4)";
            }
        }
        return "Unknown(" + powerState + ")";
    }

    public void setLogicalID(String logicalID) {
        int slotIndex = -1;
        slotIndex = SGSlot.logicalIDToSlotIndex(logicalID);
        if (slotIndex == -1) {
            Logger.logErr("setLogicalID called with invalid logicalID " + logicalID);
            return;
        }
        this.m_LogicalID = logicalID;
        this.m_slotIndex = slotIndex;
    }

    protected String testStateToString(int testState) {
        switch (testState) {
            case 1: {
                return "Unknown(1)";
            }
            case 2: {
                return "Not Tested(2)";
            }
            case 3: {
                return "Passed(3)";
            }
            case 4: {
                return "Failed(4)";
            }
            case 5: {
                return "Test(5)";
            }
            case 6: {
                return "Start Test(6)";
            }
            case 7: {
                return "Degraded(7)";
            }
            case 8: {
                return "Unusable(8)";
            }
        }
        return "Unknown(" + testState + ")";
    }

    public String toString() {
        String keyswitchPositionString = "(undefined)";
        String stateString = "(undefined)";
        String str = "\nSGSlot:\nSlot LogicalID =  " + this.m_LogicalID + "\n" + "Empty =           " + this.m_Empty + " (null means unknown)" + "\n" + "AssignedDomain =  " + this.assignedDomainToString(this.m_AssignedDomain) + "\n" + "AssignmentState = " + this.assignmentStateToString(this.m_AssignmentState) + "\n" + "BoardType =       " + this.boardTypeToString(this.m_BoardType) + "\n" + "PowerState =      " + this.powerStateToString(this.m_PowerState) + "\n" + "TestState =       " + this.testStateToString(this.m_TestState) + "\n" + "SNMP slotIndex =  " + this.m_slotIndex + "\n";
        return str;
    }
}

