/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.SGEventProvider;
import com.sun.wbem.wdr.SGSNMP;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpPduTrap;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.manager.SnmpEventReportDispatcher;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpTrapListener;

class SGSNMPTrap
extends SGSNMP
implements SnmpTrapListener {
    protected Object objectHandle = null;
    static final int DOMAIN_OFFSET = 2;

    public SGSNMPTrap() throws UnknownHostException, SnmpStatusException, CIMException {
    }

    public SGSNMPTrap(long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
    }

    public SGSNMPTrap(Object objectHandle) throws UnknownHostException, SnmpStatusException, CIMException {
        this.objectHandle = objectHandle;
    }

    public SGSNMPTrap(Object objectHandle, long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        this.objectHandle = objectHandle;
    }

    public SGSNMPTrap(Object objectHandle, String scHostName) throws UnknownHostException, SnmpStatusException, CIMException {
        this.objectHandle = objectHandle;
    }

    public SGSNMPTrap(Object objectHandle, String scHostName, long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        this.objectHandle = objectHandle;
    }

    public SGSNMPTrap(String scHostName) throws UnknownHostException, SnmpStatusException, CIMException {
    }

    public SGSNMPTrap(String scHostName, long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
    }

    protected int MIBToInteger(SnmpVarBind varBind, String mibName) {
        try {
            return Integer.parseInt(varBind.getStringValue());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.logErr(String.valueOf(mibName) + " " + varBind + " is not an integer");
            return -1;
        }
    }

    protected String chassisIndexToChassisSystemSerialNumber(SnmpVarBind varBind) throws SnmpStatusException {
        int c = this.MIBToInteger(varBind, "chassisIndex");
        if (c == -1) {
            return null;
        }
        return this.getSerengetiMibItem(c, "1.3.6.1.4.1.42.2.70.1.1.1.25", null);
    }

    protected int domainIndexToDomain(SnmpVarBind varBind) throws SnmpStatusException {
        int d;
        int di = this.MIBToInteger(varBind, "domainIndex");
        if (di == -1) {
            return -1;
        }
        String s = this.getSerengetiMibItem(di, "1.3.6.1.4.1.42.2.70.12.1.1.2", null);
        if (s == null) {
            return -1;
        }
        try {
            d = Integer.parseInt(s) - 2;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (d < 0 || d >= 4) {
            return -1;
        }
        return d;
    }

    protected void dumpVarBindArray(String comment, SnmpVarBind[] varBind) {
        Logger.logDebug("DUMP: " + comment + " (" + varBind.length + " elements)");
        Logger.logDebug("Time " + varBind[0].getStringValue() + ", trap OID: " + varBind[1].getStringValue());
        int i = 2;
        while (i < varBind.length) {
            Logger.logDebug("[" + i + "]: OID " + varBind[i].oid + ", value " + varBind[i].getStringValue());
            ++i;
        }
    }

    protected void processAclChangedTrap(SnmpVarBind[] varBind) throws SnmpStatusException {
        StringBuffer errorMessage = new StringBuffer();
        Logger.logDebug("AclChangedTrap 3");
        int domain = this.domainIndexToDomain(varBind[2]);
        String domainAclString = varBind[3].getStringValue().trim();
        int DomainAclSet = this.convertDomainAclStringToSet(domainAclString, errorMessage);
        if (errorMessage.length() != 0) {
            Logger.logErr("Error converting domainACL " + domainAclString + ": " + errorMessage);
            return;
        }
        Logger.logDebug("domain: " + domain);
        Logger.logDebug("domainAclString: " + domainAclString);
        Logger.logDebug("bitSet: DomainAclSet " + Integer.toString(DomainAclSet, 16));
        if (domain < 0 || domain >= 4 || domainAclString == null) {
            Logger.logErr("Invalid processAclChangedTrap data");
            return;
        }
        if (this.objectHandle != null) {
            SGEventProvider.raiseSolarisSGDomainAclChange(this.objectHandle, domain, DomainAclSet);
        } else {
            Logger.logErr("processAclChangedTrap: null objectHandle--no indication raised");
        }
    }

    protected void processBoardPresenceChangedTrap(SnmpVarBind[] varBind) throws SnmpStatusException {
        Logger.logDebug("BoardPresenceChangedTrap 1");
        String chassisSerialNumber = this.chassisIndexToChassisSystemSerialNumber(varBind[2]);
        String logicalId = this.slotIndexToLogicalId(varBind[3]);
        int boardType = this.MIBToInteger(varBind[4], "slotBoardType");
        Logger.logDebug("chassisSerialNumber: " + chassisSerialNumber);
        Logger.logDebug("logicalId: " + logicalId);
        Logger.logDebug("boardType: " + boardType);
        if (chassisSerialNumber == null || logicalId == null || boardType <= 0) {
            Logger.logErr("Invalid BoardPresenceChangeTrap data");
            return;
        }
        if (this.objectHandle != null) {
            SGEventProvider.raiseSolarisSGBoardPresenceChange(this.objectHandle, chassisSerialNumber, logicalId, boardType);
        } else {
            Logger.logErr("processBoardPresenceChangedTrap: null objectHandle--no indication raised");
        }
    }

    protected void processBoardStateChangedTrap(SnmpVarBind[] varBind) throws SnmpStatusException {
        Logger.logDebug("BoardStatusChangedTrap 4");
        this.dumpVarBindArray("BoardStatusChangedTrap 4", varBind);
        String chassisSerialNumber = this.chassisIndexToChassisSystemSerialNumber(varBind[2]);
        String logicalId = this.slotIndexToLogicalId(varBind[3]);
        int assignmentState = this.MIBToInteger(varBind[4], "slotState");
        int powerStatus = this.MIBToInteger(varBind[5], "slotPowerStatus");
        Logger.logDebug("chassisSerialNumber: " + chassisSerialNumber);
        Logger.logDebug("logicalId: " + logicalId);
        Logger.logDebug("assignmentState: " + assignmentState);
        Logger.logDebug("powerStatus: " + powerStatus);
        if (chassisSerialNumber == null || logicalId == null || assignmentState <= 0 || powerStatus <= 0) {
            Logger.logErr("Invalid BoardPresenceChangedTrap data");
            return;
        }
        if (this.objectHandle != null) {
            SGEventProvider.raiseSolarisSGBoardStateChange(this.objectHandle, chassisSerialNumber, logicalId, assignmentState, powerStatus);
        } else {
            Logger.logErr("processBoardStateChangedTrap: null objectHandle--no indication raised");
        }
    }

    protected void processDomainStateChangeTrap(SnmpVarBind[] varBind) throws SnmpStatusException {
        Logger.logDebug("DomainStateChangeTrap 9");
        int domain = this.domainIndexToDomain(varBind[2]);
        int domainStatus = this.MIBToInteger(varBind[3], "domainStatus");
        int domainKeySwitch = this.MIBToInteger(varBind[4], "domainKeySwitch");
        Logger.logDebug("domain: " + domain);
        Logger.logDebug("domainStatus: " + domainStatus);
        Logger.logDebug("domainKeySwitch: " + domainKeySwitch);
        if (domain < 0 || domain >= 4 || domainStatus <= 0 || domainKeySwitch <= 0) {
            Logger.logErr("Invalid DomainStateChangeTrap data");
            return;
        }
        if (this.objectHandle != null) {
            SGEventProvider.raiseSolarisSGDomainStateChange(this.objectHandle, domain, domainStatus, domainKeySwitch);
        } else {
            Logger.logErr("processDomainStateChangeTrap: null objectHandle--no indication raised");
        }
    }

    protected void processSlotAssignmentChangedTrap(SnmpVarBind[] varBind) throws SnmpStatusException {
        Logger.logDebug("SlotAssignmentChangedTrap 2");
        int domainId = this.domainIndexToDomain(varBind[2]);
        String chassisSerialNumber = this.chassisIndexToChassisSystemSerialNumber(varBind[3]);
        String logicalId = this.slotIndexToLogicalId(varBind[4]);
        int assignmentState = this.MIBToInteger(varBind[5], "slotState");
        Logger.logDebug("domainId: " + domainId);
        Logger.logDebug("chassisSerialNumber: " + chassisSerialNumber);
        Logger.logDebug("logicalId: " + logicalId);
        Logger.logDebug("assignmentState: " + assignmentState);
        if (domainId < 0 || domainId >= 4 || chassisSerialNumber == null || logicalId == null) {
            Logger.logErr("Invalid SlotAssignmentChangedTrap data");
            return;
        }
        if (this.objectHandle != null) {
            SGEventProvider.raiseSolarisSGSlotAssignmentChange(this.objectHandle, domainId, chassisSerialNumber, logicalId, assignmentState);
        } else {
            Logger.logErr("processSlotAssignmentChangedTrap: null objectHandle--no indication raised");
        }
    }

    protected void processSlotAvailabilityChangeTrap(SnmpVarBind[] varBind) throws SnmpStatusException {
        Logger.logDebug("slotAvailabilityChangeTrap 19");
        int domainId = this.domainIndexToDomain(varBind[2]);
        String chassisSerialNumber = varBind[3].getStringValue();
        String logicalId = this.slotIndexToLogicalId(varBind[4]);
        int assignmentState = this.MIBToInteger(varBind[5], "slotState");
        Logger.logDebug("domainId: " + domainId);
        Logger.logDebug("chassisSerialNumber: " + chassisSerialNumber);
        Logger.logDebug("logicalId: " + logicalId);
        Logger.logDebug("assignmentState: " + assignmentState);
        if (domainId < 0 || domainId >= 4 || chassisSerialNumber == null || logicalId == null || assignmentState <= 0) {
            Logger.logErr("Invalid SlotAvailabilityChangeTrap data");
            return;
        }
        if (this.objectHandle != null) {
            SGEventProvider.raiseSolarisSGSlotAvailabilityChange(this.objectHandle, domainId, chassisSerialNumber, logicalId, assignmentState);
        } else {
            Logger.logErr("processSlotAvailabilityChangeTrap: null objectHandle--no indication raised");
        }
    }

    public void processSnmpInternalError(SnmpRequest request, String errmsg) {
        Logger.logErr("Internal error: " + errmsg + " for SnmpRequest " + request + " (exiting)");
        System.exit(1);
    }

    public void processSnmpTrapV1(SnmpPduTrap aTrapPdu) {
        Logger.logDebug("SNMPv1 Trap received.");
    }

    public void processSnmpTrapV2(SnmpPduRequest aTrapPdu) {
        Logger.logDebug("SNMPv2 Trap received: " + aTrapPdu.varBindList);
        String trapOID = aTrapPdu.varBindList[1].getStringValue();
        Logger.logDebug("trapOID = " + trapOID);
        int trapNumber = SGSNMP.convertOIDSuffixToInteger(trapOID);
        if (trapNumber < 0) {
            Logger.logErr("v2trap " + trapOID + " for OID " + trapOID + " does not end with an integer");
            return;
        }
        Logger.logDebug("SNMPv2 trap " + trapNumber);
        try {
            switch (trapNumber) {
                case 1: {
                    this.processBoardPresenceChangedTrap(aTrapPdu.varBindList);
                    break;
                }
                case 2: {
                    this.processSlotAssignmentChangedTrap(aTrapPdu.varBindList);
                    break;
                }
                case 3: {
                    this.processAclChangedTrap(aTrapPdu.varBindList);
                    break;
                }
                case 4: {
                    this.processBoardStateChangedTrap(aTrapPdu.varBindList);
                    break;
                }
                case 9: {
                    this.processDomainStateChangeTrap(aTrapPdu.varBindList);
                    break;
                }
                case 19: {
                    this.processSlotAvailabilityChangeTrap(aTrapPdu.varBindList);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SnmpStatusException sse) {
            Logger.logErr("Snmp Status EXCEPTION");
            sse.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected String slotIndexToLogicalId(SnmpVarBind varBind) {
        int s = this.MIBToInteger(varBind, "slotIndex");
        switch (s) {
            case 400: {
                return "SB0";
            }
            case 401: {
                return "SB1";
            }
            case 402: {
                return "SB2";
            }
            case 403: {
                return "SB3";
            }
            case 404: {
                return "SB4";
            }
            case 405: {
                return "SB5";
            }
            case 506: {
                return "IB6";
            }
            case 507: {
                return "IB7";
            }
            case 508: {
                return "IB8";
            }
            case 509: {
                return "IB9";
            }
            case 100: {
                return "SSC0";
            }
            case 101: {
                return "SSC1";
            }
            case 200: {
                return "FT0";
            }
            case 201: {
                return "FT1";
            }
            case 202: {
                return "FT2";
            }
            case 203: {
                return "FT3";
            }
            case 300: {
                return "PS0";
            }
            case 301: {
                return "PS1";
            }
            case 302: {
                return "PS2";
            }
            case 303: {
                return "PS3";
            }
            case 304: {
                return "PS4";
            }
            case 305: {
                return "PS5";
            }
            case 610: {
                return "RP0";
            }
            case 611: {
                return "RP1";
            }
            case -1: {
                return null;
            }
        }
        return null;
    }

    public void startTrapMonitoring() throws UnknownHostException, SnmpStatusException, SocketException {
        SnmpEventReportDispatcher dispatcher = new SnmpEventReportDispatcher(this.configFile.getScTrapPort());
        dispatcher.addTrapListener((SnmpTrapListener)this);
        new Thread((Runnable)dispatcher).start();
    }

    public String toString() {
        String superString = super.toString();
        return new String("\n" + this.getClass().getName() + ":\n" + "-----------------------------\n" + superString + "\n" + "objectHandle:             " + this.objectHandle);
    }
}

