/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.wdr.ConfigFile;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.SGSlot;
import java.net.UnknownHostException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

class SGSNMP
extends Logger {
    public static final int MAX_NUMBER_SGDOMAINS = 4;
    public static final int MAX_NUMBER_SGSLOTS = 24;
    public static final int MIN_SLOT_INDEX = 100;
    public static final int MAX_SLOT_INDEX = 612;
    public static final int SB0 = 1;
    public static final int SB1 = 2;
    public static final int SB2 = 4;
    public static final int SB3 = 8;
    public static final int SB4 = 16;
    public static final int SB5 = 32;
    public static final int IB6 = 64;
    public static final int IB7 = 128;
    public static final int IB8 = 256;
    public static final int IB9 = 512;
    protected static final int[] boardIDToBitmap = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
    protected static final String RUNNING_SOLARIS = "9";
    protected ConfigFile configFile = null;
    protected static final int SNMP_AGENT_PORT = 161;
    protected static final long DEFAULT_WAIT_TIME = 10000L;
    protected static SnmpSession snmpSession = null;
    protected String scHostName = null;
    protected boolean communicating = false;
    protected long sessionTimeOut = 10000L;

    public SGSNMP() throws UnknownHostException, SnmpStatusException, CIMException {
        this.configFile = new ConfigFile();
        this.scHostName = this.configFile.getScHostName();
        if (snmpSession == null) {
            this.setupSnmpSession(this.scHostName, 10000L);
        }
    }

    public SGSNMP(long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        this.configFile = new ConfigFile();
        this.scHostName = this.configFile.getScHostName();
        if (snmpSession == null) {
            this.setupSnmpSession(this.scHostName, timeOut);
        }
    }

    public SGSNMP(String scHostName) throws UnknownHostException, SnmpStatusException, CIMException {
        if (scHostName == null || scHostName.length() == 0) {
            throw new UnknownHostException("scHostName in constructor is null or empty");
        }
        this.configFile = new ConfigFile();
        this.scHostName = scHostName;
        if (snmpSession == null) {
            this.setupSnmpSession(scHostName, 10000L);
        }
    }

    public SGSNMP(String scHostName, long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        if (scHostName == null || scHostName.length() == 0) {
            throw new UnknownHostException("scHostName in constructor is null or empty");
        }
        this.configFile = new ConfigFile();
        this.scHostName = scHostName;
        if (snmpSession == null) {
            this.setupSnmpSession(scHostName, timeOut);
        }
    }

    public boolean boardAssignedToDomain(String brdLogID, int domainID, StringBuffer errorMessage) throws SnmpStatusException {
        int domainAMibVal = 2;
        boolean result = false;
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        int slotIndex = SGSlot.logicalIDToSlotIndex(brdLogID);
        if (slotIndex == -1) {
            errorMessage.append("logicalID " + brdLogID + " is invalid");
            if (snmpSession != null) {
                snmpSession.destroySession();
                snmpSession = null;
            }
            return false;
        }
        if (domainID < 0 || domainID > 4) {
            errorMessage.append("domainID value " + domainID + " out of range");
            if (snmpSession != null) {
                snmpSession.destroySession();
                snmpSession = null;
            }
            return false;
        }
        int slotState = this.getSlotState(slotIndex, errorMessage);
        if (slotState != 3 && slotState != 4) {
            if (snmpSession != null) {
                snmpSession.destroySession();
                snmpSession = null;
            }
            return false;
        }
        String slotDomainString = this.getSlotMibItem(slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.8.0", errorMessage);
        if (slotDomainString != null && Integer.parseInt(slotDomainString) == domainID + 2) {
            result = true;
        }
        if (snmpSession != null) {
            snmpSession.destroySession();
            snmpSession = null;
        }
        return result;
    }

    protected int convertDomainAclStringToSet(String domainAclString, StringBuffer errorMessage) {
        boolean i = false;
        int bitSet = 0;
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainAclString == null) {
            errorMessage.append("No domainAclString");
            return -1;
        }
        String valueResult = domainAclString.trim();
        Logger.logDebug("valueResult is " + valueResult);
        StringTokenizer st = new StringTokenizer(valueResult, " ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            String sPrefix = s.substring(0, 2);
            if (sPrefix.equals("SB") || sPrefix.equals("IB")) {
                int b;
                try {
                    b = Integer.parseInt(s.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    errorMessage.append("Board " + s + " has no integer");
                    return -1;
                }
                if (b < 0 || b > boardIDToBitmap.length) {
                    errorMessage.append("Board " + s + " out of range in ACL: " + domainAclString);
                    return -1;
                }
                bitSet += boardIDToBitmap[b];
                continue;
            }
            errorMessage.append("Unrecognized board " + s + " in ACL: " + domainAclString);
            return -1;
        }
        return bitSet;
    }

    protected static int convertOIDSuffixToInteger(String oidString) {
        String numberString;
        int len = oidString.length();
        if (len < 3) {
            return -1;
        }
        if (oidString.charAt(len - 2) == '.') {
            numberString = oidString.substring(len - 1);
        } else if (oidString.charAt(len - 3) == '.') {
            numberString = oidString.substring(len - 2);
        } else {
            if (len < 4) {
                return -1;
            }
            if (oidString.charAt(len - 4) == '.') {
                numberString = oidString.substring(len - 3);
            } else {
                return -1;
            }
        }
        try {
            return Integer.parseInt(numberString);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public boolean domainIsUp(int domainID, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainID < 0 || domainID >= 4) {
            errorMessage.append("domainID " + domainID + " out of range");
            return false;
        }
        String resultString = this.searchForDomainMibItem(domainID, "1.3.6.1.4.1.42.2.70.12.1.1.9", errorMessage);
        Logger.logDebug("RESULT of searchForDomainMibItem(domainID " + domainID + ", " + "1.3.6.1.4.1.42.2.70.12.1.1.9" + ") is " + resultString);
        if (resultString == null) {
            return false;
        }
        return resultString.equals(RUNNING_SOLARIS);
    }

    protected void finalize() {
        if (snmpSession != null) {
            snmpSession.destroySession();
        }
    }

    public String[] getDomainAcl(int domainID, StringBuffer errorMessage) throws SnmpStatusException {
        Logger.logDebug("domainID is " + domainID);
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainID < 0 || domainID >= 4) {
            errorMessage.append("domainID " + domainID + " out of range");
            return null;
        }
        String resultString = this.searchForDomainMibItem(domainID, "1.3.6.1.4.1.42.2.70.12.1.1.8", errorMessage);
        Logger.logDebug("RESULT of searchForDomainMibItem(domainID " + domainID + ", " + "1.3.6.1.4.1.42.2.70.12.1.1.8" + ") is " + resultString);
        if (resultString == null) {
            return null;
        }
        int i = 0;
        String valueResult = resultString.trim();
        Logger.logDebug("valueResult is " + valueResult);
        StringTokenizer st = new StringTokenizer(valueResult, " ");
        String[] stringArray = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            stringArray[i++] = st.nextToken();
        }
        return stringArray;
    }

    public int getDomainAclSet(int domainID, StringBuffer errorMessage) throws SnmpStatusException {
        Logger.logDebug("domainID is " + domainID);
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainID < 0 || domainID >= 4) {
            errorMessage.append("domainID " + domainID + " out of range");
            return -1;
        }
        String resultString = this.searchForDomainMibItem(domainID, "1.3.6.1.4.1.42.2.70.12.1.1.8", errorMessage);
        Logger.logDebug("RESULT of searchForDomainMibItem(domainID " + domainID + ", " + "1.3.6.1.4.1.42.2.70.12.1.1.8" + ") is " + resultString);
        if (resultString == null) {
            return -1;
        }
        return this.convertDomainAclStringToSet(resultString, errorMessage);
    }

    public String getSerengetiMibItem(int keyIndex, String desiredOid, StringBuffer errorMessage) throws SnmpStatusException {
        Logger.logDebug("getSerengetiMibItem(" + keyIndex + ", " + desiredOid + ")");
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        SnmpVarBindList vbl = new SnmpVarBindList(1);
        SnmpOid sOid = new SnmpOid(String.valueOf(desiredOid) + "." + keyIndex);
        SnmpVarBind vb = new SnmpVarBind(sOid);
        vbl.addVarBind(vb);
        SnmpRequest request = snmpSession.snmpGetRequest(null, vbl);
        boolean completed = request.waitForCompletion(this.sessionTimeOut);
        if (!completed) {
            errorMessage.append("SNMP Request timed out after " + this.sessionTimeOut + " milliseconds");
            return null;
        }
        Logger.logDebug("Request after:\n" + request.toString());
        int errorStatus = request.getErrorStatus();
        if (errorStatus != 0) {
            errorMessage.append("SNMP Response error " + errorStatus + " (" + SnmpRequest.snmpErrorToString((int)errorStatus) + ") for index " + request.getErrorIndex() + 1);
            return null;
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Logger.logDebug("Result: " + result.varBindListToString());
        SnmpVarBind vb2 = result.getVarBindAt(0);
        Logger.logDebug("VarBind " + vb);
        if (vb2.status == 2 && vb2.value != null) {
            Logger.logDebug("value " + vb2.getStringValue());
            return vb2.getStringValue();
        }
        errorMessage.append("SNMP OID " + desiredOid + "." + keyIndex + " not found in MIB");
        return null;
    }

    public int getSerengetiMibItemInt(int keyIndex, String desiredOid, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        String result = this.getSerengetiMibItem(keyIndex, desiredOid, errorMessage);
        if (result == null) {
            return -1;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage.append("Result value " + result + " is not an integer");
            return -1;
        }
    }

    protected String getSlotMibItem(int index, String desiredOid, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        Logger.logDebug("DEBUG: SlotIndex value " + index);
        if (index < 100 || index >= 612) {
            errorMessage.append("slotIndex value " + index + " out of range");
            return null;
        }
        if (!desiredOid.substring(desiredOid.length() - 2).equals(".0")) {
            errorMessage.append("desiredOid " + desiredOid + " must end with \".0\" under slotTable");
            return null;
        }
        Logger.logDebug("DEBUG: getSerengetiMibItem(" + index + ", " + desiredOid + ")");
        return this.getSerengetiMibItem(index, desiredOid, errorMessage);
    }

    public String getSlotName(int index, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (index < 100 || index >= 612) {
            errorMessage.append("slotIndex value " + index + " out of range");
            return null;
        }
        return this.getSlotMibItem(index, "1.3.6.1.4.1.42.2.70.2.1.1.10.0", errorMessage);
    }

    public int getSlotState(int index, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (index < 100 || index >= 612) {
            errorMessage.append("slotIndex value " + index + " out of range");
            return -1;
        }
        String slotStateValue = this.getSlotMibItem(index, "1.3.6.1.4.1.42.2.70.2.1.1.5.0", errorMessage);
        Logger.logDebug("slotStateValue is " + slotStateValue + ".");
        if (slotStateValue == null) {
            return 0;
        }
        try {
            return Integer.parseInt(slotStateValue);
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage.append("slotState value " + slotStateValue + " is not an integer");
            return -1;
        }
    }

    public void processSnmpInternalError(SnmpRequest request, String errmsg) {
        Logger.logErr("Internal error: " + errmsg + " for SnmpRequest " + request + " (exiting)");
        System.exit(1);
    }

    public boolean searchAndSetSerengetiMibItem(String keyValue, String keyOid, String desiredOid, String desiredValue, int maxMibOccurrencesToSearch, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        int i = this.searchForSerengetiMibItemIndex(keyValue, keyOid, maxMibOccurrencesToSearch, errorMessage);
        if (i < 0) {
            errorMessage.append("OID " + keyOid + " value " + keyValue + " not found");
            return false;
        }
        return this.setSerengetiMibItem(i, desiredOid, desiredValue, errorMessage);
    }

    public boolean searchAndSetSerengetiMibItemInt(String keyValue, String keyOid, String desiredOid, int desiredValue, int maxMibOccurrencesToSearch, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        int i = this.searchForSerengetiMibItemIndex(keyValue, keyOid, maxMibOccurrencesToSearch, errorMessage);
        if (i < 0) {
            errorMessage.append("OID " + keyOid + " value " + keyValue + " not found");
            return false;
        }
        return this.setSerengetiMibItemInt(i, desiredOid, desiredValue, errorMessage);
    }

    public String searchForDomainMibItem(int domainID, String desiredOid, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        Logger.logDebug("desired domainID is " + domainID);
        if (domainID < 0 || domainID >= 4) {
            errorMessage.append("domainID " + domainID + " out of range");
            return null;
        }
        String domainIDString = Integer.toString(domainID + 2);
        return this.searchForSerengetiMibItem(domainIDString, "1.3.6.1.4.1.42.2.70.12.1.1.2", desiredOid, 4, errorMessage);
    }

    public int searchForDomainMibItemInt(int domainID, String desiredOid, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        Logger.logDebug("desired domainID is " + domainID);
        if (domainID < 0 || domainID >= 4) {
            errorMessage.append("domainID " + domainID + " out of range");
            return -1;
        }
        String domainIDString = Integer.toString(domainID + 2);
        return this.searchForSerengetiMibItemInt(domainIDString, "1.3.6.1.4.1.42.2.70.12.1.1.2", desiredOid, 4, errorMessage);
    }

    public String searchForSerengetiMibItem(String keyValue, String keyOid, String desiredOid, int maxMibOccurrencesToSearch, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        SnmpVarBindList vbl = new SnmpVarBindList(maxMibOccurrencesToSearch * 2);
        int i = 0;
        while (i < maxMibOccurrencesToSearch) {
            SnmpOid sOid1 = new SnmpOid(String.valueOf(keyOid) + "." + i);
            SnmpVarBind vb1 = new SnmpVarBind(sOid1);
            vbl.addVarBind(vb1);
            SnmpOid sOid2 = new SnmpOid(String.valueOf(desiredOid) + "." + i);
            SnmpVarBind vb2 = new SnmpVarBind(sOid2);
            vbl.addVarBind(vb2);
            ++i;
        }
        SnmpRequest request = snmpSession.snmpGetRequest(null, vbl);
        boolean completed = request.waitForCompletion(this.sessionTimeOut);
        if (!completed) {
            errorMessage.append("SNMP Request timed out after " + this.sessionTimeOut + " milliseconds");
            return null;
        }
        Logger.logDebug("Request after:\n" + request.toString());
        int errorStatus = request.getErrorStatus();
        if (errorStatus != 0) {
            errorMessage.append("SNMP Response error " + errorStatus + " (" + SnmpRequest.snmpErrorToString((int)errorStatus) + ") for index " + request.getErrorIndex() + 1);
            return null;
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Logger.logDebug("Result:\n" + result.varBindListToString());
        Logger.logDebug("looking for key " + keyValue);
        Enumeration e = result.getVarBindList();
        while (e.hasMoreElements()) {
            SnmpVarBind vb = (SnmpVarBind)e.nextElement();
            SnmpVarBind vb2 = (SnmpVarBind)e.nextElement();
            Logger.logDebug("VarBind key " + vb);
            Logger.logDebug("VarBind value " + vb2);
            if (vb.status != 2 || vb.value == null) continue;
            Logger.logDebug("keyOid value " + vb.getStringValue());
            String currentID = vb.getStringValue();
            if (!currentID.equals(keyValue) || vb2.status != 2 || vb2.value == null) continue;
            return vb2.getStringValue();
        }
        errorMessage.append("Key " + keyValue + " for " + desiredOid + " not found");
        return null;
    }

    protected int searchForSerengetiMibItemIndex(String keyValue, String keyOid, int maxMibOccurrencesToSearch, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        SnmpVarBindList vbl = new SnmpVarBindList(maxMibOccurrencesToSearch * 2);
        int i = 0;
        while (i < maxMibOccurrencesToSearch) {
            SnmpOid sOid = new SnmpOid(String.valueOf(keyOid) + "." + i);
            SnmpVarBind vb = new SnmpVarBind(sOid);
            vbl.addVarBind(vb);
            ++i;
        }
        SnmpRequest request = snmpSession.snmpGetRequest(null, vbl);
        boolean completed = request.waitForCompletion(this.sessionTimeOut);
        if (!completed) {
            errorMessage.append("SNMP Request timed out after " + this.sessionTimeOut + " milliseconds");
            return -1;
        }
        Logger.logDebug("Request after:\n" + request.toString());
        int errorStatus = request.getErrorStatus();
        if (errorStatus != 0) {
            errorMessage.append("SNMP Response error " + errorStatus + " (" + SnmpRequest.snmpErrorToString((int)errorStatus) + ") for index " + request.getErrorIndex() + 1);
            return -1;
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Logger.logDebug("Result:\n" + result.varBindListToString());
        Logger.logDebug("looking for string " + keyValue);
        Enumeration e = result.getVarBindList();
        while (e.hasMoreElements()) {
            SnmpVarBind vb = (SnmpVarBind)e.nextElement();
            Logger.logDebug("VarBind " + vb);
            if (vb.status != 2 || vb.value == null) continue;
            Logger.logDebug("keyOid value " + vb.getStringValue());
            String currentID = vb.getStringValue();
            if (!currentID.equals(keyValue)) continue;
            SGSNMP.convertOIDSuffixToInteger(vb.oid.toString());
        }
        errorMessage.append("Key " + keyValue + " for " + keyOid + " not found");
        return -1;
    }

    public int searchForSerengetiMibItemInt(String keyValue, String keyOid, String desiredOid, int maxMibOccurrencesToSearch, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        String result = this.searchForSerengetiMibItem(keyValue, keyOid, desiredOid, maxMibOccurrencesToSearch, errorMessage);
        if (result == null) {
            return -1;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage.append("Result value " + result + " is not an integer");
            return -1;
        }
    }

    public String searchForSlotMibItem(String slotId, String desiredOid, StringBuffer errorMessage) throws SnmpStatusException {
        int MAX_SLOT_TABLE_ITEMS = 24;
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (slotId == null || slotId.length() == 0) {
            errorMessage.append("slotId " + slotId + " is null or empty");
            return null;
        }
        if (!desiredOid.substring(desiredOid.length() - 2).equals(".0")) {
            errorMessage.append("desiredOid " + desiredOid + " must end with \".0\" under slotTable");
            return null;
        }
        SnmpVarBindList vbl = new SnmpVarBindList(24);
        ArrayList<Integer> slotList = new ArrayList<Integer>(20);
        slotList.add(new Integer(400));
        slotList.add(new Integer(401));
        slotList.add(new Integer(402));
        slotList.add(new Integer(403));
        slotList.add(new Integer(404));
        slotList.add(new Integer(405));
        slotList.add(new Integer(506));
        slotList.add(new Integer(507));
        slotList.add(new Integer(508));
        slotList.add(new Integer(509));
        Iterator s = ((AbstractList)slotList).iterator();
        int maxMibOccurrencesToSearch = 0;
        while (s.hasNext()) {
            ++maxMibOccurrencesToSearch;
            int n = (Integer)s.next();
            SnmpOid sOid1 = new SnmpOid("1.3.6.1.4.1.42.2.70.2.1.1.10.0." + n);
            SnmpVarBind vb1 = new SnmpVarBind(sOid1);
            vbl.addVarBind(vb1);
            SnmpOid sOid2 = new SnmpOid(String.valueOf(desiredOid) + "." + n);
            SnmpVarBind vb2 = new SnmpVarBind(sOid2);
            vbl.addVarBind(vb2);
        }
        SnmpRequest request = snmpSession.snmpGetRequest(null, vbl);
        boolean completed = request.waitForCompletion(this.sessionTimeOut);
        if (!completed) {
            errorMessage.append("SNMP Request timed out after " + this.sessionTimeOut + " milliseconds");
            return null;
        }
        Logger.logDebug("Request after:\n" + request.toString());
        int errorStatus = request.getErrorStatus();
        if (errorStatus != 0) {
            errorMessage.append("SNMP Response error " + errorStatus + " (" + SnmpRequest.snmpErrorToString((int)errorStatus) + ") for index " + request.getErrorIndex() + 1);
            return null;
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Logger.logDebug("Result:\n" + result.varBindListToString());
        Logger.logDebug("looking for string " + slotId);
        Enumeration e = result.getVarBindList();
        while (e.hasMoreElements()) {
            SnmpVarBind vb = (SnmpVarBind)e.nextElement();
            Logger.logDebug("VarBind " + vb);
            if (vb.status != 2 || vb.value == null) continue;
            Logger.logDebug("slotName.0 value " + vb.getStringValue());
            String currentID = vb.getStringValue();
            if (currentID == null || !currentID.equals(slotId)) continue;
            SnmpVarBind vb2 = (SnmpVarBind)e.nextElement();
            if (vb2.status != 2 || vb2.value == null) continue;
            return vb2.getStringValue();
        }
        errorMessage.append("Slot " + slotId + " for " + desiredOid + " not found");
        return null;
    }

    public boolean setSerengetiMibItem(int keyIndex, String desiredOid, String desiredValue, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        SnmpVarBindList vbl = new SnmpVarBindList(1);
        SnmpOid sOid = new SnmpOid(String.valueOf(desiredOid) + "." + keyIndex);
        SnmpVarBind vb = new SnmpVarBind(sOid);
        vb.setSnmpStringValue(desiredValue);
        vbl.addVarBind(vb);
        SnmpRequest request = snmpSession.snmpSetRequest(null, vbl);
        boolean completed = request.waitForCompletion(this.sessionTimeOut);
        if (!completed) {
            errorMessage.append("SNMP Request timed out after " + this.sessionTimeOut + " milliseconds");
            return false;
        }
        Logger.logDebug("Request after:\n" + request.toString());
        int errorStatus = request.getErrorStatus();
        if (errorStatus != 0) {
            errorMessage.append("SNMP Response error " + errorStatus + " (" + SnmpRequest.snmpErrorToString((int)errorStatus) + ") for index " + request.getErrorIndex() + 1);
            return false;
        }
        return true;
    }

    public boolean setSerengetiMibItemInt(int keyIndex, String desiredOid, int desiredValue, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        SnmpVarBindList vbl = new SnmpVarBindList(1);
        SnmpOid sOid = new SnmpOid(String.valueOf(desiredOid) + "." + keyIndex);
        SnmpVarBind vb = new SnmpVarBind(sOid);
        vb.setSnmpIntValue((long)desiredValue);
        vbl.addVarBind(vb);
        SnmpRequest request = snmpSession.snmpSetRequest(null, vbl);
        boolean completed = request.waitForCompletion(this.sessionTimeOut);
        if (!completed) {
            errorMessage.append("SNMP Request timed out after " + this.sessionTimeOut + " milliseconds");
            return false;
        }
        Logger.logDebug("Request after:\n" + request.toString());
        int errorStatus = request.getErrorStatus();
        if (errorStatus != 0) {
            errorMessage.append("SNMP Response error " + errorStatus + " (" + SnmpRequest.snmpErrorToString((int)errorStatus) + ") for index " + request.getErrorIndex() + 1);
            return false;
        }
        return true;
    }

    public boolean setSlotDomain(String desiredSlotID, int domainID, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainID < 0 || domainID > 4) {
            errorMessage.append("domainID value " + domainID + " out of range");
            return false;
        }
        int slotIndex = this.slotIdToSlotIndex(desiredSlotID);
        if (slotIndex < 0) {
            errorMessage.append("desiredSlotID " + desiredSlotID + " invalid");
            return false;
        }
        return this.setSerengetiMibItemInt(slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.8.0", domainID + 2, errorMessage);
    }

    public boolean setSlotPowerStatus(String desiredSlotID, int desiredSlotPowerStatus, StringBuffer errorMessage) throws SnmpStatusException {
        int MAX_SLOT_POWER_STATUS = 4;
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (desiredSlotPowerStatus < 0 || desiredSlotPowerStatus > 4) {
            errorMessage.append("slotPowerStatus value " + desiredSlotPowerStatus + " out of range");
            return false;
        }
        int slotIndex = this.slotIdToSlotIndex(desiredSlotID);
        if (slotIndex < 0) {
            errorMessage.append("desiredSlotID " + desiredSlotID + " invalid");
            return false;
        }
        return this.setSerengetiMibItemInt(slotIndex, "1.3.6.1.4.1.42.2.70.2.1.1.7.0", desiredSlotPowerStatus, errorMessage);
    }

    protected void setupSnmpSession(String snmpServer, long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        if (snmpServer == null || snmpServer.length() == 0) {
            throw new UnknownHostException("no System Controller hostname");
        }
        SnmpPeer agent = new SnmpPeer(snmpServer, 161);
        SnmpParameters params = new SnmpParameters(this.configFile.getPlatformPublicCommunity(), this.configFile.getPlatformPrivateCommunity());
        agent.setSnmpParam(params);
        snmpSession = new SnmpSession(String.valueOf(snmpServer) + " WDR Session");
        snmpSession.setDefaultPeer(agent);
        this.sessionTimeOut = timeOut;
    }

    protected int slotIdToSlotIndex(String slotId) {
        int boardTypeBase = Integer.MIN_VALUE;
        int boardInstance = Integer.MIN_VALUE;
        String slotIdPrefix = slotId.substring(0, 2);
        if (slotIdPrefix.equals("SB")) {
            boardTypeBase = 400;
        } else if (slotIdPrefix.equals("IB")) {
            boardTypeBase = 500;
        } else if (slotIdPrefix.equals("SC")) {
            boardTypeBase = 100;
        } else if (slotIdPrefix.equals("FT")) {
            boardTypeBase = 200;
        } else if (slotIdPrefix.equals("PS")) {
            boardTypeBase = 300;
        } else if (slotIdPrefix.equals("RP")) {
            boardTypeBase = 610;
        } else {
            return -1;
        }
        try {
            boardInstance = Integer.parseInt(slotId.substring(2));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (boardInstance < 0 || boardInstance > 9) {
            return -1;
        }
        return boardTypeBase + boardInstance;
    }

    public String toString() {
        return new String("\n" + this.getClass().getName() + ":\n" + "-----------------------------\n" + "scHostName:               " + this.scHostName + "\n" + "communicating:            " + this.communicating + "\n" + "sessionTimeOut: (ms)      " + this.sessionTimeOut + "\n" + "snmpSession:              " + snmpSession + "\n" + "configFile:               " + this.configFile);
    }
}

