/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.ResourceProvider;
import com.sun.wbem.wdr.SGBoardPresenceChange;
import com.sun.wbem.wdr.SGBoardStateChange;
import com.sun.wbem.wdr.SGDomainAclChange;
import com.sun.wbem.wdr.SGDomainStateChange;
import com.sun.wbem.wdr.SGSNMPTrap;
import com.sun.wbem.wdr.SGSlotAssignmentChange;
import com.sun.wbem.wdr.SGSlotAvailabilityChange;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.snmp.SnmpStatusException;

public class SGEventProvider
extends ResourceProvider {
    protected ProviderCIMOMHandle cimom;
    protected SGSNMPTrap mySGSNMPTrap;
    protected static final int Solaris_SGBoardPresenceChange = (int)Math.pow(2.0, 1.0);
    protected static final int Solaris_SGSlotAssignmentChange = (int)Math.pow(2.0, 2.0);
    protected static final int Solaris_SGDomainAclChange = (int)Math.pow(2.0, 3.0);
    protected static final int Solaris_SGBoardStateChange = (int)Math.pow(2.0, 4.0);
    protected static final int Solaris_SGDomainStateChange = (int)Math.pow(2.0, 9.0);
    protected static final int Solaris_SGSlotAvailabilityChange = (int)Math.pow(2.0, 19.0);
    private static HashMap hashMap = null;
    protected static int activeEventsSet = 0;

    public SGEventProvider() {
        Logger.logDebug("SGEventProvider constructor called");
        if (hashMap == null) {
            hashMap = new HashMap(20);
            hashMap.put("solaris_sgboardpresencechange", new Integer(Solaris_SGBoardPresenceChange));
            hashMap.put("solaris_sgslotassignmentchange", new Integer(Solaris_SGSlotAssignmentChange));
            hashMap.put("solaris_sgdomainaclchange", new Integer(Solaris_SGDomainAclChange));
            hashMap.put("solaris_sgboardstatechange", new Integer(Solaris_SGBoardStateChange));
            hashMap.put("solaris_sgdomainstatechange", new Integer(Solaris_SGDomainStateChange));
            hashMap.put("solaris_sgslotavailabilitychange", new Integer(Solaris_SGSlotAvailabilityChange));
        }
    }

    public void activateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean firstActivation) throws CIMException {
        Logger.logDebug("activateFilter called; classPath: " + classPath);
        if (firstActivation) {
            Logger.logDebug("activateFilter for eventType " + eventType + ", activeEventsSet = 0x" + Integer.toHexString(activeEventsSet |= this.determineEventType(eventType)));
            if (this.mySGSNMPTrap == null) {
                try {
                    this.mySGSNMPTrap = new SGSNMPTrap(this.cimom);
                    this.mySGSNMPTrap.startTrapMonitoring();
                    Logger.logDebug("trap monitoring started");
                }
                catch (SnmpStatusException sse) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.initializeSnmpFailed", new Object[]{sse.getLocalizedMessage()}));
                }
                catch (UnknownHostException uhe) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ResourceMessage.getMsg("WDR.unknownHost", new Object[]{uhe.getLocalizedMessage()}));
                }
                catch (SocketException se) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)ResourceMessage.getMsg("WDR.socketException", new Object[]{se.getLocalizedMessage()}));
                }
            }
        }
    }

    public void authorizeFilter(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) throws CIMException {
        Logger.logDebug("authorizeFilter should never be called;  eventType: " + eventType + ", owner: " + owner);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)eventType);
    }

    public void cleanup() throws CIMException {
    }

    public void deActivateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean lastActivation) throws CIMException {
        Logger.logDebug("deActivateFilter called; classPath: " + classPath);
        if (lastActivation) {
            Logger.logDebug("deActivateFilter for eventType " + eventType + ", activeEventsSet = 0x" + Integer.toHexString(activeEventsSet -= this.determineEventType(eventType)));
        }
    }

    protected int determineEventType(String eventTypeString) {
        Integer i = (Integer)hashMap.get(eventTypeString.toLowerCase());
        if (i != null) {
            return i;
        }
        Logger.logErr("No match for event type string: " + eventTypeString);
        return 0;
    }

    protected static String eventTypeToString(int eventSet) {
        StringBuffer sb = new StringBuffer();
        if ((eventSet & Solaris_SGBoardPresenceChange) != 0) {
            sb.append("Solaris_SGBoardPresenceChange ");
        }
        if ((eventSet & Solaris_SGSlotAssignmentChange) != 0) {
            sb.append("Solaris_SGSlotAssignmentChange ");
        }
        if ((eventSet & Solaris_SGDomainAclChange) != 0) {
            sb.append("Solaris_SGDomainAclChange ");
        }
        if ((eventSet & Solaris_SGBoardStateChange) != 0) {
            sb.append("Solaris_SGBoardStateChange ");
        }
        if ((eventSet & Solaris_SGDomainStateChange) != 0) {
            sb.append("Solaris_SGDomainStateChange ");
        }
        if ((eventSet & Solaris_SGSlotAvailabilityChange) != 0) {
            sb.append("Solaris_SGSlotAvailabilityChange ");
        }
        return sb.toString().trim();
    }

    public void initialize(CIMOMHandle cimom) throws CIMException {
        Logger.logDebug("initialize called");
        this.cimom = (ProviderCIMOMHandle)cimom;
    }

    public boolean mustPoll(SelectExp filter, String eventType, CIMObjectPath classPath) throws CIMException {
        Logger.logDebug("mustPoll called for eventType " + eventType);
        if (this.determineEventType(eventType) != 0) {
            return false;
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)eventType);
    }

    static void raiseSolarisSGBoardPresenceChange(Object objectHandle, String chassisSerialNumber, String logicalId, int boardType) {
        if ((activeEventsSet & Solaris_SGBoardPresenceChange) == 0) {
            return;
        }
        SGBoardPresenceChange indication = new SGBoardPresenceChange(chassisSerialNumber, logicalId, boardType);
        indication.raiseIndication((ProviderCIMOMHandle)objectHandle);
    }

    static void raiseSolarisSGBoardStateChange(Object objectHandle, String chassisSerialNumber, String logicalId, int assignmentState, int powerStatus) {
        Logger.logDebug("raiseSolarisSGBoardStateChange called");
        if ((activeEventsSet & Solaris_SGBoardStateChange) == 0) {
            return;
        }
        SGBoardStateChange indication = new SGBoardStateChange(chassisSerialNumber, logicalId, assignmentState, powerStatus);
        indication.raiseIndication((ProviderCIMOMHandle)objectHandle);
    }

    static void raiseSolarisSGDomainAclChange(Object objectHandle, int domain, int domainAclSet) {
        if ((activeEventsSet & Solaris_SGDomainAclChange) == 0) {
            return;
        }
        SGDomainAclChange indication = new SGDomainAclChange(domain, domainAclSet);
        indication.raiseIndication((ProviderCIMOMHandle)objectHandle);
    }

    static void raiseSolarisSGDomainStateChange(Object objectHandle, int domain, int domainState, int domainKeyswitchPosition) {
        if ((activeEventsSet & Solaris_SGDomainStateChange) == 0) {
            return;
        }
        SGDomainStateChange indication = new SGDomainStateChange(domain, domainState, domainKeyswitchPosition);
        indication.raiseIndication((ProviderCIMOMHandle)objectHandle);
    }

    static void raiseSolarisSGSlotAssignmentChange(Object objectHandle, int domain, String chassisSerialNumber, String logicalId, int assignmentState) {
        if ((activeEventsSet & Solaris_SGSlotAssignmentChange) == 0) {
            return;
        }
        SGSlotAssignmentChange indication = new SGSlotAssignmentChange(domain, chassisSerialNumber, logicalId, assignmentState);
        indication.raiseIndication((ProviderCIMOMHandle)objectHandle);
    }

    static void raiseSolarisSGSlotAvailabilityChange(Object objectHandle, int domain, String chassisSerialNumber, String logicalId, int assignmentState) {
        if ((activeEventsSet & Solaris_SGSlotAvailabilityChange) == 0) {
            return;
        }
        SGSlotAvailabilityChange indication = new SGSlotAvailabilityChange(chassisSerialNumber, logicalId, domain, assignmentState);
        indication.raiseIndication((ProviderCIMOMHandle)objectHandle);
    }

    public String toString() {
        return new String("\n" + this.getClass().getName() + ":\n" + "-----------------------------\n" + "activeEventsSet: 0x" + Integer.toHexString(activeEventsSet) + ":\n(" + SGEventProvider.eventTypeToString(activeEventsSet) + ")\n" + "cimom: " + this.cimom + "\n");
    }
}

