/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.wdr.ConfigFile;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

public class SGDomainInfo {
    public static final int MAX_NUMBER_SGDOMAINS = 4;
    protected static final String RUNNING_SOLARIS = "9";
    protected ConfigFile configFile = null;
    protected static final int SNMP_AGENT_PORT = 161;
    protected static final int POLL_RATE = 5;
    protected static final int DEFAULT_WAIT_TIME = 10000;
    protected SnmpSession snmpSession = null;
    protected String scHostName = null;
    protected long sessionTimeOut = 10000L;

    public SGDomainInfo() throws UnknownHostException, SnmpStatusException, CIMException {
        this.configFile = new ConfigFile();
        this.scHostName = this.configFile.scHostName;
        this.setupSnmpSession(this.scHostName, 10000L);
    }

    public SGDomainInfo(long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        this.configFile = new ConfigFile();
        this.scHostName = this.configFile.scHostName;
        this.setupSnmpSession(this.scHostName, timeOut);
    }

    public SGDomainInfo(String scHostName) throws UnknownHostException, SnmpStatusException, CIMException {
        if (scHostName == null || scHostName.length() == 0) {
            throw new UnknownHostException("scHostName in constructor is null or empty");
        }
        this.configFile = new ConfigFile();
        this.scHostName = scHostName;
        this.setupSnmpSession(scHostName, 10000L);
    }

    public SGDomainInfo(String scHostName, long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        if (scHostName == null || scHostName.length() == 0) {
            throw new UnknownHostException("scHostName in constructor is null or empty");
        }
        this.configFile = new ConfigFile();
        this.scHostName = scHostName;
        this.setupSnmpSession(scHostName, timeOut);
    }

    public boolean domainIsUp(int domainId, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainId < 0 || domainId >= 4) {
            errorMessage.append("domainId " + domainId + " out of range");
            if (this.snmpSession != null) {
                this.snmpSession.destroySession();
                this.snmpSession = null;
            }
            return false;
        }
        String resultString = this.getDomainMibItem(domainId, "1.3.6.1.4.1.42.2.70.12.1.1.9", errorMessage);
        if (resultString == null) {
            if (this.snmpSession != null) {
                this.snmpSession.destroySession();
                this.snmpSession = null;
            }
            return false;
        }
        if (this.snmpSession != null) {
            this.snmpSession.destroySession();
            this.snmpSession = null;
        }
        return resultString.equals(RUNNING_SOLARIS);
    }

    protected void finalize() {
        if (this.snmpSession != null) {
            this.snmpSession.destroySession();
        }
    }

    public String[] getDomainACL(int domainId, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainId < 0 || domainId >= 4) {
            errorMessage.append("domainId " + domainId + " out of range");
            if (this.snmpSession != null) {
                this.snmpSession.destroySession();
                this.snmpSession = null;
            }
            return null;
        }
        String resultString = this.getDomainMibItem(domainId, "1.3.6.1.4.1.42.2.70.12.1.1.8", errorMessage);
        if (resultString == null) {
            if (this.snmpSession != null) {
                this.snmpSession.destroySession();
                this.snmpSession = null;
            }
            return null;
        }
        int i = 0;
        String valueResult = resultString.trim();
        StringTokenizer st = new StringTokenizer(valueResult, " ");
        String[] stringArray = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            stringArray[i++] = st.nextToken();
        }
        if (this.snmpSession != null) {
            this.snmpSession.destroySession();
            this.snmpSession = null;
        }
        return stringArray;
    }

    protected String getDomainMibItem(int domainId, String desiredOid, StringBuffer errorMessage) throws SnmpStatusException {
        if (errorMessage == null) {
            errorMessage = new StringBuffer();
        }
        errorMessage.setLength(0);
        if (domainId < 0 || domainId >= 4) {
            errorMessage.append("domainId " + domainId + " out of range");
            return null;
        }
        if (this.snmpSession == null && this.scHostName != null) {
            try {
                this.setupSnmpSession(this.scHostName, this.sessionTimeOut);
            }
            catch (CIMException ce) {
                errorMessage.append("Unexpected CIMException, host " + this.scHostName + ": " + ce.getMessage());
                return null;
            }
            catch (UnknownHostException uhe) {
                errorMessage.append("Unexpected UnknownHostException, host " + this.scHostName + ": " + uhe.getMessage());
                return null;
            }
        }
        String domainIdString = Integer.toString(domainId + 2);
        SnmpVarBindList vbl = new SnmpVarBindList(8);
        int i = 0;
        while (i < 4) {
            SnmpOid sOid1 = new SnmpOid("1.3.6.1.4.1.42.2.70.12.1.1.2." + i);
            SnmpVarBind vb1 = new SnmpVarBind(sOid1);
            vbl.addVarBind(vb1);
            SnmpOid sOid2 = new SnmpOid(String.valueOf(desiredOid) + "." + i);
            SnmpVarBind vb2 = new SnmpVarBind(sOid2);
            vbl.addVarBind(vb2);
            ++i;
        }
        SnmpRequest request = this.snmpSession.snmpGetRequest(null, vbl);
        boolean completed = request.waitForCompletion(this.sessionTimeOut);
        if (!completed) {
            errorMessage.append("SNMP Request timed out after " + this.sessionTimeOut + " milliseconds");
            return null;
        }
        int errorStatus = request.getErrorStatus();
        if (errorStatus != 0) {
            errorMessage.append("SNMP Response error " + errorStatus + " (" + SnmpRequest.snmpErrorToString((int)errorStatus) + ") for index " + request.getErrorIndex() + 1);
            return null;
        }
        SnmpVarBindList result = request.getResponseVarBindList();
        Enumeration e = result.getVarBindList();
        while (e.hasMoreElements()) {
            String currentId;
            SnmpVarBind vb = (SnmpVarBind)e.nextElement();
            SnmpVarBind vb2 = (SnmpVarBind)e.nextElement();
            if (vb.status != 2 || vb.value == null || !(currentId = vb.getStringValue()).equals(domainIdString) || vb2.status != 2 || vb2.value == null) continue;
            return vb2.getStringValue();
        }
        errorMessage.append("domainId " + domainId + " not found");
        return null;
    }

    protected void setupSnmpSession(String snmpServer, long timeOut) throws UnknownHostException, SnmpStatusException, CIMException {
        if (snmpServer == null || snmpServer.length() == 0) {
            throw new UnknownHostException("no System Controller hostname");
        }
        this.configFile = new ConfigFile();
        SnmpPeer agent = new SnmpPeer(snmpServer, 161);
        SnmpParameters params = new SnmpParameters(this.configFile.platformPublicCommunity, this.configFile.platformPrivateCommunity);
        agent.setSnmpParam(params);
        this.snmpSession = new SnmpSession(String.valueOf(snmpServer) + " WDR Session");
        this.snmpSession.setDefaultPeer(agent);
        this.sessionTimeOut = timeOut;
    }

    public String toString() {
        return new String("\n" + this.getClass().getName() + ":\n" + "-----------------------------\n" + "scHostName:               " + this.scHostName + "\n" + "sessionTimeOut: (ms)      " + this.sessionTimeOut + "\n" + "snmpSession:              " + this.snmpSession + "\n" + "configFile:               " + this.configFile);
    }
}

